/*
 * Decompiled with CFR 0.152.
 */
package gestionale.liquidazione_iva;

import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.liquidazione_iva.InsiemeIva;
import gestionale.liquidazione_iva.InsiemeRiepilogoIva;
import gestionale.liquidazione_iva.Iva;
import gestionale.liquidazione_iva.IvaFixedModel;
import gestionale.liquidazione_iva.IvaTableModel;
import gestionale.liquidazione_iva.RiepilogoIva;
import gestionale.liquidazione_iva.RiepilogoIvaFixedModel;
import gestionale.liquidazione_iva.RiepilogoIvaTableModel;
import gestionale.liquidazione_iva.StampaVisualizzaRegistriIva;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.GenericTableRenderer;
import utils.MyTrace;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.TimeFormatter;
import utils.ToolTipHeader;

public class MyVisulizzaRegistriIva
extends JInternalFrame
implements ListSelectionListener,
MouseListener,
InternalFrameListener {
    JToolBar jToolBarMod;
    IvaTableModel itm;
    RiepilogoIvaTableModel ritm;
    InsiemeIva insieme_i;
    InsiemeRiepilogoIva insieme_ri;
    JScrollPane scroll;
    JScrollPane scrollRiepilogo;
    JTable jTableIva;
    JTable jTableRiepilogo;
    IvaFixedModel ifm;
    RiepilogoIvaFixedModel rifm;
    JScrollPane fixedScroll;
    JScrollPane fixedScrollRiepilogo;
    JTable fixedTable;
    JTable fixedTableRiepilogo;
    private TableRowSorter<IvaTableModel> sorter;
    RowFilter<IvaTableModel, Object> rf = null;
    ArrayList<RowFilter<IvaTableModel, Object>> andFilters = new ArrayList();
    private TableRowSorter<RiepilogoIvaTableModel> sorterRiepilogo;
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    public Iva i_selezione;
    public RiepilogoIva ri_selezione;
    Funzioni f = new Funzioni();
    public JInternalFrame chiamante;
    private TimeFormatter df = null;
    FunzioniDate fda;
    Vector condizioni_check = new Vector();
    String query_da_passare = "";
    private JButton jButtonFiltro;
    private JButton jButtonFirst;
    private JButton jButtonLast;
    private JButton jButtonNext;
    private JButton jButtonPrevious;
    private JButton jButtonStampa;
    private JComboBox jComboAnno;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelAvviso;
    private JLabel jLabelClientiOFornitori;
    private JLabel jLabelNumDoc;
    private JLabel jLabelNumDoc1;
    private JLabel jLabelNumDoc4;
    private JLabel jLabelNumDoc9;
    private JLabel jLabelRiepilogoRegistriIVA;
    private JPanel jPanel1;
    private JPanel jPanelDettagli;
    private JPanel jPanelElenco;
    private JPanel jPanelFiltro;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextImponibile;
    private JTextField jTextImposta;
    private JTextField jTextImpostaIndetraibile;
    private JTextField jTextNumeroDocumento;
    private JToolBar jToolBar1;
    private JPanel p;
    private JPanel p1;
    private JPanel p2;
    private JPanel p_riepilogo;

    public MyVisulizzaRegistriIva() {
        this.fda = new FunzioniDate();
        this.itm = new IvaTableModel();
        this.ritm = new RiepilogoIvaTableModel();
        this.insieme_i = new InsiemeIva();
        this.insieme_ri = new InsiemeRiepilogoIva();
        this.jTableIva = new JTable(this.itm);
        this.jTableIva.setSelectionMode(0);
        this.sorter = new TableRowSorter<IvaTableModel>(this.itm);
        for (int i = 0; i < this.itm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.jTableRiepilogo = new JTable(this.ritm);
        this.jTableRiepilogo.setSelectionMode(0);
        this.sorterRiepilogo = new TableRowSorter<RiepilogoIvaTableModel>(this.ritm);
        this.ifm = new IvaFixedModel();
        this.ifm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.ifm);
        this.fixedTable.setAutoResizeMode(4);
        this.rifm = new RiepilogoIvaFixedModel();
        this.rifm.setFIXED_NUM(0);
        this.fixedTableRiepilogo = new JTable(this.rifm);
        this.fixedTableRiepilogo.setAutoResizeMode(4);
        this.initComponents();
        this.crea_toolbar();
        this.aggiungi_tabelle();
        this.aggiungi_condizioni();
        this.formatta();
        this.visualizzazione();
        this.controlla_diritti();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(900, 800)));
        Vector anni = this.fda.ultimi_anni(5);
        this.jComboAnno.addItem(anni.elementAt(1));
        this.jComboAnno.addItem(anni.elementAt(2));
        this.jComboAnno.addItem(anni.elementAt(3));
        this.jComboAnno.addItem(anni.elementAt(4));
        this.jComboAnno.addItem(anni.elementAt(5));
    }

    private void controlla_diritti() {
    }

    private void aggiungi_condizioni() {
        try {
            String query_seleziona_registri = "Select * from conf_registri_iva";
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona_registri);
            JCheckBox tutto = new JCheckBox();
            tutto.setName("Tutto");
            tutto.setText("Tutto");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 2;
            gridBagConstraints1.gridy = 3;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(0, 10, 0, 0);
            this.p1.add((Component)tutto, gridBagConstraints1);
            this.condizioni_check.add(tutto);
            int contatore = 4;
            while (res.next()) {
                JCheckBox condizione = new JCheckBox();
                condizione.setName(res.getString("idconf_registri_iva"));
                condizione.setText(res.getString("descrizione"));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = contatore++;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(0, 10, 0, 0);
                this.p1.add((Component)condizione, gridBagConstraints);
                this.condizioni_check.add(condizione);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (SQLException ex) {
            Logger.getLogger(MyVisulizzaRegistriIva.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableIva){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableIva.setModel(this.itm);
        this.jTableIva.setAutoCreateRowSorter(true);
        this.jTableIva.setRowSorter(this.sorter);
        this.jTableIva.setFillsViewportHeight(true);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
        this.scrollRiepilogo = new JScrollPane(this.jTableRiepilogo){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scrollRiepilogo.setHorizontalScrollBarPolicy(31);
        this.fixedScrollRiepilogo = new JScrollPane(this.fixedTableRiepilogo);
        this.fixedScrollRiepilogo.setVerticalScrollBarPolicy(22);
        this.fixedScrollRiepilogo.setPreferredSize(new Dimension(400, 25));
        JScrollBar barRiepilogo = this.fixedScrollRiepilogo.getVerticalScrollBar();
        JScrollBar dummyBarRiepilogo = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBarRiepilogo.setPreferredSize(barRiepilogo.getPreferredSize());
        this.fixedScrollRiepilogo.setVerticalScrollBar(dummyBarRiepilogo);
        final JScrollBar bar1Riepilogo = this.scrollRiepilogo.getHorizontalScrollBar();
        JScrollBar bar2Riepilogo = this.fixedScrollRiepilogo.getHorizontalScrollBar();
        bar2Riepilogo.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1Riepilogo.setValue(e.getValue());
            }
        });
        this.jTableRiepilogo.setModel(this.ritm);
        this.jTableRiepilogo.setAutoCreateRowSorter(true);
        this.jTableRiepilogo.setRowSorter(this.sorterRiepilogo);
        this.jTableRiepilogo.setFillsViewportHeight(true);
        this.p_riepilogo.add((Component)this.scrollRiepilogo, "Center");
        this.p_riepilogo.add((Component)this.fixedScrollRiepilogo, "North");
    }

    public void visualizzazione() {
        this.jTextImponibile.setEnabled(false);
        this.jTextImposta.setEnabled(false);
        this.jTextImpostaIndetraibile.setEnabled(false);
        this.jTextNumeroDocumento.setEnabled(false);
    }

    public void formatta() {
        ListSelectionModel listSelectionModel = this.jTableIva.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.jTableIva.getSelectionModel().setSelectionInterval(0, 0);
        this.jTableIva.setDefaultRenderer(Object.class, new GenericTableRenderer());
        this.fixedTable.setRowHeight(30);
        this.fixedTable.setDefaultEditor(String.class, new TextEditor());
        this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        TableColumn gruppoColumn = this.fixedTable.getColumnModel().getColumn(2);
        this.jTableIva.addMouseListener(this);
        ListSelectionModel listSelectionModelRiepilogo = this.jTableRiepilogo.getSelectionModel();
        listSelectionModelRiepilogo.addListSelectionListener(this);
        this.jTableRiepilogo.getSelectionModel().setSelectionInterval(0, 0);
        this.jTableRiepilogo.setDefaultRenderer(Object.class, new GenericTableRenderer());
        this.fixedTableRiepilogo.setRowHeight(30);
        this.fixedTableRiepilogo.setDefaultEditor(String.class, new TextEditor());
        this.fixedTableRiepilogo.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        TableColumn gruppoColumnRiepilogo = this.fixedTableRiepilogo.getColumnModel().getColumn(2);
        this.jTableRiepilogo.addMouseListener(this);
        this.header_tebella();
    }

    public void header_tebella() {
        try {
            String[] toolTipStr = new String[]{"Numero Documento / Anno", "Numero Protocollo IVA", "Registro IVA", "Imponibile", "Imposta", "Imposta Indetraibile"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableIva.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableIva.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filtra() {
        String query_seleziona = "select registro_iva.*, registro.*, registro.protocollo_iva as protocollo_iva2, conf_registri_iva.* from registro_iva left join registro on registro_iva.id_registro=registro.idregistro left join conf_registri_iva on registro_iva.id_conf_registri_iva=conf_registri_iva.idconf_registri_iva  where anno='" + this.jComboAnno.getSelectedItem().toString() + "' and (";
        if (!((JCheckBox)this.condizioni_check.elementAt(0)).isSelected()) {
            boolean ci_passo = false;
            boolean ho_aggiunto = false;
            for (JCheckBox check : this.condizioni_check) {
                if (!check.isSelected() || check.getName().equals("Tutto")) continue;
                if (ci_passo) {
                    query_seleziona = query_seleziona + " OR ";
                }
                query_seleziona = query_seleziona + " conf_registri_iva.idconf_registri_iva= " + check.getName() + " ";
                ci_passo = true;
                ho_aggiunto = true;
            }
            query_seleziona = !ho_aggiunto ? query_seleziona + "1)" : query_seleziona + " )";
        } else {
            query_seleziona = query_seleziona + "1 )";
        }
        this.query_da_passare = query_seleziona;
        this.insieme_i.caricamento(query_seleziona);
        this.itm.setDataIva(this.insieme_i.vettoreIva);
    }

    public void filtra_riepilogo() {
        this.jLabelRiepilogoRegistriIVA.setText("Riepilogo Registri IVA:");
        String query_seleziona = "SELECT * FROM conf_aliquote_iva";
        this.insieme_ri.caricamento(query_seleziona, this.jComboAnno.getSelectedItem().toString(), this.condizioni_check);
        this.ritm.setDataRiepilogoIva(this.insieme_ri.vettoreRiepilogoIva);
        if (Configurazioni.righe_ricerca != 0 && this.insieme_ri.vettoreRiepilogoIva.size() >= Configurazioni.righe_ricerca) {
            this.non_tutte_le_righe = true;
        }
        for (JCheckBox check : this.condizioni_check) {
            if (!check.isSelected() || this.jLabelRiepilogoRegistriIVA.getText().equals("Riepilogo Registri IVA: Tutto")) continue;
            this.jLabelRiepilogoRegistriIVA.setText(this.jLabelRiepilogoRegistriIVA.getText() + " " + check.getText());
        }
    }

    public void seleziona(int row) {
        this.i_selezione = new Iva();
        this.i_selezione = (Iva)this.insieme_i.vettoreIva.elementAt(row);
        this.riempi_campi();
    }

    public void riempi_campi() {
        this.jTextImponibile.setText(this.f.formattaNumero("" + this.i_selezione.getImponibile()));
        this.jTextImposta.setText(this.f.formattaNumero("" + this.i_selezione.getImposta()));
        this.jTextImpostaIndetraibile.setText(this.f.formattaNumero("" + this.i_selezione.getImposta_ind()));
        this.jTextNumeroDocumento.setText("" + this.i_selezione.getNum_doc() + "  del  " + this.i_selezione.getAnno());
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jLabel13 = new JLabel();
        this.jLabel29 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelFiltro = new JPanel();
        this.p1 = new JPanel();
        this.jLabelClientiOFornitori = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jComboAnno = new JComboBox();
        this.jButtonFiltro = new JButton();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.p_riepilogo = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabelRiepilogoRegistriIVA = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.jLabel30 = new JLabel();
        this.jPanelDettagli = new JPanel();
        this.p2 = new JPanel();
        this.jTextNumeroDocumento = new JTextField();
        this.jLabelNumDoc = new JLabel();
        this.jLabelNumDoc1 = new JLabel();
        this.jTextImposta = new JTextField();
        this.jLabelNumDoc4 = new JLabel();
        this.jTextImponibile = new JTextField();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jTextImpostaIndetraibile = new JTextField();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabelNumDoc9 = new JLabel();
        this.jLabelAvviso = new JLabel();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("I.V.A. \\ Visualizza Registri");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyVisulizzaRegistriIva.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyVisulizzaRegistriIva.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setName("jToolBar1");
        this.jSeparator1.setName("jSeparator1");
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setName("jButtonFirst");
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVisulizzaRegistriIva.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setName("jButtonPrevious");
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVisulizzaRegistriIva.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setName("jButtonNext");
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVisulizzaRegistriIva.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setName("jButtonLast");
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVisulizzaRegistriIva.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jSeparator2.setName("jSeparator2");
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setName("jButtonStampa");
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jButtonStampa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVisulizzaRegistriIva.this.jButtonStampaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonStampa);
        this.jLabel13.setText("                                         ");
        this.jLabel13.setName("jLabel13");
        this.jToolBar1.add(this.jLabel13);
        this.jLabel29.setText("                    ");
        this.jLabel29.setName("jLabel29");
        this.jToolBar1.add(this.jLabel29);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jScrollPane1.setName("jScrollPane1");
        this.jTabbedPane1.setName("jTabbedPane1");
        this.jPanelFiltro.setName("jPanelFiltro");
        this.jPanelFiltro.setLayout(new BorderLayout());
        this.p1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p1.setName("p1");
        this.p1.setLayout(new GridBagLayout());
        this.jLabelClientiOFornitori.setText("Anno");
        this.jLabelClientiOFornitori.setName("jLabelClientiOFornitori");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.p1.add((Component)this.jLabelClientiOFornitori, gridBagConstraints);
        this.jLabel1.setText("   ");
        this.jLabel1.setName("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.p1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("   ");
        this.jLabel2.setName("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.p1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("   ");
        this.jLabel3.setName("jLabel3");
        this.p1.add((Component)this.jLabel3, new GridBagConstraints());
        this.jLabel4.setText("   ");
        this.jLabel4.setName("jLabel4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        this.p1.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("   ");
        this.jLabel5.setName("jLabel5");
        this.p1.add((Component)this.jLabel5, new GridBagConstraints());
        this.jLabel6.setText("   ");
        this.jLabel6.setName("jLabel6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.p1.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("   ");
        this.jLabel7.setName("jLabel7");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.p1.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText("   ");
        this.jLabel8.setName("jLabel8");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.p1.add((Component)this.jLabel8, gridBagConstraints);
        this.jComboAnno.setName("jComboAnno");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.p1.add((Component)this.jComboAnno, gridBagConstraints);
        this.jButtonFiltro.setText("Filtra");
        this.jButtonFiltro.setName("jButtonFiltro");
        this.jButtonFiltro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVisulizzaRegistriIva.this.jButtonFiltroActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.p1.add((Component)this.jButtonFiltro, gridBagConstraints);
        this.jPanelFiltro.add((Component)this.p1, "Center");
        this.jTabbedPane1.addTab("Filtro", this.jPanelFiltro);
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setMinimumSize(new Dimension(2, 50));
        this.p.setName("p");
        this.p.setPreferredSize(new Dimension(2, 300));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "First");
        this.p_riepilogo.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100000));
        this.p_riepilogo.setMinimumSize(new Dimension(0, 150));
        this.p_riepilogo.setName("p_riepilogo");
        this.p_riepilogo.setPreferredSize(new Dimension(500, 250));
        this.p_riepilogo.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p_riepilogo, "Last");
        this.jPanel1.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.jPanel1.setName("jPanel1");
        this.jLabelRiepilogoRegistriIVA.setText("Riepilogo Registri IVA:");
        this.jLabelRiepilogoRegistriIVA.setName("jLabelRiepilogoRegistriIVA");
        this.jLabel21.setText("     ");
        this.jLabel21.setName("jLabel21");
        this.jLabel22.setText("     ");
        this.jLabel22.setName("jLabel22");
        this.jLabel23.setText("     ");
        this.jLabel23.setName("jLabel23");
        this.jLabel24.setText("     ");
        this.jLabel24.setName("jLabel24");
        this.jLabel25.setText("     ");
        this.jLabel25.setName("jLabel25");
        this.jLabel26.setText("     ");
        this.jLabel26.setName("jLabel26");
        this.jLabel27.setText("                                                                                               ");
        this.jLabel27.setName("jLabel27");
        this.jLabel28.setText("     ");
        this.jLabel28.setName("jLabel28");
        this.jLabel30.setText("     ");
        this.jLabel30.setName("jLabel30");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel27).addComponent(this.jLabel28).addComponent(this.jLabel26).addComponent(this.jLabel24).addComponent(this.jLabel21).addComponent(this.jLabel25).addComponent(this.jLabel22).addComponent(this.jLabel30).addComponent(this.jLabel23).addComponent(this.jLabelRiepilogoRegistriIVA)).addGap(686, 686, 686)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel27).addComponent(this.jLabel28).addComponent(this.jLabel26).addComponent(this.jLabel24).addComponent(this.jLabel21).addComponent(this.jLabel25).addComponent(this.jLabel22).addComponent(this.jLabel30).addComponent(this.jLabel23)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 34, Short.MAX_VALUE).addComponent(this.jLabelRiepilogoRegistriIVA)));
        this.jPanelElenco.add((Component)this.jPanel1, "Center");
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelDettagli.setName("jPanelDettagli");
        this.jPanelDettagli.setLayout(new BorderLayout());
        this.p2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p2.setName("p2");
        this.p2.setLayout(new GridBagLayout());
        this.jTextNumeroDocumento.setMinimumSize(new Dimension(80, 20));
        this.jTextNumeroDocumento.setName("jTextNumeroDocumento");
        this.jTextNumeroDocumento.setPreferredSize(new Dimension(220, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jTextNumeroDocumento, gridBagConstraints);
        this.jLabelNumDoc.setText("Numero Documento");
        this.jLabelNumDoc.setName("jLabelNumDoc");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jLabelNumDoc, gridBagConstraints);
        this.jLabelNumDoc1.setText("Imposta");
        this.jLabelNumDoc1.setName("jLabelNumDoc1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jLabelNumDoc1, gridBagConstraints);
        this.jTextImposta.setMinimumSize(new Dimension(80, 20));
        this.jTextImposta.setName("jTextImposta");
        this.jTextImposta.setPreferredSize(new Dimension(220, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jTextImposta, gridBagConstraints);
        this.jLabelNumDoc4.setText("Imponibile");
        this.jLabelNumDoc4.setName("jLabelNumDoc4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jLabelNumDoc4, gridBagConstraints);
        this.jTextImponibile.setMinimumSize(new Dimension(80, 20));
        this.jTextImponibile.setName("jTextImponibile");
        this.jTextImponibile.setPreferredSize(new Dimension(220, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jTextImponibile, gridBagConstraints);
        this.jLabel9.setText("       ");
        this.jLabel9.setName("jLabel9");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setText("       ");
        this.jLabel10.setName("jLabel10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel11.setText("       ");
        this.jLabel11.setName("jLabel11");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        this.p2.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel12.setText("       ");
        this.jLabel12.setName("jLabel12");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jLabel12, gridBagConstraints);
        this.jLabel14.setText("       ");
        this.jLabel14.setName("jLabel14");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel15.setText("       ");
        this.jLabel15.setName("jLabel15");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jLabel15, gridBagConstraints);
        this.jTextImpostaIndetraibile.setMinimumSize(new Dimension(80, 20));
        this.jTextImpostaIndetraibile.setName("jTextImpostaIndetraibile");
        this.jTextImpostaIndetraibile.setPreferredSize(new Dimension(220, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jTextImpostaIndetraibile, gridBagConstraints);
        this.jLabel16.setText("       ");
        this.jLabel16.setName("jLabel16");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jLabel16, gridBagConstraints);
        this.jLabel17.setText("       ");
        this.jLabel17.setName("jLabel17");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jLabel17, gridBagConstraints);
        this.jLabel18.setText("       ");
        this.jLabel18.setName("jLabel18");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jLabel18, gridBagConstraints);
        this.jLabel19.setText("       ");
        this.jLabel19.setName("jLabel19");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jLabel19, gridBagConstraints);
        this.jLabel20.setText("       ");
        this.jLabel20.setName("jLabel20");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jLabel20, gridBagConstraints);
        this.jLabelNumDoc9.setText("Imposta Indetraibile");
        this.jLabelNumDoc9.setName("jLabelNumDoc9");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.p2.add((Component)this.jLabelNumDoc9, gridBagConstraints);
        this.jLabelAvviso.setText("           ");
        this.jLabelAvviso.setName("jLabelAvviso");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.p2.add((Component)this.jLabelAvviso, gridBagConstraints);
        this.jPanelDettagli.add((Component)this.p2, "Center");
        this.jTabbedPane1.addTab("Dettagli", this.jPanelDettagli);
        this.jScrollPane1.setViewportView(this.jTabbedPane1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.itm.getRowCount() != 0) {
            this.jTableIva.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        if (this.jTableIva.getSelectedRow() > 0 && this.itm.getRowCount() != 0) {
            try {
                this.jTableIva.getSelectionModel().setSelectionInterval(this.jTableIva.getSelectedRow() - 1, this.jTableIva.getSelectedRow() - 1);
            }
            catch (Exception e) {
                MyTrace.log.info("\u00e8 il primo elemento del vettore");
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
            }
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        if (this.itm.getRowCount() != 0) {
            try {
                this.jTableIva.getSelectionModel().setSelectionInterval(this.jTableIva.getSelectedRow() + 1, this.jTableIva.getSelectedRow() + 1);
            }
            catch (Exception e) {
                MyTrace.log.info("\u00e8 l'ultimo elemento del vettore");
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
            }
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.itm.getRowCount() != 0) {
            this.jTableIva.getSelectionModel().setSelectionInterval(this.itm.getRowCount() - 1, this.itm.getRowCount() - 1);
        }
    }

    private void jButtonFiltroActionPerformed(ActionEvent evt) {
        this.filtra();
        this.filtra_riepilogo();
        this.jTabbedPane1.setSelectedIndex(1);
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void jButtonStampaActionPerformed(ActionEvent evt) {
        StampaVisualizzaRegistriIva stampa = new StampaVisualizzaRegistriIva();
        stampa.elabora(this.query_da_passare, this.condizioni_check, this.jComboAnno.getSelectedItem().toString());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableIva.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableIva.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.itm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int viewRow = this.jTableIva.getSelectedRow();
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableIva.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow <= this.itm.getRowCount() - 1 && modelRow >= 0) {
                this.seleziona(modelRow);
                this.jTabbedPane1.setSelectedIndex(2);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<IvaTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            if (!MyVisulizzaRegistriIva.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyVisulizzaRegistriIva.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyVisulizzaRegistriIva.this.rf = RowFilter.andFilter(MyVisulizzaRegistriIva.this.andFilters);
                MyVisulizzaRegistriIva.this.sorter.setRowFilter(MyVisulizzaRegistriIva.this.rf);
                MyVisulizzaRegistriIva.this.formatta();
            } else {
                String query = "select registro_iva.*, registro.*, conf_registri_iva.* from registro_iva left join registro on registro_iva.id_registro=registro.idregistro left join conf_registri_iva on registro_iva.id_conf_registri_iva=conf_registri_iva.idconf_registri_iva where anno='" + MyVisulizzaRegistriIva.this.jComboAnno.getSelectedItem().toString() + "'";
                if (col == 0) {
                    query = query + " AND num_doc LIKE '%" + this.tf.getText() + "%'";
                    query = query + " or anno LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 1) {
                    query = query + " AND importo LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 2) {
                    query = query + " AND imposta LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 3) {
                    query = query + " AND  imposta_ind Like'%" + this.tf.getText() + "%'";
                }
                query = query + " ORDER BY data_doc ASC LIMIT 0," + Configurazioni.righe_ricerca;
                MyVisulizzaRegistriIva.this.insieme_i.caricamento(query);
                MyVisulizzaRegistriIva.this.itm.setDataIva(MyVisulizzaRegistriIva.this.insieme_i.vettoreIva);
                MyVisulizzaRegistriIva.this.formatta();
            }
        }
    }
}

