/*
 * Decompiled with CFR 0.152.
 */
package gestionale.iva;

import gestionale.causali_contabili.MyCausaliContabili;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import gestionale.iva.InsiemeRegistriIVA;
import gestionale.iva.RegistriIVA;
import gestionale.iva.RegistriIVAFixedModel;
import gestionale.iva.RegistriIVATableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import utils.Funzioni;
import utils.GenericTableRenderer;
import utils.MyTrace;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.ToolTipHeader;

public class MyConfiguraRegistriIVA
extends JInternalFrame
implements ListSelectionListener,
MouseListener {
    JToolBar jToolBarMod;
    RegistriIVATableModel rtm;
    InsiemeRegistriIVA insieme_r;
    JScrollPane scroll;
    JTable jTableRegistro;
    RegistriIVAFixedModel rfm;
    JScrollPane fixedScroll;
    JTable fixedTable;
    private TableRowSorter<RegistriIVATableModel> sorter;
    RowFilter<RegistriIVATableModel, Object> rf = null;
    ArrayList<RowFilter<RegistriIVATableModel, Object>> andFilters = new ArrayList();
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    RegistriIVA r_selezione;
    Funzioni f = new Funzioni();
    public JInternalFrame chiamante;
    private JButton jButtonClean;
    private JButton jButtonElimina;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JComboBox jComboTipo;
    private JComboBox jComboTransitoria;
    private JLabel jLabel1;
    private JLabel jLabelCF;
    private JLabel jLabelCF1;
    private JLabel jLabelCodice;
    private JLabel jLabelNote;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelDettaglio;
    private JPanel jPanelElenco;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextCodice;
    private JTextArea jTextDescrizione;
    private JToolBar jToolBar1;
    private JPanel p;

    public MyConfiguraRegistriIVA() {
        this.rtm = new RegistriIVATableModel();
        this.insieme_r = new InsiemeRegistriIVA();
        this.jTableRegistro = new JTable(this.rtm);
        this.jTableRegistro.setSelectionMode(0);
        this.sorter = new TableRowSorter<RegistriIVATableModel>(this.rtm);
        for (int i = 0; i < this.rtm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.rfm = new RegistriIVAFixedModel();
        this.rfm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.rfm);
        this.fixedTable.setAutoResizeMode(4);
        this.initComponents();
        this.crea_toolbar();
        this.aggiungi_tabelle();
        this.filtra();
        ListSelectionModel listSelectionModel = this.jTableRegistro.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.formatta();
        this.visualizzazione();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(600, 400)));
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableRegistro){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableRegistro.setModel(this.rtm);
        this.jTableRegistro.setAutoCreateRowSorter(true);
        this.jTableRegistro.setRowSorter(this.sorter);
        this.jTableRegistro.setFillsViewportHeight(true);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraRegistriIVA.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraRegistriIVA.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    public void visualizzazione() {
        this.jTextCodice.setEnabled(this.in_modifica);
        this.jTextDescrizione.setEnabled(this.in_modifica);
        this.jComboTipo.setEnabled(this.in_modifica);
        this.jComboTransitoria.setEnabled(this.in_modifica);
        if (this.in_modifica) {
            this.getContentPane().remove(this.jToolBar1);
            this.getContentPane().add((Component)this.jToolBarMod, "North");
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.getContentPane().remove(this.jToolBarMod);
            this.getContentPane().add((Component)this.jToolBar1, "North");
            this.jTabbedPane1.setEnabledAt(0, true);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void formatta() {
        this.jTableRegistro.getSelectionModel().setSelectionInterval(0, 0);
        this.jTableRegistro.setDefaultRenderer(Object.class, new GenericTableRenderer());
        this.fixedTable.setRowHeight(30);
        this.fixedTable.setDefaultEditor(String.class, new TextEditor());
        this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        TableColumn gruppoColumn = this.fixedTable.getColumnModel().getColumn(2);
        this.jTableRegistro.addMouseListener(this);
        TableColumn c = this.fixedTable.getColumn("Codice");
        c.setPreferredWidth(70);
        c.setMaxWidth(70);
        c = this.jTableRegistro.getColumn("Codice");
        c.setPreferredWidth(70);
        c.setMaxWidth(70);
        c = this.fixedTable.getColumn("Tipo");
        c.setPreferredWidth(70);
        c.setMaxWidth(70);
        c = this.jTableRegistro.getColumn("Tipo");
        c.setPreferredWidth(70);
        c.setMaxWidth(70);
        this.header_tebella();
    }

    public void header_tebella() {
        try {
            String[] toolTipStr = new String[]{"Codice Registro", "Tipo", "Descrizione"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableRegistro.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableRegistro.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filtra() {
        String query = "select  conf_registri_iva.*  from conf_registri_iva WHERE abilita=1";
        if (Configurazioni.righe_ricerca != 0) {
            query = query + " LIMIT 0," + Configurazioni.righe_ricerca;
        }
        this.insieme_r.caricamento(query);
        this.rtm.setDataRegistro(this.insieme_r.vettoreRegistro);
        if (Configurazioni.righe_ricerca != 0 && this.insieme_r.vettoreRegistro.size() >= Configurazioni.righe_ricerca) {
            this.non_tutte_le_righe = true;
        }
    }

    public void seleziona(int row) {
        this.r_selezione = new RegistriIVA();
        this.r_selezione = (RegistriIVA)this.insieme_r.vettoreRegistro.elementAt(row);
        this.riempi_campi();
    }

    public void riempi_campi() {
        this.jTextCodice.setText(this.r_selezione.getCodice());
        this.jTextDescrizione.setText(this.r_selezione.getDescrizione());
        if (this.r_selezione.getTipo().equals("A")) {
            this.jComboTipo.setSelectedItem("Acquisti");
        } else {
            this.jComboTipo.setSelectedItem("Vendite");
        }
        if (this.r_selezione.getTipo().equals("A")) {
            this.jComboTipo.setSelectedItem("Acquisti");
        } else {
            this.jComboTipo.setSelectedItem("Vendite");
        }
        if (this.r_selezione.getTransitoria() == 0) {
            this.jComboTransitoria.setSelectedItem("No");
        } else {
            this.jComboTransitoria.setSelectedItem("Si");
        }
    }

    private void costruisci() {
        this.r_selezione.setCodice(this.jTextCodice.getText());
        this.r_selezione.setDescrizione(this.jTextDescrizione.getText());
        if (this.jComboTipo.getSelectedItem().equals("Acquisti")) {
            this.r_selezione.setTipo("A");
        } else {
            this.r_selezione.setTipo("V");
        }
        if (this.jComboTransitoria.getSelectedItem().equals("Si")) {
            this.r_selezione.setTransitoria(1);
        } else {
            this.r_selezione.setTransitoria(0);
        }
    }

    private boolean check() {
        if (this.jTextCodice.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire un Codice valido");
            return false;
        }
        if (this.jTextDescrizione.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire una Descrizione");
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.jPanelDettaglio = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabelCodice = new JLabel();
        this.jTextCodice = new JTextField();
        this.jLabelCF = new JLabel();
        this.jLabel1 = new JLabel();
        this.jComboTipo = new JComboBox();
        this.jComboTransitoria = new JComboBox();
        this.jLabelCF1 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabelNote = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextDescrizione = new JTextArea();
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Configurazioni \\ Registri I.V.A.");
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                MyConfiguraRegistriIVA.this.chiusura_frame(evt);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyConfiguraRegistriIVA.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyConfiguraRegistriIVA.this.finestra_ridimensionata(evt);
            }
        });
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelDettaglio.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabelCodice.setText("Codice Registro");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCodice, gridBagConstraints);
        this.jTextCodice.setMinimumSize(new Dimension(200, 30));
        this.jTextCodice.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextCodice, gridBagConstraints);
        this.jLabelCF.setText("Tipo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCF, gridBagConstraints);
        this.jLabel1.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jComboTipo.setModel(new DefaultComboBoxModel<String>(new String[]{"Acquisti", "Vendite"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jComboTipo, gridBagConstraints);
        this.jComboTransitoria.setModel(new DefaultComboBoxModel<String>(new String[]{"Si", "No"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jComboTransitoria, gridBagConstraints);
        this.jLabelCF1.setText("Transitoria");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCF1, gridBagConstraints);
        this.jPanel2.add((Component)this.jPanel3, new GridBagConstraints());
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabelNote.setText("Descrizione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel4.add((Component)this.jLabelNote, gridBagConstraints);
        this.jTextDescrizione.setColumns(60);
        this.jTextDescrizione.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextDescrizione);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanelDettaglio.add((Component)this.jPanel2, "West");
        this.jTabbedPane1.addTab("Dettagli", this.jPanelDettaglio);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraRegistriIVA.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraRegistriIVA.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraRegistriIVA.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraRegistriIVA.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraRegistriIVA.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraRegistriIVA.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraRegistriIVA.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraRegistriIVA.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraRegistriIVA.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraRegistriIVA.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyConfiguraRegistriIVA.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                boolean check2 = this.r_selezione.inserisci(false);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.formatta();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci();
            boolean check2 = this.r_selezione.modifica(false);
            if (check2) {
                this.in_modifica = false;
                this.filtra();
                this.formatta();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento della modifica dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
            }
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void chiusura_frame(InternalFrameEvent evt) {
        if (this.chiamante != null && this.chiamante.getClass() == MyCausaliContabili.class && ((MyCausaliContabili)this.chiamante).f_ri_open) {
            ((MyCausaliContabili)this.chiamante).f_ri_open = false;
        }
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        this.in_new = true;
        this.jTableRegistro.getSelectionModel().clearSelection();
        this.r_selezione = new RegistriIVA();
        this.riempi_campi();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        this.in_modifica = true;
        this.visualizzazione();
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
        this.jTabbedPane1.setSelectedIndex(1);
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare questa Aliquota?");
        if (res == 0) {
            this.r_selezione.elimina();
            this.in_modifica = false;
            this.filtra();
        }
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.rtm.getRowCount() != 0) {
            this.jTableRegistro.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableRegistro.getSelectedRow() > 0 && this.rtm.getRowCount() != 0) {
                this.jTableRegistro.getSelectionModel().setSelectionInterval(this.jTableRegistro.getSelectedRow() - 1, this.jTableRegistro.getSelectedRow() - 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO ULTIMO");
            err.printStackTrace();
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        try {
            if (this.rtm.getRowCount() != 0) {
                this.jTableRegistro.getSelectionModel().setSelectionInterval(this.jTableRegistro.getSelectedRow() + 1, this.jTableRegistro.getSelectedRow() + 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO ULTIMO");
            err.printStackTrace();
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.rtm.getRowCount() != 0) {
            this.jTableRegistro.getSelectionModel().setSelectionInterval(this.rtm.getRowCount() - 1, this.rtm.getRowCount() - 1);
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            this.in_filter = true;
            String[] a_ric = new String[]{"", "", ""};
            this.rfm.addRow(a_ric);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.fixedTable.setCellSelectionEnabled(true);
            this.fixedTable.changeSelection(0, 0, false, false);
            this.fixedTable.requestFocus();
        } else {
            this.in_filter = false;
            this.rfm.deleteRow();
            this.rfm = new RegistriIVAFixedModel();
            this.fixedTable.setModel(this.rfm);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            this.sorter.setRowFilter(null);
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] a_ric = new String[]{"", "", ""};
            this.rfm = new RegistriIVAFixedModel();
            this.fixedTable.setModel(this.rfm);
            this.rfm.addRow(a_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.rtm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyConfiguraRegistriIVA().setVisible(true);
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableRegistro.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableRegistro.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.rtm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTable jtb = (JTable)e.getSource();
            int viewRow = jtb.getSelectedRow();
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableRegistro.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow <= this.rtm.getRowCount() - 1 && modelRow >= 0) {
                RegistriIVA r = new RegistriIVA();
                r = (RegistriIVA)this.insieme_r.vettoreRegistro.elementAt(modelRow);
                if (this.chiamante != null) {
                    if (this.chiamante.getClass() == MyCausaliContabili.class && ((MyCausaliContabili)this.chiamante).f_ri_open) {
                        ((MyCausaliContabili)this.chiamante).jTextRegistroIVA.setText(r.getCodice());
                        ((MyCausaliContabili)this.chiamante).f_ri_open = false;
                    }
                    this.dispose();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<RegistriIVATableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            if (!MyConfiguraRegistriIVA.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyConfiguraRegistriIVA.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyConfiguraRegistriIVA.this.rf = RowFilter.andFilter(MyConfiguraRegistriIVA.this.andFilters);
                MyConfiguraRegistriIVA.this.sorter.setRowFilter(MyConfiguraRegistriIVA.this.rf);
                MyConfiguraRegistriIVA.this.formatta();
            } else {
                String query = "SELECT * FROM conf_registri_iva WHERE abilita='1'";
                if (col == 0) {
                    query = query + " AND codice LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 1) {
                    query = query + " AND tipo LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 2) {
                    query = query + " AND descrizione LIKE '%" + this.tf.getText() + "%'";
                }
                query = query + " ORDER BY codice ASC LIMIT 0," + Configurazioni.righe_ricerca;
                MyConfiguraRegistriIVA.this.insieme_r.caricamento(query);
                MyConfiguraRegistriIVA.this.rtm.setDataRegistro(MyConfiguraRegistriIVA.this.insieme_r.vettoreRegistro);
                MyConfiguraRegistriIVA.this.formatta();
            }
        }
    }
}

