/*
 * Decompiled with CFR 0.152.
 */
package gestionale.documenti;

import anagrafiche.indirizzi.DA_CANCELLARE_Indirizzo;
import gestionale.configurazioni.Configurazioni;
import gestionale.documenti.Documento;
import gestionale.documenti.RigaDocumento;
import gestionale.documenti.TipoDocumentoAttivo;
import gestionale.documenti.TotaliDocumento;
import gestionale.personalizzazione.stampe.IntestazioneFatturaAttiva;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import gestionale.scadenziario.Scadenza;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaDocumentoAttivo
implements Runnable {
    ArrayList<Documento> v_fatture;
    Documento fa_selezione;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    int nr_colli = 9999;
    int y_inizio;
    Thread thread;
    GestoreStampe stampa;

    public StampaDocumentoAttivo(Documento fa_selezione) {
        Configurazioni.getIstanza();
        this.y_inizio = Configurazioni.inizio_stampe;
        this.v_fatture = new ArrayList();
        this.v_fatture.add(fa_selezione);
    }

    public StampaDocumentoAttivo(ArrayList<Documento> v) {
        Configurazioni.getIstanza();
        this.y_inizio = Configurazioni.inizio_stampe;
        this.v_fatture = new ArrayList();
        for (Documento f : v) {
            this.v_fatture.add(f);
        }
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA FATTURA ATTIVA");
        attesa.start();
        this.lancia_elaborazione();
        attesa.stop();
    }

    public void lancia_elaborazione() {
        Iterator<Documento> i = this.v_fatture.iterator();
        this.stampa = new GestoreStampe();
        int contatore_doc = 0;
        while (i.hasNext()) {
            Documento fa;
            this.fa_selezione = fa = i.next();
            this.fa_selezione.seleziona_dettagli();
            this.fa_selezione.calcola_totali();
            this.stampa.aggiungi_pj();
            this.elabora();
            ++contatore_doc;
        }
        this.stampa.print();
    }

    public void elabora() {
        int y = this.y_inizio;
        int y_da_togliere = y - 100;
        MyTrace.log.info("STAMPA FATTURA ATTIVA: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  INIZIO STAMPA XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        String ragione_sociale = this.fa_selezione.getR().getAnagrafica().getRagione_sociale();
        String sede_via = "via";
        String sede_cap = "cap";
        String sede_citta = "citt\u00e0";
        String sede_provincia = "provincia";
        DA_CANCELLARE_Indirizzo i = this.fa_selezione.getR().getAnagrafica().getSede_legale();
        if (i.getId() != 0) {
            sede_cap = i.getCap().getCap();
            sede_citta = i.getLocalita_selezionata();
            sede_provincia = i.getCap().getCd_provincia();
            sede_via = i.getIndirizzo();
        }
        int contatore = 0;
        Vector insiemepagine = new Vector();
        Vector<RigaDocumento> pagina = new Vector<RigaDocumento>();
        int tipo = this.fa_selezione.getId_tipo();
        for (RigaDocumento rf : this.fa_selezione.getInsieme_r().vettoreR) {
            int righe = 0;
            Vector rigasplittata = new Vector();
            if (tipo == 1) {
                righe = this.stampa.dimensioneSplitString(rf.getDescrizione(), 350, this.stampa.Font_Calibri_8);
                rigasplittata = this.stampa.SplitString(rf.getDescrizione(), 350, this.stampa.Font_Calibri_8);
            }
            if (tipo == 2) {
                righe = this.stampa.dimensioneSplitString(rf.getDescrizione(), 240, this.stampa.Font_Calibri_8);
                rigasplittata = this.stampa.SplitString(rf.getDescrizione(), 240, this.stampa.Font_Calibri_8);
            }
            if (tipo == 3) {
                righe = this.stampa.dimensioneSplitString(rf.getDescrizione(), 130, this.stampa.Font_Calibri_8);
                rigasplittata = this.stampa.SplitString(rf.getDescrizione(), 130, this.stampa.Font_Calibri_8);
            }
            if (tipo == 4) {
                righe = this.stampa.dimensioneSplitString(rf.getDescrizione(), 150, this.stampa.Font_Calibri_8);
                rigasplittata = this.stampa.SplitString(rf.getDescrizione(), 150, this.stampa.Font_Calibri_8);
            }
            if (tipo == 5) {
                righe = this.stampa.dimensioneSplitString(rf.getDescrizione(), 350, this.stampa.Font_Calibri_8);
                rigasplittata = this.stampa.SplitString(rf.getDescrizione(), 350, this.stampa.Font_Calibri_8);
            }
            contatore = righe > 1 ? (contatore += 11 + (righe - 1) * 11) : (contatore += 11);
            Object[] str = rigasplittata.toArray();
            rf.setDescrizione(str[0].toString());
            if (rf.getCol_gen_1().contains("DDT")) {
                String s = rf.getCol_gen_1().substring(7, rf.getCol_gen_1().length());
                rf.setCol_gen_1(s);
            }
            pagina.add(rf);
            for (int j = 1; j < str.length; ++j) {
                RigaDocumento riga_fattura = new RigaDocumento();
                riga_fattura.setDescrizione(str[j].toString());
                pagina.add(riga_fattura);
            }
            if (contatore <= 308) continue;
            insiemepagine.add(pagina);
            pagina = new Vector();
            contatore = 0;
        }
        insiemepagine.add(pagina);
        int ultima_pagina = insiemepagine.size();
        int conta_pagina = 0;
        Iterator i_pagine = insiemepagine.iterator();
        while (i_pagine.hasNext()) {
            ++conta_pagina;
            Vector righerighe = (Vector)i_pagine.next();
            this.appendi_causale(y);
            if (tipo != 5) {
                this.appendi_trattamento(y);
            }
            this.appendi_descrizione(y);
            this.appendi_cliente(y, ragione_sociale, sede_via, sede_cap, sede_citta, sede_provincia);
            this.appendi_destinazione(y, ragione_sociale);
            this.appendi_piva_cf(y);
            this.appendi_righe(y, y - this.y_inizio, righerighe, this.y_inizio, 350);
            if (conta_pagina == ultima_pagina) {
                this.appendi_totali(y, y_da_togliere);
                this.appendi_scadenze(y, y_da_togliere);
            } else {
                this.appendi_totali_vuoto(y, y_da_togliere);
                this.appendi_scadenze_vuoto(y, y_da_togliere);
            }
            this.appendi_piedi_pagina_fattura(y, y_da_togliere);
        }
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        String date_now = this.fda.dataCorrente().replaceAll("-", "");
        String ora_now = this.fda.OraCorrente().replaceAll(":", "");
        String ragione_sociale1 = this.fa_selezione.getR().getAnagrafica().getRagione_sociale().replaceAll("\\.", "");
        String codice = this.fa_selezione.getR().getAnagrafica().getCodice().replaceAll("\\.", "");
        String n = this.fa_selezione.getR().getCc().getTm().getContatore().getAppellativo_stampa().replaceAll(" ", "_");
        String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_" + n + "_" + this.fa_selezione.getNumero() + "_" + this.fa_selezione.getAnno() + "_" + ragione_sociale1 + "_C" + codice);
        this.stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
        this.stampa.setInt((OggettoToPrint)new IntestazioneFatturaAttiva());
        this.stampa.setIntPP((OggettoToPrint)new IntestazioneFatturaAttiva());
        this.stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Fattura Attiva"));
        MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA FATTURA ATTIVA FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
    }

    public void appendi_causale(int y) {
        this.stampa.setFont(this.stampa.Font_Calibri_11_B);
        String descrizione = this.fa_selezione.getR().getCc().getTm().getContatore().getAppellativo_stampa();
        int numero = this.fa_selezione.getNumero();
        this.stampa.appendTextOvunque(descrizione, 22, y + 22);
        this.stampa.setFont(this.stampa.Font_Calibri_11_B);
        if (this.fa_selezione.getCodifica() != null && !this.fa_selezione.getCodifica().equals("") && !this.fa_selezione.getCodifica().equals("null")) {
            this.stampa.appendTextOvunque("Nr. " + numero + "/" + this.fa_selezione.getCodifica() + " - " + this.fa_selezione.getAnno() + "   del " + this.fa_selezione.getR().getData_docIt(), 22, y + 37);
        } else {
            this.stampa.appendTextOvunque("Nr. " + numero + " - " + this.fa_selezione.getAnno() + "   del " + this.fa_selezione.getR().getData_docIt(), 22, y + 37);
        }
    }

    public void appendi_trattamento(int y) {
        this.stampa.setFont(this.stampa.Font_Calibri_10);
        this.stampa.appendTextOvunque("MODALITA' DI PAGAMENTO ", 22, y + 52);
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        int id_banca = this.fa_selezione.getR().getId_banca_appoggio();
        if (id_banca != 0) {
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            this.stampa.appendTestoDimensionePosizione(this.fa_selezione.getR().getTe().getDescrizione() + ", " + this.fa_selezione.getR().getDesc_banca() + "," + " IBAN:" + this.fa_selezione.getR().getIban_banca(), 22, y + 62, 250);
        } else {
            this.stampa.appendTextOvunque(this.fa_selezione.getR().getTe().getDescrizione(), 22, y + 62);
        }
    }

    public void appendi_descrizione(int y) {
        this.stampa.appendRoundRect(18, y + 75, 406, 60, 10, 10);
        this.stampa.setFont(this.stampa.Font_Calibri_10_B);
        this.stampa.appendTextOvunque("DESCRIZIONE GENERICA:", 22, y + 85);
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        this.stampa.appendTestoDimensionePosizione(this.fa_selezione.getDescrizione(), 22, y + 95, 396);
        int altezza_descrizione = this.stampa.dimensioneSplitString(this.fa_selezione.getDescrizione(), 396, this.stampa.Font_Calibri_8);
        System.out.println("L'altezza della descrizione \u00e8 di " + altezza_descrizione + " Righe");
    }

    public void appendi_cliente(int y, String ragione_sociale, String sede_via, String sede_cap, String sede_citta, String sede_provincia) {
        this.stampa.appendRoundRect(429, y + 75, 149, 60, 10, 10);
        this.stampa.setFont(this.stampa.Font_Calibri_10_B);
        this.stampa.appendTextOvunque("Spett.", 433, y + 87);
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        this.stampa.appendTestoDimensionePosizione(ragione_sociale + " \n " + sede_via + " \n " + sede_cap + " " + sede_citta + "  " + sede_provincia, 433, y + 100, 130);
        this.stampa.setFont(this.stampa.Font_Calibri_8);
    }

    public void appendi_destinazione(int y, String ragione_sociale) {
        this.stampa.appendRoundRect(335, y + 10, 243, 60, 10, 10);
        this.stampa.setFont(this.stampa.Font_Calibri_10_B);
        this.stampa.appendTextOvunque("DESTINAZIONE:", 342, y + 22);
        this.stampa.setFont(this.stampa.Font_Calibri_9);
        this.stampa.appendTestoDimensionePosizione(ragione_sociale + " \n" + this.fa_selezione.getDestinazione(), 342, y + 33, 150);
        this.stampa.setFont(this.stampa.Font_Calibri_9);
    }

    public void appendi_piva_cf(int y) {
        this.stampa.appendRoundRect(225, y + 10, 105, 40, 10, 10);
        this.stampa.appendTextOvunque("P.Iva/Cod. Fiscale Cliente : ", 230, y + 22);
        if (this.fa_selezione.getR().getAnagrafica().getPiva() != null) {
            this.stampa.appendTextOvunque((this.fa_selezione.getR().getAnagrafica().getPiva() + "  ").replaceAll("null  ", ""), 230, y + 32);
            this.stampa.appendTextOvunque((this.fa_selezione.getR().getAnagrafica().getCf() + "  ").replaceAll("null  ", ""), 230, y + 40);
        } else {
            this.stampa.appendTextOvunque((this.fa_selezione.getR().getAnagrafica().getCf() + "  ").replaceAll("null  ", ""), 230, y + 32);
        }
    }

    public void appendi_righe(int y, int y_da_togliere, Vector righerighe, int y_inizio, int hh) {
        String[] riga;
        Iterator i_data;
        this.stampa.appendRoundRect(18, y + 140, 559, 18, 10, 10);
        this.stampa.appendRoundRect(18, y + 161, 559, hh - y_da_togliere, 10, 10);
        TipoDocumentoAttivo tf = new TipoDocumentoAttivo();
        tf.seleziona(this.fa_selezione.getId_tipo());
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        int contocolonne = tf.getColonne().size();
        String[] h = new String[contocolonne];
        Iterator ic = tf.getColonne().iterator();
        Vector<String[]> data = new Vector<String[]>();
        Iterator ii = righerighe.iterator();
        while (ic.hasNext()) {
            TipoDocumentoAttivo.Colonna cc = (TipoDocumentoAttivo.Colonna)ic.next();
            h[cc.getIndice()] = cc.getAlias();
        }
        while (ii.hasNext()) {
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            String[] riga2 = new String[contocolonne];
            RigaDocumento temp = (RigaDocumento)ii.next();
            for (TipoDocumentoAttivo.Colonna cc : tf.getColonne()) {
                switch (cc.getId_di_riferimento()) {
                    case 1: {
                        riga2[cc.getIndice()] = temp.getCodice_articolo();
                        break;
                    }
                    case 2: {
                        riga2[cc.getIndice()] = temp.getDescrizione();
                        break;
                    }
                    case 3: {
                        riga2[cc.getIndice()] = temp.getCol_gen_1();
                        break;
                    }
                    case 4: {
                        riga2[cc.getIndice()] = temp.getCol_gen_2();
                        break;
                    }
                    case 5: {
                        riga2[cc.getIndice()] = temp.getUnita_misura();
                        break;
                    }
                    case 6: {
                        String q = this.f.formattaNumero("" + temp.getQuantita());
                        String sub = q.substring(q.indexOf("."), q.length());
                        if (sub.equals("00")) {
                            riga2[cc.getIndice()] = "" + q.substring(0, q.indexOf("."));
                            break;
                        }
                        riga2[cc.getIndice()] = "" + q;
                        break;
                    }
                    case 7: {
                        riga2[cc.getIndice()] = "" + temp.getPrezzo_unitario();
                        break;
                    }
                    case 8: {
                        riga2[cc.getIndice()] = this.f.formattaNumero(Double.toString(temp.getSconto()));
                        break;
                    }
                    case 9: {
                        riga2[cc.getIndice()] = "" + temp.getImporto();
                        break;
                    }
                    case 10: {
                        riga2[cc.getIndice()] = temp.getAliquota() != null ? temp.getAliquota().getCodice() : "";
                    }
                }
            }
            data.add(riga2);
        }
        int tipo = this.fa_selezione.getId_tipo();
        if (tipo == 1) {
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            i_data = data.iterator();
            int y_tabella = y + 150;
            this.stampa.appendTextOvunque(h[0], 20, y_tabella);
            this.stampa.appendTextOvunque(h[1], 400, y_tabella);
            this.stampa.appendTextOvunque(h[2], 500, y_tabella);
            y_tabella += 20;
            boolean trovato = false;
            while (i_data.hasNext()) {
                riga = (String[])i_data.next();
                this.stampa.appendTestoDimensionePosizione(riga[0], 20, y_tabella, 350);
                int righe = this.stampa.dimensioneSplitString(riga[0], 350, this.stampa.Font_Calibri_8);
                this.stampa.appendTextOvunque(riga[1], 400, y_tabella);
                this.stampa.appendTextOvunque(riga[2], 500, y_tabella);
                if (righe > 1) {
                    y_tabella += 11 + (righe - 1) * 11;
                    continue;
                }
                y_tabella += 11;
            }
        }
        if (tipo == 2) {
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            i_data = data.iterator();
            int y_tabella = y + 150;
            this.stampa.appendTextOvunque(h[1], 20, y_tabella);
            this.stampa.appendTextOvunque(h[2], 115, y_tabella);
            this.stampa.appendTextOvunque(h[3] + " [" + h[4] + "]", 340, y_tabella);
            this.stampa.appendTextOvunque(h[5], 410, y_tabella);
            this.stampa.appendTextOvunque(h[6], 500, y_tabella);
            this.stampa.appendTextOvunque(h[7], 550, y_tabella);
            y_tabella += 20;
            boolean trovato = false;
            while (i_data.hasNext()) {
                riga = (String[])i_data.next();
                this.stampa.appendTestoDimensionePosizione(riga[1], 20, y_tabella, 350);
                this.stampa.appendTestoDimensionePosizione(riga[2], 115, y_tabella, 240);
                int righe = this.stampa.dimensioneSplitString(riga[2], 240, this.stampa.Font_Calibri_8);
                this.stampa.appendTestoDimensionePosizione(riga[3] + " [" + riga[4] + "]", 340, y_tabella, 80);
                this.stampa.appendTestoDimensionePosizione(riga[5], 410, y_tabella, 350);
                this.stampa.appendTextOvunque(riga[6], 500, y_tabella);
                this.stampa.appendTextOvunque(riga[7], 550, y_tabella);
                if (righe > 1) {
                    y_tabella += 11 + (righe - 1) * 11;
                    continue;
                }
                y_tabella += 11;
            }
        }
        if (tipo == 3) {
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            i_data = data.iterator();
            int y_tabella = y + 150;
            this.stampa.appendTextOvunque(h[0], 20, y_tabella);
            this.stampa.appendTextOvunque(h[1], 135, y_tabella);
            this.stampa.appendTextOvunque(h[2], 277, y_tabella);
            this.stampa.appendTextOvunque(h[3] + " [" + h[4] + "]", 350, y_tabella);
            this.stampa.appendTextOvunque(h[5], 400, y_tabella);
            this.stampa.appendTextOvunque(h[6], 490, y_tabella);
            this.stampa.appendTextOvunque(h[7], 540, y_tabella);
            y_tabella += 20;
            boolean trovato = false;
            while (i_data.hasNext()) {
                riga = (String[])i_data.next();
                this.stampa.appendTextOvunque(riga[0], 20, y_tabella);
                this.stampa.appendTestoDimensionePosizione(riga[1], 135, y_tabella, 130);
                int righe = this.stampa.dimensioneSplitString(riga[1], 130, this.stampa.Font_Calibri_8);
                this.stampa.appendTextOvunque(riga[2], 277, y_tabella);
                if (!riga[0].equals("")) {
                    this.stampa.appendTestoDimensionePosizione(riga[3] + " [" + riga[4] + "]", 350, y_tabella, 80);
                    this.stampa.appendTextOvunque(riga[5], 400, y_tabella);
                    this.stampa.appendTextOvunque(riga[6], 490, y_tabella);
                    this.stampa.appendTextOvunque(riga[7], 540, y_tabella);
                }
                if (righe > 2) {
                    y_tabella += 11 + (righe - 2) * 11;
                    continue;
                }
                y_tabella += 11;
            }
        }
        if (tipo == 4) {
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            i_data = data.iterator();
            int y_tabella = y + 150;
            this.stampa.appendTextOvunque(h[0], 20, y_tabella);
            this.stampa.appendTextOvunque(h[1], 85, y_tabella);
            this.stampa.appendTextOvunque(h[2], 150, y_tabella);
            this.stampa.appendTextOvunque(h[3] + "[" + h[4] + "]", 340, y_tabella);
            this.stampa.appendTextOvunque(h[5], 410, y_tabella);
            this.stampa.appendTextOvunque(h[6], 490, y_tabella);
            this.stampa.appendTextOvunque(h[7], 540, y_tabella);
            y_tabella += 20;
            boolean trovato = false;
            while (i_data.hasNext()) {
                riga = (String[])i_data.next();
                this.stampa.appendTestoDimensionePosizione(riga[0], 20, y_tabella, 60);
                this.stampa.appendTestoDimensionePosizione(riga[1], 85, y_tabella, 150);
                this.stampa.appendTestoDimensionePosizione(riga[2], 150, y_tabella, 150);
                int righe = this.stampa.dimensioneSplitString(riga[2], 150, this.stampa.Font_Calibri_8);
                if (!riga[0].equals("")) {
                    this.stampa.appendTestoDimensionePosizione(riga[3] + "[" + riga[4] + "]", 340, y_tabella, 340);
                    this.stampa.appendTextOvunque(riga[5], 410, y_tabella);
                    this.stampa.appendTextOvunque(riga[6], 490, y_tabella);
                }
                this.stampa.appendTextOvunque(riga[7], 540, y_tabella);
                if (righe > 2) {
                    y_tabella += 11 + (righe - 2) * 11;
                    continue;
                }
                y_tabella += 11;
            }
        }
        if (tipo == 5) {
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            i_data = data.iterator();
            int y_tabella = y + 150;
            this.stampa.appendTextOvunque(h[1], 20, y_tabella);
            this.stampa.appendTextOvunque(h[2], 100, y_tabella);
            this.stampa.appendTextOvunque(h[3], 400, y_tabella);
            this.stampa.appendTextOvunque(h[4], 500, y_tabella);
            y_tabella += 20;
            while (i_data.hasNext()) {
                String[] riga3 = (String[])i_data.next();
                this.stampa.appendTestoDimensionePosizione(riga3[1], 20, y_tabella, 350);
                int righe = this.stampa.dimensioneSplitString(riga3[1], 350, this.stampa.Font_Calibri_8);
                this.stampa.appendTextOvunque(riga3[2], 100, y_tabella);
                this.stampa.appendTextOvunque(riga3[3], 400, y_tabella);
                this.stampa.appendTextOvunque(riga3[4], 500, y_tabella);
                if (righe > 1) {
                    y_tabella += 11 + (righe - 1) * 11;
                    continue;
                }
                y_tabella += 11;
            }
        }
    }

    public void appendi_totali(int y, int y_da_togliere) {
        this.stampa.appendRoundRect(18, y + 518 - y_da_togliere, 358, 100, 10, 10);
        this.stampa.setFont(this.stampa.Font_Calibri_9_B);
        if (this.fa_selezione.getId_tipo() != 5) {
            String iva = "% IVA";
            String imponibile = "Imponibile";
            String imposta = "Imposta";
            String descrizione = "Descrizione";
            this.stampa.appendTextOvunque(iva, 22, y + 530);
            this.stampa.appendStringaOvunqueFormattazioneDestra(imponibile, 65, y + 530, 45);
            this.stampa.appendStringaOvunqueFormattazioneDestra(imposta, 125, y + 530, 45);
            this.stampa.appendTextOvunque(descrizione, 190, y + 530);
            this.stampa.setFont(this.stampa.Font_Calibri_9);
            for (TotaliDocumento temp : this.fa_selezione.getV_riepilogo()) {
                String s_iva = temp.getAliquota().getAliquota() + " %";
                String s_imponibile = this.f.formattaNumero("" + temp.getImponibile());
                String s_imposta = this.f.formattaNumero("" + temp.getImpsta());
                String s_descrizione = temp.getAliquota().getDescrizione();
                if (s_descrizione.equals("")) {
                    s_iva = "TOTALI";
                }
                this.stampa.appendTextOvunque(s_iva, 22, y + 541);
                this.stampa.appendStringaOvunqueFormattazioneDestra(s_imponibile, 65, y + 541, 45);
                this.stampa.appendStringaOvunqueFormattazioneDestra(s_imposta, 125, y + 541, 45);
                this.stampa.appendTextOvunque(s_descrizione, 190, y + 540);
                y += 12;
            }
            this.stampa.appendLine(22, y + 541 - 20, 230, y + 541 - 20);
        } else {
            Iterator<RigaDocumento> i = this.fa_selezione.getInsieme_r().vettoreR.iterator();
            int nr_colli = 0;
            while (i.hasNext()) {
                RigaDocumento temp = i.next();
                try {
                    nr_colli += Integer.parseInt(temp.getCol_gen_1());
                }
                catch (NumberFormatException e) {}
            }
            this.stampa.setFont(this.stampa.Font_Arial_12_B);
            this.stampa.appendTextOvunque("Nr. Colli = " + nr_colli, 30, y + 535 - y_da_togliere);
            this.stampa.appendTextOvunque("Aspetto Visibile", 30, y + 550 - y_da_togliere);
        }
    }

    public void appendi_totali_vuoto(int y, int y_da_togliere) {
        this.stampa.appendRoundRect(18, y + 518 - y_da_togliere, 358, 100, 10, 10);
    }

    public void appendi_scadenze(int y, int y_da_togliere) {
        if (this.fa_selezione.getId_tipo() != 5) {
            this.stampa.appendRoundRect(382, y + 518 - y_da_togliere, 195, 100, 10, 10);
            if (this.fa_selezione.getR().getCc().getTm().getNotaCredito() == 1) {
                this.stampa.setFont(this.stampa.Font_Calibri_12_B);
                this.stampa.appendTextOvunque("TOTALE A CREDITO", 390, y + 535 - y_da_togliere);
                this.stampa.appendTextOvunque("" + this.fa_selezione.getR().getImporto_doc().toString(), 480, y + 555 - y_da_togliere);
            } else {
                Vector vettorescadenze = new Vector();
                vettorescadenze = this.fa_selezione.getR().getInsieme_s().vettoreS;
                Iterator is = vettorescadenze.iterator();
                int numero_rate = vettorescadenze.size();
                Money importo = this.fa_selezione.getR().getImporto_doc();
                int indice = 0;
                while (is.hasNext()) {
                    Scadenza scadenza;
                    if (numero_rate == 1) {
                        this.stampa.setFont(this.stampa.Font_Calibri_12_B);
                        this.stampa.appendTextOvunque("TOTALE A PAGARE", 390, y + 535 - y_da_togliere);
                        this.stampa.appendTextOvunque("" + importo.toString(), 480, y + 555 - y_da_togliere);
                        this.stampa.appendTextOvunque("SCADENZA", 390, y + 600 - y_da_togliere);
                        scadenza = (Scadenza)is.next();
                        this.stampa.appendTextOvunque("" + this.fda.gira_data(scadenza.getData_scadenza()), 480, y + 610 - y_da_togliere);
                        continue;
                    }
                    this.stampa.setFont(this.stampa.Font_Calibri_12_B);
                    this.stampa.appendTextOvunque("TOTALE A PAGARE", 390, y + 535 - y_da_togliere);
                    this.stampa.appendTextOvunque("" + this.fa_selezione.getR().getImporto_doc(), 520, y + 535 - y_da_togliere);
                    this.stampa.setFont(this.stampa.Font_Calibri_10_B);
                    this.stampa.appendTextOvunque("SCADENZA DEL", 390, y + 555 + indice * 15 - y_da_togliere);
                    scadenza = (Scadenza)is.next();
                    this.stampa.appendTextOvunque("" + this.fda.gira_data(scadenza.getData_scadenza()), 460, y + 555 + indice * 15 - y_da_togliere);
                    this.stampa.appendTextOvunque(scadenza.getImporto().toString(), 530, y + 555 + indice * 15 - y_da_togliere);
                    ++indice;
                }
            }
        } else {
            this.stampa.appendRoundRect(382, y + 518 - y_da_togliere, 195, 100, 10, 10);
            this.stampa.setFont(this.stampa.Font_Calibri_10_B);
            this.stampa.appendTextOvunque("Firma del Conducente/Vettore :", 395, y + 531 - y_da_togliere);
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            this.stampa.appendTestoDimensionePosizione("Si dichiara di aver preso in carico la merce.", 395, y + 541 - y_da_togliere, 200);
            this.stampa.appendTestoDimensionePosizione("_____________________________________________", 395, y + 563 - y_da_togliere, 200);
            this.stampa.setFont(this.stampa.Font_Calibri_10_B);
            this.stampa.appendTextOvunque("Firma del Cessionario/Intermediario :", 395, y + 583 - y_da_togliere);
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            this.stampa.appendTestoDimensionePosizione("Si dichiara di aver ricevuto la merce sopra indicata.", 395, y + 593 - y_da_togliere, 200);
            this.stampa.appendTestoDimensionePosizione("_____________________________________________", 395, y + 615 - y_da_togliere, 200);
        }
    }

    public void appendi_scadenze_vuoto(int y, int y_da_togliere) {
        this.stampa.appendRoundRect(382, y + 518 - y_da_togliere, 195, 100, 10, 10);
        this.stampa.appendTestoDimensionePosizione("Le scadenze e i totali si trovano nell'ultima pagina della fattura", 400, y + 540, 170);
    }

    public void appendi_piedi_pagina_fattura(int y, int y_da_togliere) {
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        this.stampa.appendTextOvunque(" I Vs. dati anagrafici sono da noi considerati esatti sotto la Vs. responsabilit\u00e0, salvo diversa comunicazione, come previsto dall'art. 41 DPR 26/10/72 n\u00b0633.", 22, y + 645 - y_da_togliere);
        this.stampa.appendTextOvunque(" Legge 196/2003 PRIVACY: I Vs. dati esposti nel presente documento vengono usati esclusivamente per fini contabili ed amministrativi", 22, y + 653 - y_da_togliere);
        this.stampa.appendTestoDimensionePosizione(" In caso di ritardato pagamento Vi verranno addebitati gli interessi di mora pari al prime rate ABI in vigore al momento dell'insolvenza ,aumentato di 7 punti", 22, y + 665 - y_da_togliere, 600);
    }
}

