/*
 * Decompiled with CFR 0.152.
 */
package gestionale.documenti;

import gestionale.documenti.RigaDocumento;
import gestionale.documenti.TipoDocumentoAttivo;
import gestionale.iva.Aliquota;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import magazzino.articoli.Articolo;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.Quantita;

public class RigheDocumentiTableModel
extends AbstractTableModel {
    public ArrayList<RigaDocumento> cache;
    int colCount;
    public TipoDocumentoAttivo tf = new TipoDocumentoAttivo();
    String[] headers;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public RigheDocumentiTableModel(int id_tipo_fattura) {
        this.cache = new ArrayList();
        this.tf.seleziona(id_tipo_fattura);
    }

    public void setTipoFattura(int id_tipo_fattura) {
        this.tf = new TipoDocumentoAttivo();
        this.tf.seleziona(id_tipo_fattura);
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        for (TipoDocumentoAttivo.Colonna c : this.tf.colonne) {
            if (c.getIndice() != i) continue;
            retVal = c.getAlias();
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return this.tf.colonne.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object retVal = "";
        RigaDocumento riga = new RigaDocumento();
        if (!this.cache.isEmpty()) {
            riga = this.cache.get(row);
            for (TipoDocumentoAttivo.Colonna c : this.tf.colonne) {
                if (c.getIndice() != col) continue;
                retVal = riga.getColValue(c);
            }
        } else {
            retVal = "";
        }
        return retVal;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        RigaDocumento r = this.cache.get(row);
        for (TipoDocumentoAttivo.Colonna c : this.tf.colonne) {
            if (c.getIndice() != col) continue;
            switch (c.getId_di_riferimento()) {
                case 1: {
                    String w;
                    if (this.tf.getId() == 2) {
                        if (r.getArticolo() == null) {
                            r.setArticolo(new Articolo());
                        }
                        r.getArticolo().setCodice_articolo(value.toString());
                        w = " WHERE codice_articolo='" + value.toString() + "'";
                        r.getArticolo().seleziona(w);
                        r.setCodice_articolo(r.getArticolo().getCodice_articolo());
                        r.setDescrizione(r.getArticolo().getDescrizione());
                        r.setPrezzo_unitario(r.getArticolo().getUltimo_costo_acquisto());
                        r.setUnita_misura(r.getArticolo().getCodice_um());
                        r.setQuantita(new Quantita(BigDecimal.ONE));
                        r.setImporto(r.getPrezzo_unitario().multiply(r.getQuantita()));
                        r.setAliquota(new Aliquota());
                        String w2 = " WHERE idAliquota=" + r.getArticolo().getId_aliquota_vendite() + " ";
                        r.getAliquota().seleziona(w2);
                        break;
                    }
                    r.setCodice_articolo(value.toString());
                    break;
                }
                case 2: {
                    r.setDescrizione(value.toString());
                    break;
                }
                case 3: {
                    r.setCol_gen_1(value.toString());
                    break;
                }
                case 4: {
                    r.setCol_gen_2(value.toString());
                    break;
                }
                case 5: {
                    r.setUnita_misura(value.toString());
                    break;
                }
                case 6: {
                    r.setQuantita(new Quantita(value.toString()));
                    r.setImporto(r.getPrezzo_unitario().multiply(r.getQuantita()));
                    break;
                }
                case 7: {
                    r.setPrezzo_unitario(new Money(value.toString()));
                    r.setImporto(r.getPrezzo_unitario().multiply(r.getQuantita()));
                    break;
                }
                case 8: {
                    r.setSconto(Double.parseDouble(value.toString()));
                    break;
                }
                case 9: {
                    r.setImporto(new Money(value.toString()));
                    break;
                }
                case 10: {
                    r.setAliquota(new Aliquota());
                    String w = " WHERE codice='" + value.toString() + "' ";
                    r.getAliquota().seleziona(w);
                    r.setId_aliquota(r.getAliquota().getId());
                }
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        for (TipoDocumentoAttivo.Colonna c : this.tf.colonne) {
            if (c.getIndice() != col) continue;
            return c.getEditabile() == 1;
        }
        return true;
    }

    public void setDataRiga(ArrayList<RigaDocumento> vettoreR) {
        this.cache = new ArrayList();
        Iterator<RigaDocumento> i = vettoreR.iterator();
        while (i.hasNext()) {
            this.cache.add(i.next());
        }
        this.fireTableChanged(null);
    }

    public void _setDataRiga2(ArrayList<RigaDocumento> vettoreR) {
        this.cache = new ArrayList();
        for (RigaDocumento rf : vettoreR) {
            if (rf.getImporto().isZero() && rf.getDescrizione().equals("") && rf.getAliquota() != null) continue;
            this.cache.add(rf);
        }
        this.fireTableChanged(null);
    }
}

