/*
 * Decompiled with CFR 0.152.
 */
package gestionale.documenti;

import anagrafiche.banche.MyBanche;
import anagrafiche.clienti_fornitori.Anagrafica;
import anagrafiche.indirizzi.DA_CANCELLARE_Indirizzo;
import controlling.regole.MyRegole;
import controlling.voci_di_analisi.MyVociDiAnalisi;
import gestionale.MyDesktopWindow;
import gestionale.causali_contabili.CausaleContabile;
import gestionale.causali_contabili.MyCausaliContabili;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import gestionale.documenti.DocumentiAttiviTableRenderer;
import gestionale.documenti.DocumentiFixedModel;
import gestionale.documenti.DocumentiTableModel;
import gestionale.documenti.Documento;
import gestionale.documenti.InsiemeDocumenti;
import gestionale.documenti.InsiemeRigheDoc;
import gestionale.documenti.RigaDocumento;
import gestionale.documenti.RigheDocumentiTableModel;
import gestionale.documenti.StampaDocumentoAttivo;
import gestionale.documenti.TotaliDocumento;
import gestionale.documenti.TotaliDocumentoTableModel;
import gestionale.iva.Aliquota;
import gestionale.iva.MyConfiguraAliquotaIVA;
import gestionale.iva.RegistriIVA;
import gestionale.piano_dei_conti.MyConto5;
import gestionale.primanota.InsiemePNIva;
import gestionale.primanota.InsiemePNRiga;
import gestionale.primanota.InsiemePartite;
import gestionale.primanota.PNIvaMagTableModel;
import gestionale.primanota.PNRigaMagTableModel;
import gestionale.primanota.Registrazione;
import gestionale.primanota.RiepilogoTableRenderer;
import gestionale.scadenziario.InsiemeScadenze;
import gestionale.trattamento_economico.MyTrattamentoEconomico;
import gestionale.trattamento_economico.TrattamentoEconomico;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import utils.ClientiFornitoriField;
import utils.ComboInsertEditor;
import utils.DataCellRenderer;
import utils.DateField;
import utils.DateInsertEditor;
import utils.FixedTable;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.PanelElenco;
import utils.Performance;
import utils.RicercaCellComboRenderer;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.TextInsertEditor;
import utils.TimeFormatter;
import utils.ToolTipHeader;

public class MyDocumentiAttivi
extends JInternalFrame
implements ListSelectionListener {
    String civetta_permessi;
    public static int size_diritti = 2;
    public static String[] array_diritti = new String[]{"DOCUMENTI_VISUALIZZA", "DOCUMENTI_MODIFICA"};
    JToolBar jToolBarMod;
    DocumentiTableModel fatm;
    DocumentiFixedModel fafm;
    InsiemeDocumenti insieme_fa;
    JTable jTableFA;
    FixedTable fixedTable;
    Documento fa_selezione;
    DateField data_emissione;
    DateField data_reg;
    TimeFormatter mf = null;
    ArrayList<DA_CANCELLARE_Indirizzo> v_sedi;
    int sede_sel;
    RigheDocumentiTableModel rf_tm;
    TotaliDocumentoTableModel tf_tm;
    PNRigaMagTableModel pnr_tm;
    PNIvaMagTableModel pni_tm;
    private TableRowSorter<DocumentiTableModel> sorter;
    RowFilter<DocumentiTableModel, Object> rf = null;
    ArrayList<RowFilter<DocumentiTableModel, Object>> andFilters = new ArrayList();
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    public JInternalFrame chiamante;
    public int row_chiamante;
    public boolean f_causali_open = false;
    public boolean f_ba_open = false;
    public boolean f_te_open = false;
    public boolean f_aliquota_open = false;
    public boolean f_vda_open = false;
    public boolean f_regole_open = false;
    public boolean aiuto_riga_c = false;
    public boolean aiuto_iva_a = false;
    public boolean aiuto_iva_rf = false;
    public ClientiFornitoriField jTextCodCliente;
    int riga_selezionata_nella_tabella = -1;
    PanelElenco p;
    private JButton jBN;
    private JButton jBP;
    private JButton jButtonAddRigaRow;
    private JButton jButtonClean;
    private JButton jButtonElimina;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JComboBox jComboIVAP;
    private JComboBox jComboModello;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelDescCausale;
    private JLabel jLabelDescCliente;
    private JLabel jLabelRI;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPanel jPanelContabilit\u00e0;
    private JPanel jPanelElenco;
    private JPanel jPanelGenerale;
    private JPanel jPanelIva;
    private JPanel jPanelRiepilogo;
    private JPanel jPanelRighe;
    private JPanel jPanelRighe1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane8;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JTabbedPane jTabbedPane2;
    public JTable jTablePNIva;
    public JTable jTablePNRighe;
    public JTable jTableRighe;
    public JTable jTableTotali;
    private JTextField jTextAnno;
    private JTextField jTextAnnoProt;
    private JTextField jTextAnnoReg;
    public JTextField jTextBanca;
    public JTextField jTextCC;
    private JTextField jTextCodifica;
    private JTextArea jTextDescrizione;
    private JTextArea jTextDestinazione;
    private JTextField jTextNReg;
    private JTextArea jTextNote;
    private JTextField jTextNumero;
    private JTextField jTextProtIVA;
    private JTextField jTextRI;
    public JTextField jTextTE;
    private JTextField jTextTot;
    private JTextField jTextTotIVA;
    private JTextField jTextTotImponibile;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;

    public MyDocumentiAttivi() {
        Performance perf = new Performance("MyDocumentiAttivi");
        if (!MyDesktopWindow.profilo.controllaPermesso("DOCUMENTI_VISUALIZZA")) {
            Configurazioni.eccezione.gestisci("7.1", null);
            this.dispose();
        }
        this.rf_tm = new RigheDocumentiTableModel(1);
        this.tf_tm = new TotaliDocumentoTableModel();
        this.pnr_tm = new PNRigaMagTableModel();
        this.pni_tm = new PNIvaMagTableModel();
        this.initComponents();
        this.fatm = new DocumentiTableModel();
        this.insieme_fa = new InsiemeDocumenti();
        this.jTableFA = new JTable(this.fatm);
        this.fafm = new DocumentiFixedModel();
        this.fafm.setFIXED_NUM(0);
        this.fixedTable = new FixedTable(this.fafm);
        this.p = new PanelElenco(this.jTableFA, this.fixedTable);
        this.sorter = new TableRowSorter<DocumentiTableModel>(this.fatm);
        for (int i = 0; i < this.fatm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.jTableFA.setRowSorter(this.sorter);
        ListSelectionModel listSelectionModel = this.jTableFA.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jTextDestinazione.setLineWrap(true);
        this.jTextDescrizione.setLineWrap(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mf = new TimeFormatter();
        this.data_emissione = new DateFieldLocal(this.mf);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.data_emissione, gridBagConstraints);
        this.data_reg = new DateFieldLocalReg(this.mf);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.data_reg, gridBagConstraints);
        this.jTextCodCliente = new ClientiFornitoriFieldLocal(this, "C");
        this.jTextCodCliente.setPreferredSize(new Dimension(100, 27));
        this.jTextCodCliente.tipo = "C";
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jTextCodCliente, gridBagConstraints);
        this.crea_toolbar();
        this.filtra();
        this.formatta();
        this.visualizzazione();
        this.controlla_diritti();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(850, 500)));
        perf.fine();
    }

    private void controlla_diritti() {
        if (!MyDesktopWindow.profilo.controllaPermesso("DOCUMENTI_MODIFICA")) {
            this.jButtonModifica.setEnabled(false);
            this.jButtonNuovo.setEnabled(false);
            this.jButtonElimina.setEnabled(false);
        }
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    public void aggiornamento() {
        if (this.data_reg.getText().equals("") || this.data_reg.getText().equals("  -  -    ")) {
            this.data_reg.setText(this.fda.dataCorrenteIt());
        }
        if (this.data_emissione.getText().equals("") || this.data_emissione.getText().equals("  -  -    ")) {
            this.data_emissione.setText(this.fda.dataCorrenteIt());
        }
        String anno_reg = this.fda.anno(this.fda.gira_data(this.data_reg.getText()));
        int num_reg = this.f.ultima_registrazione(Integer.parseInt(anno_reg)) + 1;
        if (!anno_reg.equals(this.jTextAnnoReg.getText())) {
            MyTrace.log.info("E'cambiato l'anno registrazione");
            boolean ok = true;
            if (this.jTextAnnoReg.getText().equals("") || this.jTextNReg.getText().equals("")) {
                MyTrace.log.info("Prima era nullo => posso settare il nuovo numero di registrazione");
                ok = true;
            } else {
                MyTrace.log.info("Controllo se era l'ultima registrazione per quell'anno");
                int ultima_registrazione_fatta = this.f.ultima_registrazione(Integer.parseInt(this.jTextAnnoReg.getText()));
                if (Integer.parseInt(this.jTextNReg.getText()) >= ultima_registrazione_fatta) {
                    MyTrace.log.info("Era l'ultima registrazione per quell'anno  => posso settare il nuovo num,ero di registrazione ");
                    ok = true;
                } else {
                    MyTrace.log.info("NON era l'ultima registrazione per quell'anno  => NON posso settare il nuovo n um,ero di registrazione ");
                    ok = false;
                }
            }
            if (ok) {
                this.jTextNReg.setText("" + num_reg);
                this.jTextAnnoReg.setText(anno_reg);
            }
        }
        String anno_fat = this.fda.anno(this.fda.gira_data(this.data_emissione.getText()));
        if (!this.jTextCC.getText().equals("")) {
            CausaleContabile cc_temp = new CausaleContabile();
            cc_temp.seleziona(this.jTextCC.getText());
            cc_temp.seleziona_dettagli();
            this.fa_selezione.getR().setCc(cc_temp);
            if (cc_temp.getTm().getFatturaAttiva() == 1 || cc_temp.getTm().getNotaDebito() == 1 || cc_temp.getTm().getNotaCredito() == 1) {
                int num_fat = cc_temp.getTm().getContatore().ultimo_documento(Integer.parseInt(anno_fat)) + 1;
                int prot_iva = cc_temp.getTm().getContatore().ultimo_protocollo_iva(Integer.valueOf(anno_fat), cc_temp.getId_registro_iva()) + 1;
                if (cc_temp.getId() != this.fa_selezione.getId_causale_contabile() || !anno_fat.equals(this.jTextAnno.getText())) {
                    MyTrace.log.info("E' cambiata la causale contabile o l'anno del documento");
                    boolean ok_prot = true;
                    if (this.jTextAnno.getText().equals("") || this.jTextProtIVA.getText().equals("") || this.in_new) {
                        MyTrace.log.info("Prima era nullo => posso settare il nuovo numero di protocollo e di documento");
                        ok_prot = true;
                    } else {
                        MyTrace.log.info("Controllo se era l'ultimo protocollo per quell'anno");
                        int ultima_protoc_fatto = cc_temp.getTm().getContatore().ultimo_protocollo_iva(Integer.parseInt(anno_fat), cc_temp.getId_registro_iva());
                        if (Integer.parseInt(this.jTextProtIVA.getText()) >= ultima_protoc_fatto) {
                            MyTrace.log.info("Era l'ultimo prot per quell'anno  => posso settare il nuovo numero di protocollo ");
                            ok_prot = true;
                        } else {
                            MyTrace.log.info("NON era l'ultimo prot per quell'anno  => NON posso settare il nuovo n um,ero di protocollo ");
                            ok_prot = false;
                        }
                    }
                    if (ok_prot) {
                        this.jTextAnno.setText(anno_fat);
                        this.jTextNumero.setText("" + num_fat);
                        this.jTextCC.setText(cc_temp.getCodice());
                        this.jTextCodifica.setText(cc_temp.getTm().getContatore().getCodifica());
                        this.jTextRI.setText(cc_temp.getReg_iva().getCodice());
                        this.jLabelRI.setText(cc_temp.getReg_iva().getDescrizione());
                        this.jTextProtIVA.setText("" + prot_iva);
                        this.jTextAnnoProt.setText("" + anno_fat);
                        this.fa_selezione.setNumero(num_fat);
                    } else {
                        JOptionPane.showMessageDialog(this, "ATTENZIONE, non posso modificare il protocollo anche se hai cambiato l'anno del documento!!!!");
                    }
                }
                this.fa_selezione.setId_causale_contabile(cc_temp.getId());
                this.fa_selezione.getR().setCc(cc_temp);
                this.jLabelDescCausale.setText(cc_temp.getDescrizione());
            } else {
                JOptionPane.showMessageDialog(this, "Questa Causale Contabile non \u00e8 per un documento attivo (fattura di vendita, nota di debito, nota di credito !!!");
            }
        }
    }

    public void visualizzazione() {
        this.jTextCC.setEnabled(this.in_modifica);
        this.jTextCodCliente.setEnabled(this.in_modifica);
        this.jTextDestinazione.setEnabled(this.in_modifica);
        this.jBN.setEnabled(this.in_modifica);
        this.jBP.setEnabled(this.in_modifica);
        this.jTextTE.setEnabled(this.in_modifica);
        this.data_emissione.setEnabled(this.in_modifica);
        this.data_reg.setEnabled(this.in_modifica);
        this.jTextDescrizione.setEnabled(this.in_modifica);
        this.jTextDescrizione.setEditable(true);
        this.jTextBanca.setEnabled(this.in_modifica);
        this.jButtonAddRigaRow.setEnabled(this.in_modifica);
        this.jTextNote.setEnabled(this.in_modifica);
        if (this.in_modifica) {
            this.getContentPane().remove(this.jToolBar1);
            this.getContentPane().add((Component)this.jToolBarMod, "North");
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.getContentPane().remove(this.jToolBarMod);
            this.getContentPane().add((Component)this.jToolBar1, "North");
            this.jTabbedPane1.setEnabledAt(0, true);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    private void azzera() {
        this.jTextCC.setText("");
        this.jLabelDescCausale.setText("** Non definito **");
        this.jComboModello.setSelectedIndex(0);
        this.jTextNumero.setText("");
        this.jTextCodifica.setText("");
        this.jTextAnno.setText("");
        this.data_emissione.setText(this.fda.dataCorrenteIt());
        this.jTextCodCliente.setText("");
        this.jLabelDescCliente.setText("** Non definito **");
        this.jTextDescrizione.setText("");
        this.jTextDestinazione.setText("");
        this.jTextRI.setText("");
        this.jLabelRI.setText("** Non definito **");
        this.jTextBanca.setText("");
        this.jComboIVAP.setSelectedIndex(0);
        this.jTextNote.setText("");
        this.jTextAnnoProt.setText("");
        this.jTextAnnoReg.setText("");
        this.jTextNReg.setText("");
        this.jTextProtIVA.setText("");
        this.data_reg.setText(this.fda.dataCorrenteIt());
        this.jTextTE.setText("");
        this.rf_tm = new RigheDocumentiTableModel(1);
        this.jTableRighe.setModel(this.rf_tm);
        this.tf_tm.setDataTF(new ArrayList<TotaliDocumento>());
        this.jTableTotali.setModel(this.tf_tm);
        this.pnr_tm = new PNRigaMagTableModel();
        this.jTablePNRighe.setModel(this.pnr_tm);
        this.pni_tm = new PNIvaMagTableModel();
        this.jTablePNIva.setModel(this.pni_tm);
        this.jTextTot.setText("");
        this.jTextTotIVA.setText("");
        this.jTextTotImponibile.setText("");
    }

    public void formatta() {
        this.jTableFA.setSelectionMode(0);
        this.jTableFA.setDefaultRenderer(Object.class, new DocumentiAttiviTableRenderer());
        this.fixedTable.setRowHeight(30);
        this.fixedTable.setDefaultEditor(String.class, new TextEditor());
        this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        this.header_tebella();
        TableColumn c = this.fixedTable.getColumn("CC");
        c.setPreferredWidth(80);
        c.setMaxWidth(80);
        c = this.jTableFA.getColumn("CC");
        c.setPreferredWidth(80);
        c.setMaxWidth(80);
        c = this.fixedTable.getColumn("Numero");
        c.setPreferredWidth(80);
        c.setMaxWidth(80);
        c = this.jTableFA.getColumn("Numero");
        c.setPreferredWidth(80);
        c.setMaxWidth(80);
        c = this.fixedTable.getColumn("Anno");
        c.setPreferredWidth(60);
        c.setMaxWidth(60);
        c = this.jTableFA.getColumn("Anno");
        c.setPreferredWidth(60);
        c.setMaxWidth(60);
        c = this.fixedTable.getColumn("Data");
        c.setPreferredWidth(90);
        c.setMaxWidth(90);
        c = this.jTableFA.getColumn("Data");
        c.setPreferredWidth(90);
        c.setMaxWidth(90);
        c = this.fixedTable.getColumn("Totale a pagare");
        c.setPreferredWidth(90);
        c.setMaxWidth(90);
        c = this.jTableFA.getColumn("Totale a pagare");
        c.setPreferredWidth(90);
        c.setMaxWidth(90);
    }

    public void formatta_dettagli() {
        this.jTablePNRighe.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyDocumentiAttivi.this.jTablePNRRigheKeyPressed(evt);
            }
        });
        this.jTableTotali.setModel(this.tf_tm);
        this.jTableTotali.setDefaultRenderer(Object.class, new RiepilogoTableRenderer());
        this.jTableRighe.setRowHeight(27);
        this.jTableRighe.setDefaultEditor(Object.class, new TextRigaEditor());
        this.jTableRighe.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        this.jTableRighe.setDefaultEditor(Date.class, new DateInsertEditor());
        this.jTableRighe.setDefaultRenderer(Date.class, new DataCellRenderer());
        this.jTablePNRighe.setRowHeight(27);
        this.jTablePNRighe.setDefaultEditor(Object.class, new TextPNRigaEditor());
        this.jTablePNRighe.setDefaultEditor(JCheckBox.class, new ComboInsertEditor(new String[]{"Dare", "Avere"}));
        this.jTablePNRighe.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        this.jTablePNRighe.setDefaultRenderer(JCheckBox.class, new RicercaCellComboRenderer(new String[]{"Dare", "Avere"}));
        this.jTablePNRighe.setDefaultEditor(Date.class, new DateInsertEditor());
        this.jTablePNRighe.setDefaultRenderer(Date.class, new DataCellRenderer());
        this.jTablePNIva.setRowHeight(27);
        this.jTablePNIva.setDefaultEditor(Object.class, new TextIVAEditor());
        this.jTablePNIva.setDefaultEditor(JCheckBox.class, new ComboInsertEditor(new String[]{"Dare", "Avere"}));
        this.jTablePNIva.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        this.jTablePNIva.setDefaultRenderer(JCheckBox.class, new RicercaCellComboRenderer(new String[]{"Dare", "Avere"}));
    }

    public void header_tebella() {
        try {
            String[] headerStr = new String[]{"Causale Contabile", "Numero", "Anno", "Data", "Cliente", "Descrizione", "Totale Imponibile", "Totale Imposta", "Totale a Pagare"};
            String[] toolTipStr = new String[]{"Causale Contabile", "Numero", "Anno", "Data", "Cliente", "Descrizione", "Totale Imponibile", "Totale Imposta", "Totale a Pagare"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableFA.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableFA.setTableHeader(header1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filtra() {
        this.insieme_fa = new InsiemeDocumenti();
        String order_by = " ORDER BY registro.data_doc DESC, numero DESC ";
        if (Configurazioni.righe_ricerca != 0) {
            order_by = order_by + " LIMIT 0," + Configurazioni.righe_ricerca;
        }
        this.insieme_fa.caricamento(" ", order_by);
        this.fatm.setDataFA(this.insieme_fa.vettoreDOC);
        if (Configurazioni.righe_ricerca != 0 && this.insieme_fa.vettoreDOC.size() >= Configurazioni.righe_ricerca) {
            this.non_tutte_le_righe = true;
        }
    }

    public void seleziona(int row) {
        this.fa_selezione = new Documento();
        this.fa_selezione = this.insieme_fa.vettoreDOC.get(row);
        this.fa_selezione.seleziona_dettagli();
        this.riempi_campi();
        this.formatta_dettagli();
    }

    public void riempi_campi() {
        this.jTextCC.setText(this.fa_selezione.getR().getCc().getCodice());
        if (this.fa_selezione.getR().getCc().getDescrizione() != null && !this.fa_selezione.getR().getCc().getDescrizione().equals("")) {
            this.jLabelDescCausale.setText(this.fa_selezione.getR().getCc().getDescrizione());
        }
        this.jComboModello.setSelectedItem(this.fa_selezione.getString_tipo());
        this.jTextCodCliente.setText("C" + this.fa_selezione.getR().getAnagrafica().getCodice());
        if (this.fa_selezione.getR().getAnagrafica().getRagione_sociale() != null && !this.fa_selezione.getR().getAnagrafica().getRagione_sociale().equals("")) {
            this.jLabelDescCliente.setText(this.fa_selezione.getR().getAnagrafica().getRagione_sociale());
        }
        this.jTextTE.setText(this.fa_selezione.getR().getTe().getCodice());
        this.jTextDestinazione.setText(this.fa_selezione.getDestinazione());
        this.jTextDescrizione.setText(this.fa_selezione.getDescrizione());
        if (this.fa_selezione.getNumero() != 0) {
            this.jTextNumero.setText("" + this.fa_selezione.getNumero());
        }
        this.jTextCodifica.setText(this.fa_selezione.getCodifica());
        this.jTextAnno.setText("" + this.fa_selezione.getAnno());
        this.data_emissione.setText(this.fa_selezione.getR().getData_docIt());
        this.data_reg.setText(this.fa_selezione.getR().getData_regIt());
        this.jTextRI.setText("" + this.fa_selezione.getR().getRi().getCodice());
        if (this.fa_selezione.getR().getRi().getDescrizione() != null && !this.fa_selezione.getR().getRi().getDescrizione().equals("")) {
            this.jLabelRI.setText(this.fa_selezione.getR().getRi().getDescrizione());
        }
        this.jTextProtIVA.setText("" + this.fa_selezione.getR().getProtocollo_iva());
        this.jTextAnnoProt.setText("" + this.fa_selezione.getR().getAnno_prot());
        this.jTextNReg.setText("" + this.fa_selezione.getR().getNum_reg());
        this.jTextAnnoReg.setText("" + this.fa_selezione.getR().getAnno_reg());
        this.jTextBanca.setText(this.fa_selezione.getR().getDesc_banca());
        this.jTextNote.setText(this.fa_selezione.getR().getNote());
        this.rf_tm.setTipoFattura(this.fa_selezione.getId_tipo());
        if (this.fa_selezione.getInsieme_r() != null) {
            this.rf_tm.setDataRiga(this.fa_selezione.getInsieme_r().vettoreR);
        }
        this.jTableRighe.setModel(this.rf_tm);
        this.tf_tm = new TotaliDocumentoTableModel();
        this.calcola_totali();
        this.pni_tm.setDataPNIva(this.fa_selezione.getR().getInsieme_iva().vettoreIVAPN);
        this.jTablePNIva.setModel(this.pni_tm);
        this.pnr_tm.setDataPNRiga(this.fa_selezione.getR().getInsieme_righe().vettoreRPN);
        this.jTablePNRighe.setModel(this.pnr_tm);
        this.visualizzazione();
    }

    private void costruisci() {
        int id_te;
        if (this.fa_selezione.getR() == null) {
            this.fa_selezione.setR(new Registrazione());
        }
        if (this.fa_selezione.getR().getCc() == null) {
            this.fa_selezione.getR().setCc(new CausaleContabile());
            if (!this.jTextCC.getText().equals("")) {
                this.fa_selezione.getR().getCc().seleziona(this.jTextCC.getText());
                this.fa_selezione.getR().getCc().seleziona_dettagli();
            }
        }
        this.fa_selezione.setId_causale_contabile(this.fa_selezione.getR().getCc().getId());
        this.fa_selezione.getR().setId_causale_contabile_e_basta(this.fa_selezione.getR().getCc().getId());
        this.fa_selezione.setId_tipo(this.f.id_tipo_modello_fa(this.jComboModello.getSelectedItem().toString()));
        this.fa_selezione.setDestinazione(this.jTextDestinazione.getText());
        this.fa_selezione.setDescrizione(this.jTextDescrizione.getText());
        this.fa_selezione.setNumero(Integer.valueOf(this.jTextNumero.getText()));
        this.fa_selezione.getR().setNum_doc(this.jTextNumero.getText() + this.jTextCodifica.getText());
        this.fa_selezione.setCodifica(this.jTextCodifica.getText());
        this.fa_selezione.setAnno(Integer.parseInt(this.jTextAnno.getText()));
        this.fa_selezione.getR().setAnno_prot(Integer.parseInt(this.jTextAnno.getText()));
        this.fa_selezione.setId_contatore(this.fa_selezione.getR().getCc().getTm().getContatore().getIdContatori());
        this.fa_selezione.getR().setId_registro_iva(this.fa_selezione.getR().getCc().getId_registro_iva());
        this.fa_selezione.getR().setNum_reg(Integer.parseInt(this.jTextNReg.getText()));
        this.fa_selezione.getR().setData_reg(this.fda.gira_data(this.data_reg.getText()));
        this.fa_selezione.getR().setAnno_reg(Integer.parseInt(this.jTextAnnoReg.getText()));
        this.fa_selezione.getR().setData_doc(this.fda.gira_data(this.data_emissione.getText()));
        this.fa_selezione.getR().setTipo_cf(this.fa_selezione.getR().getAnagrafica().getTipo_anag());
        this.fa_selezione.getR().setId_anag_e_basta(this.fa_selezione.getR().getAnagrafica().getIdanag());
        this.fa_selezione.getR().setNote(this.jTextNote.getText());
        if (this.fa_selezione.getR().getTe() == null) {
            this.fa_selezione.getR().setTe(new TrattamentoEconomico());
        }
        if ((id_te = this.f.id_trattamento_economico(this.jTextTE.getText())) != 0) {
            this.fa_selezione.getR().setId_trattamento_economico(id_te);
            String w = " where idtrattamento_economico=" + id_te + " ";
            this.fa_selezione.getR().getTe().seleziona(w);
            this.fa_selezione.getR().getTe().seleziona_dettagli();
        } else {
            JOptionPane.showMessageDialog(this, "Inserire il trattamento economico");
        }
        this.fa_selezione.getR().setId_banca_appoggio(this.f.id_banca_da_descrizione(this.jTextBanca.getText()));
        this.fa_selezione.getR().setProtocollo_iva(Integer.parseInt(this.jTextProtIVA.getText()));
        if (this.jComboIVAP.getSelectedIndex() == 0) {
            this.fa_selezione.getR().setIva_proporzionale(1);
        } else {
            this.fa_selezione.getR().setIva_proporzionale(0);
        }
        this.costruisci_contabilita();
        this.fa_selezione.getR().setImporto_doc(this.fa_selezione.getTot_doc());
    }

    public void costruisci_contabilita() {
        if (this.fa_selezione.getR().getInsieme_righe() == null) {
            this.fa_selezione.getR().setInsieme_righe(new InsiemePNRiga());
        }
        if (this.fa_selezione.getR().getInsieme_iva() == null) {
            this.fa_selezione.getR().setInsieme_iva(new InsiemePNIva());
        }
        if (this.fa_selezione.getR().getInsieme_s() == null) {
            this.fa_selezione.getR().setInsieme_s(new InsiemeScadenze());
        }
        if (this.fa_selezione.getR().getInsieme_p() == null) {
            this.fa_selezione.getR().setInsieme_p(new InsiemePartite());
        }
        this.calcola_totali();
        this.fa_selezione.costruisci_righe_iva(0);
        this.pni_tm.setDataPNIva(this.fa_selezione.getR().getInsieme_iva().vettoreIVAPN);
        this.jTablePNIva.setModel(this.pni_tm);
        this.fa_selezione.costruisci_righe_gestione();
        this.pnr_tm.setDataPNRiga(this.fa_selezione.getR().getInsieme_righe().vettoreRPN);
        this.jTablePNRighe.setModel(this.pnr_tm);
        this.fa_selezione.costruisci_partite();
        String note = this.fa_selezione.getNumero() + "/" + this.fa_selezione.getCodifica() + " del " + this.fa_selezione.getR().getData_docIt();
        if (!this.fa_selezione.getR().costruisci_scadenze(this.in_new, this.fa_selezione.getR().getData_doc(), this.jComboIVAP.getSelectedItem().toString().equals("Si"), note)) {
            JOptionPane.showMessageDialog(this, this.fa_selezione.getR().getMessage());
        }
    }

    public void calcola_totali() {
        this.fa_selezione.calcola_totali();
        this.tf_tm.setDataTF(this.fa_selezione.getV_riepilogo());
        this.jTableTotali.setModel(this.tf_tm);
        this.jTextTot.setText(this.fa_selezione.getTot_doc().toString());
        this.jTextTotIVA.setText(this.fa_selezione.getTot_imposta().toString());
        this.jTextTotImponibile.setText(this.fa_selezione.getTot_imponibile().toString());
    }

    public void aiuto_riga(int row, int col) {
        JInternalFrame oggetto;
        if (col == 0 && !this.aiuto_riga_c) {
            oggetto = new MyConto5();
            ((MyConto5)oggetto).chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setLocation(200, 100);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.aiuto_riga_c = true;
        }
        if (col == 5 && !this.f_vda_open) {
            oggetto = new MyVociDiAnalisi();
            ((MyVociDiAnalisi)oggetto).chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setLocation(200, 100);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_vda_open = true;
        }
        if (col == 6 && !this.f_regole_open) {
            oggetto = new MyRegole();
            ((MyRegole)oggetto).chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setLocation(200, 100);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_regole_open = true;
        }
    }

    public void aiuto_iva(int row, int col) {
        if (col == 0 && !this.aiuto_iva_a) {
            MyConfiguraAliquotaIVA oggetto = new MyConfiguraAliquotaIVA();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setLocation(200, 100);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.aiuto_iva_a = true;
        }
    }

    public void aiuto_riga_fattura(int row, int col) {
        if (col == 2 && !this.aiuto_iva_rf) {
            MyConfiguraAliquotaIVA oggetto = new MyConfiguraAliquotaIVA();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.aiuto_iva_rf = true;
        }
    }

    private boolean check() {
        if (this.jTextCC.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire la Causale Contabile");
            return false;
        }
        if (this.jComboModello.getSelectedItem().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il Modello di Fattura");
            return false;
        }
        if (this.jTextCodCliente.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il cliente");
            return false;
        }
        if (this.data_emissione.getText().equals("00-00-0000") || this.data_emissione.getText().equals("  -  -    ")) {
            JOptionPane.showMessageDialog(this, "Inserire data documento");
            return false;
        }
        if (this.jTextDestinazione.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire la Destinazione");
            return false;
        }
        if (this.jTextTE.getText().equals("") || this.f.id_trattamento_economico(this.jTextTE.getText()) == 0) {
            JOptionPane.showMessageDialog(this, "Inserire il trattamento economico");
            return false;
        }
        if (this.fa_selezione.getInsieme_r() == null || this.fa_selezione.getInsieme_r().vettoreR.size() == 0) {
            JOptionPane.showMessageDialog(this, "Inserire almeno una riga");
            return false;
        }
        return true;
    }

    private void stop_edit() {
        if (this.jTablePNIva.getCellEditor() != null) {
            this.jTablePNIva.getCellEditor().stopCellEditing();
        }
        if (this.jTablePNRighe.getCellEditor() != null) {
            this.jTablePNRighe.getCellEditor().stopCellEditing();
        }
        if (this.jTableRighe.getCellEditor() != null) {
            this.jTableRighe.getCellEditor().stopCellEditing();
        }
    }

    public void stampa_fattura_attiva() {
        StampaDocumentoAttivo stampa = new StampaDocumentoAttivo(this.fa_selezione);
        MyTrace.log.config("HO COSTRUITO L'OGGETTO STAMPA FATTURA ATTIVA");
        stampa.avvia();
        MyTrace.log.config("HO APPENA LANCIATO L'ELABORAZIONE DELLA STAMPA FATTURA ATTIVA");
    }

    public void stampa_fattura_attiva_riepilogo() {
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelElenco = new JPanel();
        this.jPanelGenerale = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextCC = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboModello = new JComboBox(this.f.crea_vettore_modello(0));
        this.jLabelDescCausale = new JLabel();
        this.jTabbedPane2 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabelDescCliente = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jTextNumero = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jTextCodifica = new JTextField();
        this.jLabel10 = new JLabel();
        this.jTextAnno = new JTextField();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextDescrizione = new JTextArea();
        this.jLabel13 = new JLabel();
        this.jTextTE = new JTextField();
        this.jLabel15 = new JLabel();
        this.jTextRI = new JTextField();
        this.jLabelRI = new JLabel();
        this.jLabel17 = new JLabel();
        this.jTextBanca = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTextDestinazione = new JTextArea();
        this.jBP = new JButton();
        this.jBN = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jTextNote = new JTextArea();
        this.jLabel18 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel29 = new JLabel();
        this.jComboIVAP = new JComboBox();
        this.jLabel24 = new JLabel();
        this.jTextProtIVA = new JTextField();
        this.jTextAnnoProt = new JTextField();
        this.jLabel25 = new JLabel();
        this.jTextNReg = new JTextField();
        this.jLabel26 = new JLabel();
        this.jTextAnnoReg = new JTextField();
        this.jLabel28 = new JLabel();
        this.jPanelRighe = new JPanel();
        this.jToolBar2 = new JToolBar();
        this.jButtonAddRigaRow = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel20 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.jTableRighe = new JTable(this.rf_tm);
        this.jPanelRiepilogo = new JPanel();
        this.jLabel21 = new JLabel();
        this.jScrollPane6 = new JScrollPane();
        this.jTableTotali = new JTable(this.tf_tm);
        this.jPanelContabilit\u00e0 = new JPanel();
        this.jPanelRighe1 = new JPanel();
        this.jLabel19 = new JLabel();
        this.jScrollPane7 = new JScrollPane();
        this.jTablePNRighe = new JTable(this.pnr_tm);
        this.jPanel10 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel16 = new JLabel();
        this.jTextTotImponibile = new JTextField();
        this.jLabel22 = new JLabel();
        this.jTextTotIVA = new JTextField();
        this.jLabel23 = new JLabel();
        this.jTextTot = new JTextField();
        this.jPanelIva = new JPanel();
        this.jLabel27 = new JLabel();
        this.jScrollPane8 = new JScrollPane();
        this.jTablePNIva = new JTable(this.pni_tm);
        this.jPanel11 = new JPanel();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Documenti Attivi (Emessi)");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyDocumentiAttivi.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyDocumentiAttivi.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jButtonStampa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonStampaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MyDocumentiAttivi.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jPanelElenco.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelGenerale.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Causale Contabile");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jTextCC.setMinimumSize(new Dimension(100, 27));
        this.jTextCC.setPreferredSize(new Dimension(100, 27));
        this.jTextCC.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MyDocumentiAttivi.this.jTextCCFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MyDocumentiAttivi.this.jTextCCFocusLost(evt);
            }
        });
        this.jTextCC.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyDocumentiAttivi.this.jTextCCKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jTextCC, gridBagConstraints);
        this.jLabel2.setText("Modello");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jComboModello.setEnabled(false);
        this.jComboModello.setPreferredSize(new Dimension(200, 27));
        this.jComboModello.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jComboModelloActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jComboModello, gridBagConstraints);
        this.jLabelDescCausale.setText("** Non Definito **");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabelDescCausale, gridBagConstraints);
        this.jPanelGenerale.add((Component)this.jPanel1, "North");
        this.jTabbedPane2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MyDocumentiAttivi.this.jTabbedPane2StateChanged(evt);
            }
        });
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel3.setText("Cliente");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabelDescCliente.setFont(new Font("Tahoma", 1, 11));
        this.jLabelDescCliente.setText("** Non Definito **");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabelDescCliente, gridBagConstraints);
        this.jLabel6.setText("Destinazione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("Numero");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        this.jTextNumero.setEnabled(false);
        this.jTextNumero.setMinimumSize(new Dimension(100, 27));
        this.jTextNumero.setPreferredSize(new Dimension(80, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jTextNumero, gridBagConstraints);
        this.jLabel8.setText("/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setText("Codifica");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel9, gridBagConstraints);
        this.jTextCodifica.setEnabled(false);
        this.jTextCodifica.setMinimumSize(new Dimension(100, 27));
        this.jTextCodifica.setPreferredSize(new Dimension(80, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jTextCodifica, gridBagConstraints);
        this.jLabel10.setText("Anno");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel10, gridBagConstraints);
        this.jTextAnno.setEnabled(false);
        this.jTextAnno.setMinimumSize(new Dimension(100, 27));
        this.jTextAnno.setPreferredSize(new Dimension(80, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jTextAnno, gridBagConstraints);
        this.jLabel11.setText("Data Emissione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel12.setText("Descrizione Generale del Documento");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel12, gridBagConstraints);
        this.jScrollPane2.setPreferredSize(new Dimension(500, 150));
        this.jTextDescrizione.setColumns(20);
        this.jTextDescrizione.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextDescrizione);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jLabel13.setText("Trattamento Economico");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel13, gridBagConstraints);
        this.jTextTE.setMinimumSize(new Dimension(100, 27));
        this.jTextTE.setPreferredSize(new Dimension(100, 27));
        this.jTextTE.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyDocumentiAttivi.this.jTextTEKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jTextTE, gridBagConstraints);
        this.jLabel15.setText("Registro IVA");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel15, gridBagConstraints);
        this.jTextRI.setEnabled(false);
        this.jTextRI.setMinimumSize(new Dimension(100, 27));
        this.jTextRI.setPreferredSize(new Dimension(80, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jTextRI, gridBagConstraints);
        this.jLabelRI.setText("** Non Definito **");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabelRI, gridBagConstraints);
        this.jLabel17.setText("Banca d'Appoggio");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel17, gridBagConstraints);
        this.jTextBanca.setMinimumSize(new Dimension(100, 27));
        this.jTextBanca.setPreferredSize(new Dimension(200, 27));
        this.jTextBanca.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyDocumentiAttivi.this.jTextBancaKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jTextBanca, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 100));
        this.jTextDestinazione.setColumns(20);
        this.jTextDestinazione.setRows(5);
        this.jTextDestinazione.setMaximumSize(new Dimension(164, 94));
        this.jScrollPane1.setViewportView(this.jTextDestinazione);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jBP.setText("<");
        this.jBP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jBPActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 5;
        this.jPanel2.add((Component)this.jBP, gridBagConstraints);
        this.jBN.setText(">");
        this.jBN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jBNActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 6;
        this.jPanel2.add((Component)this.jBN, gridBagConstraints);
        this.jScrollPane3.setPreferredSize(new Dimension(300, 150));
        this.jTextNote.setColumns(20);
        this.jTextNote.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextNote);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jLabel18.setText("Note");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel18, gridBagConstraints);
        this.jLabel4.setBackground(new Color(153, 153, 153));
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("Dati Intestatario");
        this.jLabel4.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setBackground(new Color(153, 153, 153));
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setText("Dati Principali");
        this.jLabel5.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel14.setBackground(new Color(153, 153, 153));
        this.jLabel14.setFont(new Font("Tahoma", 1, 11));
        this.jLabel14.setText("Dati Principali");
        this.jLabel14.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel29.setText("IVA Proporzionale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel29, gridBagConstraints);
        this.jComboIVAP.setModel(new DefaultComboBoxModel<String>(new String[]{"Si", "No"}));
        this.jComboIVAP.setMinimumSize(new Dimension(33, 27));
        this.jComboIVAP.setPreferredSize(new Dimension(56, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jComboIVAP, gridBagConstraints);
        this.jLabel24.setText("Protocollo IVA");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel24, gridBagConstraints);
        this.jTextProtIVA.setEnabled(false);
        this.jTextProtIVA.setMinimumSize(new Dimension(80, 27));
        this.jTextProtIVA.setPreferredSize(new Dimension(80, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jTextProtIVA, gridBagConstraints);
        this.jTextAnnoProt.setEditable(false);
        this.jTextAnnoProt.setEnabled(false);
        this.jTextAnnoProt.setMinimumSize(new Dimension(80, 27));
        this.jTextAnnoProt.setPreferredSize(new Dimension(80, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jTextAnnoProt, gridBagConstraints);
        this.jLabel25.setText("Registrazione N\u00b0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel25, gridBagConstraints);
        this.jTextNReg.setEditable(false);
        this.jTextNReg.setFont(new Font("Tahoma", 1, 12));
        this.jTextNReg.setEnabled(false);
        this.jTextNReg.setMinimumSize(new Dimension(80, 27));
        this.jTextNReg.setPreferredSize(new Dimension(80, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel2.add((Component)this.jTextNReg, gridBagConstraints);
        this.jLabel26.setText("/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.jLabel26, gridBagConstraints);
        this.jTextAnnoReg.setEditable(false);
        this.jTextAnnoReg.setEnabled(false);
        this.jTextAnnoReg.setMaximumSize(new Dimension(80, 30));
        this.jTextAnnoReg.setMinimumSize(new Dimension(60, 27));
        this.jTextAnnoReg.setPreferredSize(new Dimension(60, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.jTextAnnoReg, gridBagConstraints);
        this.jLabel28.setText("Data Registrazione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel28, gridBagConstraints);
        this.jTabbedPane2.addTab("Generale", this.jPanel2);
        this.jPanelRighe.setLayout(new BorderLayout());
        this.jToolBar2.setRollover(true);
        this.jButtonAddRigaRow.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-add.png")));
        this.jButtonAddRigaRow.setText("Aggiungi Riga");
        this.jButtonAddRigaRow.setFocusable(false);
        this.jButtonAddRigaRow.setHorizontalAlignment(11);
        this.jButtonAddRigaRow.setVerticalTextPosition(3);
        this.jButtonAddRigaRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDocumentiAttivi.this.jButtonAddRigaRowActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonAddRigaRow);
        this.jPanelRighe.add((Component)this.jToolBar2, "North");
        this.jPanel3.setLayout(new BorderLayout());
        this.jLabel20.setBackground(new Color(153, 153, 153));
        this.jLabel20.setFont(new Font("Tahoma", 1, 12));
        this.jLabel20.setText("Righe Documento");
        this.jLabel20.setOpaque(true);
        this.jPanel3.add((Component)this.jLabel20, "North");
        this.jScrollPane5.setMaximumSize(new Dimension(452, 200));
        this.jScrollPane5.setMinimumSize(new Dimension(400, 22));
        this.jScrollPane5.setPreferredSize(new Dimension(600, 200));
        this.jTableRighe.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane5.setViewportView(this.jTableRighe);
        this.jPanel3.add((Component)this.jScrollPane5, "Center");
        this.jPanelRighe.add((Component)this.jPanel3, "Center");
        this.jTabbedPane2.addTab("Righe", this.jPanelRighe);
        this.jPanelRiepilogo.setLayout(new BorderLayout());
        this.jLabel21.setBackground(new Color(153, 153, 153));
        this.jLabel21.setFont(new Font("Tahoma", 1, 12));
        this.jLabel21.setText("Riepilogo Importi");
        this.jLabel21.setOpaque(true);
        this.jPanelRiepilogo.add((Component)this.jLabel21, "North");
        this.jScrollPane6.setMaximumSize(new Dimension(452, 200));
        this.jScrollPane6.setMinimumSize(new Dimension(400, 22));
        this.jScrollPane6.setPreferredSize(new Dimension(800, 200));
        this.jTableTotali.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane6.setViewportView(this.jTableTotali);
        this.jPanelRiepilogo.add((Component)this.jScrollPane6, "Center");
        this.jTabbedPane2.addTab("Riepilogo", this.jPanelRiepilogo);
        this.jPanelContabilit\u00e0.setLayout(new BorderLayout());
        this.jPanelRighe1.setBackground(new Color(255, 255, 255));
        this.jPanelRighe1.setPreferredSize(new Dimension(800, 200));
        this.jPanelRighe1.setVerifyInputWhenFocusTarget(false);
        this.jPanelRighe1.setLayout(new BorderLayout());
        this.jLabel19.setBackground(new Color(153, 153, 153));
        this.jLabel19.setFont(new Font("Tahoma", 1, 12));
        this.jLabel19.setText("Sezione Righe");
        this.jLabel19.setOpaque(true);
        this.jPanelRighe1.add((Component)this.jLabel19, "North");
        this.jScrollPane7.setBackground(new Color(255, 255, 255));
        this.jScrollPane7.setMaximumSize(new Dimension(452, 200));
        this.jScrollPane7.setMinimumSize(new Dimension(400, 150));
        this.jScrollPane7.setPreferredSize(new Dimension(800, 200));
        this.jTablePNRighe.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane7.setViewportView(this.jTablePNRighe);
        this.jPanelRighe1.add((Component)this.jScrollPane7, "Center");
        this.jPanel10.setLayout(new BorderLayout());
        this.jPanelRighe1.add((Component)this.jPanel10, "South");
        this.jPanelContabilit\u00e0.add((Component)this.jPanelRighe1, "North");
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel16.setText("Totale Imponibile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel5.add((Component)this.jLabel16, gridBagConstraints);
        this.jTextTotImponibile.setEditable(false);
        this.jTextTotImponibile.setFont(new Font("Tahoma", 1, 11));
        this.jTextTotImponibile.setMinimumSize(new Dimension(100, 20));
        this.jTextTotImponibile.setPreferredSize(new Dimension(100, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel5.add((Component)this.jTextTotImponibile, gridBagConstraints);
        this.jLabel22.setText("Totale IVA");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel5.add((Component)this.jLabel22, gridBagConstraints);
        this.jTextTotIVA.setEditable(false);
        this.jTextTotIVA.setFont(new Font("Tahoma", 1, 11));
        this.jTextTotIVA.setMinimumSize(new Dimension(100, 20));
        this.jTextTotIVA.setPreferredSize(new Dimension(100, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel5.add((Component)this.jTextTotIVA, gridBagConstraints);
        this.jLabel23.setText("Totale a Pagare");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel5.add((Component)this.jLabel23, gridBagConstraints);
        this.jTextTot.setEditable(false);
        this.jTextTot.setFont(new Font("Tahoma", 1, 11));
        this.jTextTot.setMinimumSize(new Dimension(100, 20));
        this.jTextTot.setPreferredSize(new Dimension(100, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel5.add((Component)this.jTextTot, gridBagConstraints);
        this.jPanelContabilit\u00e0.add((Component)this.jPanel5, "South");
        this.jPanelIva.setBackground(new Color(255, 255, 255));
        this.jPanelIva.setLayout(new BorderLayout());
        this.jLabel27.setBackground(new Color(153, 153, 153));
        this.jLabel27.setFont(new Font("Tahoma", 1, 12));
        this.jLabel27.setText("Sezione IVA");
        this.jLabel27.setOpaque(true);
        this.jPanelIva.add((Component)this.jLabel27, "North");
        this.jScrollPane8.setMaximumSize(new Dimension(452, 150));
        this.jScrollPane8.setMinimumSize(new Dimension(400, 150));
        this.jScrollPane8.setPreferredSize(new Dimension(800, 150));
        this.jTablePNIva.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane8.setViewportView(this.jTablePNIva);
        this.jPanelIva.add((Component)this.jScrollPane8, "Center");
        this.jPanel11.setLayout(new BorderLayout());
        this.jPanelIva.add((Component)this.jPanel11, "South");
        this.jPanelContabilit\u00e0.add((Component)this.jPanelIva, "Center");
        this.jTabbedPane2.addTab("Contabilit\u00e0", this.jPanelContabilit\u00e0);
        this.jPanelGenerale.add((Component)this.jTabbedPane2, "Center");
        this.jTabbedPane1.addTab("Generale", this.jPanelGenerale);
        this.jScrollPane4.setViewportView(this.jTabbedPane1);
        this.getContentPane().add((Component)this.jScrollPane4, "Center");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        this.stop_edit();
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                boolean check2 = this.fa_selezione.inserisci(true);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci();
            boolean check2 = this.fa_selezione.modificaFA(true);
            if (check2) {
                this.in_modifica = false;
                this.filtra();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento della modifica dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
            }
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        MyTrace.log.info("MyFattureAttive ANNULLA RICHIESTO");
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
        MyTrace.log.info("MyFattureAttive ANNULLA EFFETTUATO");
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        MyTrace.log.info("MyFattureAttive NUOVO RICHIESTO");
        this.in_new = true;
        this.fa_selezione = new Documento();
        this.azzera();
        this.jTableFA.getSelectionModel().clearSelection();
        this.fa_selezione.setR(new Registrazione());
        this.fa_selezione.getR().setCc(new CausaleContabile());
        this.fa_selezione.getR().setAnagrafica(new Anagrafica());
        this.fa_selezione.getR().setRi(new RegistriIVA());
        this.fa_selezione.setId_tipo(1);
        this.rf_tm = new RigheDocumentiTableModel(this.fa_selezione.getId_tipo());
        this.jTableRighe.setModel(this.rf_tm);
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.formatta_dettagli();
        this.visualizzazione();
        MyTrace.log.info("MyFattureAttive NUOVO APERTO");
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        MyTrace.log.info("MyFattureAttive MODIFICA RICHIESTO");
        if (this.fa_selezione != null && this.fa_selezione.getIdDocumento() != 0) {
            if (this.fa_selezione.getId_tipo() == 1) {
                this.in_modifica = true;
                this.visualizzazione();
                if (this.jTabbedPane1.getSelectedIndex() == 0) {
                    this.jTabbedPane1.setSelectedIndex(1);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Questa Fattuira pu\u00f2 essere modificata solo dal relativo modulo!!!");
            }
        }
        MyTrace.log.info("MyFattureAttive MODIFICA APERTO");
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        try {
            if (this.fatm.getRowCount() != 0) {
                this.jTableFA.getSelectionModel().setSelectionInterval(0, 0);
                this.fa_selezione = this.insieme_fa.vettoreDOC.get(this.jTableFA.getSelectedRow());
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ERRORE: Eccezione");
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableFA.getSelectedRow() > 0 && this.fatm.getRowCount() != 0) {
                this.jTableFA.getSelectionModel().setSelectionInterval(this.jTableFA.getSelectedRow() - 1, this.jTableFA.getSelectedRow() - 1);
                this.fa_selezione = this.insieme_fa.vettoreDOC.get(this.jTableFA.getSelectedRow());
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ERRORE: Eccezione");
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        try {
            if (this.fatm.getRowCount() != 0) {
                this.jTableFA.getSelectionModel().setSelectionInterval(this.jTableFA.getSelectedRow() + 1, this.jTableFA.getSelectedRow() + 1);
                this.fa_selezione = this.insieme_fa.vettoreDOC.get(this.jTableFA.getSelectedRow());
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ERRORE: Eccezione");
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        try {
            if (this.fatm.getRowCount() != 0) {
                this.jTableFA.getSelectionModel().setSelectionInterval(this.fatm.getRowCount() - 1, this.fatm.getRowCount() - 1);
                this.fa_selezione = this.insieme_fa.vettoreDOC.get(this.jTableFA.getSelectedRow());
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ERRORE: Eccezione");
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            this.in_filter = true;
            String[] a_ric = new String[]{"", "", "", "", "", "", "", "", ""};
            this.fafm.addRow(a_ric);
            this.p.addFilterTable();
            this.repaint();
            this.header_tebella();
        } else {
            this.in_filter = false;
            this.fafm.deleteRow();
            this.fafm = new DocumentiFixedModel();
            this.fixedTable.setModel(this.fafm);
            this.sorter.setRowFilter(null);
            this.p.delFilterTable();
            this.repaint();
            this.header_tebella();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] a_ric = new String[]{"", "", "", "", "", "", "", "", ""};
            this.fafm = new DocumentiFixedModel();
            this.fixedTable.setModel(this.fafm);
            this.fafm.addRow(a_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.fatm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.repaint();
        }
        this.formatta();
    }

    private void jTextCCKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 115 && !this.f_causali_open) {
            MyCausaliContabili oggetto = new MyCausaliContabili();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_causali_open = true;
        }
    }

    private void jTextCCFocusLost(FocusEvent evt) {
        this.aggiornamento();
    }

    private void jBPActionPerformed(ActionEvent evt) {
        this.v_sedi = this.fa_selezione.getR().getAnagrafica().getInsieme_sedi().vettoreI;
        if (this.sede_sel != 0) {
            this.jTextDestinazione.setText(this.v_sedi.get(this.sede_sel - 1).toString());
            --this.sede_sel;
        }
    }

    private void jBNActionPerformed(ActionEvent evt) {
        this.v_sedi = this.fa_selezione.getR().getAnagrafica().getInsieme_sedi().vettoreI;
        if (this.sede_sel != this.v_sedi.size()) {
            this.jTextDestinazione.setText(this.v_sedi.get(this.sede_sel + 1).toString());
            ++this.sede_sel;
        }
    }

    private void jTextBancaKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 115 && !this.f_ba_open) {
            MyBanche oggetto = new MyBanche();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_ba_open = true;
        }
    }

    private void jTabbedPane2StateChanged(ChangeEvent evt) {
        this.stop_edit();
        if ((this.jTabbedPane2.getSelectedIndex() == 2 || this.jTabbedPane2.getSelectedIndex() == 3) && (this.in_new || this.in_modifica)) {
            if (this.check()) {
                this.costruisci();
            } else {
                this.jTabbedPane2.setSelectedIndex(0);
            }
        }
    }

    private void jButtonAddRigaRowActionPerformed(ActionEvent evt) {
        this.stop_edit();
        RigaDocumento temp = new RigaDocumento();
        if (this.fa_selezione.getInsieme_r() == null || this.fa_selezione.getInsieme_r().vettoreR.isEmpty()) {
            this.fa_selezione.setInsieme_r(new InsiemeRigheDoc());
        }
        Configurazioni.getIstanza();
        Aliquota a = Configurazioni.aliquota_predefinita;
        temp.setAliquota(a);
        temp.setId_aliquota(a.getId());
        this.fa_selezione.getInsieme_r().vettoreR.add(temp);
        this.rf_tm.setDataRiga(this.fa_selezione.getInsieme_r().vettoreR);
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.jTabbedPane1.getSelectedIndex() == 1) {
            this.jTabbedPane2.setSelectedIndex(0);
        }
    }

    private void jComboModelloActionPerformed(ActionEvent evt) {
        if (!this.jComboModello.getSelectedItem().toString().equals("")) {
            this.fa_selezione.setId_tipo(this.f.id_tipo_modello_fa(this.jComboModello.getSelectedItem().toString()));
            this.rf_tm = new RigheDocumentiTableModel(this.fa_selezione.getId_tipo());
            this.jTableRighe.setModel(this.rf_tm);
        }
    }

    private void jButtonStampaActionPerformed(ActionEvent evt) {
        this.stampa_fattura_attiva();
    }

    private void jTextTEKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 115 && !this.f_te_open) {
            MyTrattamentoEconomico oggetto = new MyTrattamentoEconomico();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_te_open = true;
        }
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyDocumentiAttivi().setVisible(true);
            }
        });
    }

    private void jTextCodClienteKeyPressed(KeyEvent evt) {
    }

    private void jTextCodClienteFocusLost(FocusEvent evt) {
    }

    private void jTextCCFocusGained(FocusEvent evt) {
        this.stop_edit();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableFA.getSelectedRow();
        if (this.riga_selezionata_nella_tabella != viewRow) {
            this.riga_selezionata_nella_tabella = viewRow;
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableFA.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow <= this.fatm.getRowCount() - 1 && modelRow >= 0) {
                this.seleziona(modelRow);
            }
        }
    }

    private void jTablePNRRigheKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 115 && this.jTablePNRighe.getSelectedColumn() == 2 && !this.f_aliquota_open) {
            MyConfiguraAliquotaIVA oggetto = new MyConfiguraAliquotaIVA();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_aliquota_open = true;
        }
    }

    class ClientiFornitoriFieldLocal
    extends ClientiFornitoriField {
        public ClientiFornitoriFieldLocal(JInternalFrame frame, String t) {
            super(frame, t);
        }

        @Override
        public void focusLost(FocusEvent evt) {
            this.completaAutomaticamente();
            this.getAnagrafica().seleziona_dettagli();
            if (this.getAnagrafica().getIdanag() != 0) {
                MyDocumentiAttivi.this.fa_selezione.getR().setId_anag_e_basta(this.getAnagrafica().getIdanag());
                MyDocumentiAttivi.this.fa_selezione.getR().setAnagrafica(this.getAnagrafica());
                MyDocumentiAttivi.this.jLabelDescCliente.setText(this.getAnagrafica().getRagione_sociale());
                if (MyDocumentiAttivi.this.jTextTE.getText().equals("")) {
                    MyDocumentiAttivi.this.jTextTE.setText(this.getAnagrafica().getTrattamento_economico_codice());
                }
                if (MyDocumentiAttivi.this.jTextBanca.getText().equals("")) {
                    MyDocumentiAttivi.this.jTextBanca.setText(this.getAnagrafica().getBanca().getDescrizione());
                }
                Iterator<DA_CANCELLARE_Indirizzo> i = this.getAnagrafica().getInsieme_sedi().vettoreI.iterator();
                MyDocumentiAttivi.this.v_sedi = new ArrayList();
                while (i.hasNext()) {
                    DA_CANCELLARE_Indirizzo s = i.next();
                    String sede = s.getIndirizzo() + "\n" + s.getCap().getCap() + " " + s.getLocalita_selezionata() + " " + s.getCap().getCd_provincia();
                    MyDocumentiAttivi.this.v_sedi.add(s);
                }
                MyDocumentiAttivi.this.sede_sel = 0;
                if (!MyDocumentiAttivi.this.v_sedi.isEmpty()) {
                    MyDocumentiAttivi.this.jTextDestinazione.setText(MyDocumentiAttivi.this.v_sedi.get(MyDocumentiAttivi.this.sede_sel).toString());
                }
            }
        }
    }

    public class TextIVAEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            System.out.println("chiamaaiuto " + col + " " + row);
            MyDocumentiAttivi.this.aiuto_iva(MyDocumentiAttivi.this.jTablePNIva.getSelectedRow(), col);
            this.getCellEditorValue();
        }

        @Override
        public void azione_focus_lost(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            if (col == 2) {
                MyDocumentiAttivi.this.calcola_totali();
            }
            this.getCellEditorValue();
        }
    }

    public class TextPNRigaEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            System.out.println("chiamaaiuto " + col + " " + row);
            MyDocumentiAttivi.this.aiuto_riga(MyDocumentiAttivi.this.jTablePNRighe.getSelectedRow(), col);
            this.getCellEditorValue();
        }

        @Override
        public void azione_focus_lost(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            String[] b = null;
            double test = 0.0;
            try {
                test = Double.valueOf(this.tf.getText());
                System.out.println("questo \u00e8 il valore di test:__" + test + "__");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (col == 3) {
                MyDocumentiAttivi.this.calcola_totali();
            }
            this.getCellEditorValue();
            if (col == 0 && test == 0.0) {
                b = MyDocumentiAttivi.this.f.descrizione_conto_da_alias(this.tf.getText());
                System.out.println("Focus lost " + col + " " + row + "   testo: " + this.tf.getText() + "   " + b[0] + "  " + b[1]);
                MyTrace.log.info("FOCUS LOST:>   " + col + " " + row + "   testo: " + this.tf.getText() + "   " + b[0] + "  " + b[1]);
                MyDocumentiAttivi.this.jTablePNRighe.setValueAt(b[1], row, col);
                MyDocumentiAttivi.this.jTablePNRighe.setValueAt(b[0], row, col + 1);
            } else {
                String appoggio = this.tf.getText();
                try {
                    b[1] = MyDocumentiAttivi.this.f.descrizione_conto(appoggio);
                    b[0] = this.tf.getText();
                    System.out.println("Focus lost " + col + " " + row + "   testo: " + this.tf.getText() + "   " + b[0] + "  " + b[1]);
                    MyTrace.log.info("FOCUS LOST:>   " + col + " " + row + "   testo: " + this.tf.getText() + "   " + b[0] + "  " + b[1]);
                    MyDocumentiAttivi.this.jTablePNRighe.setValueAt(b[1], row, col);
                    MyDocumentiAttivi.this.jTablePNRighe.setValueAt(b[0], row, col + 1);
                }
                catch (Exception e) {
                    MyDocumentiAttivi.this.jTablePNRighe.setValueAt(appoggio, row, col);
                }
            }
        }
    }

    class DateFieldLocalReg
    extends DateField {
        public DateFieldLocalReg(JFormattedTextField.AbstractFormatter formatter) {
            super(formatter);
        }

        @Override
        public void focusLost(FocusEvent e) {
            MyDocumentiAttivi.this.aggiornamento();
        }
    }

    class DateFieldLocal
    extends DateField {
        public DateFieldLocal(JFormattedTextField.AbstractFormatter formatter) {
            super(formatter);
        }

        @Override
        public void focusLost(FocusEvent e) {
            MyDocumentiAttivi.this.aggiornamento();
        }
    }

    public class TextRigaEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            MyDocumentiAttivi.this.aiuto_riga_fattura(MyDocumentiAttivi.this.jTableRighe.getSelectedRow(), col);
            this.getCellEditorValue();
        }

        @Override
        public void azione_focus_lost(String col_row) {
            String[] col_cow = new String[2];
            col_cow = col_row.split("_");
            int col = Integer.valueOf(col_cow[0]);
            int row = Integer.valueOf(col_cow[1]);
            if (col == 0) {
                MyDocumentiAttivi.this.jTableRighe.setColumnSelectionInterval(2, 2);
            }
            if (col == 1) {
                MyDocumentiAttivi.this.jTableRighe.setColumnSelectionInterval(2, 2);
            }
            if (col == 2) {
                MyDocumentiAttivi.this.jTableRighe.setColumnSelectionInterval(0, 0);
            }
        }
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<DocumentiTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            if (!MyDocumentiAttivi.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyDocumentiAttivi.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyDocumentiAttivi.this.rf = RowFilter.andFilter(MyDocumentiAttivi.this.andFilters);
                MyDocumentiAttivi.this.sorter.setRowFilter(MyDocumentiAttivi.this.rf);
                MyDocumentiAttivi.this.formatta();
            } else {
                String where = " WHERE 1 ";
                if (col == 0) {
                    where = where + " AND vcausali.codice like '%" + this.tf.getText() + "%'";
                }
                if (col == 1) {
                    where = where + " AND numero like '%" + this.tf.getText() + "%' ";
                }
                if (col == 2) {
                    where = where + " AND anno like '%" + this.tf.getText() + "%'";
                }
                if (col == 3) {
                    where = where + " AND data_emissione like '%" + this.tf.getText() + "%'";
                    try {
                        where = where + "  or data_emissione LIKE '%" + MyDocumentiAttivi.this.f.gira_stringa_data(this.tf.getText()) + "%'";
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (col == 4) {
                    where = where + " AND anag_anagrafica.ragione_sociale LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 5) {
                    where = where + " AND fatture_attive.descrizione LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 6) {
                    where = where + " AND totale_imponibile  LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 7) {
                    where = where + " AND totale_imposta LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 8) {
                    where = where + " AND totale_a_pagare LIKE '%" + this.tf.getText() + "%'";
                }
                String order_by = " ORDER BY data_emissione DESC, numero DESC LIMIT 0," + Configurazioni.righe_ricerca;
                MyDocumentiAttivi.this.insieme_fa.caricamento(where, order_by);
                MyDocumentiAttivi.this.fatm.setDataFA(MyDocumentiAttivi.this.insieme_fa.vettoreDOC);
                MyDocumentiAttivi.this.formatta();
            }
        }
    }
}

