/*
 * Decompiled with CFR 0.152.
 */
package gestionale.corrispettivi;

import gestionale.azienda.Azienda;
import gestionale.personalizzazione.stampe.IntestazioneCorrispettivi;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import gestionale.primanota.PNIva;
import gestionale.primanota.Registrazione;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaCorrispettivi
implements Runnable {
    public Vector vettore_corrispettivi;
    Azienda azienda;
    String mese;
    int anno;
    Thread thread;
    GestoreStampe stampa;

    public StampaCorrispettivi(Vector vettore_corrispettivi, String mese, int anno, Azienda azienda) {
        this.vettore_corrispettivi = vettore_corrispettivi;
        this.mese = mese;
        this.anno = anno;
        this.azienda = azienda;
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    public void elabora() {
        try {
            int y_inizio;
            Color colore = new Color(235, 235, 235, 235);
            this.stampa = new GestoreStampe();
            this.stampa.aggiungi_pj();
            this.stampa.setFont(this.stampa.Font_Calibri_7);
            int y = y_inizio = 100;
            this.stampa.setInt((OggettoToPrint)new IntestazioneCorrispettivi());
            this.stampa.setIntPP((OggettoToPrint)new IntestazioneCorrispettivi());
            this.stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Corrispettivi"));
            Money tot_imponibile = new Money(BigDecimal.ZERO);
            Money tot_imposta = new Money(BigDecimal.ZERO);
            Money tot_tot = new Money(BigDecimal.ZERO);
            this.appendi_intestazione(y);
            this.stampa.appendLine(20, y, 20, 780);
            this.stampa.appendLine(580, y, 580, 780);
            this.stampa.appendLine(20, 780, 580, 780);
            y += 75;
            Iterator i = this.vettore_corrispettivi.iterator();
            int contatore = 0;
            while (i.hasNext()) {
                if (y > 750) {
                    this.stampa.paginanuova();
                    y = y_inizio;
                    this.appendi_intestazione(y);
                    this.stampa.appendLine(20, y += 75, 20, 780);
                    this.stampa.appendLine(580, y, 580, 780);
                    this.stampa.appendLine(20, 780, 580, 780);
                }
                Registrazione r = new Registrazione();
                r = (Registrazione)i.next();
                r.seleziona_righe();
                r.selezionaDati();
                ++contatore;
                this.stampa.appendTextOvunque(r.getData_docIt(), 25, y + 8);
                this.stampa.appendTextOvunque(r.getCodice_causale_contabile(), 100, y + 8);
                Iterator iiva = r.getInsieme_iva().vettoreIVAPN.iterator();
                int yrighe = y + 8;
                while (iiva.hasNext()) {
                    if (y > 750) {
                        this.stampa.paginanuova();
                        y = y_inizio;
                        this.appendi_intestazione(y);
                        y += 75;
                    }
                    PNIva riga = (PNIva)iiva.next();
                    this.stampa.appendTextOvunque("" + riga.getC().getConto() + "-" + riga.getC().getDescrizione(), 100, yrighe += 8);
                    this.stampa.appendTextOvunque("" + riga.getImponibile(), 350, yrighe);
                    this.stampa.appendTextOvunque("" + riga.getA().getAliquota(), 420, yrighe);
                    this.stampa.appendTextOvunque("" + riga.getImposta(), 490, yrighe);
                    this.stampa.appendTextOvunque("" + riga.getImponibile().plus(riga.getImposta()), 540, yrighe);
                    tot_imponibile = tot_imponibile.plus(riga.getImponibile());
                    tot_imposta = tot_imposta.plus(riga.getImposta());
                    tot_tot = tot_tot.plus(riga.getImposta().plus(riga.getImponibile()));
                }
                y = yrighe;
            }
            if (y > 750) {
                this.stampa.paginanuova();
                y = y_inizio;
                this.appendi_intestazione(y);
                y += 75;
            }
            this.appendi_riga_totali(y, tot_imponibile, tot_imposta, tot_tot);
            FunzioniDate fda = new FunzioniDate();
            String date_now = fda.dataCorrente().replaceAll("-", "");
            String ora_now = fda.OraCorrente().replaceAll(":", "");
            Funzioni f = new Funzioni();
            String nome_file = f.pulisci_nome_file(date_now + ora_now + "_Corrispettivi_di_" + this.mese + "_" + this.anno);
            this.stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            this.stampa.print();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su StampaCorrispettivi.elabora() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void appendi_intestazione(int y) {
        try {
            this.stampa.appendRect(20, y, 40, 25);
            this.stampa.setFont(this.stampa.Font_Calibri_7);
            this.stampa.appendRect(60, y, 300, 25);
            this.stampa.appendTextOvunque("" + this.azienda.getRagione_sociale(), 70, y + 8);
            this.stampa.appendTextOvunque("" + this.azienda.getVia() + " " + this.azienda.getNumero(), 70, y + 16);
            this.stampa.appendTextOvunque("" + this.azienda.getCap() + " " + this.azienda.getComune() + " " + this.azienda.getProvincia(), 70, y + 24);
            this.stampa.appendRect(360, y, 220, 25);
            this.stampa.appendTextOvunque("", 370, y + 8);
            this.stampa.appendTextOvunque("Codice Fiscale: " + this.azienda.getCf(), 370, y + 16);
            this.stampa.appendTextOvunque("Partita IVA: " + this.azienda.getP_iva(), 370, y + 24);
            this.stampa.appendRect(20, y + 25, 560, 25);
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            this.stampa.appendTextOvunque("Mese: " + this.mese + "  Anno:" + this.anno, 35, y + 40);
            this.stampa.appendTextOvunque("***  REGISTRO DEI CORRISPETTIVI  ***", 250, y + 35);
            this.stampa.setFont(this.stampa.Font_Calibri_7);
            this.stampa.appendRect(20, y + 50, 560, 25);
            this.stampa.appendTextOvunque("Data", 25, y + 60);
            this.stampa.appendTextOvunque("Causale Contabile", 100, y + 60);
            this.stampa.appendTextOvunque("Conto - Denominazione del conto", 100, y + 72);
            this.stampa.appendTextOvunque("Imponibile", 350, y + 72);
            this.stampa.appendTextOvunque("%IVA", 420, y + 72);
            this.stampa.appendTextOvunque("Imposta", 490, y + 72);
            this.stampa.appendTextOvunque("Totale", 540, y + 72);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su StampaCorrispettivi.appendi_intestazione() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void appendi_riga_totali(int y, Money imponibile, Money imposta, Money totale) {
        try {
            this.stampa.appendRect(20, y + 5, 560, 25);
            this.stampa.appendTextOvunque("TOTALI:", 250, y + 15);
            this.stampa.appendTextOvunque("" + imponibile, 350, y + 15);
            this.stampa.appendTextOvunque("" + imposta, 420, y + 15);
            this.stampa.appendTextOvunque("" + totale, 540, y + 15);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su StampaCorrispettivi.appendi_riga_totali() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD ANDAMENTO TEMPORALE");
        attesa.start();
        this.elabora();
        attesa.stop();
    }
}

