/*
 * Decompiled with CFR 0.152.
 */
package gestionale.corrispettivi;

import anagrafiche.banche.IBAN;
import gestionale.corrispettivi.Reparto;
import java.awt.Button;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import utils.Funzioni;
import utils.FunzioniDate;

public class RigheRepartiTableModel
extends AbstractTableModel {
    public Vector cache;
    int colCount;
    String[] headers;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public RigheRepartiTableModel() {
        this.cache = new Vector();
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Nome Reparto";
                break;
            }
            case 1: {
                retVal = "Codice IVA";
                break;
            }
            case 2: {
                retVal = "Percentuale IVA";
                break;
            }
            case 3: {
                retVal = "Codice Conto";
                break;
            }
            case 4: {
                retVal = "Descrizione Conto";
                break;
            }
            case 5: {
                retVal = "";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Reparto p = new Reparto();
        if (!this.cache.isEmpty()) {
            p = (Reparto)this.cache.elementAt(row);
            return p.getColValue(col);
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Reparto cc = new Reparto();
        cc = (Reparto)this.cache.elementAt(row);
        if (col == 0) {
            cc.setNome_reparto(value.toString());
        }
        if (col == 1) {
            cc.setId_aliquota(this.f.id_aliquota_da_codice(value.toString()));
            cc.setCodice_aliquota(value.toString());
            cc.setPercentuale_aliquota(this.f.percentuale_aliquota_da_id(cc.getId_aliquota()));
        }
        if (col == 2) {
            // empty if block
        }
        if (col == 3) {
            cc.setId_conto_5(this.f.id_conto5(value.toString()));
            cc.setCodice_conto(value.toString());
            cc.setDescrizione_conto(this.f.descrizione_conto(value.toString()));
        }
        if (col == 4) {
            // empty if block
        }
        this.fireTableRowsUpdated(row, row);
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return IBAN.class;
        }
        if (c == 5) {
            return Button.class;
        }
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0 || col == 1 || col == 3 || col == 5;
    }

    public void setDataReparto(Vector vettorePNR) {
        this.cache = new Vector();
        for (Reparto ro : vettorePNR) {
            this.cache.addElement(ro);
        }
        this.fireTableChanged(null);
    }
}

