/*
 * Decompiled with CFR 0.152.
 */
package gestionale.corrispettivi;

import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.corrispettivi.StampaCorrispettivi;
import gestionale.primanota.InsiemeRegistrazioni;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;

public class MyStampaCorrispettivi
extends JInternalFrame {
    FunzioniDate fda;
    InsiemeRegistrazioni insieme_r;
    private JButton jButtonStampa;
    private JComboBox jComboAnno;
    private JComboBox jComboMese;
    private JLabel jLabelAnno;
    private JLabel jLabelMese;
    private JPanel p3;

    public MyStampaCorrispettivi() {
        this.initComponents();
        this.formatta();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(500, 400)));
    }

    private void formatta() {
        try {
            this.fda = new FunzioniDate();
            Vector Anni = this.fda.ultimi_anni(6);
            for (int i = 1; i <= 12; ++i) {
                this.jComboMese.addItem(this.fda.converti_mese("" + i));
            }
            this.insieme_r = new InsiemeRegistrazioni();
            this.jComboAnno.addItem(Anni.elementAt(1).toString());
            this.jComboAnno.addItem(Anni.elementAt(2).toString());
            this.jComboAnno.addItem(Anni.elementAt(3).toString());
            this.jComboAnno.addItem(Anni.elementAt(4).toString());
            this.jComboAnno.addItem(Anni.elementAt(5).toString());
            this.jComboAnno.setSelectedIndex(0);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyStampaCorrispettivi.formatta() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void filtra() {
        try {
            int anno = Integer.valueOf(this.jComboAnno.getSelectedItem().toString());
            String mese = this.jComboMese.getSelectedItem().toString();
            String where = " WHERE conf_causale_contabile.codice='corr' and data_doc BETWEEN '" + anno + "-" + this.fda.riconverti_mese(mese) + "-01' and '" + anno + "-" + this.fda.riconverti_mese(mese) + "-31'";
            String order_by = "  ORDER BY data_doc ASC ";
            if (Configurazioni.righe_ricerca != 0) {
                order_by = order_by + " LIMIT 0," + Configurazioni.righe_ricerca;
            }
            this.insieme_r.caricamento_veloce(where, order_by);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyStampaCorrispettivi.filtra() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void initComponents() {
        this.p3 = new JPanel();
        this.jButtonStampa = new JButton();
        this.jLabelAnno = new JLabel();
        this.jComboAnno = new JComboBox();
        this.jComboMese = new JComboBox();
        this.jLabelMese = new JLabel();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Contabilit\u00e0 \\ Stampa Corrispettivi");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyStampaCorrispettivi.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyStampaCorrispettivi.this.finestra_ridimensionata(evt);
            }
        });
        this.p3.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p3.setLayout(new GridBagLayout());
        this.jButtonStampa.setText("STAMPA");
        this.jButtonStampa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyStampaCorrispettivi.this.jButtonStampaActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        this.p3.add((Component)this.jButtonStampa, gridBagConstraints);
        this.jLabelAnno.setText("Anno");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        this.p3.add((Component)this.jLabelAnno, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        this.p3.add((Component)this.jComboAnno, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        this.p3.add((Component)this.jComboMese, gridBagConstraints);
        this.jLabelMese.setText("Mese");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        this.p3.add((Component)this.jLabelMese, gridBagConstraints);
        this.getContentPane().add((Component)this.p3, "Center");
        this.pack();
    }

    private void jButtonStampaActionPerformed(ActionEvent evt) {
        this.filtra();
        Vector vector = this.insieme_r.vettoreRegistrazioni;
        String string = this.jComboMese.getSelectedItem().toString();
        int n = Integer.valueOf(this.jComboAnno.getSelectedItem().toString());
        Configurazioni.getIstanza();
        StampaCorrispettivi stampa = new StampaCorrispettivi(vector, string, n, Configurazioni.azienda);
        stampa.avvia();
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }
}

