/*
 * Decompiled with CFR 0.152.
 */
package gestionale.corrispettivi;

import gestionale.causali_contabili.CausaleContabile;
import gestionale.causali_contabili.CausaleContabileRiga;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import gestionale.corrispettivi.ConfigurazioneCorrispettivo;
import gestionale.corrispettivi.Corrispettivo;
import gestionale.corrispettivi.CorrispettivoTableModel;
import gestionale.corrispettivi.InsiemeReparti;
import gestionale.corrispettivi.MyStampaCorrispettivi;
import gestionale.corrispettivi.RegistrazioneCorrispettiviFixedModel;
import gestionale.corrispettivi.RegistrazioniCorrispettiviTableModel;
import gestionale.corrispettivi.Reparto;
import gestionale.corrispettivi.RiepilogoCorrispettiviTableModel;
import gestionale.corrispettivi.RiepilogoCorrispettiviTableRenderer;
import gestionale.iva.Aliquota;
import gestionale.primanota.InsiemePNIva;
import gestionale.primanota.InsiemePNRiga;
import gestionale.primanota.InsiemePartite;
import gestionale.primanota.InsiemeRegistrazioni;
import gestionale.primanota.MyInterrogazioneConti;
import gestionale.primanota.MyRegistrazioni;
import gestionale.primanota.PNIva;
import gestionale.primanota.PNRiga;
import gestionale.primanota.Registrazione;
import gestionale.primanota.Riepilogo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import utils.ClientiFornitoriField;
import utils.ColumnGroup;
import utils.DateField;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.GenericTableRenderer;
import utils.GroupableTableHeader;
import utils.Money;
import utils.MyTrace;
import utils.Performance;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.TextInsertEditor;
import utils.TimeFormatter;
import utils.ToolTipHeader;

public class MyCorrispettivi
extends JInternalFrame
implements ListSelectionListener,
MouseListener {
    Registrazione r_selezione;
    JToolBar jToolBarMod;
    RegistrazioniCorrispettiviTableModel reg_tm;
    InsiemeRegistrazioni insieme_r;
    JScrollPane scroll;
    JTable jTableRegistro;
    RegistrazioneCorrispettiviFixedModel rfm;
    JScrollPane fixedScroll;
    JTable fixedTable;
    private TableRowSorter<RegistrazioniCorrispettiviTableModel> sorter;
    RowFilter<RegistrazioniCorrispettiviTableModel, Object> rf = null;
    ArrayList<RowFilter<RegistrazioniCorrispettiviTableModel, Object>> andFilters = new ArrayList();
    DateField data_dal;
    DateField data_al;
    TimeFormatter mf = null;
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    public boolean f_causali_open = false;
    public boolean f_fornitori_open = false;
    public boolean f_clienti_open = false;
    public boolean f_te_open = false;
    public boolean f_ba_open = false;
    public boolean aiuto_riga_analisi = false;
    public boolean aiuto_riga_c = false;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    public JInternalFrame chiamante;
    public int row_chiamante;
    CorrispettivoTableModel ctm;
    public boolean aiuto_iva_a = false;
    public boolean aiuto_cf_open = false;
    public boolean f_partite_open = false;
    Vector vettore_riepilogo;
    public ClientiFornitoriField jTextCF;
    long tempo_di_visualizzazione = System.currentTimeMillis();
    public ConfigurazioneCorrispettivo config_c;
    int riga_selezionata_nella_tabella = -1;
    RiepilogoCorrispettiviTableModel riepilogo_tm;
    private Vector vettore_corrispettivi;
    private Vector vettore_registrazioni;
    Reparto reparto;
    private JButton jButtonClean;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonProcedi;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JLabel jLabel35;
    private JLabel jLabelDataAl;
    private JLabel jLabelDataDa;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanelCreazione;
    private JPanel jPanelElenco;
    private JPanel jPanelNuovo;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane9;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    public JTable jTableCreazione;
    private JTable jTableRiepilogo;
    private JToolBar jToolBar1;
    private JPanel p;

    public MyCorrispettivi() {
        Performance perf = new Performance("ISTANZA MY CORRISPETTIVI");
        this.reg_tm = new RegistrazioniCorrispettiviTableModel();
        this.insieme_r = new InsiemeRegistrazioni();
        this.jTableRegistro = new JTable(this.reg_tm);
        this.jTableRegistro.setSelectionMode(0);
        this.jTableRegistro.addMouseListener(this);
        this.sorter = new TableRowSorter<RegistrazioniCorrispettiviTableModel>(this.reg_tm);
        for (int i = 0; i < this.reg_tm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.rfm = new RegistrazioneCorrispettiviFixedModel();
        this.rfm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.rfm);
        this.fixedTable.setAutoResizeMode(4);
        this.initComponents();
        this.config_c = new ConfigurazioneCorrispettivo();
        this.riepilogo_tm = new RiepilogoCorrispettiviTableModel();
        this.jTableRiepilogo.setModel(this.riepilogo_tm);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mf = new TimeFormatter();
        this.data_dal = new DateField(this.mf);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 50, 0);
        this.jPanel2.add((Component)this.data_dal, gridBagConstraints);
        this.mf = new TimeFormatter();
        this.data_al = new DateField(this.mf);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.jPanel2.add((Component)this.data_al, gridBagConstraints);
        this.vettore_registrazioni = new Vector();
        this.crea_toolbar();
        this.aggiungi_tabelle();
        this.filtra();
        ListSelectionModel listSelectionModel = this.jTableRegistro.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.formatta();
        this.visualizzazione();
        this.controlla_diritti();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(850, 850)));
        MyTrace.log.info("PERFORMANCE: Registrazioni ISTANZIATA in=" + (System.currentTimeMillis() - this.tempo_di_visualizzazione) + " millisecondi");
        perf.fine();
    }

    private void controlla_diritti() {
    }

    public void verifica_CC() {
        try {
            CausaleContabile causale_contabile = new CausaleContabile();
            Configurazioni.getIstanza();
            String codice_causale = Configurazioni.hm.get("cc_corrispettivi");
            causale_contabile.seleziona(codice_causale);
            if (causale_contabile.getCodice().equals("")) {
                JOptionPane.showMessageDialog(this, "Creare una causale contabile per i Corrispettivi chiamata 'CORR'. \nCreare nel file di configurazioni la seguente riga:'cc_corrispettivi = CORR'");
                this.dispose();
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.verifica_CC(): " + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void crea_toolbar() {
        try {
            this.jToolBarMod = new JToolBar();
            JButton jButtonSalva = new JButton();
            JButton jButtonAnnulla = new JButton();
            jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
            jButtonSalva.setText("Salva");
            jButtonSalva.setFocusable(true);
            jButtonSalva.setVerticalTextPosition(3);
            jButtonSalva.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MyCorrispettivi.this.jButtonSalvaActionPerformed(evt);
                }
            });
            this.jToolBarMod.add(jButtonSalva);
            jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
            jButtonAnnulla.setText("Annulla");
            jButtonAnnulla.setFocusable(true);
            jButtonAnnulla.setVerticalTextPosition(3);
            jButtonAnnulla.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MyCorrispettivi.this.jButtonAnnullaActionPerformed(evt);
                }
            });
            this.jToolBarMod.add(jButtonAnnulla);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.crea_toolbar(): " + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void aggiungi_tabelle() {
        try {
            this.scroll = new JScrollPane(this.jTableRegistro){

                @Override
                public void setColumnHeaderView(Component view) {
                }
            };
            this.scroll.setHorizontalScrollBarPolicy(31);
            this.fixedScroll = new JScrollPane(this.fixedTable);
            this.fixedScroll.setVerticalScrollBarPolicy(22);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
            JScrollBar dummyBar = new JScrollBar(){

                @Override
                public void paint(Graphics g) {
                }
            };
            dummyBar.setPreferredSize(bar.getPreferredSize());
            this.fixedScroll.setVerticalScrollBar(dummyBar);
            final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
            JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
            bar2.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    bar1.setValue(e.getValue());
                }
            });
            this.jTableRegistro.setModel(this.reg_tm);
            this.jTableRegistro.setAutoCreateRowSorter(true);
            this.jTableRegistro.setRowSorter(this.sorter);
            this.jTableRegistro.setFillsViewportHeight(true);
            this.p.add((Component)this.scroll, "Center");
            this.p.add((Component)this.fixedScroll, "North");
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.aggiungi_tabelle(): " + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void azzera() {
    }

    public void visualizzazione() {
        try {
            if (this.in_modifica) {
                this.getContentPane().remove(this.jToolBar1);
                this.getContentPane().add((Component)this.jToolBarMod, "North");
                this.jTabbedPane1.setEnabledAt(0, false);
            } else {
                this.getContentPane().remove(this.jToolBarMod);
                this.getContentPane().add((Component)this.jToolBar1, "North");
                this.jTabbedPane1.setEnabledAt(0, true);
                this.jTabbedPane1.setEnabledAt(1, false);
                this.jTabbedPane1.setEnabledAt(2, false);
                this.jTabbedPane1.setEnabledAt(3, false);
            }
            this.getContentPane().validate();
            this.getContentPane().repaint();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.visualizzazione(): " + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void formatta() {
        try {
            this.jTableRegistro.setDefaultRenderer(Object.class, new GenericTableRenderer());
            this.fixedTable.setRowHeight(30);
            this.fixedTable.setDefaultEditor(String.class, new TextEditor());
            this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
            JTableHeader h = this.fixedTable.getTableHeader();
            h.setResizingAllowed(false);
            this.jTableCreazione.setRowHeight(27);
            this.jTableCreazione.setDefaultEditor(Object.class, new TextIVAEditor());
            this.jTableCreazione.setDefaultRenderer(Object.class, new RicercaCellRenderer());
            this.header_tebella();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.formatta(): " + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void formatta_riepilogo() {
        try {
            this.jTableRiepilogo.setDefaultRenderer(Object.class, new RiepilogoCorrispettiviTableRenderer());
            TableColumn c = this.jTableRiepilogo.getColumn("Conto");
            c.setPreferredWidth(120);
            c.setMaxWidth(120);
            c = this.jTableRiepilogo.getColumn("Data Registrazione");
            c.setPreferredWidth(100);
            c.setMaxWidth(100);
            c = this.jTableRiepilogo.getColumn("IVA");
            c.setPreferredWidth(60);
            c.setMaxWidth(60);
            c = this.jTableRiepilogo.getColumn("Dare");
            c.setPreferredWidth(90);
            c.setMaxWidth(90);
            c = this.jTableRiepilogo.getColumn("Avere");
            c.setPreferredWidth(90);
            c.setMaxWidth(90);
            c = this.jTableRiepilogo.getColumn("Imponibile");
            c.setPreferredWidth(90);
            c.setMaxWidth(90);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.formatta_riepilogo(): " + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void header_tebella() {
        try {
            String[] toolTipStr = new String[]{"Data Documento", "Numero Documento", "Codice Causale Contabile", "Numero Registrazione", "Data Registrazione", "Importo", "Codice Cliente/Fornitore", "Ragione Sociale Cliente/Fornitore"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableRegistro.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableRegistro.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void header_tebella_corrispettivi() {
        try {
            int i;
            TableColumnModel cm = this.jTableCreazione.getColumnModel();
            ColumnGroup g_name = new ColumnGroup("Reparti");
            ColumnGroup g_lang = new ColumnGroup("Incassi");
            for (i = 1; i < this.config_c.ottieni_colonne_reparti().size() + 1; ++i) {
                g_name.add(cm.getColumn(i));
            }
            for (i = this.config_c.ottieni_colonne_reparti().size() + 1; i < this.config_c.ottieni_colonne_tutte().size() - 2; ++i) {
                g_lang.add(cm.getColumn(i));
            }
            GroupableTableHeader header = new GroupableTableHeader(cm);
            header.addColumnGroup(g_name);
            header.addColumnGroup(g_lang);
            this.jTableCreazione.setTableHeader(header);
            header.setResizingAllowed(false);
        }
        catch (Exception e) {
            MyTrace.log.severe("Eccezione in MyCorrispettivi.header_tabella_corrispettivi():" + e);
            System.out.println("Eccezione in MyCorrispettivi.header_tabella_corrispettivi()");
        }
    }

    public void filtra() {
        try {
            InsiemeReparti insieme = new InsiemeReparti();
            insieme.caricamento("Select * from conf_reparti WHERE abilita='1'");
            this.reparto = (Reparto)insieme.vettoreReparti.elementAt(1);
            String where = " WHERE conf_causale_contabile.idcausale_contabile='" + this.reparto.getId_cc() + "' ";
            String order_by = "  ORDER BY data_doc DESC ";
            if (Configurazioni.righe_ricerca != 0) {
                order_by = order_by + " LIMIT 0," + Configurazioni.righe_ricerca;
            }
            this.insieme_r.caricamento_veloce(where, order_by);
            this.reg_tm.setDataRegistro(this.insieme_r.vettoreRegistrazioni);
            if (Configurazioni.righe_ricerca != 0 && this.insieme_r.vettoreRegistrazioni.size() >= Configurazioni.righe_ricerca) {
                this.non_tutte_le_righe = true;
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.filtra(): " + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void filtra_uno(int id) {
        try {
            String where = " WHERE idregistro=" + id;
            this.insieme_r.caricamento_veloce(where, "");
            this.reg_tm.setDataRegistro(this.insieme_r.vettoreRegistrazioni);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.filtra_uno(): " + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void seleziona(int row) {
        try {
            MyTrace.log.info("SELEZIONATA RIGA:>");
            this.r_selezione = new Registrazione();
            this.r_selezione = (Registrazione)this.insieme_r.vettoreRegistrazioni.elementAt(row);
            MyRegistrazioni oggetto = new MyRegistrazioni();
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            oggetto.filtra_uno(this.r_selezione.getIdregistro());
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.seleziona(): " + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void riempi_campi() {
        this.visualizzazione();
    }

    private void costruisci() {
        try {
            int riga = 0;
            Iterator i_corrispettivi = this.vettore_corrispettivi.iterator();
            this.vettore_registrazioni = new Vector();
            while (i_corrispettivi.hasNext()) {
                String anno_doc;
                CausaleContabile cc = new CausaleContabile();
                cc.seleziona(this.reparto.getId_cc());
                cc.seleziona_dettagli();
                Registrazione registrazione = new Registrazione();
                String data_doc_it = this.ctm.getValueAt(riga, 0).toString();
                System.out.println("_" + data_doc_it + "_");
                String data_doc = this.fda.gira_data(data_doc_it);
                String anno_prot = anno_doc = this.fda.anno(data_doc);
                String data_reg = this.fda.dataCorrente();
                String anno_reg = this.fda.anno(this.fda.dataCorrente());
                int num_reg = this.f.ultima_registrazione(Integer.parseInt(anno_reg)) + 1;
                registrazione.setAnno_reg(Integer.valueOf(anno_reg));
                registrazione.setData_doc(data_doc);
                registrazione.setData_reg(data_reg);
                registrazione.setCc(cc);
                registrazione.setCodice_causale_contabile(cc.getCodice());
                registrazione.setId_causale_contabile(cc.getId());
                registrazione.setNum_doc("");
                registrazione.setNum_reg(num_reg);
                registrazione.setTipo_cf("N");
                registrazione.setRi(cc.getReg_iva());
                ConfigurazioneCorrispettivo corr = new ConfigurazioneCorrispettivo();
                registrazione.setNote("Corrispettivo del " + data_doc_it);
                int colonna = corr.ottieni_dimensione_colonne();
                registrazione.setImporto_doc(new Money(this.ctm.getValueAt(riga, colonna - 1).toString()));
                registrazione.setRi(cc.getReg_iva());
                registrazione.setId_registro_iva(cc.getId_registro_iva());
                System.out.println("Vediamo se si vede il registro iva" + cc.getReg_iva().getCodice());
                int ultima_protoc_fatto = cc.getTm().getContatore().ultimo_protocollo_iva(Integer.parseInt(anno_reg), cc.getId_registro_iva());
                registrazione.setProtocollo_iva(ultima_protoc_fatto + 1);
                registrazione.setInsieme_righe(new InsiemePNRiga());
                registrazione.setInsieme_iva(new InsiemePNIva());
                registrazione.setInsieme_p(new InsiemePartite());
                Iterator i_r = this.config_c.getInsiemeReparti().vettoreReparti.iterator();
                int contatore_reparti = 1;
                while (i_r.hasNext()) {
                    Reparto reparto = (Reparto)i_r.next();
                    PNRiga pnr = new PNRiga();
                    pnr.setId_conto(reparto.getId_conto_5());
                    pnr.setData_doc(data_doc);
                    pnr.setFine_competenza(data_doc);
                    pnr.setInizio_competenza(data_doc);
                    pnr.setR(registrazione);
                    Money totale = new Money(this.ctm.getValueAt(riga, contatore_reparti).toString());
                    Aliquota a = new Aliquota();
                    String w = "where idAliquota= " + reparto.getId_aliquota() + " ";
                    a.seleziona(w);
                    Money aliquota_iva = new Money(a.getAliquota());
                    MyTrace.log.info("ALIQUOTA=" + aliquota_iva.toString());
                    Money imponibile = totale.div(1.0 + aliquota_iva.div(100).getDoubleValue());
                    MyTrace.log.info("IMPORTO_IMPONIBILE=" + imponibile.toString());
                    Money imposta = totale.minus(imponibile);
                    MyTrace.log.info("IMPOSTA=" + imposta.toString());
                    pnr.setImporto(imponibile);
                    pnr.setSegno(2);
                    registrazione.getInsieme_righe().vettoreRPN.add(pnr);
                    PNIva pni = new PNIva();
                    pni.setAnno(Integer.valueOf(anno_doc));
                    pni.setId_aliquota(reparto.getId_aliquota());
                    pni.setId_conto(cc.getId_conto_iva());
                    pni.setImporto_riga(totale);
                    pni.setImposta(imposta);
                    pni.setId_registro_iva(cc.getId_registro_iva());
                    pni.setImponibile(totale.minus(imposta));
                    pni.setSegno(2);
                    pni.setR(registrazione);
                    registrazione.getInsieme_iva().vettoreIVAPN.add(pni);
                    ++contatore_reparti;
                }
                for (CausaleContabileRiga ccr : cc.getInsieme_righe().vettoreCCRighe) {
                    PNRiga pnr = new PNRiga();
                    pnr.setId_conto(ccr.getId_conto());
                    pnr.setData_doc(data_doc);
                    pnr.setDocumento("");
                    pnr.setFine_competenza(data_doc);
                    pnr.setInizio_competenza(data_doc);
                    pnr.setR(registrazione);
                    Money importo = new Money(this.ctm.getValueAt(riga, contatore_reparti).toString());
                    pnr.setImporto(importo);
                    pnr.setSegno(ccr.getSegno());
                    registrazione.getInsieme_righe().vettoreRPN.add(pnr);
                    ++contatore_reparti;
                }
                this.vettore_registrazioni.add(registrazione);
                i_corrispettivi.next();
                ++riga;
            }
            this.costruisci_riepilogo();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.costruisci(): " + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void costruisci_riepilogo() {
        try {
            MyTrace.log.info("Sto facendo costruisci_riepilogo()");
            this.vettore_riepilogo = new Vector();
            for (Registrazione registrazione : this.vettore_registrazioni) {
                Riepilogo r_temp;
                Iterator i;
                if (registrazione.getInsieme_iva() != null && !registrazione.getInsieme_iva().vettoreIVAPN.isEmpty()) {
                    i = registrazione.getInsieme_iva().vettoreIVAPN.iterator();
                    while (i.hasNext()) {
                        PNIva pni = new PNIva();
                        pni = (PNIva)i.next();
                        r_temp = new Riepilogo();
                        r_temp.setConto(pni.getC().getConto());
                        r_temp.setCodice_cf("");
                        r_temp.setDescrizione_conto(pni.getC().getDescrizione());
                        r_temp.setCodice_aliquota(pni.getA().getCodice());
                        if (pni.getSegno() == 1) {
                            r_temp.setDare(pni.getImposta().minus(pni.getImposta_ind()));
                            r_temp.setAvere(new Money(BigDecimal.ZERO));
                        } else {
                            r_temp.setDare(new Money(BigDecimal.ZERO));
                            r_temp.setAvere(pni.getImposta().minus(pni.getImposta_ind()));
                        }
                        r_temp.setImponibile(pni.getImponibile());
                        this.vettore_riepilogo.add(r_temp);
                    }
                }
                if (registrazione.getInsieme_righe() != null && !registrazione.getInsieme_righe().vettoreRPN.isEmpty()) {
                    i = registrazione.getInsieme_righe().vettoreRPN.iterator();
                    while (i.hasNext()) {
                        PNRiga pnr = new PNRiga();
                        pnr = (PNRiga)i.next();
                        r_temp = new Riepilogo();
                        r_temp.setConto(pnr.getC().getConto());
                        r_temp.setCodice_cf("");
                        r_temp.setDescrizione_conto(pnr.getC().getDescrizione());
                        r_temp.setCodice_aliquota("");
                        if (pnr.getSegno() == 1) {
                            r_temp.setDare(pnr.getImporto());
                            r_temp.setAvere(new Money(BigDecimal.ZERO));
                        } else {
                            r_temp.setDare(new Money(BigDecimal.ZERO));
                            r_temp.setAvere(pnr.getImporto());
                        }
                        r_temp.setImponibile(new Money(BigDecimal.ZERO));
                        this.vettore_riepilogo.add(r_temp);
                    }
                }
                Riepilogo r_tot = new Riepilogo();
                r_tot.setConto("Data Corrispettivo");
                r_tot.setCodice_cf("" + registrazione.getData_docIt());
                r_tot.setDescrizione_conto("Totale");
                r_tot.setCodice_aliquota("");
                Iterator i2 = this.vettore_riepilogo.iterator();
                Money dare = new Money(BigDecimal.ZERO);
                Money avere = new Money(BigDecimal.ZERO);
                Money imponibile = new Money(BigDecimal.ZERO);
                while (i2.hasNext()) {
                    Riepilogo r_temp2 = (Riepilogo)i2.next();
                    if (!r_temp2.getDescrizione_conto().equals("Totale")) {
                        dare = dare.plus(r_temp2.getDare());
                        avere = avere.plus(r_temp2.getAvere());
                        imponibile = r_temp2.getImponibile();
                        continue;
                    }
                    dare = dare.minus(r_temp2.getDare());
                    avere = avere.minus(r_temp2.getAvere());
                    imponibile = r_temp2.getImponibile();
                }
                r_tot.setDare(dare);
                r_tot.setAvere(avere);
                r_tot.setImponibile(imponibile);
                this.vettore_riepilogo.add(r_tot);
            }
            this.riepilogo_tm.setDataRiepilogo(this.vettore_riepilogo);
            this.formatta_riepilogo();
            MyTrace.log.info("fine costruisci_riepilogo()");
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyCorrispettivi.costruisci_riepilogo(): " + e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void costruisci_scadenze() {
    }

    private boolean check() {
        for (int i = 0; i < this.ctm.cache.size(); ++i) {
            Corrispettivo c = (Corrispettivo)this.ctm.cache.elementAt(i);
            Iterator<Money> i_reparti = c.getIncasso_reparti().iterator();
            Money somma_depositi = new Money(BigDecimal.ZERO);
            Money somma_reparti = new Money(BigDecimal.ZERO);
            Money totale = new Money(BigDecimal.ZERO);
            while (i_reparti.hasNext()) {
                somma_reparti = somma_reparti.plus(new Money(((Object)i_reparti.next()).toString()));
            }
            Iterator<Money> i_depositi = c.getDeposito_cassa().iterator();
            while (i_depositi.hasNext()) {
                somma_depositi = somma_depositi.plus(new Money(((Object)i_depositi.next()).toString()));
            }
            totale = c.getTotale_giorno();
            if (!somma_reparti.eq(somma_depositi)) {
                JOptionPane.showMessageDialog(this, "Le somme in data " + c.getData_corrispettivo() + " non tornano:\nSomma Reparti = " + somma_reparti + " \n" + "Somma Depositi = " + somma_depositi + " \n" + "Totale = " + totale);
                return false;
            }
            if (!somma_reparti.eq(totale)) {
                JOptionPane.showMessageDialog(this, "Le somme in data " + c.getData_corrispettivo() + " non tornano:\nSomma Reparti = " + somma_reparti + " \n" + "Somma Depositi = " + somma_depositi + " \n" + "Totale = " + totale);
                return false;
            }
            if (somma_depositi.eq(totale)) continue;
            JOptionPane.showMessageDialog(this, "Le somme in data " + c.getData_corrispettivo() + " non tornano:\nSomma Reparti = " + somma_reparti + " \n" + "Somma Depositi = " + somma_depositi + " \n" + "Totale = " + totale);
            return false;
        }
        return true;
    }

    private boolean check2() {
        Date da = this.fda.string_to_date(this.fda.gira_data(this.data_dal.getText()));
        Date a = this.fda.string_to_date(this.fda.gira_data(this.data_al.getText()));
        boolean trovato = false;
        int anno = Integer.valueOf(this.fda.anno(this.fda.date_to_string(da)));
        int giorno = Integer.valueOf(this.fda.giorno(this.fda.date_to_string(da)));
        int mese = Integer.valueOf(this.fda.mese(this.fda.date_to_string(da)));
        while (!trovato) {
            Date nuovo = this.fda.string_to_date(anno + "-" + mese + "-" + giorno);
            trovato = this.f.controlla_data(this.fda.date_to_string(nuovo));
            if (trovato) {
                JOptionPane.showMessageDialog(this, "E' gi\u00e0 presente nel database un corrispettivo con data " + this.fda.gira_data(this.fda.date_to_string(nuovo)));
                return false;
            }
            if (a.equals(nuovo)) break;
            ++giorno;
        }
        if (da.after(a)) {
            JOptionPane.showMessageDialog(this, "La prima data non deve essere seguente alla seconda!");
            return false;
        }
        return true;
    }

    public void aiuto_iva(int row, int col) {
    }

    public void aiuto_riga(int row, int col) {
    }

    public void focus_riga(int row, int col) {
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane6 = new JScrollPane();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.jScrollPane7 = new JScrollPane();
        this.jPanelNuovo = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabelDataDa = new JLabel();
        this.jLabelDataAl = new JLabel();
        this.jButtonProcedi = new JButton();
        this.jLabel35 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelCreazione = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jScrollPane9 = new JScrollPane();
        this.jTableCreazione = new JTable(this.ctm);
        this.jPanel1 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jTableRiepilogo = new JTable();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Contabilit\u00e0 \\ Registrazione Corrispettivi");
        this.setPreferredSize(new Dimension(822, 700));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                MyCorrispettivi.this.finestra_chiusa(evt);
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyCorrispettivi.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyCorrispettivi.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyCorrispettivi.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyCorrispettivi.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyCorrispettivi.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyCorrispettivi.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyCorrispettivi.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyCorrispettivi.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyCorrispettivi.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyCorrispettivi.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyCorrispettivi.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jButtonStampa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyCorrispettivi.this.jButtonStampaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MyCorrispettivi.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jScrollPane6.setViewportView(this.jPanelElenco);
        this.jTabbedPane1.addTab("Elenco", this.jScrollPane6);
        this.jPanelNuovo.setBackground(new Color(255, 255, 255));
        this.jPanelNuovo.setAutoscrolls(true);
        this.jPanelNuovo.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabelDataDa.setText("Dal Giorno");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 50, 0);
        this.jPanel2.add((Component)this.jLabelDataDa, gridBagConstraints);
        this.jLabelDataAl.setText("Al Giorno");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.jPanel2.add((Component)this.jLabelDataAl, gridBagConstraints);
        this.jButtonProcedi.setText("Avanti");
        this.jButtonProcedi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyCorrispettivi.this.jButtonProcediActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(110, 100, 100, 100);
        this.jPanel2.add((Component)this.jButtonProcedi, gridBagConstraints);
        this.jLabel35.setBackground(new Color(153, 153, 153));
        this.jLabel35.setFont(new Font("Tahoma", 1, 11));
        this.jLabel35.setText("Selezionare l'intervallo di date su cui effettuare la registrazione dei corrispettivi");
        this.jLabel35.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 50, 0);
        this.jPanel2.add((Component)this.jLabel35, gridBagConstraints);
        this.jPanelNuovo.add((Component)this.jPanel2, "Center");
        this.jScrollPane7.setViewportView(this.jPanelNuovo);
        this.jTabbedPane1.addTab("Nuovo", this.jScrollPane7);
        this.jPanelCreazione.setBackground(new Color(255, 255, 255));
        this.jPanelCreazione.setAutoscrolls(true);
        this.jPanelCreazione.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel7.setLayout(new BorderLayout());
        this.jScrollPane9.setMaximumSize(new Dimension(100, 200));
        this.jScrollPane9.setPreferredSize(new Dimension(250, 300));
        this.jTableCreazione.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTableCreazione.setDragEnabled(true);
        this.jTableCreazione.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyCorrispettivi.this.jTableCreazioneFocusLost(evt);
            }
        });
        this.jScrollPane9.setViewportView(this.jTableCreazione);
        this.jPanel7.add((Component)this.jScrollPane9, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel7.add((Component)this.jPanel1, "Last");
        this.jPanel3.add((Component)this.jPanel7, "Center");
        this.jPanelCreazione.add((Component)this.jPanel3, "Center");
        this.jScrollPane1.setViewportView(this.jPanelCreazione);
        this.jTabbedPane1.addTab("Creazione", this.jScrollPane1);
        this.jPanel8.setLayout(new BorderLayout());
        this.jTableRiepilogo.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane4.setViewportView(this.jTableRiepilogo);
        this.jPanel8.add((Component)this.jScrollPane4, "Center");
        this.jTabbedPane1.addTab("Riepilogo", this.jPanel8);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        MyTrace.log.info("PRIMANOTA SALVA RICHIESTO");
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                Iterator i_r = this.vettore_registrazioni.iterator();
                boolean test = true;
                while (i_r.hasNext() && test) {
                    Registrazione r = (Registrazione)i_r.next();
                    if (r.getImporto_doc().eq(new Money(BigDecimal.ZERO))) continue;
                    test = r.inserisciRegistrazione(true);
                }
                if (test) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.formatta();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "E' stato rilevato un errore nella query!\nRicontrollare i dati inseriti e tentare nuovamente il salvataggio");
                    this.jTabbedPane1.setSelectedIndex(2);
                }
            }
        } else if (this.check()) {
            this.costruisci();
            this.in_modifica = false;
            this.filtra();
            this.formatta();
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
        MyTrace.log.info("PRIMANOTA SALVA EFFETTUATO");
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        MyTrace.log.info("PRIMANOTA ANNULLA RICHIESTO");
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            if (this.in_new) {
                this.vettore_registrazioni = new Vector();
                this.in_new = false;
            }
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
        MyTrace.log.info("PRIMANOTA ANNULLA EFFETTUATO");
    }

    private void jTextCFKeyPressed(KeyEvent evt) {
    }

    private void jTextjTablePNRigheLost(FocusEvent evt) {
    }

    private void jTextCFFocusLost(FocusEvent evt) {
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        MyTrace.log.info("PRIMANOTA NUOVO RICHIESTO ***************************************************************************");
        this.in_new = true;
        this.jTableRegistro.getSelectionModel().clearSelection();
        this.jTabbedPane1.setEnabledAt(1, true);
        this.jTabbedPane1.setSelectedIndex(1);
        this.data_dal.setText(this.fda.dataCorrenteIt());
        this.data_al.setText(this.fda.dataCorrenteIt());
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.config_c = new ConfigurazioneCorrispettivo();
        this.visualizzazione();
        MyTrace.log.info("PRIMANOTA NUOVO APERTO*****************************************************************************");
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.reg_tm.getRowCount() != 0) {
            this.jTableRegistro.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableRegistro.getSelectedRow() > 0 && this.reg_tm.getRowCount() != 0) {
                this.jTableRegistro.getSelectionModel().setSelectionInterval(this.jTableRegistro.getSelectedRow() - 1, this.jTableRegistro.getSelectedRow() - 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO PRIMO");
            err.printStackTrace();
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        try {
            if (this.reg_tm.getRowCount() != 0) {
                this.jTableRegistro.getSelectionModel().setSelectionInterval(this.jTableRegistro.getSelectedRow() + 1, this.jTableRegistro.getSelectedRow() + 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO ULTIMO");
            err.printStackTrace();
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.reg_tm.getRowCount() != 0) {
            this.jTableRegistro.getSelectionModel().setSelectionInterval(this.reg_tm.getRowCount() - 1, this.reg_tm.getRowCount() - 1);
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            MyTrace.log.info("FILTRO INSERITO");
            this.in_filter = true;
            String[] a_ric = new String[]{"", "", "", "", "", "", ""};
            this.rfm.addRow(a_ric);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.fixedTable.setCellSelectionEnabled(true);
            this.fixedTable.changeSelection(0, 0, false, false);
            this.fixedTable.requestFocus();
        } else {
            MyTrace.log.info("FILTRO DISINSERITO");
            this.in_filter = false;
            this.rfm.deleteRow();
            this.rfm = new RegistrazioneCorrispettiviFixedModel();
            this.fixedTable.setModel(this.rfm);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            this.sorter.setRowFilter(null);
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] a_ric = new String[]{"", "", "", "", "", "", ""};
            this.rfm = new RegistrazioneCorrispettiviFixedModel();
            this.fixedTable.setModel(this.rfm);
            this.rfm.addRow(a_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.reg_tm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonStampaActionPerformed(ActionEvent evt) {
        MyStampaCorrispettivi oggetto = new MyStampaCorrispettivi();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void finestra_chiusa(InternalFrameEvent evt) {
        try {
            if (this.chiamante.getClass() == MyInterrogazioneConti.class) {
                ((MyInterrogazioneConti)this.chiamante).f_pn_open = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        try {
            if (this.in_modifica && (this.jTabbedPane1.getSelectedIndex() == 2 || this.jTabbedPane1.getSelectedIndex() == 3)) {
                this.costruisci();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButtonProcediActionPerformed(ActionEvent evt) {
        if (this.check2()) {
            Iterator iii;
            Iterator ii;
            ArrayList<Money> vettore_incassi;
            ArrayList<Money> vettore_reparti;
            Corrispettivo temp;
            int max_incassi;
            ConfigurazioneCorrispettivo c = new ConfigurazioneCorrispettivo();
            Vector<String> nomi_colonne = new Vector<String>();
            Vector colonne_reparti = new Vector();
            colonne_reparti = c.ottieni_colonne_reparti();
            Vector colonne_incassi = new Vector();
            colonne_incassi = c.ottieni_colonne_cassa();
            nomi_colonne.add("Giorno");
            Iterator i = colonne_reparti.iterator();
            while (i.hasNext()) {
                nomi_colonne.add(i.next().toString());
            }
            Iterator y = colonne_incassi.iterator();
            while (y.hasNext()) {
                nomi_colonne.add(y.next().toString());
            }
            nomi_colonne.add("Totale Giorno");
            String[] array_colonne = new String[nomi_colonne.size()];
            for (int ii2 = 0; ii2 < nomi_colonne.size(); ++ii2) {
                array_colonne[ii2] = "" + nomi_colonne.elementAt(ii2);
            }
            int max_reparti = colonne_reparti.size() + 1;
            int max_totale = max_incassi = max_reparti + colonne_incassi.size();
            this.jTabbedPane1.setEnabledAt(2, true);
            this.jTabbedPane1.setSelectedIndex(2);
            this.jTabbedPane1.setEnabledAt(3, true);
            this.vettore_corrispettivi = new Vector();
            Date dal = this.fda.string_to_date(this.fda.gira_data(this.data_dal.getText()));
            Date al = this.fda.string_to_date(this.fda.gira_data(this.data_al.getText()));
            Date cursore = new Date();
            cursore = dal;
            int dim_colonne = c.ottieni_dimensione_colonne();
            int dim_cassa = c.ottieni_dimensione_cassa();
            int dim_reparti = c.ottieni_dimensione_reparti();
            while (!cursore.equals(al)) {
                temp = new Corrispettivo(c, dim_colonne, dim_reparti, dim_cassa);
                vettore_reparti = new ArrayList<Money>();
                vettore_incassi = new ArrayList<Money>();
                ii = colonne_incassi.iterator();
                while (ii.hasNext()) {
                    vettore_incassi.add(new Money(BigDecimal.ZERO));
                    ii.next();
                }
                iii = colonne_reparti.iterator();
                while (iii.hasNext()) {
                    vettore_reparti.add(new Money(BigDecimal.ZERO));
                    iii.next();
                }
                int anno = Integer.valueOf(this.fda.anno(this.fda.date_to_string(cursore)));
                int giorno = Integer.valueOf(this.fda.giorno(this.fda.date_to_string(cursore)));
                int mese = Integer.valueOf(this.fda.mese(this.fda.date_to_string(cursore)));
                Date nuovo = this.fda.string_to_date(anno + "-" + mese + "-" + giorno);
                temp.setData_corrispettivo(this.fda.gira_data(this.fda.date_to_string(nuovo)));
                temp.setDeposito_cassa(vettore_incassi);
                temp.setIncasso_reparti(vettore_reparti);
                this.vettore_corrispettivi.add(temp);
                System.out.println(temp.getData_corrispettivo());
                cursore = nuovo = this.fda.string_to_date(anno + "-" + mese + "-" + ++giorno);
            }
            temp = new Corrispettivo(c, dim_colonne, dim_reparti, dim_cassa);
            vettore_reparti = new ArrayList();
            vettore_incassi = new ArrayList();
            ii = colonne_incassi.iterator();
            while (ii.hasNext()) {
                vettore_incassi.add(new Money(BigDecimal.ZERO));
                ii.next();
            }
            iii = colonne_reparti.iterator();
            while (iii.hasNext()) {
                vettore_reparti.add(new Money(BigDecimal.ZERO));
                iii.next();
            }
            temp.setData_corrispettivo(this.fda.gira_data(this.fda.date_to_string(al)));
            temp.setDeposito_cassa(vettore_incassi);
            temp.setIncasso_reparti(vettore_reparti);
            this.vettore_corrispettivi.add(temp);
            InsiemeReparti insieme_re = new InsiemeReparti();
            String query_seleziona_reparti = "SELECT * FROM conf_reparti WHERE abilita=1";
            insieme_re.caricamento(query_seleziona_reparti);
            this.config_c.setInsiemeReparti(insieme_re);
            this.ctm = new CorrispettivoTableModel(max_incassi, max_reparti, max_totale, colonne_reparti, colonne_incassi, vettore_reparti, vettore_incassi, array_colonne);
            this.ctm.setDataCorrispettivo(this.vettore_corrispettivi);
            this.jTableCreazione.setModel(this.ctm);
            TableColumn cc = this.jTableCreazione.getColumn("Giorno");
            cc.setPreferredWidth(90);
            cc.setMaxWidth(90);
            cc = this.jTableCreazione.getColumn("Totale Giorno");
            cc.setPreferredWidth(95);
            cc.setMaxWidth(95);
            this.formatta_riepilogo();
            this.visualizzazione();
        }
    }

    private void jTableCreazioneFocusLost(FocusEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyRegistrazioni().setVisible(true);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableRegistro.getSelectedRow();
        if (this.riga_selezionata_nella_tabella != viewRow) {
            this.riga_selezionata_nella_tabella = viewRow;
            long tempo_di_visualizzazione = System.currentTimeMillis();
            try {
                int modelRow = 1000000000;
                if (this.in_filter) {
                    if (viewRow >= 0) {
                        try {
                            modelRow = this.jTableRegistro.convertRowIndexToModel(viewRow);
                        }
                        catch (Exception err) {
                            MyTrace.log.severe("valueChanged() viewrow >=0  ECCEZIONE");
                            err.printStackTrace();
                            Funzioni.inviaBugPerEmail(err);
                            Funzioni.LogStackTrace(err);
                        }
                    }
                } else {
                    modelRow = viewRow;
                }
                if (modelRow <= this.reg_tm.getRowCount() - 1 && modelRow < 0) {
                    // empty if block
                }
            }
            catch (Exception err) {
                MyTrace.log.severe("valueChanged(ListSelectionEvent) errore presunto negli indici");
                err.printStackTrace();
                Funzioni.inviaBugPerEmail(err);
                Funzioni.LogStackTrace(err);
            }
            MyTrace.log.fine("PERFORMANCE: Selezionata Riga in=" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int viewRow = this.jTableRegistro.getSelectedRow();
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableRiepilogo.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow <= this.reg_tm.getRowCount() - 1 && modelRow >= 0) {
                this.seleziona(modelRow);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public class TextPartitaEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
        }

        class DateFieldLocal
        extends DateField {
            public DateFieldLocal(JFormattedTextField.AbstractFormatter formatter) {
                super(formatter);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        }
    }

    public class TextRigaEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
        }

        @Override
        public void azione_focus_lost(String col_row) {
        }
    }

    public class TextIVAEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
        }

        @Override
        public void azione_focus_lost(String col_row) {
        }
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<RegistrazioniCorrispettiviTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            if (!MyCorrispettivi.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyCorrispettivi.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyCorrispettivi.this.rf = RowFilter.andFilter(MyCorrispettivi.this.andFilters);
                MyCorrispettivi.this.sorter.setRowFilter(MyCorrispettivi.this.rf);
                MyCorrispettivi.this.formatta();
            } else {
                String where = " WHERE conf_causale_contabile.codice='corr' ";
                if (col == 0) {
                    where = where + " AND data_doc LIKE '%" + this.tf.getText() + "%'";
                    try {
                        where = where + "  or data_doc LIKE '%" + MyCorrispettivi.this.fda.gira_data(this.tf.getText()) + "%'";
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (col == 1) {
                    where = where + " AND num_doc LIKE '%" + this.tf.getText() + "%' or data_doc LIKE '" + this.tf.getText() + "%'";
                }
                if (col == 2) {
                    where = where + " AND conf_causale_contabile.codice LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 3) {
                    where = where + " AND num_reg LIKE '%" + this.tf.getText() + "%' or anno_reg LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 4) {
                    where = where + "  AND data_reg LIKE '%" + this.tf.getText() + "%'";
                    try {
                        where = where + "  or data_reg LIKE '%" + MyCorrispettivi.this.f.gira_stringa_data(this.tf.getText()) + "%'";
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (col == 5) {
                    where = where + "  AND importo_doc LIKE '%" + this.tf.getText() + "%'";
                }
                String order_by = " ORDER BY data_doc ASC LIMIT 0," + Configurazioni.righe_ricerca;
                MyCorrispettivi.this.insieme_r.caricamento_veloce(where, order_by);
                MyCorrispettivi.this.reg_tm.setDataRegistro(MyCorrispettivi.this.insieme_r.vettoreRegistrazioni);
                MyCorrispettivi.this.formatta();
            }
        }
    }
}

