/*
 * Decompiled with CFR 0.152.
 */
package gestionale.configurazioni;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.Performance;
import utils.SysSessioneUtente;

public class ProfiloUtente {
    String username = "";
    String password = "";
    public String nome;
    public String cognome;
    Vector diritti_db;
    public int id;
    public int id_gruppo;
    public HashMap map_diritti;
    FunzioniDate fda = new FunzioniDate();
    public SysSessioneUtente HB = new SysSessioneUtente();

    public ProfiloUtente(String user, String pw) {
        this.username = user;
        this.password = pw;
        this.map_diritti = new HashMap();
    }

    public void setHB(SysSessioneUtente HB) {
        this.HB = HB;
    }

    public boolean controllaCredenzialiSeOK() {
        int colCount = 0;
        int numeroRisultati = 0;
        MyTrace.log.info("CONTROLLO CREDANZIALI SUl DATABASE MASTER = " + Configurazioni.getIstanza().connessione_master.nomeDB);
        String query = "";
        query = query + " SELECT * FROM auth_operatori LEFT JOIN auth_gruppi on auth_operatori.id_gruppo=auth_gruppi.id WHERE auth_operatori.username='" + this.username + "' AND auth_operatori.password='" + this.password + "' " + " AND auth_operatori.abilita='1'";
        ResultSet res = null;
        try {
            res = Configurazioni.getIstanza().connessione_master.eseguiQuery(query);
            ResultSetMetaData meta = res.getMetaData();
            colCount = meta.getColumnCount();
            while (res.next()) {
                ++numeroRisultati;
                this.id = res.getInt("id");
                this.nome = res.getString("nome");
                this.cognome = res.getString("cognome");
                this.id_gruppo = res.getInt("id_gruppo");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: errore di avvio o di linkaggio");
            err.printStackTrace();
        }
        Configurazioni.getIstanza().connessione_master.ChiudiResultSet(res);
        if (numeroRisultati != 0) {
            if (numeroRisultati != 1) {
                MyTrace.log.info("CREDENZIALI MULTIPLE (ERRORE)");
                Configurazioni.eccezione.gestisci("1.3", null);
                return false;
            }
        } else {
            MyTrace.log.info("CREDENZIALI ERRATE");
            Configurazioni.eccezione.gestisci("1.4", null);
            return false;
        }
        MyTrace.log.info("CREDENZIALI CORRETTE");
        return true;
    }

    public boolean carica_diritti_del_gruppo_utente_dal_database() {
        Performance performance = new Performance("CARICO DIRITTI DEL GRUPPO UTENTE DAL DATABASE AZIENDA :" + Configurazioni.getIstanza().connessione.nomeDB);
        this.map_diritti.clear();
        int colCount = 0;
        String query2 = "SELECT nome_permesso,ok FROM auth_diritti left join  auth_permessi ON auth_diritti.id_permesso=auth_permessi.id  WHERE auth_diritti.id_gruppo='" + this.id_gruppo + "' ";
        ResultSet res2 = null;
        try {
            res2 = Configurazioni.getIstanza().connessione.eseguiQuery(query2);
            ResultSetMetaData meta = res2.getMetaData();
            colCount = meta.getColumnCount();
            while (res2.next()) {
                if (!this.map_diritti.containsKey(res2.getString("nome_permesso"))) {
                    this.map_diritti.put(res2.getString("nome_permesso"), res2.getInt("ok"));
                    continue;
                }
                MyTrace.log.severe("ERRORE: Permesso :" + res2.getString("nome_permesso") + ": DUPLICATO SULLA TABELLA auth_permessi");
            }
            MyTrace.log.info("##################################################################");
            MyTrace.log.info("#####  PERMESSI UTENTE ESTARTTI DAL DB AZIENDA   ##### quantit\u00e0:" + this.map_diritti.size());
            MyTrace.log.info("#####  PERMESSI UTENTE ESTARTTI DAL DB AZIENDA   #####   valori:" + this.map_diritti.toString());
            MyTrace.log.info("##################################################################");
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res2);
            return false;
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: errore di avvio o di linkaggio");
            err.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res2);
        performance.fine();
        MyTrace.log.info("####   ESTRATTI DIRITTI DEL GRUPPO DI APPARTENENZA DELL'UTENTE:" + this.toString() + "  in numero=" + this.map_diritti.size() + " #####");
        return true;
    }

    public int NumeroPermessiDelProfilo() {
        return this.map_diritti.size();
    }

    public boolean controllaPermesso(String permesso) {
        MyTrace.log.log(Level.FINEST, "CONTROLLO PER UTENTE :{0}:  AUTORIZZAZIONE :{1}: ", new Object[]{this.toString(), permesso});
        try {
            String diritto_s = this.map_diritti.get(permesso).toString();
            int diritto = Integer.parseInt(diritto_s);
            if (diritto == 1) {
                MyTrace.log.finest("+CONTROLLO AUTORIZZAZIONE '" + permesso + "' = OK");
                return true;
            }
            MyTrace.log.info("-CONTROLLO AUTORIZZAZIONE '" + permesso + "' = KO");
            return false;
        }
        catch (Exception e) {
            MyTrace.log.severe("ERRORE: ECCEZIONE catturata dentro al CONTROLLO AUTORIZZAZIONE probabile permesso assente per il gruppo dell'utente = " + permesso);
            e.printStackTrace();
            MyTrace.log.severe("________________________________________ PERMESSI START ____________________________");
            MyTrace.log.severe(this.map_diritti.toString());
            MyTrace.log.severe("________________________________________ PERMESSI STOP  ____________________________");
            if (this.id_gruppo == 1) {
                MyTrace.log.info("ATTENZIONE GRUPPO CON ID == 1 (presunto Amministratore) => CONTROLLO AUTORIZZAZIONE FORZATO OK");
                return true;
            }
            MyTrace.log.info("ECCEZIONE => CONTROLLO AUTORIZZAZIONE KO");
            return false;
        }
    }

    public String toString() {
        return this.nome + " " + this.cognome;
    }

    public boolean tracciaAzione(String nome_tabella, int id_soggetto, String azione) {
        String query = "INSERT INTO indizzi(id_operatore,nome_tabella,id_soggetto,data,azione) VALUES ('" + this.id + "','" + nome_tabella + "','" + id_soggetto + "','" + this.fda.dataCorrente() + "','" + azione + "'";
        MyTrace.log.info("QUERY::: " + query);
        MyDesktopWindow.statusBar.setMessage("Modifico la tabella" + nome_tabella);
        boolean retval = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query);
        if (!retval) {
            MyTrace.log.severe("Inserimento non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        return true;
    }
}

