/*
 * Decompiled with CFR 0.152.
 */
package gestionale.configurazioni;

import gestionale.azienda.Azienda;
import gestionale.configurazioni.Configurazioni;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import utils.Funzioni;
import utils.HashMapKronos;
import utils.IniFile;
import utils.MyTrace;

public class ConfigurazioneIni {
    IniFile inif;
    public static String file_di_configurazione = "/config.ini";
    public static HashMap<String, String> hm;
    public static ConfigurazioneIni puntatore;
    private String file_di_configurazione_utente = "";
    private String file_di_configurazione_sistema = "";
    private static boolean classe_istanziata;
    private static Configurazioni puntatore_istanza;
    public static int righe_ricerca;
    public static String codice_aliquota_predefinito;
    public static int id_azienda;
    public static int inizio_stampe;
    public Azienda azienda;
    public static String nome_azienda;
    public static String operatore;

    public ConfigurazioneIni() {
        MyTrace.log.info("CONFIGURAZIONE INI  START");
        if (!classe_istanziata) {
            hm = new HashMapKronos<String, String>();
            String user_home = System.getProperty("user.home");
            this.file_di_configurazione_utente = user_home + System.getProperty("file.separator") + "config.inc";
            this.file_di_configurazione_sistema = System.getProperty("user.dir") + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "config.inc";
            MyTrace.log.info("CONFIGURAZIONE INI SISTEMA:" + this.file_di_configurazione_sistema);
            this.inif = new IniFile(this.file_di_configurazione_sistema);
            this.leggiConfigurazione();
            MyTrace.log.info("CONFIGURAZIONE INI  UTENTE:" + this.file_di_configurazione_utente);
            if (this.SeNonEsisteCreaIlFile(this.file_di_configurazione_utente)) {
                this.inif = new IniFile(this.file_di_configurazione_utente);
                this.leggiConfigurazione();
            }
            puntatore = this;
            classe_istanziata = true;
            MyTrace.log.info("CONFIGURAZIONE INI  END");
        } else {
            MyTrace.log.severe("ERRORE DI PROGRAMMAZIONE (CLASSE ConfigurazioneIni istanziata pi\u00f9 volte)");
        }
    }

    public void leggiConfigurazione() {
        try {
            String[] sections = this.inif.getAllSectionNames();
            for (int i = 0; i < sections.length; ++i) {
                hm.put("section", sections[i]);
                hm.put("server", this.inif.getStringProperty(sections[i], "server"));
                hm.put("dbPorta", this.inif.getStringProperty(sections[i], "dbPorta"));
                hm.put("dbName", this.inif.getStringProperty(sections[i], "dbName"));
                hm.put("dbUser", this.inif.getStringProperty(sections[i], "dbUser"));
                hm.put("dbPass", this.inif.getStringProperty(sections[i], "dbPass"));
                hm.put("righe_ricerca", this.inif.getStringProperty(sections[i], "righe_ricerca"));
                hm.put("cc_fattura_differita_magazzino", this.inif.getStringProperty(sections[i], "cc_fattura_differita_magazzino"));
                hm.put("cc_fattura_accompagnatoria_magazzino", this.inif.getStringProperty(sections[i], "cc_fattura_accompagnatoria_magazzino"));
                hm.put("cc_fattura_accompagnatoria_gasolio", this.inif.getStringProperty(sections[i], "cc_fattura_accompagnatoria_gasolio"));
                hm.put("cc_fattura_passiva_manutenzione", this.inif.getStringProperty(sections[i], "cc_fattura_passiva_manutenzione"));
                hm.put("cc_nota_di_credito_da_vettore", this.inif.getStringProperty(sections[i], "cc_nota_di_credito_da_vettore"));
                hm.put("cc_nota_di_credito_da_fornitore_da_manutenzioni", this.inif.getStringProperty(sections[i], "cc_nota_di_credito_da_fornitore_da_manutenzioni"));
                hm.put("cc_nota_di_credito_a_cliente_da_magazzino", this.inif.getStringProperty(sections[i], "cc_nota_di_credito_a_cliente_da_magazzino"));
                hm.put("cc_nota_di_credito_da_fornitore_da_magazzino", this.inif.getStringProperty(sections[i], "cc_nota_di_credito_da_fornitore_da_magazzino"));
                hm.put("cc_corrispettivi", this.inif.getStringProperty(sections[i], "cc_corrispettivi"));
                hm.put("cc_fattura_autostrade", this.inif.getStringProperty(sections[i], "cc_fattura_autostrade"));
                hm.put("login.controllo_unicita", this.inif.getStringProperty(sections[i], "login.controllo_unicita"));
                hm.put("trace.level", this.inif.getStringProperty(sections[i], "trace.level"));
                hm.put("debug.invia_email", this.inif.getStringProperty(sections[i], "debug.invia_email"));
                hm.put("pianodeiconti.ritenuta_acconto", this.inif.getStringProperty(sections[i], "pianodeiconti.ritenuta_acconto"));
                hm.put("pianodeiconti.versamento_iva", this.inif.getStringProperty(sections[i], "pianodeiconti.versamento_iva"));
                hm.put("pianodeiconti.versamento_ritenuta_acconto", this.inif.getStringProperty(sections[i], "pianodeiconti.versamento_ritenuta_acconto"));
                hm.put("pianodeiconti.carico_gasolio", this.inif.getStringProperty(sections[i], "pianodeiconti.carico_gasolio"));
                hm.put("pianodeiconti.pedaggi_autostradali_trattori", this.inif.getStringProperty(sections[i], "pianodeiconti.pedaggi_autostradali_trattori"));
                hm.put("pianodeiconti.canone_telepass", this.inif.getStringProperty(sections[i], "pianodeiconti.canone_telepass"));
                hm.put("cdr_casa_spedizioni", this.inif.getStringProperty(sections[i], "cdr_casa_spedizioni"));
                hm.put("cdr_trasporti", this.inif.getStringProperty(sections[i], "cdr_trasporti"));
                hm.put("voce_di_analisi_carico_gasolio", this.inif.getStringProperty(sections[i], "voce_di_analisi_carico_gasolio"));
                hm.put("voce_di_analisi_carico_gasolio_altri", this.inif.getStringProperty(sections[i], "voce_di_analisi_carico_gasolio_altri"));
                hm.put("voce_di_analisi_manutenzione", this.inif.getStringProperty(sections[i], "voce_di_analisi_manutenzione"));
                hm.put("voce_di_analisi_manutenzione_altri", this.inif.getStringProperty(sections[i], "voce_di_analisi_manutenzione_altri"));
                hm.put("voce_di_analisi_viaggi_terzi", this.inif.getStringProperty(sections[i], "voce_di_analisi_viaggi_terzi"));
                hm.put("voce_di_analisi_fatturato", this.inif.getStringProperty(sections[i], "voce_di_analisi_fatturato"));
                hm.put("cc_fattura_vettore_trasporti", this.inif.getStringProperty(sections[i], "cc_fattura_vettore_trasporti"));
                hm.put("path_bolle", this.inif.getStringProperty(sections[i], "path_bolle"));
                hm.put("id_azienda_predefinita", this.inif.getStringProperty(sections[i], "id_azienda_predefinita"));
                hm.put("codice_iva_predefinito", this.inif.getStringProperty(sections[i], "codice_iva_predefinito"));
                hm.put("inizio_stampa", this.inif.getStringProperty(sections[i], "inizio_stampa"));
                codice_aliquota_predefinito = hm.get("codice_iva_predefinito");
                righe_ricerca = Integer.parseInt(hm.get("righe_ricerca"));
                id_azienda = Integer.parseInt(hm.get("id_azienda_predefinita"));
                inizio_stampe = Integer.parseInt(hm.get("inizio_stampa"));
                MyTrace.log.info("hm=" + hm.toString());
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("ECCEZIONE: nella lettura del file di configurazione");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
        }
    }

    public void scriviConfigurazione() {
        MyTrace.log.info("####   SALVATAGGIO  CONFIGURAZIONE NEL FILE INI UTENTE  ######");
        this.SeNonEsisteCreaIlFile(this.file_di_configurazione_utente);
        file_di_configurazione = this.file_di_configurazione_utente;
        this.inif = null;
        this.inif = new IniFile(file_di_configurazione);
        String[] sections = this.inif.getAllSectionNames();
        for (int i = 0; i < sections.length; ++i) {
            this.inif.setStringProperty(sections[i], "righe_ricerca", hm.get("righe_ricerca"), null);
            this.inif.setStringProperty(sections[i], "id_azienda_predefinita", hm.get("id_azienda_predefinita"), null);
            MyTrace.log.info("SALVATAGGIO(Configurazione ini::::::::::::::: righe_ricerca =" + hm.get("righe_ricerca"));
            MyTrace.log.info("SALVATAGGIO(Configurazione ini::::::::::::::: id_azienda_predefinita =" + hm.get("id_azienda_predefinita"));
        }
        this.inif.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SeNonEsisteCreaIlFile(String nomefile) {
        boolean ret = true;
        File objFile = null;
        boolean blnRet = false;
        try {
            objFile = new File(nomefile);
            boolean bl = blnRet = objFile.exists() && objFile.isFile();
            if (!blnRet) {
                MyTrace.log.severe("ATTENZIONE: file di preferenze per la configurazione INI non presente: lo creo: " + nomefile);
                ret = false;
                objFile.createNewFile();
                objFile.setWritable(true);
                FileWriter objWriter = new FileWriter(objFile);
                objWriter.write("[configurazione_ini]\r\n");
                objWriter.close();
                objWriter = null;
                return (boolean)objWriter;
            }
        }
        catch (Exception e) {
            blnRet = false;
            MyTrace.log.severe("ECCEZIONE: errore e/o problemi nella creazione o lettura del file di preferenze INI");
        }
        finally {
            if (objFile != null) {
                objFile = null;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String ScegliFileUtenteoSistema(String nomefile_utente, String nomefile_sistema) {
        File objFile = null;
        boolean blnRet = false;
        String nomefilescelto = nomefile_sistema;
        try {
            objFile = new File(nomefile_utente);
            boolean bl = blnRet = objFile.exists() && objFile.isFile();
            if (blnRet) {
                MyTrace.log.info("CONFIGURAZIONE: Trovato file di preferenza UTENTE per la configurazione INI");
                nomefilescelto = nomefile_utente;
            } else {
                MyTrace.log.info("CONFIGURAZIONE: Configurazione INI tramite il file di CONFIGURAZIONE STANDARD");
            }
        }
        catch (Exception e) {
            blnRet = false;
            MyTrace.log.severe("ECCEZIONE: errore e/o problemi nella scelta del file di preferenze INI");
        }
        finally {
            if (objFile != null) {
                objFile = null;
            }
        }
        return nomefilescelto;
    }

    public static Configurazioni getIstanza() {
        if (classe_istanziata) {
            return puntatore_istanza;
        }
        MyTrace.log.severe("ERRORE: Classe Configurazioni non ISTANZIATA!");
        return null;
    }

    static {
        puntatore = null;
        classe_istanziata = false;
        id_azienda = 0;
        inizio_stampe = 100;
        nome_azienda = "NON SELEZIONATA";
        operatore = "NON SELEZIONATO";
    }
}

