/*
 * Decompiled with CFR 0.152.
 */
package gestionale.configurazioni;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Set;
import utils.IniFile;
import utils.MyTrace;

public class ConfigurazioneFinestre {
    IniFile inif;
    public static String file_di_configurazione = "/preferenza_finestre.txt";
    public static HashMap<String, String> hm;
    public static ConfigurazioneFinestre puntatore;
    private String file_di_configurazione_utente = "";
    private String file_di_configurazione_sistema = "";
    private static boolean classe_istanziata;

    public ConfigurazioneFinestre() {
        if (!classe_istanziata) {
            String user_home = System.getProperty("user.home");
            this.file_di_configurazione_utente = user_home + System.getProperty("file.separator") + "Configurazione_Finestre_Gestionale.ini";
            this.file_di_configurazione_sistema = System.getProperty("user.dir") + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "Configurazione_Finestre_Gestionale.ini";
            MyTrace.log.info("CONFIGURAZIONE FINESTRE  UTENTE:" + this.file_di_configurazione_utente);
            MyTrace.log.info("CONFIGURAZIONE FINESTRE SISTEMA:" + this.file_di_configurazione_sistema);
            this.SeNonEsisteCreaIlFile(this.file_di_configurazione_sistema);
            file_di_configurazione = this.ScegliFileUtenteoSistema(this.file_di_configurazione_utente, this.file_di_configurazione_sistema);
            this.inif = new IniFile(file_di_configurazione);
            this.leggiConfigurazione();
            puntatore = this;
            classe_istanziata = true;
        } else {
            MyTrace.log.severe("ERRORE DI PROGRAMMAZIONE (CLASSE ConfigurazioneFinestre istanziata pi\u00f9 volte)");
        }
    }

    public final void leggiConfigurazione() {
        MyTrace.log.info("####   CARICO  CONFIGURAZIONE FINESTRE  ######");
        try {
            String[] sections = this.inif.getAllSectionNames();
            if (sections == null) {
                MyTrace.log.severe("ECCEZIONE: NON CI SONO SEZIONI NEL FILE PREFERENZE_FINESTRE");
            }
            hm = new HashMap();
            String[] chiavi = this.inif.getPropertyNames("configurazione_finestre");
            if (chiavi != null) {
                for (int i = 0; i < chiavi.length; ++i) {
                    String chiave = chiavi[i];
                    Integer valore = this.inif.getIntegerProperty("configurazione_finestre", chiave);
                    MyTrace.log.finest("LETTURA::::::: " + chiave + "=" + valore);
                    hm.put(chiave, valore.toString());
                }
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("ECCEZIONE: nella lettura del file di configurazione PREFERENZE_FINESTRE");
            err.printStackTrace();
        }
    }

    public void scriviConfigurazione() {
        MyTrace.log.info("####   SALVATAGGIO  CONFIGURAZIONE FINESTRE NEL FILE UTENTE  ######");
        this.SeNonEsisteCreaIlFile(this.file_di_configurazione_utente);
        file_di_configurazione = this.file_di_configurazione_utente;
        this.inif = null;
        this.inif = new IniFile(file_di_configurazione);
        Set<String> setElementi = hm.keySet();
        for (String chiave : setElementi) {
            String valore = hm.get(chiave);
            MyTrace.log.info("SALVATAGGIO(Configurazione Finestre::::::::::::::: " + chiave + "=" + valore);
            this.inif.setStringProperty("configurazione_finestre", chiave, valore, null);
        }
        this.inif.save();
    }

    public static Point GetPoint(String NomeDellaClasse, Point puntodefault) {
        Point point;
        try {
            int x = Integer.parseInt(hm.get(NomeDellaClasse + ".Point.x"));
            int y = Integer.parseInt(hm.get(NomeDellaClasse + ".Point.y"));
            point = new Point(x, y);
        }
        catch (Exception ex) {
            MyTrace.log.info("FINESTRA:(" + NomeDellaClasse + ") posizione di default");
            hm.put(NomeDellaClasse + ".Point.x", new Integer(puntodefault.x).toString());
            hm.put(NomeDellaClasse + ".Point.y", new Integer(puntodefault.y).toString());
            point = puntodefault;
        }
        MyTrace.log.info("FINESTRA: p (" + NomeDellaClasse + "): a=" + hm.get(NomeDellaClasse + ".Point.x") + "  b=" + hm.get(NomeDellaClasse + ".Point.y"));
        return point;
    }

    public static Dimension GetDimension(String NomeDellaClasse, Dimension dimensionedefault) {
        Dimension dimension;
        try {
            int x = Integer.parseInt(hm.get(NomeDellaClasse + ".Dimension.w"));
            int y = Integer.parseInt(hm.get(NomeDellaClasse + ".Dimension.h"));
            dimension = new Dimension(x, y);
        }
        catch (Exception ex) {
            MyTrace.log.info("FINESTRA:(" + NomeDellaClasse + ") dimensioni di default");
            hm.put(NomeDellaClasse + ".Dimension.w", new Integer(dimensionedefault.width).toString());
            hm.put(NomeDellaClasse + ".Dimension.h", new Integer(dimensionedefault.height).toString());
            dimension = dimensionedefault;
        }
        MyTrace.log.info("FINESTRA: d (" + NomeDellaClasse + "): a=" + hm.get(NomeDellaClasse + ".Dimension.w") + "  b=" + hm.get(NomeDellaClasse + ".Dimension.h"));
        return dimension;
    }

    public static void SetPoint(String NomeDellaClasse, Point p) {
        try {
            hm.put(NomeDellaClasse + ".Point.x", new Integer(p.x).toString());
            hm.put(NomeDellaClasse + ".Point.y", new Integer(p.y).toString());
        }
        catch (Exception ex) {
            MyTrace.log.finer("FINESTRA: ECCEZIONE nell'assegnazione della posizione");
        }
    }

    public static void SetDimension(String NomeDellaClasse, Dimension d) {
        try {
            hm.put(NomeDellaClasse + ".Dimension.w", new Integer((int)d.getWidth()).toString());
            hm.put(NomeDellaClasse + ".Dimension.h", new Integer((int)d.getHeight()).toString());
        }
        catch (Exception ex) {
            MyTrace.log.finer("FINESTRA: ECCEZIONE nell'assegnazione della dimensione");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SeNonEsisteCreaIlFile(String nomefile) {
        File objFile = null;
        boolean blnRet = false;
        try {
            objFile = new File(nomefile);
            boolean bl = blnRet = objFile.exists() && objFile.isFile();
            if (!blnRet) {
                MyTrace.log.severe("ATTENZIONE: file di preferenze per la configurazione finestre non presente: lo creo: " + nomefile);
                objFile.createNewFile();
                objFile.setWritable(true);
                FileWriter objWriter = new FileWriter(objFile);
                objWriter.write("[configurazione_finestre]\r\n");
                objWriter.close();
                objWriter = null;
            }
        }
        catch (Exception e) {
            blnRet = false;
            MyTrace.log.severe("ECCEZIONE: errore e/o problemi nella creazione o lettura del file di preferenze per le finestre");
        }
        finally {
            if (objFile != null) {
                objFile = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String ScegliFileUtenteoSistema(String nomefile_utente, String nomefile_sistema) {
        File objFile = null;
        boolean blnRet = false;
        String nomefilescelto = nomefile_sistema;
        try {
            objFile = new File(nomefile_utente);
            boolean bl = blnRet = objFile.exists() && objFile.isFile();
            if (blnRet) {
                MyTrace.log.info("CONFIGURAZIONE: Trovato file di preferenza UTENTE per la configurazione finestre");
                nomefilescelto = nomefile_utente;
            } else {
                MyTrace.log.info("CONFIGURAZIONE: Configurazione finestre tramite il file di CONFIGURAZIONE STANDARD");
            }
        }
        catch (Exception e) {
            blnRet = false;
            MyTrace.log.severe("ECCEZIONE: errore e/o problemi nella scelta del file di preferenze per le finestre");
        }
        finally {
            if (objFile != null) {
                objFile = null;
            }
        }
        return nomefilescelto;
    }

    static {
        puntatore = null;
        classe_istanziata = false;
    }
}

