/*
 * Decompiled with CFR 0.152.
 */
package gestionale.commesse;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.sql.ResultSet;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;

public class Commessa {
    int id;
    int id_anagrafica = 0;
    int numero;
    int anno;
    String descrizione_breve = "";
    String descrizione = "";
    String data_apertura;
    String committente;
    String codice_cliente;
    String note;
    FunzioniDate fda = new FunzioniDate();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public int getId_anagrafica() {
        return this.id_anagrafica;
    }

    public void setId_anagrafica(int id_anagrafica) {
        this.id_anagrafica = id_anagrafica;
    }

    public String getCommittente() {
        return this.committente;
    }

    public void setCommittente(String committente) {
        this.committente = committente;
    }

    public String getCodice_cliente() {
        return this.codice_cliente;
    }

    public void setCodice_cliente(String codice_cliente) {
        this.codice_cliente = codice_cliente;
    }

    public int getNumero() {
        return this.numero;
    }

    public void setNumero(int numero) {
        this.numero = numero;
    }

    public int getAnno() {
        return this.anno;
    }

    public void setAnno(int anno) {
        this.anno = anno;
    }

    public String getDescrizione_breve() {
        return this.descrizione_breve;
    }

    public void setDescrizione_breve(String descrizione_breve) {
        this.descrizione_breve = descrizione_breve;
    }

    public String getData_apertura() {
        return this.data_apertura;
    }

    public String getData_apertura_it() {
        return this.fda.gira_data(this.data_apertura);
    }

    public void setData_apertura(String data_apertura) {
        this.data_apertura = data_apertura;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public boolean inserisci(boolean da_solo) {
        String q_trace;
        boolean r_trace;
        String query_ins;
        boolean r_ins;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO commesse (descrizione_breve,descrizione,id_anag,data_apertura,numero_commessa,anno,note) VALUES ('" + this.getDescrizione_breve().replaceAll("'", "''") + "'," + "'" + this.getDescrizione().replaceAll("'", "''") + "'," + "" + this.getId_anagrafica() + "," + "'" + this.getData_apertura() + "'," + "(SELECT (COALESCE(MAX(numero_commessa),0))+1 FROM (SELECT * FROM commesse WHERE anno=" + this.getAnno() + " )as temp2)," + "" + this.getAnno() + "," + " '" + this.getNote().replaceAll("'", "''") + "')"))) {
            MyTrace.log.severe("Inserimento Commessa Wrapper non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String strSQL = "SELECT @@identity FROM commesse";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId(id_inserito);
        String q_numero = "SELECT numero_commessa from commesse where idCommessa=" + id_inserito;
        ResultSet res_num = Configurazioni.getIstanza().connessione.eseguiQuery(q_numero);
        int numero = 0;
        try {
            while (res_num.next()) {
                numero = res_num.getInt("numero_commessa");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res_num);
        if (numero != this.getNumero()) {
            this.setNumero(numero);
        }
        if (!(r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','commesse','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')"))) {
            MyTrace.log.severe("Inserimento CC non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean modifica(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE commesse  SET   id_anag=" + this.getId_anagrafica() + ", " + " descrizione_breve='" + this.getDescrizione_breve().replaceAll("'", "''") + "', " + " descrizione='" + this.getDescrizione().replaceAll("'", "''") + "', " + " data_apertura='" + this.getData_apertura() + "', " + " note='" + this.getNote().replaceAll("'", "''") + "', " + " numero_commessa=" + this.getNumero() + ", " + " anno=" + this.getAnno() + " " + " WHERE idCommessa=" + this.getId() + " "))) {
            MyTrace.log.severe("Modifica commessa non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','commesse','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica Commessa non riuscita per trace");
            Configurazioni.getIstanza().connessione.rollback();
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean elimina(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "DELETE FROM commesse  WHERE idCommessa=" + this.getId() + " "))) {
            MyTrace.log.severe("Eliminazione Commessa Wrapper non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','commesse','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Eliminazione Commessa non riuscita per trace");
            Configurazioni.getIstanza().connessione.rollback();
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public void seleziona(String where) {
        String query = "SELECT commesse.*,  anag_anagrafica.*  FROM commesse  LEFT JOIN anag_anagrafica on commesse.id_anag=anag_anagrafica.idAnagrafica ";
        query = query + " " + where;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                this.setId(res.getInt("idCommessa"));
                this.setDescrizione(res.getString("descrizione"));
                this.setDescrizione_breve(res.getString("descrizione_breve"));
                this.setCommittente(res.getString("ragione_sociale"));
                this.setId_anagrafica(res.getInt("id_anag"));
                this.setCodice_cliente(res.getString("tipo_anag") + res.getString("codice"));
                this.setData_apertura(res.getString("data_apertura"));
                this.setNumero(res.getInt("numero_commessa"));
                this.setAnno(res.getInt("anno"));
                this.setNote(res.getString("note"));
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Commessa non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = this.getNumero() + "/" + this.getAnno();
                break;
            }
            case 1: {
                retVal = this.getData_apertura_it();
                break;
            }
            case 2: {
                retVal = this.getCodice_cliente() + " - " + this.getCommittente();
                break;
            }
            case 3: {
                if (this.getDescrizione_breve().length() > 30) {
                    retVal = "" + this.getDescrizione_breve().substring(0, 29) + " ... ";
                    break;
                }
                retVal = "" + this.getDescrizione_breve();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

