/*
 * Decompiled with CFR 0.152.
 */
package gestionale.causali_contabili;

import gestionale.configurazioni.Configurazioni;
import gestionale.personalizzazione.stampe.IntestazioneCausaliContabili;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import java.awt.Color;
import java.sql.ResultSet;
import java.sql.SQLException;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaCausaliContabili
implements Runnable {
    public GestoreStampe stampa_causali_contabili;
    FunzioniDate fda;
    Funzioni f;
    String dataDA;
    String dataA;
    String siono;
    boolean esito = false;
    Thread thread;
    Color colore1 = new Color(220, 220, 220);

    public StampaCausaliContabili() {
        MyTrace.log.info("RICHIESTA ISTANZA CLASSE StampaCausaliContabili()");
        MyTrace.log.info("CLASSE StampaCausaliContabili() ISTANZIATA");
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    public boolean elabora() {
        Configurazioni.getIstanza();
        int y_inizio = Configurazioni.inizio_stampe;
        try {
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA CAUSALI CONTABILI INIZIO XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            long tempo_di_visualizzazione = System.currentTimeMillis();
            this.fda = new FunzioniDate();
            this.f = new Funzioni();
            this.stampa_causali_contabili = new GestoreStampe();
            this.stampa_causali_contabili.aggiungi_pj();
            int y_corrente = y_inizio + 55;
            this.stampa_intestazione_causali_contabili(100);
            this.stampa_causali_contabili.setIntPP((OggettoToPrint)new IntestazioneCausaliContabili());
            this.stampa_causali_contabili.setInt((OggettoToPrint)new IntestazioneCausaliContabili());
            this.stampa_causali_contabili.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Causali Contabili"));
            String query = "SELECT conf_causale_contabile.*,conf_modello_causale_contabile.* FROM conf_causale_contabile  LEFT JOIN conf_modello_causale_contabile on conf_causale_contabile.id_modelli_cc = conf_modello_causale_contabile.id  WHERE abilita='1' ORDER BY codice";
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            String id = "";
            String codice = "";
            String descrizione = "";
            String riferimento = "";
            String tipo = "";
            Color colore = Color.black;
            while (res.next()) {
                double totale = 0.0;
                id = "" + res.getInt("idcausale_contabile");
                codice = "" + res.getString("codice");
                descrizione = "" + res.getString("descrizione");
                riferimento = "" + res.getString("riferimento");
                int editabile = res.getInt("editabile");
                tipo = res.getString("tipo_causale");
                if (y_corrente > 710) {
                    this.stampa_causali_contabili.paginanuova();
                    y_corrente = y_inizio;
                    this.stampa_intestazione_causali_contabili(25);
                }
                if (editabile == 1) {
                    colore = Color.black;
                }
                if (editabile == 0) {
                    colore = this.stampa_causali_contabili.colore_rosso;
                }
                this.stampa_causali_contabili.setFont(this.stampa_causali_contabili.Font_Calibri_8);
                this.stampa_causali_contabili.appendRect(18, y_corrente, 550, 20, this.colore1);
                this.stampa_causali_contabili.appendTextOvunque("" + id, 21, y_corrente + 15, colore);
                this.stampa_causali_contabili.appendTextOvunque(codice, 42, y_corrente + 15, colore);
                if (riferimento.equals("C")) {
                    riferimento = "Cliente";
                }
                if (riferimento.equals("F")) {
                    riferimento = "Fornitore";
                }
                if (riferimento.equals("N")) {
                    riferimento = "Nessuno";
                }
                if (riferimento.equals("")) {
                    riferimento = "Fornitore";
                }
                this.stampa_causali_contabili.appendTextOvunque(riferimento, 360, y_corrente + 15, colore);
                this.stampa_causali_contabili.appendTextOvunque(tipo, 405, y_corrente + 15, colore);
                y_corrente += 20;
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            String date_now = this.fda.dataCorrente().replaceAll("-", "");
            String ora_now = this.fda.OraCorrente().replaceAll(":", "");
            String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_Causali_Contabili_aggiornato_al_" + this.fda.dataCorrenteIt());
            this.stampa_causali_contabili.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            MyTrace.log.info(" PERFORMANCE: Tempo di Elaborazione =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            this.stampa_causali_contabili.print();
            System.out.println("Fine Stampa");
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA CAUSALI CONTABILI FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            MyTrace.log.info(" PERFORMANCE: Tempo Totale compresa la stampa =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            this.esito = true;
        }
        catch (SQLException ex) {
            MyTrace.log.severe("ECCEZIONE in StampaCausaliContabili()");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            this.esito = false;
        }
        return this.esito;
    }

    public void stampa_intestazione_causali_contabili(int altezza) {
        this.stampa_causali_contabili.appendRoundRect(18, (altezza += 10) - 10, 550, 35, 10, 10);
        this.stampa_causali_contabili.setFont(this.stampa_causali_contabili.Font_Calibri_8);
        this.stampa_causali_contabili.appendTextOvunque("*Non Editabile", 20, altezza + 2, Color.red);
        this.stampa_causali_contabili.setFont(this.stampa_causali_contabili.Font_Calibri_10_B);
        this.stampa_causali_contabili.appendTextOvunque("ID", 20, altezza + 17);
        this.stampa_causali_contabili.appendTextOvunque("Codice", 42, altezza + 17);
        this.stampa_causali_contabili.appendTextOvunque("Descrizione", 90, altezza + 17);
        this.stampa_causali_contabili.appendTextOvunque("Riferimento", 345, altezza + 17);
        this.stampa_causali_contabili.appendTextOvunque("Tipo Causale", 405, altezza + 17);
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA CAUSALI CONTABILI");
        attesa.start();
        this.elabora();
        attesa.stop();
    }
}

