/*
 * Decompiled with CFR 0.152.
 */
package gestionale.causali_contabili;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import gestionale.piano_dei_conti.Conto5;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import utils.Funzioni;
import utils.MyTrace;

public class CausaleContabileRiga {
    private int id;
    private int segno;
    private int id_cc;
    private int id_conto;
    private Conto5 c;
    private Funzioni f = new Funzioni();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getSegno() {
        return this.segno;
    }

    public void setSegno(int segno) {
        this.segno = segno;
    }

    public int getId_cc() {
        return this.id_cc;
    }

    public void setId_cc(int id_cc) {
        this.id_cc = id_cc;
    }

    public Conto5 getC() {
        return this.c;
    }

    public void setC(Conto5 c) {
        this.c = c;
    }

    public int getId_conto() {
        return this.id_conto;
    }

    public void setId_conto(int id_conto) {
        this.id_conto = id_conto;
        this.c = new Conto5();
        if (id_conto != 0) {
            this.c.seleziona(id_conto);
        } else {
            this.c.setDescrizione("");
            this.c.setConto("");
        }
    }

    public boolean inserisci(boolean da_fuori) {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_ins = "INSERT INTO conf_cc_righe(conto,segno,id_cc) VALUES ('" + this.getC().getConto() + "','" + this.getSegno() + "','" + this.getId_cc() + "')";
        boolean r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins);
        if (!r_start || !r_ins) {
            MyTrace.log.severe("Inserimento Riga Causale Contabile non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String strSQL = "SELECT @@identity FROM conf_cc_righe";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId(id_inserito);
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','conf_cc_righe','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Inserimento  Riga Causale Contabile non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Inserimento  Riga Causale Contabile non riuscito per commit");
            Configurazioni.eccezione.gestisci("2.4", null);
            return false;
        }
        return true;
    }

    public boolean modifica(boolean da_fuori) {
        String query_mod;
        boolean r_mod;
        if (!da_fuori) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE  conf_cc_righe  SET  conto='" + this.getC().getConto() + "', " + " segno='" + this.getSegno() + "'" + " WHERE idCCRighe='" + this.getId() + "'"))) {
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            MyTrace.log.severe("Modifica  Riga Causale Contabile non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','conf_cc_righe','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica  Riga Causale Contabile non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Modifica  Riga Causale Contabile non riuscito per commit");
            Configurazioni.eccezione.gestisci("3.4", null);
            return false;
        }
        return true;
    }

    public void seleziona(int id) {
        String query_seleziona = "select * from conf_cc_righe where idCCRighe='" + id + "'";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                Conto5 c5 = new Conto5();
                c5.seleziona(res.getString("conto"));
                this.setC(c5);
                this.setId(res.getInt("idCCRighe"));
                this.setId_cc(res.getInt("id_cc"));
                this.setSegno(res.getInt("segno"));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona  Riga Causale Contabile non riuscito ");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public boolean elimina() {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_del = "delete from conf_cc_righe WHERE idCCRighe='" + this.getId() + "'";
        boolean r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del);
        if (!r_start || !r_del) {
            MyTrace.log.severe("Elimina  Riga Causale Contabile non riuscita");
            Configurazioni.eccezione.gestisci("3.5", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','conf_cc_righe','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Elimina  Riga Causale Contabile non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.6", null);
            return false;
        }
        String q_commit = "COMMIT";
        boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
        if (r_commit) {
            return true;
        }
        MyTrace.log.severe("Elimina  Riga Causale Contabile non riuscito per commit");
        Configurazioni.eccezione.gestisci("3.4", null);
        return false;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.c != null) {
                    retVal = this.c.getConto();
                    break;
                }
                retVal = "";
                break;
            }
            case 1: {
                if (this.c != null) {
                    retVal = this.c.getDescrizione();
                    break;
                }
                retVal = "";
                break;
            }
            case 2: {
                retVal = this.f.string_segno(this.getSegno(), 0);
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValue_2(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.c != null) {
                    retVal = this.c.getAlias();
                    break;
                }
                retVal = "";
                break;
            }
            case 1: {
                if (this.c != null) {
                    retVal = this.c.getConto();
                    break;
                }
                retVal = "";
                break;
            }
            case 2: {
                if (this.c != null) {
                    retVal = this.c.getDescrizione();
                    break;
                }
                retVal = "";
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

