/*
 * Decompiled with CFR 0.152.
 */
package gestionale.andamento_e_bilancio;

import anagrafiche.clienti_fornitori.Anagrafica;
import gestionale.andamento_e_bilancio.FatturatoCF;
import gestionale.azienda.Azienda;
import gestionale.personalizzazione.stampe.IntestazioneFatturatoCF;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaFatturatoCF
implements Runnable {
    Vector vettore_fatturato;
    String data_da;
    String data_a;
    String tipo_cf;
    Money tetto = new Money(BigDecimal.ZERO);
    Azienda azienda;
    Thread thread;

    public StampaFatturatoCF(Vector vettore_fatturato, String data_da, String data_a, Money tetto, Azienda azienda, String tipo_cf) {
        this.tipo_cf = tipo_cf;
        this.vettore_fatturato = vettore_fatturato;
        this.data_da = data_da;
        this.data_a = data_a;
        this.tetto = tetto;
        this.azienda = azienda;
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA FATTURATO CLIENTI FORNITORI");
        attesa.start();
        this.elabora();
        attesa.stop();
    }

    public void elabora() {
        int y_inizio;
        GestoreStampe stampa = new GestoreStampe();
        stampa.aggiungi_pj();
        stampa.setFont(stampa.Font_Calibri_10);
        int y = y_inizio = 100;
        stampa.setInt((OggettoToPrint)new IntestazioneFatturatoCF());
        stampa.setIntPP((OggettoToPrint)new IntestazioneFatturatoCF());
        stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Fatturato"));
        Money tot_imponibile = new Money(BigDecimal.ZERO);
        Money tot_imposta = new Money(BigDecimal.ZERO);
        Money tot_tot = new Money(BigDecimal.ZERO);
        this.appendi_intestazione(y, stampa);
        stampa.appendLine(20, y, 20, 780);
        stampa.appendLine(580, y, 580, 780);
        stampa.appendLine(20, 780, 580, 780);
        y += 75;
        Iterator i = this.vettore_fatturato.iterator();
        boolean contatore = false;
        while (i.hasNext()) {
            if (y > 750) {
                stampa.paginanuova();
                y = y_inizio;
                this.appendi_intestazione(y, stampa);
                stampa.appendLine(20, y += 75, 20, 780);
                stampa.appendLine(580, y, 580, 780);
                stampa.appendLine(20, 780, 580, 780);
            }
            FatturatoCF r = new FatturatoCF();
            r = (FatturatoCF)i.next();
            Anagrafica a = new Anagrafica();
            a.seleziona_da_ragione(r.getRagione_sociale(), this.tipo_cf);
            stampa.appendTextOvunque(a.getCodice(), 25, y + 8);
            stampa.appendTextOvunque(r.getRagione_sociale(), 100, y + 8);
            stampa.appendTextOvunque("" + r.getImporto(), 300, y + 8);
            y += 10;
        }
        FunzioniDate fda = new FunzioniDate();
        String date_now = fda.dataCorrente().replaceAll("-", "");
        String ora_now = fda.OraCorrente().replaceAll(":", "");
        Funzioni f = new Funzioni();
        String nome_file = f.pulisci_nome_file(date_now + ora_now + "_Fatturato_dal_" + this.data_da + "_al_" + this.data_a);
        stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
        stampa.print();
    }

    public void appendi_intestazione(int y, GestoreStampe stampa) {
        stampa.appendRect(20, y, 40, 25);
        stampa.setFont(stampa.Font_Calibri_7);
        stampa.appendTextOvunque("Ditta n. " + this.azienda.getId_azienda(), 22, y + 15);
        stampa.appendRect(60, y, 300, 25);
        stampa.appendTextOvunque("" + this.azienda.getRagione_sociale(), 70, y + 8);
        stampa.appendTextOvunque("" + this.azienda.getVia() + " " + this.azienda.getNumero(), 70, y + 16);
        stampa.appendTextOvunque("" + this.azienda.getCap() + " " + this.azienda.getComune() + " " + this.azienda.getProvincia(), 70, y + 24);
        stampa.appendRect(360, y, 220, 25);
        stampa.appendTextOvunque("C.F. " + this.azienda.getCf(), 370, y + 16);
        stampa.appendTextOvunque("P. IVA " + this.azienda.getP_iva(), 370, y + 24);
        stampa.appendRect(20, y + 25, 560, 25);
        stampa.appendTextOvunque("Fatturato dal: " + this.data_da + "  Anno:" + this.data_a, 35, y + 35);
        if (this.tipo_cf.equals("C")) {
            stampa.appendTextOvunque("***  FATTURATO CLIENTI  ***", 250, y + 35);
            stampa.appendTextOvunque("CODICE CLIENTE", 25, y + 65);
            stampa.appendTextOvunque("Elenco Clienti con fatturato maggiore di " + this.tetto, 35, y + 45);
        } else {
            stampa.appendTextOvunque("***  FATTURATO FORNITORI  ***", 250, y + 35);
            stampa.appendTextOvunque("CODICE FORNITORE", 25, y + 65);
            stampa.appendTextOvunque("Elenco Fornitori con fatturato maggiore di " + this.tetto, 35, y + 45);
        }
        stampa.appendRect(20, y + 50, 560, 25);
        stampa.appendTextOvunque("RAGIONE SOCIALE", 100, y + 65);
        stampa.appendTextOvunque("IMPORTO FATTURATO", 300, y + 65);
    }
}

