/*
 * Decompiled with CFR 0.152.
 */
package gestionale.andamento_e_bilancio;

import gestionale.andamento_e_bilancio.FunzioniPunti;
import gestionale.andamento_e_bilancio.Punto;
import gestionale.configurazioni.Configurazioni;
import gestionale.personalizzazione.stampe.IntestazioneAndamentoTemporale;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import java.util.Vector;
import org.jfree.data.category.DefaultCategoryDataset;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaAndamentoTemporale
implements Runnable {
    Funzioni f;
    FunzioniDate fda;
    private final String data_da;
    private final String data_a;
    Thread thread;

    public StampaAndamentoTemporale(String data_da, String data_a) {
        this.data_da = data_da;
        this.data_a = data_a;
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD ANDAMENTO TEMPORALE");
        attesa.start();
        this.corpo_principale();
        attesa.stop();
    }

    private void corpo_principale() {
        try {
            Configurazioni.getIstanza();
            int y_inizio = Configurazioni.inizio_stampe;
            this.fda = new FunzioniDate();
            this.f = new Funzioni();
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            MyTrace.log.info("Calcolo Attivo");
            FunzioniPunti funzioni_punti = new FunzioniPunti();
            Vector punti = funzioni_punti.test(this.data_da, this.data_a);
            Vector a = funzioni_punti.seleziona_attivo_prova(this.data_da, this.data_a, punti);
            for (Punto punto : a) {
                dataset.addValue(punto.getImporto(), (Comparable)((Object)"attivo"), (Comparable)((Object)("" + punto.getIndice())));
            }
            MyTrace.log.info("Calcolo Passivo");
            Vector punti1 = funzioni_punti.test(this.data_da, this.data_a);
            Vector p = funzioni_punti.seleziona_passivo_prova(this.data_da, this.data_a, punti1);
            for (Punto punto1 : p) {
                dataset.addValue(punto1.getImporto(), (Comparable)((Object)"passivo"), (Comparable)((Object)("" + punto1.getIndice())));
            }
            MyTrace.log.info("Calcolo Utile");
            Vector punti2 = funzioni_punti.test(this.data_da, this.data_a);
            Vector u = funzioni_punti.seleziona_utile_prova(this.data_da, this.data_a, punti2);
            for (Punto punto2 : u) {
                dataset.addValue(punto2.getImporto(), (Comparable)((Object)"utile"), (Comparable)((Object)("" + punto2.getIndice())));
            }
            GestoreStampe stampa = new GestoreStampe();
            stampa.aggiungi_pj();
            String date_now = this.fda.dataCorrente().replaceAll("-", "");
            String ora_now = this.fda.OraCorrente().replaceAll(":", "");
            String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_Andamento_Temporale_" + this.data_da + "__" + this.data_a);
            stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            MyTrace.log.info("Chiamo appendGraficoOvunque");
            stampa.appendGraficoOvunque(dataset, u.size(), 25, 130, 510, 500, "Situazione Economica Mensile dal " + this.data_da + "  al " + this.data_a, "Mesi", "Euro");
            MyTrace.log.info("Ritorno appendGraficoOvunque");
            IntestazioneAndamentoTemporale intestazione = new IntestazioneAndamentoTemporale();
            stampa.setIntPP((OggettoToPrint)intestazione);
            stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato(""));
            MyTrace.log.info("FINALIZZO CON print()");
            stampa.print();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su StampaAndamentoTemporale.corpo_principale() ECCEZIONE:[" + e + "]");
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }
}

