/*
 * Decompiled with CFR 0.152.
 */
package gestionale.andamento_e_bilancio;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import utils.FunzioniDate;
import utils.MyTrace;

public class Punto {
    Date data;
    GregorianCalendar data2;
    double importo;
    int anno;
    int mese;
    private FunzioniDate fda;
    int indice;

    public Punto() {
        String[] ids = TimeZone.getAvailableIDs(3600000);
        if (ids.length == 0) {
            MyTrace.log.severe("PROBLEMI CON LE DATE: non \u00e8 settato l'orario GMT+1=Roma");
            System.exit(0);
        }
        SimpleTimeZone pdt = new SimpleTimeZone(3600000, ids[0]);
        pdt.setStartRule(3, 1, 1, 0x6DDD00);
        pdt.setEndRule(9, -1, 1, 0x6DDD00);
        this.data2 = new GregorianCalendar(pdt);
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
        this.data2.setTime(data);
        this.mese = this.data2.get(2);
        this.anno = this.data2.get(1);
    }

    public double getImporto() {
        return this.importo;
    }

    public void setImporto(double importo) {
        this.importo = importo;
    }

    public int getAnno() {
        return this.anno;
    }

    public void setAnno(int anno) {
        this.anno = anno;
    }

    public int getMese() {
        return this.mese + 1;
    }

    public void setMese(int mese) {
        this.mese = mese;
    }

    public boolean isMonth(int mese_richiesto) {
        boolean bool = false;
        if (this.data2.get(2) == mese_richiesto) {
            bool = true;
        }
        return bool;
    }

    public boolean isYear(int anno_richiesto) {
        boolean bool = false;
        if (this.data2.get(1) == anno_richiesto) {
            bool = true;
        }
        return bool;
    }

    public int getIndice() {
        return this.indice;
    }

    public void setIndice(int indice) {
        this.indice = indice;
    }
}

