/*
 * Decompiled with CFR 0.152.
 */
package gestionale.andamento_e_bilancio;

import gestionale.andamento_e_bilancio.Bilancio;
import gestionale.auth.Gruppo;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import utils.Funzioni;
import utils.FunzioniDate;

public class BilancioTableModel
extends AbstractTableModel {
    Vector cache;
    int colCount;
    String[] headers;
    String tipo_cf;
    boolean modificabile;
    double totale = 0.0;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public BilancioTableModel(String tipo_cf) {
        this.cache = new Vector();
        this.tipo_cf = tipo_cf;
        this.modificabile = true;
    }

    public BilancioTableModel() {
        this.cache = new Vector();
        this.modificabile = true;
    }

    public String getTipo_cf() {
        return this.tipo_cf;
    }

    public void setTipo_cf(String tipo_cf) {
        this.tipo_cf = tipo_cf;
    }

    public boolean isModificabile() {
        return this.modificabile;
    }

    public void setModificabile(boolean modificabile) {
        this.modificabile = modificabile;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Nome Bilancio";
                break;
            }
            case 1: {
                retVal = "Descrizione";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Bilancio b = new Bilancio();
        if (this.cache.size() != 0) {
            b = (Bilancio)this.cache.elementAt(row);
            return b.getColValue(col);
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public void addRow(Gruppo g) {
        this.cache.add(0, g);
        this.fireTableDataChanged();
    }

    public void setDataBilancio(Vector vettoreBilancio) {
        this.cache = new Vector();
        Iterator i = vettoreBilancio.iterator();
        while (i.hasNext()) {
            this.cache.addElement(i.next());
        }
        this.fireTableChanged(null);
    }
}

