/*
 * Decompiled with CFR 0.152.
 */
package gestionale;

import anagrafiche.clienti_fornitori.MyAnagrafica;
import gestionale.MyDesktopWindow;
import gestionale.azienda.MySelezionaAzienda;
import gestionale.configurazioni.Configurazioni;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import trasporti.indirizzi.MyIndirizziPC;
import trasporti.listini.MyTraListini;
import utils.AvvioSuThread;
import utils.Funzioni;
import utils.Link;
import utils.MenuDinamico;
import utils.MyTrace;

public class MyMenu
extends JInternalFrame
implements TreeSelectionListener,
InternalFrameListener {
    MyTree albero;
    MyDesktopWindow chiamante;
    private int alpha = 0;
    private static final int MIN = 0;
    private static final int MAX = 10;
    private static final int RED = 0;
    private static final int GREEN = 255;
    private static final int BLUE = 0;

    public MyMenu(MyDesktopWindow chiamante) {
        MyTrace.log.info("MYMENU'    START");
        this.chiamante = chiamante;
        this.setOpaque(false);
        this.albero = new MyTree();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.initComponents();
        jScrollPane1.setViewportView(this.albero);
        this.getContentPane().add((Component)jScrollPane1, "Center");
        this.albero.getSelectionModel().setSelectionMode(1);
        this.albero.addTreeSelectionListener(this);
        this.albero.setCellRenderer(new MyCellRenderer());
        this.albero.setOpaque(true);
        jScrollPane1.setOpaque(false);
        this.addInternalFrameListener(this);
        this.albero.putClientProperty("JTree.lineStyle", "None");
        this.albero.setCellRenderer(new MyCellRenderer());
        this.albero.setOpaque(false);
        jScrollPane1.setOpaque(false);
        this.addInternalFrameListener(this);
        Color color_bg = this.getBackground();
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.albero.getCellRenderer();
        renderer.setBackgroundNonSelectionColor(color_bg);
        renderer.setBackgroundSelectionColor(new Color(204, 255, 255));
        renderer.setTextSelectionColor(Color.BLUE);
        MyTrace.log.info("MYMENU'    STOP");
    }

    private void initComponents() {
        this.setBorder(new SoftBevelBorder(0));
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyMenu(null).setVisible(true);
            }
        });
    }

    public void apri_finestra(Link l) {
        try {
            this.setCursor(new Cursor(3));
            MyTrace.log.info("********************************* MENU **************************************************");
            MyTrace.log.info("*********************     <START>    selezione voce Men\u00f9:      <" + l.toString() + ">     ********");
            MyTrace.log.info("*****************************************************************************************");
            MyTrace.log.info("MENU: LANCIO L'AZIONE");
            l.azionePredefinita();
            MyTrace.log.info("MENU: AZIONE LANCIATA");
            this.setCursor(new Cursor(0));
            this.albero.setSelectionRow(0);
            MyTrace.log.info("-------------------------------------------------------------------------------------------");
            MyTrace.log.info("---------------------    <STOP>     selezione voce Men\u00f9:    <" + l.toString() + "> ------------------");
            MyTrace.log.info("------------------------------------------  MENU  -----------------------------------------");
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione MyMenu' errore di istanziazione non \u00e8 stata trovata la voce di men\u00f9 o non \u00e8 stata ben definita l'azione");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            this.setCursor(new Cursor(0));
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: MyMenu' errore di avvio o di linkaggio dello specifico modulo");
            err.printStackTrace();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.albero.getLastSelectedPathComponent();
        MyTrace.log.info("valueChanged=" + e.toString());
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (!node.isLeaf()) {
            return;
        }
        Link link = (Link)nodeInfo;
        this.apri_finestra(link);
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
        this.chiamante.menu_attivato = false;
        this.chiamante.visualizza_menu();
        this.dispose();
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    private synchronized void fadeIn(Component c) {
        this.alpha = 0;
        while (this.alpha <= 10) {
            c.setBackground(new Color(0, 255, 0, this.alpha));
            ++this.alpha;
        }
    }

    private synchronized void fadeOut(Component c) {
        this.alpha = 10;
        while (this.alpha >= 0) {
            c.setBackground(new Color(0, 255, 0, this.alpha));
            --this.alpha;
        }
    }

    class MyCellRenderer
    extends DefaultTreeCellRenderer {
        private boolean is_selected;
        private boolean selectable;

        MyCellRenderer() {
        }

        public void setSelectable(boolean selectable) {
            this.selectable = selectable;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject().getClass() != String.class) {
                Link l = (Link)node.getUserObject();
                this.is_selected = false;
                if (!l.getPermesso().equals("") && !l.getPermessoConcesso()) {
                    this.setEnabled(false);
                }
                if (leaf) {
                    this.setToolTipText(l.toString());
                }
            }
            MyTrace.log.finest("CellRender=" + value.toString());
            return this;
        }

        @Override
        public void paintComponent(Graphics g) {
            int offset = 0;
            if (this.is_selected) {
                g.drawRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            }
            super.paintComponent(g);
        }
    }

    class MyTree
    extends JTree
    implements TreeExpansionListener {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Men\u00f9");

        public MyTree() {
            this.setTree();
            this.setModel(new DefaultTreeModel(this.root));
            this.setCellRenderer(new MyCellRenderer());
            this.addTreeExpansionListener(this);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void setTree() {
            DefaultMutableTreeNode category = null;
            DefaultMutableTreeNode nodo = null;
            DefaultMutableTreeNode nodo2 = null;
            DefaultMutableTreeNode nodo3 = null;
            category = new DefaultMutableTreeNode("Anagrafiche");
            Link link_anagrafica_clienti = new Link("Fornitori", "Fornitori", "ANAG_Anagrafica_Visualizza"){

                @Override
                public boolean azionePredefinita() {
                    MyAnagrafica oggetto = new MyAnagrafica("F");
                    Configurazioni.getIstanza().desktopwindow.myDesktopPane.add(oggetto);
                    oggetto.setVisible(true);
                    oggetto.moveToFront();
                    return true;
                }
            };
            nodo = new DefaultMutableTreeNode(link_anagrafica_clienti);
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Clienti", "Clienti", "ANAG_Anagrafica_Visualizza"){

                @Override
                public boolean azionePredefinita() {
                    MyAnagrafica oggetto = new MyAnagrafica("C");
                    Configurazioni.getIstanza().desktopwindow.myDesktopPane.add(oggetto);
                    oggetto.setVisible(true);
                    oggetto.moveToFront();
                    return true;
                }
            });
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Dipendenti", "anagrafiche.dipendenti.MyAnagDipendenti", "ANAG_Anagrafica_Visualizza"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Parco Mezzi", "anagrafiche.mezzi.MyMezzi", "ANAG_Macchine_Visualizza"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Banche", "anagrafiche.banche.MyBanche", "ANAG_Banche_Visualizza"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("AbiCab", "anagrafiche.banche.MyAbiCab", ""));
            category.add(nodo);
            this.root.add(category);
            category = new DefaultMutableTreeNode("Contabilit\u00e0");
            nodo = new DefaultMutableTreeNode(new Link("Prima Nota", "gestionale.primanota.MyRegistrazioni", "PRIME_NOTA_VISUALIZZA"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Partite C/F", "gestionale.primanota.MyInterrogazionePartite", "PRIME_NOTA_VISUALIZZA"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Interrogazione Conti", "gestionale.primanota.MyInterrogazioneConti", "Conti_Visualizza"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Scadenze", "gestionale.scadenziario.MyScadenze", ""));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Stampa Registro", "gestionale.primanota.MyStampaPrimaNota", ""));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Corrispettivi", "gestionale.corrispettivi.MyCorrispettivi", ""));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Stampa Fatture D'Acquisto", "gestionale.corrispettivi.MyStampaFattureAcquisto", ""));
            category.add(nodo);
            this.root.add(category);
            category = new DefaultMutableTreeNode("Analisi e Bilancio");
            nodo = new DefaultMutableTreeNode(new Link("Elabora Mastrini", "gestionale.mastrino.MyMastrino", ""));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Situazione Sintetica Bilancio", "gestionale.andamento_e_bilancio.MyBilancioSemplificato", ""));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Bilancio (elaborazioni)", "gestionale.andamento_e_bilancio.MyBilancio", ""));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Stato Patrimoniale Di Chiusura", "gestionale.andamento_e_bilancio.MyStatoPatrimonialeDiChiusura", ""));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Analisi Temporale Attivit\u00e0", "gestionale.andamento_e_bilancio.MyAndamentoTemporale", "Andamento_Visualizza"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Fatturato Clienti/Fornitori", "gestionale.andamento_e_bilancio.MyFatturatoCF", ""));
            category.add(nodo);
            if (MyDesktopWindow.profilo.controllaPermesso("BILANCIO_MENU_VISUALIZZA")) {
                this.root.add(category);
            }
            category = new DefaultMutableTreeNode("Ratei e Risconti");
            nodo = new DefaultMutableTreeNode(new Link("Calcolo Competenze", "gestionale.ratei_risconti.MyRateiRisconti", ""));
            category.add(nodo);
            if (MyDesktopWindow.profilo.controllaPermesso("RATEI_MENU_VISUALIZZA")) {
                this.root.add(category);
            }
            category = new DefaultMutableTreeNode("Documenti Emessi");
            nodo = new DefaultMutableTreeNode(new Link("DOCUMENTI EMESSI", "gestionale.documenti.MyDocumentiAttivi", "DOCUMENTI_VISUALIZZA"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("STAMPA DOCUMENTI", "gestionale.documenti.MyStampaDocumenti", ""));
            category.add(nodo);
            this.root.add(category);
            category = new DefaultMutableTreeNode("Gestione I.V.A.");
            nodo = new DefaultMutableTreeNode(new Link("Registri I.V.A.", "gestionale.liquidazione_iva.MyVisulizzaRegistriIva", ""));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Liquidazione I.V.A.", "gestionale.liquidazione_iva.MyLiquidazioneIva", ""));
            category.add(nodo);
            if (MyDesktopWindow.profilo.controllaPermesso("IVA_MENU_VISUALIZZA")) {
                this.root.add(category);
            }
            category = new DefaultMutableTreeNode("Sostituto d'Imposta");
            nodo = new DefaultMutableTreeNode(new Link("Ritenuta d'acconto", "gestionale.ritenuta_d_acconto.MyRitenutaAcconto", ""));
            category.add(nodo);
            if (MyDesktopWindow.profilo.controllaPermesso("SOSTITUTO_DIMPOSTA_MENU_VISUALIZZA")) {
                this.root.add(category);
            }
            category = new DefaultMutableTreeNode("Protocollo");
            nodo = new DefaultMutableTreeNode(new Link("Registro Protocollo", "protocollo.MyRegistroProtocollo", "PROTOCOLLO_Visualizza"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Stampa Registro Protocollo", "protocollo.MyStampaProtocollo", "PROTOCOLLO_Visualizza"));
            category.add(nodo);
            if (MyDesktopWindow.profilo.controllaPermesso("PROTOCOLLO_MENU_VISUALIZZA")) {
                this.root.add(category);
            }
            category = new DefaultMutableTreeNode("Magazzino");
            nodo2 = new DefaultMutableTreeNode("Richieste Offerte / Ordini");
            category.add(nodo2);
            nodo = new DefaultMutableTreeNode(new Link("Richieste Offerte", "magazzino.richieste_offerte.MyMagazzinoRO", "MAGAZZINO_RO_VISUALIZZA"));
            nodo2.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Ordini a Fornitore", "magazzino.ordini_for.MyMagazzinoOrdini", "MAGAZZINO_OR_VISUALIZZA"));
            nodo2.add(nodo);
            nodo2 = new DefaultMutableTreeNode("DDT");
            category.add(nodo2);
            nodo = new DefaultMutableTreeNode(new Link("DDT Ricevuti", "magazzino.ddtIN.MyDDTIn", "DDI_Visualizza"));
            nodo2.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("DDT Emessi", "magazzino.ddtOUT.MyDDTOut", "DDU_Visualizza"));
            nodo2.add(nodo);
            nodo2 = new DefaultMutableTreeNode("Fatture");
            category.add(nodo2);
            nodo = new DefaultMutableTreeNode(new Link("FP Ricevute", "magazzino.fpIN.MyfpIN", "DDI_Visualizza"));
            nodo2.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("FA Emesse", "magazzino.fOUT.MyFOut", "DDU_Visualizza"));
            nodo2.add(nodo);
            nodo2 = new DefaultMutableTreeNode("Note di Credito");
            category.add(nodo2);
            nodo = new DefaultMutableTreeNode(new Link("NC Ricevute", "magazzino.ncIN.MyncIN", "DDU_Visualizza"));
            nodo2.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("NC Emesse", "magazzino.ncOUT.MyNcOut", "DDI_Visualizza"));
            nodo2.add(nodo);
            nodo2 = new DefaultMutableTreeNode("Listini");
            category.add(nodo2);
            nodo = new DefaultMutableTreeNode(new Link("Listini di Vendita", "magazzino.listini.MyListiniVendita", "Listini_Visualizza"));
            nodo2.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Listini d'Acquisto", "magazzino.listini.MyListiniAcquisto", "Listini_Visualizza"));
            nodo2.add(nodo);
            nodo2 = new DefaultMutableTreeNode("Articoli");
            category.add(nodo2);
            nodo = new DefaultMutableTreeNode(new Link("Articoli", "magazzino.articoli.MyArticoli", "Articoli_Visualizza"));
            nodo2.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Gruppi", "magazzino.gruppi.MyGruppiArticoli", ""));
            nodo2.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Giacenze", "magazzino.movimenti.MyGiacenzeOut", ""));
            nodo2.add(nodo);
            nodo2 = new DefaultMutableTreeNode("Utility");
            category.add(nodo2);
            nodo = new DefaultMutableTreeNode(new Link("BARCODE", "Test.TEST_IMAGE", ""));
            nodo2.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Importa Listino Acquisto", "magazzino.listini.MyImportaListini", "Listini_Visualizza"));
            nodo2.add(nodo);
            if (MyDesktopWindow.profilo.controllaPermesso("MAGAZZINO_MENU_VISUALIZZA")) {
                this.root.add(category);
            }
            category = new DefaultMutableTreeNode("Gestione Cisterna");
            nodo = new DefaultMutableTreeNode(new Link("Giacenza Gasolio - Prelievi", "cisterna.carico_gasolio.MyCaricoGasolio", ""));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Registra documento o fattura di carico", "cisterna.das.MyDAS", "DAS_Visualizza"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Stampa Prelievi Gasolio", "cisterna.report_prelievi_gasolio.MyReportPrelieviGasolio", ""));
            category.add(nodo);
            if (MyDesktopWindow.profilo.controllaPermesso("DAS_Visualizza")) {
                this.root.add(category);
            }
            category = new DefaultMutableTreeNode("Trasporti");
            nodo = new DefaultMutableTreeNode("Autisti e Macchine");
            nodo2 = new DefaultMutableTreeNode(new Link("Autisti", "trasporti.autista.MyAutisti", "Autisti_Visualizza"));
            nodo.add(nodo2);
            category.add(nodo);
            nodo = new DefaultMutableTreeNode("Manutenzione Mezzi");
            nodo3 = new DefaultMutableTreeNode("Magazzino Articoli");
            nodo.add(nodo3);
            nodo2 = new DefaultMutableTreeNode(new Link("Articoli Manutenzione", "trasporti.manutenzione_articoli.MyArticoliManutenzione", ""));
            nodo3.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Gruppi di Articoli Manutenzione", "trasporti.manutenzione_gruppi.MyGruppiManutenzione", ""));
            nodo3.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Giacenze Manutenzione", "trasporti.magazzino_manutenzione_giacenze.MyGiacenzeManutenzione", ""));
            nodo3.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Fatture Passive Manutenzioni", "trasporti.manutenzione_ddi.MyDDIManutenzione", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Manutenzioni", "trasporti.manutenzioni.MyManutenzioni", "REVISIONI_VISUALIZZA"));
            nodo.add(nodo2);
            category.add(nodo);
            nodo = new DefaultMutableTreeNode("Tratte");
            nodo2 = new DefaultMutableTreeNode(new Link("Tratte Generiche", "trasporti.tratte.MyTratteGeneriche", "TRATTE_VISUALIZZA"));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Tratte", "trasporti.tratte.MyTratte", "TRATTE_VISUALIZZA"));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Indirizzi Prese Consegne", "IndirizziPC", "TRATTE_VISUALIZZA"){

                @Override
                public boolean azionePredefinita() {
                    MyIndirizziPC oggetto = new MyIndirizziPC();
                    Configurazioni.getIstanza().desktopwindow.myDesktopPane.add(oggetto);
                    AvvioSuThread primo_filtra_separato = new AvvioSuThread(oggetto, "primo_caricamento_apertura_form");
                    oggetto.setVisible(true);
                    oggetto.moveToFront();
                    return true;
                }
            });
            nodo.add(nodo2);
            category.add(nodo);
            nodo = new DefaultMutableTreeNode("Listini");
            nodo2 = new DefaultMutableTreeNode(new Link("Listini di Vendita", "TraListiniVendita", "TRASPORTI_Listini_Visualizza"){

                @Override
                public boolean azionePredefinita() {
                    MyTraListini oggetto = new MyTraListini("C");
                    Configurazioni.getIstanza().desktopwindow.myDesktopPane.add(oggetto);
                    oggetto.setVisible(true);
                    oggetto.moveToFront();
                    return true;
                }
            });
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Listini di Acquisto", "TraListiniAcquisto", "TRASPORTI_Listini_Visualizza"){

                @Override
                public boolean azionePredefinita() {
                    MyTraListini oggetto = new MyTraListini("F");
                    Configurazioni.getIstanza().desktopwindow.myDesktopPane.add(oggetto);
                    oggetto.setVisible(true);
                    oggetto.moveToFront();
                    return true;
                }
            });
            nodo.add(nodo2);
            category.add(nodo);
            nodo = new DefaultMutableTreeNode("Gestione Pedane");
            nodo2 = new DefaultMutableTreeNode(new Link("Pedane", "trasporti.pedane.MyPedane", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Situazione Pedane Clienti", "trasporti.pedane_giacenze.MyGiacenzaPedaneClienti", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Situazione Pedane Vettori", "trasporti.pedane_giacenze.MyGiacenzaPedaneVettori", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("DDU Pedane", "trasporti.pedane_ddu.MyDDU_pedane", ""));
            nodo.add(nodo2);
            category.add(nodo);
            nodo = new DefaultMutableTreeNode("Report");
            nodo2 = new DefaultMutableTreeNode(new Link("Stampa Ordini", "trasporti.report_ordini.MyReportOrdini", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Stampa Manutenzioni", "trasporti.report_manutenzioni.MyReportManutenzioni", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Stampa Fatturato Automezzi", "trasporti.report_fatturato.MyReportFatturato", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Stampa Lista Fatture", "trasporti.report_lista_fatture.MyReportFatture", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Stampa Viaggi Vettori", "trasporti.report_viaggi_per_fornitore.MyReportViaggi", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Stampa Km percorsi", "trasporti.report_km.MyReportKm", ""));
            nodo.add(nodo2);
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Ordini", "trasporti.ordini.MyOrdini", "TRASPORTI_Listini_Visualizza"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Viaggi", "trasporti.viaggi.MyViaggi", "VIAGGI_VISUALIZZA"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Borderaux", "trasporti.borderaux.MyBorderaux", "TRASPORTI_Listini_Visualizza"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Fatture Attive Trasporti", "trasporti.fatturazione.MyTraFatturazione", "FATTURE_ATTIVE_VISUALIZZA"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Fatture/Note di Credito Vettori", "trasporti.fatture_vettori.MyTraFattureVettori", "FATTURE_VETTORI_VISUALIZZA"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Fatture Autostrade", "trasporti.fatture_passive_autostrade.MyTraFattureAutostrade", "FATTURE_AUTOSTRADE_VISUALIZZA"));
            category.add(nodo);
            this.root.add(category);
            category = new DefaultMutableTreeNode("Edilizia");
            nodo = new DefaultMutableTreeNode(new Link("Commesse", "edilizia.commesse.MyEdilCommesse", "Commesse_Visualizza"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Gare", "edilizia.gare.MyGare", "GARE_VISUALIZZA"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Rapportini", "edilizia.rapportino.MyRapportino", "EDILIZIA_RAPPORTINO_VISUALIZZA"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Report Ore Dipendenti", "gestionale.ore_impiego_personale.MyReportOrePersonale", "EDILIZIA_RAPPORTINO_VISUALIZZA"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Report Ore Mezzi", "gestionale.ore_impiego_mezzi.MyReportOreMezzi", "EDILIZIA_RAPPORTINO_VISUALIZZA"));
            category.add(nodo);
            if (MyDesktopWindow.profilo.controllaPermesso("GARE_MENU_VISUALIZZA")) {
                this.root.add(category);
            }
            category = new DefaultMutableTreeNode("Gestione operatori");
            this.root.add(category);
            nodo = new DefaultMutableTreeNode(new Link("Gestione Gruppi", "gestionale.auth.MyGruppi", "AUTH_Gruppi_Visualizza"));
            category.add(nodo);
            nodo = new DefaultMutableTreeNode(new Link("Gestione Operatori", "gestionale.auth.MyOperatori", "AUTH_Operatori_Visualizza"));
            category.add(nodo);
            if (MyDesktopWindow.profilo.controllaPermesso("AUTH_Menu_Visualizza")) {
                this.root.add(category);
            }
            category = new DefaultMutableTreeNode("Controlling");
            nodo = new DefaultMutableTreeNode("Configurazioni");
            category.add(nodo);
            nodo2 = new DefaultMutableTreeNode(new Link("Regole", "controlling.regole.MyRegole", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Voci di Analisi", "controlling.voci_di_analisi.MyVociDiAnalisi", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Centri di Responsabilit\u00e0", "controlling.centri_di_responsabilita.MyCentriDiresponsabilita", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Esportazione", "controlling.esportazione.MyEsportazione", ""));
            nodo.add(nodo2);
            MenuDinamico menu = new MenuDinamico();
            category.add(menu.creaMenuReport());
            if (MyDesktopWindow.profilo.controllaPermesso("CONTROLLING_MENU_VISUALIZZA")) {
                this.root.add(category);
            }
            category = new DefaultMutableTreeNode("Configurazioni");
            nodo = new DefaultMutableTreeNode("Contabilit\u00e0");
            category.add(nodo);
            nodo2 = new DefaultMutableTreeNode(new Link("Causali Contabili", "gestionale.causali_contabili.MyCausaliContabili", "CONFIGURAZIONE_TABELLE_MODIFICA"));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Piano dei conti", "gestionale.piano_dei_conti.MyConto5", "PDC_Modifica"));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Albero Piano dei conti", "gestionale.piano_dei_conti.MyPDC", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Configurazione Corrispettivi", "gestionale.corrispettivi.MyConfigurazioneCorrispettivi", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Configurazione Sollecito", "gestionale.scadenziario.MyConfigurazioneSollecito", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Registri IVA", "gestionale.iva.MyConfiguraRegistriIVA", ""));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Aliquote IVA", "gestionale.iva.MyConfiguraAliquotaIVA", "CONFIGURAZIONE_TABELLE_MODIFICA"));
            nodo.add(nodo2);
            nodo = new DefaultMutableTreeNode("Ambiente e Tabelle");
            category.add(nodo);
            nodo2 = new DefaultMutableTreeNode(new Link("Trattamenti Economici", "gestionale.trattamento_economico.MyTrattamentoEconomico", "CONFIGURAZIONE_TABELLE_MODIFICA"));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("ABI e CAB", "gestionale.banche.MyBancheInserimento", "CONFIGURAZIONE_TABELLE_MODIFICA"));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Cap", "gestionale.cap.MyCap", "CONFIGURAZIONE_TABELLE_MODIFICA"));
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Unit\u00e0 Di Misura", "gestionale.unita_di_misura.MyUnitaDiMisura", ""));
            nodo.add(nodo2);
            nodo = new DefaultMutableTreeNode("Sistema");
            category.add(nodo);
            if (MyDesktopWindow.profilo.id_gruppo == 1) {
                DefaultMutableTreeNode sottomenu = null;
                DefaultMutableTreeNode foglia = null;
                sottomenu = new DefaultMutableTreeNode("AMMINISTRAZIONE DEL SOFTWARE [KRONOS]");
                foglia = new DefaultMutableTreeNode(new Link("Converti Anagrafica", "gestionale.anagrafica.MyConversioneAnag", ""));
                sottomenu.add(foglia);
                foglia = new DefaultMutableTreeNode(new Link("Converti Magazzino", "utils.conversione_db.MyConversione", ""));
                sottomenu.add(foglia);
                nodo.add(sottomenu);
            }
            nodo2 = new DefaultMutableTreeNode(new Link("Scelta Azienda", "SelezionaAzienda", "CONFIGURAZIONE_TABELLE_MODIFICA"){

                @Override
                public boolean azionePredefinita() {
                    MyDesktopWindow.statusBar.chiudiTutteLeFinestre();
                    MySelezionaAzienda oggetto = new MySelezionaAzienda(MyMenu.this.chiamante);
                    Configurazioni.getIstanza().desktopwindow.myDesktopPane.add(oggetto);
                    oggetto.setVisible(true);
                    oggetto.moveToFront();
                    return true;
                }
            });
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Salva Impostazioni Utente", "SalvaImpostazioniUtente", "CONFIGURAZIONE_TABELLE_MODIFICA"){

                @Override
                public boolean azionePredefinita() {
                    Configurazioni c = Configurazioni.getIstanza();
                    c.scriviConfigurazione();
                    MyDesktopWindow cfr_ignored_0 = MyMenu.this.chiamante;
                    MyDesktopWindow.statusBar.setToolTipText("Preferenze Utente Salvate");
                    return true;
                }
            });
            nodo.add(nodo2);
            nodo2 = new DefaultMutableTreeNode(new Link("Backup Archivi", "gestionale.backup.MyBackUpArchivi", "Backup_Archivi_Visualizza"));
            nodo.add(nodo2);
            if (MyDesktopWindow.profilo.controllaPermesso("Configurazioni_Menu_Visualizza")) {
                this.root.add(category);
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            TreePath path = e.getPath();
            String str = (String)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (str.equals("Parent 3")) {
                this.setExpandedState(path, false);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
        }
    }
}

