/*
 * Decompiled with CFR 0.152.
 */
package gestionale;

import gestionale.Main;
import gestionale.MyMenu;
import gestionale.azienda.MySelezionaAzienda;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.ProfiloUtente;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import utils.Funzioni;
import utils.MyStatusBar;
import utils.MyTrace;
import utils.Performance;

public class MyDesktopWindow
extends JFrame
implements WindowListener {
    public static MyStatusBar statusBar;
    public static ProfiloUtente profilo;
    public boolean menu_attivato = true;
    public Main main = null;
    JToolBar jt;
    public JDesktopPane myDesktopPane;

    public MyDesktopWindow(Main app) {
        this.initComponents();
        VerticalButton vb = new VerticalButton("Menu", true);
        this.jt = new JToolBar(1);
        this.jt.add(vb);
        this.jt.setPreferredSize(new Dimension(30, 500));
        this.getContentPane().add((Component)this.jt, "West");
        this.getContentPane().repaint();
        statusBar = new MyStatusBar(this.getWidth(), this);
        this.addWindowListener(this);
        try {
            this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("icons/icona_24x20.png")).getImage());
        }
        catch (Exception err) {
            MyTrace.log.severe("ERRORE: non trovo l'icona \n" + err.toString());
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
        }
        MyTrace.log.info("CREATO IL DESKTOP");
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void inserisci_scelta_azienda() {
        MySelezionaAzienda oggetto = new MySelezionaAzienda(this);
        this.myDesktopPane.add(oggetto);
        oggetto.setSize(400, 300);
        int wSize = 400;
        int hSize = 250;
        double hh = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double ww = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        oggetto.setLocation((int)ww / 2 - wSize / 2, (int)hh / 2 - hSize / 2);
        oggetto.setVisible(true);
        oggetto.moveToFront();
    }

    public void setProfilo(ProfiloUtente p) {
        profilo = p;
        this.getContentPane().add((Component)statusBar, "South");
        String text = "";
        text = Configurazioni.getIstanza().connessione.isConnesso() ? text + "** Connesso al DATABASE '" + Configurazioni.getIstanza().connessione.nomeDB + "' CONNESSO con Utente '" + Configurazioni.operatore + "'   Azienda '" + Configurazioni.nome_azienda + "'" : text + "Non sei Connesso Al Database, controllare le configurazioni";
        statusBar.setMessage(text);
    }

    public void visualizza_menu() {
        if (this.menu_attivato) {
            this.jt.setVisible(false);
            MyMenu menu = new MyMenu(this);
            this.myDesktopPane.add(menu);
            menu.setSize(200, this.getHeight() - 70);
            menu.setLocation(0, 0);
            menu.setVisible(true);
            menu.moveToFront();
        } else {
            this.jt.setVisible(true);
        }
    }

    public void riempi_campi() {
        this.visualizza_menu();
        this.setCursor(new Cursor(3));
        this.getContentPane().add((Component)statusBar, "South");
        String text = "";
        statusBar.setVisible(true);
        text = Configurazioni.getIstanza().connessione.isConnesso() ? text + "*+ Connesso al DATABASE '" + Configurazioni.getIstanza().connessione.nomeDB + "' CONNESSO con Utente '" + Configurazioni.operatore + "'   Azienda '" + Configurazioni.nome_azienda + "'" : text + "Non sei Connesso Al Database, controllare le configurazioni";
        statusBar.setMessage(text);
        statusBar.riempi_campi();
        this.myDesktopPane.repaint();
        this.setCursor(new Cursor(0));
    }

    private void initComponents() {
        this.myDesktopPane = new JDesktopPane();
        this.setDefaultCloseOperation(3);
        this.setTitle("Olimpo");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MyDesktopWindow.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().add((Component)this.myDesktopPane, "Center");
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        Performance perf = new Performance("DESKTOP: !!!!!!!!!! CHIUSURA da formWindowClosing()  !!!!!!!!!");
        try {
            MyDesktopWindow.profilo.HB.stopsessione();
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: ECCEZIONE formWindowClosing eccezione nella chiusura del profilo non definito o non ancora assegnato");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: ERRORE  formWindowClosing eccezione nella chiusura del profilo");
            err.printStackTrace();
        }
        this.main.uscita();
        Runtime.getRuntime().runFinalization();
        perf.fine();
        MyTrace.log.info("DESKTOP: !!!!!!!!!!!!! FINE APPLICAZIONE !!!!!!!!!!!!!!!!!!");
    }

    @Override
    public void windowClosed(WindowEvent evt) {
        Performance perf = new Performance(" CHIUSURA da windowClosed()");
        perf.fine();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        MyTrace.log.info("!!!!!!!!!!!!! Richiesta Uscita dall'applicazione !!!!!!!!!!!!!!!!!!");
        MyDesktopWindow.profilo.HB.stopsessione();
        this.main.uscita();
        Runtime.getRuntime().runFinalization();
        MyTrace.log.info("!!!!!!!!!!!!! FINE APPLICAZIONE !!!!!!!!!!!!!!!!!!");
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public class VerticalButton
    extends JButton
    implements ActionListener {
        public VerticalButton(String caption, boolean clockwise) {
            Font f = new Font("Arial", 1, 12);
            FontMetrics fm = this.getFontMetrics(f);
            int captionHeight = fm.getHeight();
            int captionWidth = fm.stringWidth(caption);
            BufferedImage bi = new BufferedImage(captionHeight + 4, captionWidth + 4, 2);
            Graphics2D g = (Graphics2D)bi.getGraphics();
            g.setColor(new Color(0, 0, 0, 0));
            g.fillRect(0, 0, bi.getWidth(), bi.getHeight());
            g.setBackground(new Color(255, 255, 255));
            g.setColor(this.getForeground());
            g.setFont(f);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (clockwise) {
                g.rotate(1.5707963267948966);
            } else {
                g.rotate(-1.5707963267948966);
                g.translate(-bi.getHeight(), bi.getWidth());
            }
            g.drawString(caption, 2, -6);
            ImageIcon icon = new ImageIcon(bi);
            this.setIcon(icon);
            this.setBackground(new Color(255, 255, 255));
            this.setMargin(new Insets(15, 2, 15, 2));
            this.setActionCommand(caption);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MyDesktopWindow.this.menu_attivato = true;
            MyDesktopWindow.this.visualizza_menu();
        }
    }
}

