/*
 * Decompiled with CFR 0.152.
 */
package gestionale.DA_CANCELLARE_fatturazione;

import anagrafiche.banche.Banca;
import anagrafiche.clienti_fornitori.Anagrafica;
import anagrafiche.indirizzi.DA_CANCELLARE_Indirizzo;
import gestionale.DA_CANCELLARE_fatturazione.DA_CANCELLARE_FatturaAttiva;
import gestionale.DA_CANCELLARE_fatturazione.DA_CANCELLARE_RigaFattura;
import gestionale.DA_CANCELLARE_fatturazione.DA_CANCELLARE_TotaliFattura;
import gestionale.configurazioni.Configurazioni;
import gestionale.documenti.TipoDocumentoAttivo;
import gestionale.personalizzazione.stampe.IntestazioneFatturaAttiva;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import gestionale.primanota.Registrazione;
import gestionale.scadenziario.Scadenza;
import gestionale.trattamento_economico.TrattamentoEconomico;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import magazzino.DA_CANCELLARE_ddu.DA_CANCELLARE_DDU;
import magazzino.DA_CANCELLARE_ddu.DA_CANCELLARE_InsiemeDDU;
import magazzino.DA_CANCELLARE_fp_riepilogative.DA_CANCELLARE_FatturaDifferita;
import magazzino.articoli.Articolo;
import magazzino.magazzino.DA_CANCELLARE_InsiemeOggettiMagazzino;
import magazzino.magazzino.DA_CANCELLARE_OggettoMagazzino;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class DA_CANCELLARE_StampaFatturaAttiva
implements Runnable {
    ArrayList<DA_CANCELLARE_FatturaAttiva> v_fatture;
    DA_CANCELLARE_FatturaAttiva fa_selezione;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    DA_CANCELLARE_DDU ddu_selezione;
    int nr_colli = 9999;
    private DA_CANCELLARE_InsiemeOggettiMagazzino insieme_righe;
    int y_inizio;
    Thread thread;
    GestoreStampe stampa;

    public DA_CANCELLARE_StampaFatturaAttiva(DA_CANCELLARE_FatturaAttiva fa_selezione) {
        Configurazioni.getIstanza();
        this.y_inizio = Configurazioni.inizio_stampe;
        this.v_fatture = new ArrayList();
        this.v_fatture.add(fa_selezione);
    }

    public DA_CANCELLARE_StampaFatturaAttiva(Vector v) {
        Configurazioni.getIstanza();
        this.y_inizio = Configurazioni.inizio_stampe;
        this.v_fatture = new ArrayList();
        for (DA_CANCELLARE_FatturaAttiva f : v) {
            this.v_fatture.add(f);
        }
    }

    public DA_CANCELLARE_StampaFatturaAttiva(DA_CANCELLARE_DDU ddu_selezione) {
        this.ddu_selezione = ddu_selezione;
        this.v_fatture = new ArrayList();
        this.v_fatture.add(ddu_selezione.getFa());
        this.insieme_righe = ddu_selezione.getInsieme_om_da_togliere();
        Vector data = new Vector();
        int num_row = this.insieme_righe.vettoreOM.size();
        Iterator<DA_CANCELLARE_OggettoMagazzino> i = this.insieme_righe.vettoreOM.iterator();
        this.nr_colli = 0;
        Configurazioni.getIstanza();
        this.y_inizio = Configurazioni.inizio_stampe;
        while (i.hasNext()) {
            DA_CANCELLARE_OggettoMagazzino temp = i.next();
            this.nr_colli += temp.getNrColli();
        }
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA FATTURA ATTIVA");
        attesa.start();
        this.elabora1();
        attesa.stop();
    }

    public void elabora1() {
        Iterator<DA_CANCELLARE_FatturaAttiva> i = this.v_fatture.iterator();
        this.stampa = new GestoreStampe();
        int contatore_doc = 0;
        while (i.hasNext()) {
            DA_CANCELLARE_FatturaAttiva fa;
            this.fa_selezione = fa = i.next();
            this.fa_selezione.seleziona_dettagli();
            this.fa_selezione.calcola_totali();
            this.stampa.aggiungi_pj();
            this.elabora();
            ++contatore_doc;
        }
        this.stampa.print();
    }

    public void elabora() {
        int y = this.y_inizio;
        int y_da_togliere = y - 100;
        MyTrace.log.info("STAMPA FATTURA ATTIVA: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  INIZIO STAMPA XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        String ragione_sociale = this.fa_selezione.getC().getRagione_sociale();
        String email = this.fa_selezione.getC().getEmail();
        String piva = this.fa_selezione.getC().getPiva();
        int id_trattamento = this.fa_selezione.getId_te();
        TrattamentoEconomico te = new TrattamentoEconomico();
        String w = " where idtrattamento_economico=" + id_trattamento + " ";
        te.seleziona(w);
        String trattamento = te.getDescrizione();
        String sede_via = "via";
        String sede_cap = "cap";
        String sede_citta = "citt\u00e0";
        String sede_provincia = "provincia";
        DA_CANCELLARE_Indirizzo i = this.fa_selezione.getC().getSede_legale();
        if (i.getId() != 0) {
            sede_cap = i.getCap().getCap();
            sede_citta = i.getLocalita_selezionata();
            sede_provincia = i.getCap().getCd_provincia();
            sede_via = i.getIndirizzo();
        }
        int contatore = 0;
        Vector insiemepagine = new Vector();
        Vector<DA_CANCELLARE_RigaFattura> pagina = new Vector<DA_CANCELLARE_RigaFattura>();
        for (DA_CANCELLARE_RigaFattura rf : this.fa_selezione.getInsieme_r().vettoreR) {
            int righe = 0;
            Vector rigasplittata = new Vector();
            int tipo = this.fa_selezione.getId_fa_tipi();
            if (tipo == 1) {
                righe = this.stampa.dimensioneSplitString(rf.getDescrizione(), 350, this.stampa.Font_Calibri_8);
                rigasplittata = this.stampa.SplitString(rf.getDescrizione(), 350, this.stampa.Font_Calibri_8);
            }
            if (tipo == 2) {
                righe = this.stampa.dimensioneSplitString(rf.getDescrizione(), 240, this.stampa.Font_Calibri_8);
                rigasplittata = this.stampa.SplitString(rf.getDescrizione(), 240, this.stampa.Font_Calibri_8);
            }
            if (tipo == 3) {
                righe = this.stampa.dimensioneSplitString(rf.getDescrizione(), 130, this.stampa.Font_Calibri_8);
                rigasplittata = this.stampa.SplitString(rf.getDescrizione(), 130, this.stampa.Font_Calibri_8);
            }
            if (tipo == 4) {
                righe = this.stampa.dimensioneSplitString(rf.getDescrizione(), 150, this.stampa.Font_Calibri_8);
                rigasplittata = this.stampa.SplitString(rf.getDescrizione(), 150, this.stampa.Font_Calibri_8);
            }
            contatore = righe > 1 ? (contatore += 11 + (righe - 1) * 11) : (contatore += 11);
            Object[] str = rigasplittata.toArray();
            rf.setDescrizione(str[0].toString());
            if (rf.getCol_gen_1().contains("DDT")) {
                String s = rf.getCol_gen_1().substring(7, rf.getCol_gen_1().length());
                rf.setCol_gen_1(s);
            }
            pagina.add(rf);
            for (int j = 1; j < str.length; ++j) {
                DA_CANCELLARE_RigaFattura riga_fattura = new DA_CANCELLARE_RigaFattura();
                riga_fattura.setDescrizione(str[j].toString());
                pagina.add(riga_fattura);
            }
            if (contatore <= 308) continue;
            insiemepagine.add(pagina);
            pagina = new Vector();
            contatore = 0;
        }
        insiemepagine.add(pagina);
        int ultima_pagina = insiemepagine.size();
        int conta_pagina = 0;
        Iterator i_pagine = insiemepagine.iterator();
        while (i_pagine.hasNext()) {
            ++conta_pagina;
            Vector righerighe = (Vector)i_pagine.next();
            this.appendi_causale(y);
            this.appendi_trattamento(y, this.fa_selezione.getC());
            this.appendi_descrizione(y);
            this.appendi_cliente(y, ragione_sociale, sede_via, sede_cap, sede_citta, sede_provincia);
            this.appendi_destinazione(y, ragione_sociale);
            this.appendi_piva_cf(y, this.fa_selezione.getC());
            this.appendi_righe(y, y - this.y_inizio, righerighe, this.y_inizio);
            if (conta_pagina == ultima_pagina) {
                this.appendi_totali(y, y_da_togliere);
                this.appendi_scadenze(y, y_da_togliere);
                this.appendi_elenco_ddt(y, y_da_togliere);
            } else {
                this.appendi_totali_vuoto(y, y_da_togliere);
                this.appendi_scadenze_vuoto(y, y_da_togliere);
            }
            this.appendi_piedi_pagina_fattura(y, y_da_togliere);
        }
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        String date_now = this.fda.dataCorrente().replaceAll("-", "");
        String ora_now = this.fda.OraCorrente().replaceAll(":", "");
        String ragione_sociale1 = this.fa_selezione.getRagione_sociale().replaceAll("\\.", "");
        String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_Fattura_" + this.fa_selezione.getNumero() + "_" + this.fa_selezione.getAnno() + "_" + ragione_sociale1 + "_C" + this.fa_selezione.getC().getCodice());
        this.stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
        this.stampa.setInt((OggettoToPrint)new IntestazioneFatturaAttiva());
        this.stampa.setIntPP((OggettoToPrint)new IntestazioneFatturaAttiva());
        this.stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Fattura Attiva"));
        MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA FATTURA ATTIVA FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
    }

    public void appendi_causale(int y) {
        this.stampa.setFont(this.stampa.Font_Calibri_11_B);
        int numero = 0;
        String descrizione = "Fattura di Vendita";
        if (this.fa_selezione.getNumero() == 0) {
            numero = this.fa_selezione.getNumero_nd();
            descrizione = "Nota di Debito";
        } else {
            numero = this.fa_selezione.getNumero();
        }
        this.stampa.appendTextOvunque(descrizione, 22, y + 22);
        this.stampa.setFont(this.stampa.Font_Calibri_11_B);
        if (!this.fa_selezione.getCodifica().equals("")) {
            this.stampa.appendTextOvunque("Nr. " + numero + "/" + this.fa_selezione.getCodifica() + " - " + this.fa_selezione.getAnno() + "   del " + this.fa_selezione.getData_emissione_it(), 22, y + 37);
        } else {
            this.stampa.appendTextOvunque("Nr. " + numero + " - " + this.fa_selezione.getAnno() + "   del " + this.fa_selezione.getData_emissione_it(), 22, y + 37);
        }
    }

    public void appendi_trattamento(int y, Anagrafica c) {
        String banca = "";
        String trattamento = "";
        this.stampa.setFont(this.stampa.Font_Calibri_10);
        this.stampa.appendTextOvunque("MODALITA' DI PAGAMENTO ", 22, y + 52);
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        Banca temp4 = new Banca();
        this.fa_selezione.getId_anagrafica();
        int id_banca = c.getId_anag_banche();
        if (id_banca != 0) {
            TrattamentoEconomico te = new TrattamentoEconomico();
            String w = " where idtrattamento_economico=" + this.fa_selezione.getId_te() + " ";
            te.seleziona(w);
            trattamento = te.getDescrizione();
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            temp4.seleziona(id_banca);
            System.out.println("id banca appoggio = " + this.fa_selezione.getId_banca_appoggio());
            temp4.seleziona(this.fa_selezione.getId_banca_appoggio());
            banca = temp4.getDescrizione();
            this.stampa.appendTestoDimensionePosizione(trattamento + ", " + banca + ", IBAN:" + temp4.getIBAN(), 22, y + 62, 250);
        } else {
            this.stampa.appendTextOvunque(trattamento, 22, y + 62);
        }
    }

    public void appendi_descrizione(int y) {
        this.stampa.appendRoundRect(18, y + 75, 406, 60, 10, 10);
        this.stampa.setFont(this.stampa.Font_Calibri_10_B);
        this.stampa.appendTextOvunque("DESCRIZIONE GENERICA:", 22, y + 85);
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        this.stampa.appendTestoDimensionePosizione(this.fa_selezione.getDescrizione(), 22, y + 95, 396);
        int altezza_descrizione = this.stampa.dimensioneSplitString(this.fa_selezione.getDescrizione(), 396, this.stampa.Font_Calibri_8);
        System.out.println("L'altezza della descrizione \u00e8 di " + altezza_descrizione + " Righe");
    }

    public void appendi_cliente(int y, String ragione_sociale, String sede_via, String sede_cap, String sede_citta, String sede_provincia) {
        this.stampa.appendRoundRect(429, y + 75, 149, 60, 10, 10);
        this.stampa.setFont(this.stampa.Font_Calibri_10_B);
        this.stampa.appendTextOvunque("Spett.", 433, y + 87);
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        this.stampa.appendTestoDimensionePosizione(ragione_sociale + " \n " + sede_via + " \n " + sede_cap + " " + sede_citta + "  " + sede_provincia, 433, y + 100, 130);
        this.stampa.setFont(this.stampa.Font_Calibri_8);
    }

    public void appendi_destinazione(int y, String ragione_sociale) {
        this.stampa.appendRoundRect(335, y + 10, 243, 60, 10, 10);
        this.stampa.setFont(this.stampa.Font_Calibri_10_B);
        this.stampa.appendTextOvunque("DESTINAZIONE:", 342, y + 22);
        this.stampa.setFont(this.stampa.Font_Calibri_9);
        this.stampa.appendTestoDimensionePosizione(ragione_sociale + " \n" + this.fa_selezione.getDestinazione(), 342, y + 33, 150);
        this.stampa.setFont(this.stampa.Font_Calibri_9);
    }

    public void appendi_piva_cf(int y, Anagrafica c) {
        this.stampa.appendRoundRect(225, y + 10, 105, 40, 10, 10);
        this.stampa.appendTextOvunque("P.Iva/Cod. Fiscale Cliente : ", 230, y + 22);
        if (c.getPiva() != null) {
            this.stampa.appendTextOvunque((c.getPiva() + "  ").replaceAll("null  ", ""), 230, y + 32);
            this.stampa.appendTextOvunque((c.getCf() + "  ").replaceAll("null  ", ""), 230, y + 40);
        } else {
            this.stampa.appendTextOvunque((c.getCf() + "  ").replaceAll("null  ", ""), 230, y + 32);
        }
    }

    public void appendi_righe(int y, int y_da_togliere, Vector righerighe, int y_inizio) {
        String[] riga;
        Iterator i_data;
        this.stampa.appendRoundRect(18, y + 140, 559, 18, 10, 10);
        this.stampa.appendRoundRect(18, y + 161, 559, 350 - y_da_togliere, 10, 10);
        TipoDocumentoAttivo tf = new TipoDocumentoAttivo();
        tf.seleziona(this.fa_selezione.getId_fa_tipi());
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        int contocolonne = tf.getColonne().size();
        String[] h = new String[contocolonne];
        Iterator ic = tf.getColonne().iterator();
        Vector<String[]> data = new Vector<String[]>();
        Iterator ii = righerighe.iterator();
        while (ic.hasNext()) {
            TipoDocumentoAttivo.Colonna cc = (TipoDocumentoAttivo.Colonna)ic.next();
            h[cc.indice] = cc.getAlias();
        }
        while (ii.hasNext()) {
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            String[] riga2 = new String[contocolonne];
            DA_CANCELLARE_RigaFattura temp = (DA_CANCELLARE_RigaFattura)ii.next();
            Articolo a = new Articolo();
            String w = " WHERE codice='" + temp.getCodice_articolo() + "' ";
            a.seleziona(w);
            for (TipoDocumentoAttivo.Colonna cc : tf.getColonne()) {
                switch (cc.getId_di_riferimento()) {
                    case 1: {
                        riga2[cc.getIndice()] = temp.getCodice_articolo();
                        break;
                    }
                    case 2: {
                        riga2[cc.getIndice()] = temp.getDescrizione();
                        break;
                    }
                    case 3: {
                        riga2[cc.getIndice()] = temp.getCol_gen_1();
                        break;
                    }
                    case 4: {
                        riga2[cc.getIndice()] = temp.getCol_gen_2();
                        break;
                    }
                    case 5: {
                        riga2[cc.getIndice()] = temp.getUnita_misura();
                        if (!temp.getUnita_misura().equals("")) break;
                        temp.setUnita_misura(a.getCodice_um());
                        riga2[cc.getIndice()] = temp.getUnita_misura();
                        break;
                    }
                    case 6: {
                        String q = this.f.formattaNumero("" + temp.getQuantita());
                        String sub = q.substring(q.indexOf("."), q.length());
                        if (sub.equals("00")) {
                            riga2[cc.getIndice()] = "" + q.substring(0, q.indexOf("."));
                            break;
                        }
                        riga2[cc.getIndice()] = "" + q;
                        break;
                    }
                    case 7: {
                        riga2[cc.getIndice()] = "" + temp.getPrezzo_unitario();
                        break;
                    }
                    case 8: {
                        riga2[cc.getIndice()] = this.f.formattaNumero(Double.toString(temp.getSconto()));
                        break;
                    }
                    case 9: {
                        riga2[cc.getIndice()] = "" + temp.getImporto();
                        break;
                    }
                    case 10: {
                        riga2[cc.getIndice()] = temp.getAliquota() != null ? temp.getAliquota().getCodice() : "";
                    }
                }
            }
            data.add(riga2);
        }
        int tipo = this.fa_selezione.getId_fa_tipi();
        if (tipo == 1) {
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            i_data = data.iterator();
            int y_tabella = y + 150;
            this.stampa.appendTextOvunque(h[0], 20, y_tabella);
            this.stampa.appendTextOvunque(h[1], 400, y_tabella);
            this.stampa.appendTextOvunque(h[2], 500, y_tabella);
            y_tabella += 20;
            boolean trovato = false;
            while (i_data.hasNext()) {
                riga = (String[])i_data.next();
                this.stampa.appendTestoDimensionePosizione(riga[0], 20, y_tabella, 350);
                int righe = this.stampa.dimensioneSplitString(riga[0], 350, this.stampa.Font_Calibri_8);
                this.stampa.appendTextOvunque(riga[1], 400, y_tabella);
                this.stampa.appendTextOvunque(riga[2], 500, y_tabella);
                if (righe > 1) {
                    y_tabella += 11 + (righe - 1) * 11;
                    continue;
                }
                y_tabella += 11;
            }
        }
        if (tipo == 2) {
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            i_data = data.iterator();
            int y_tabella = y + 150;
            this.stampa.appendTextOvunque(h[0], 20, y_tabella);
            this.stampa.appendTextOvunque(h[1], 115, y_tabella);
            this.stampa.appendTextOvunque(h[2] + " [" + h[3] + "]", 340, y_tabella);
            this.stampa.appendTextOvunque(h[4], 410, y_tabella);
            this.stampa.appendTextOvunque(h[5], 500, y_tabella);
            this.stampa.appendTextOvunque(h[6], 550, y_tabella);
            y_tabella += 20;
            boolean trovato = false;
            while (i_data.hasNext()) {
                riga = (String[])i_data.next();
                this.stampa.appendTestoDimensionePosizione(riga[0], 20, y_tabella, 350);
                this.stampa.appendTestoDimensionePosizione(riga[1], 115, y_tabella, 240);
                int righe = this.stampa.dimensioneSplitString(riga[1], 240, this.stampa.Font_Calibri_8);
                this.stampa.appendTestoDimensionePosizione(riga[2] + " [" + riga[3] + "]", 340, y_tabella, 80);
                this.stampa.appendTestoDimensionePosizione(riga[4], 410, y_tabella, 350);
                this.stampa.appendTextOvunque(riga[5], 500, y_tabella);
                this.stampa.appendTextOvunque(riga[6], 550, y_tabella);
                if (righe > 1) {
                    y_tabella += 11 + (righe - 1) * 11;
                    continue;
                }
                y_tabella += 11;
            }
        }
        if (tipo == 3) {
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            i_data = data.iterator();
            int y_tabella = y + 150;
            this.stampa.appendTextOvunque(h[0], 20, y_tabella);
            this.stampa.appendTextOvunque(h[1], 135, y_tabella);
            this.stampa.appendTextOvunque(h[2], 277, y_tabella);
            this.stampa.appendTextOvunque(h[3] + " [" + h[4] + "]", 350, y_tabella);
            this.stampa.appendTextOvunque(h[5], 400, y_tabella);
            this.stampa.appendTextOvunque(h[6], 490, y_tabella);
            this.stampa.appendTextOvunque(h[7], 540, y_tabella);
            y_tabella += 20;
            boolean trovato = false;
            while (i_data.hasNext()) {
                riga = (String[])i_data.next();
                this.stampa.appendTextOvunque(riga[0], 20, y_tabella);
                this.stampa.appendTestoDimensionePosizione(riga[1], 135, y_tabella, 130);
                int righe = this.stampa.dimensioneSplitString(riga[1], 130, this.stampa.Font_Calibri_8);
                this.stampa.appendTextOvunque(riga[2], 277, y_tabella);
                if (!riga[0].equals("")) {
                    this.stampa.appendTestoDimensionePosizione(riga[3] + " [" + riga[4] + "]", 350, y_tabella, 80);
                    this.stampa.appendTextOvunque(riga[5], 400, y_tabella);
                    this.stampa.appendTextOvunque(riga[6], 490, y_tabella);
                    this.stampa.appendTextOvunque(riga[7], 540, y_tabella);
                }
                if (righe > 2) {
                    y_tabella += 11 + (righe - 2) * 11;
                    continue;
                }
                y_tabella += 11;
            }
        }
        if (tipo == 4) {
            this.stampa.setFont(this.stampa.Font_Calibri_8);
            i_data = data.iterator();
            int y_tabella = y + 150;
            this.stampa.appendTextOvunque(h[0], 20, y_tabella);
            this.stampa.appendTextOvunque(h[1], 85, y_tabella);
            this.stampa.appendTextOvunque(h[2], 150, y_tabella);
            this.stampa.appendTextOvunque(h[3] + "[" + h[4] + "]", 340, y_tabella);
            this.stampa.appendTextOvunque(h[5], 410, y_tabella);
            this.stampa.appendTextOvunque(h[6], 490, y_tabella);
            this.stampa.appendTextOvunque(h[7], 540, y_tabella);
            y_tabella += 20;
            boolean trovato = false;
            while (i_data.hasNext()) {
                riga = (String[])i_data.next();
                this.stampa.appendTestoDimensionePosizione(riga[0], 20, y_tabella, 60);
                this.stampa.appendTestoDimensionePosizione(riga[1], 85, y_tabella, 150);
                this.stampa.appendTestoDimensionePosizione(riga[2], 150, y_tabella, 150);
                int righe = this.stampa.dimensioneSplitString(riga[2], 150, this.stampa.Font_Calibri_8);
                if (!riga[0].equals("")) {
                    this.stampa.appendTestoDimensionePosizione(riga[3] + "[" + riga[4] + "]", 340, y_tabella, 340);
                    this.stampa.appendTextOvunque(riga[5], 410, y_tabella);
                    this.stampa.appendTextOvunque(riga[6], 490, y_tabella);
                }
                this.stampa.appendTextOvunque(riga[7], 540, y_tabella);
                if (righe > 2) {
                    y_tabella += 11 + (righe - 2) * 11;
                    continue;
                }
                y_tabella += 11;
            }
        }
    }

    public void appendi_totali(int y, int y_da_togliere) {
        this.stampa.appendRoundRect(18, y + 518 - y_da_togliere, 358, 100, 10, 10);
        this.stampa.setFont(this.stampa.Font_Calibri_9_B);
        String iva = "% IVA";
        String imponibile = "Imponibile";
        String imposta = "Imposta";
        String descrizione = "Descrizione";
        this.stampa.appendTextOvunque(iva, 22, y + 530);
        this.stampa.appendStringaOvunqueFormattazioneDestra(imponibile, 65, y + 530, 45);
        this.stampa.appendStringaOvunqueFormattazioneDestra(imposta, 125, y + 530, 45);
        this.stampa.appendTextOvunque(descrizione, 190, y + 530);
        this.stampa.setFont(this.stampa.Font_Calibri_9);
        for (DA_CANCELLARE_TotaliFattura temp : this.fa_selezione.getV_riepilogo()) {
            String s_iva = temp.getAliquota().getAliquota() + " %";
            String s_imponibile = this.f.formattaNumero("" + temp.getImponibile());
            String s_imposta = this.f.formattaNumero("" + temp.getImpsta());
            String s_descrizione = temp.getAliquota().getDescrizione();
            if (s_descrizione.equals("")) {
                s_iva = "TOTALI";
            }
            this.stampa.appendTextOvunque(s_iva, 22, y + 541);
            this.stampa.appendStringaOvunqueFormattazioneDestra(s_imponibile, 65, y + 541, 45);
            this.stampa.appendStringaOvunqueFormattazioneDestra(s_imposta, 125, y + 541, 45);
            this.stampa.appendTextOvunque(s_descrizione, 190, y + 540);
            y += 12;
        }
        this.stampa.appendLine(22, y + 541 - 20, 230, y + 541 - 20);
    }

    public void appendi_totali_vuoto(int y, int y_da_togliere) {
        this.stampa.appendRoundRect(18, y + 518 - y_da_togliere, 358, 100, 10, 10);
    }

    public void appendi_scadenze(int y, int y_da_togliere) {
        this.stampa.appendRoundRect(382, y + 518 - y_da_togliere, 195, 100, 10, 10);
        Registrazione registrazione = new Registrazione();
        registrazione = this.fa_selezione.getFa_come_registrazione();
        Vector vettorescadenze = new Vector();
        vettorescadenze = registrazione.getInsieme_s().vettoreS;
        Iterator is = vettorescadenze.iterator();
        int numero_rate = vettorescadenze.size();
        Money importo = this.fa_selezione.getTot_a_pagare();
        int indice = 0;
        while (is.hasNext()) {
            Scadenza scadenza;
            if (numero_rate == 1) {
                this.stampa.setFont(this.stampa.Font_Calibri_12_B);
                this.stampa.appendTextOvunque("TOTALE A PAGARE", 390, y + 535 - y_da_togliere);
                this.stampa.appendTextOvunque("" + importo.toString(), 480, y + 555 - y_da_togliere);
                this.stampa.appendTextOvunque("SCADENZA", 390, y + 600 - y_da_togliere);
                scadenza = (Scadenza)is.next();
                this.stampa.appendTextOvunque("" + this.fda.gira_data(scadenza.getData_scadenza()), 480, y + 610 - y_da_togliere);
                continue;
            }
            this.stampa.setFont(this.stampa.Font_Calibri_12_B);
            this.stampa.appendTextOvunque("TOTALE A PAGARE", 390, y + 535 - y_da_togliere);
            this.stampa.appendTextOvunque("" + this.fa_selezione.getTot_a_pagare().toString(), 520, y + 535 - y_da_togliere);
            this.stampa.setFont(this.stampa.Font_Calibri_10_B);
            this.stampa.appendTextOvunque("SCADENZA DEL", 390, y + 555 + indice * 15 - y_da_togliere);
            scadenza = (Scadenza)is.next();
            this.stampa.appendTextOvunque("" + this.fda.gira_data(scadenza.getData_scadenza()), 460, y + 555 + indice * 15 - y_da_togliere);
            this.stampa.appendTextOvunque(scadenza.getImporto().toString(), 530, y + 555 + indice * 15 - y_da_togliere);
            ++indice;
        }
    }

    public void appendi_scadenze_vuoto(int y, int y_da_togliere) {
        this.stampa.appendRoundRect(382, y + 518 - y_da_togliere, 195, 100, 10, 10);
        this.stampa.appendTestoDimensionePosizione("Le scadenze e i totali si trovano nell'ultima pagina della fattura", 400, y + 540, 170);
    }

    public void appendi_piedi_pagina_fattura(int y, int y_da_togliere) {
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        this.stampa.appendTextOvunque(" I Vs. dati anagrafici sono da noi considerati esatti sotto la Vs. responsabilit\u00e0, salvo diversa comunicazione, come previsto dall'art. 41 DPR 26/10/72 n\u00b0633.", 22, y + 645 - y_da_togliere);
        this.stampa.appendTextOvunque(" Legge 196/2003 PRIVACY: I Vs. dati esposti nel presente documento vengono usati esclusivamente per fini contabili ed amministrativi", 22, y + 653 - y_da_togliere);
        this.stampa.appendTestoDimensionePosizione(" In caso di ritardato pagamento Vi verranno addebitati gli interessi di mora pari al prime rate ABI in vigore al momento dell'insolvenza ,aumentato di 7 punti", 22, y + 665 - y_da_togliere, 600);
    }

    public void appendi_elenco_ddt(int y, int y_da_togliere) {
        this.stampa.setFont(this.stampa.Font_Calibri_9);
        if (!this.f.controlla_FA_se_riepilogativa(this.fa_selezione)) {
            this.nr_colli = 0;
            DA_CANCELLARE_FatturaDifferita fa = new DA_CANCELLARE_FatturaDifferita();
            DA_CANCELLARE_InsiemeDDU inseme = new DA_CANCELLARE_InsiemeDDU();
            inseme = this.f.ottieni_insiemeDDU_fattura(this.fa_selezione);
            Iterator<DA_CANCELLARE_DDU> i = inseme.vettoreDDU.iterator();
            String stringaddu = "";
            while (i.hasNext()) {
                DA_CANCELLARE_DDU ddu = i.next();
                stringaddu = stringaddu + " " + ddu.getN_doc() + "/" + ddu.getAnno_doc() + ",";
                ddu.seleziona_dettagli();
                for (DA_CANCELLARE_OggettoMagazzino om : ddu.getInsieme_om_da_togliere().vettoreOM) {
                    this.nr_colli += om.getNrColli();
                }
            }
            stringaddu = stringaddu.substring(0, stringaddu.length() - 1);
            stringaddu = stringaddu + ".";
            this.stampa.appendRoundRect(248, y + 522 - y_da_togliere, 123, 81, 10, 10);
            this.stampa.setFont(this.stampa.Font_Calibri_9_B);
            this.stampa.appendTestoDimensionePosizione("DDT riepilogate:", 250, y + 530 - y_da_togliere, 130);
            this.stampa.setFont(this.stampa.Font_Calibri_9);
            this.stampa.appendTestoDimensionePosizione("" + stringaddu, 250, y + 541 - y_da_togliere, 130);
        }
        this.stampa.setFont(this.stampa.Font_Calibri_10_B);
        if (this.nr_colli != 9999) {
            this.stampa.appendRoundRect(248, y + 606 - y_da_togliere, 123, 9, 10, 10);
            this.stampa.appendTextOvunque("Nr. Colli = " + this.nr_colli, 251, y + 614 - y_da_togliere);
        }
    }
}

