/*
 * Decompiled with CFR 0.152.
 */
package edilizia.gare;

import edilizia.commesse.EdilCommessa;
import edilizia.gare.EdilCommesseGareRif;
import edilizia.gare.InsiemeEdilCommesseGareRif;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import protocollo.RegistrazioneProtocollo;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.Performance;
import utils.Quantita;

public class Gara {
    private String dataScadenza;
    private String note_ati = "";
    private String categoria_gara;
    private String data_affidamento;
    private String ragione_sociale_ati;
    private String tipo_cf_ati;
    private String codice_cf_ati;
    private int idGara;
    private int id_protocollo;
    private int id_categoria_gara;
    private int ati_si_no;
    private int id_anag_ati;
    private int esito_si_no;
    private int affidata_si_no;
    private Money importo_base_asta = new Money(BigDecimal.ZERO);
    private Money offertaCifra = new Money(BigDecimal.ZERO);
    private Money versamento = new Money(BigDecimal.ZERO);
    private Quantita offertaPercentuale = new Quantita(BigDecimal.ZERO);
    private RegistrazioneProtocollo gara_come_registrazione = new RegistrazioneProtocollo();
    private Funzioni f = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();

    public String getDataScadenza() {
        return this.dataScadenza;
    }

    public String getDataScadenza_it() {
        return this.fda.gira_data(this.dataScadenza);
    }

    public void setDataScadenza(String dataScadenza) {
        this.dataScadenza = dataScadenza;
    }

    public String getNote_ati() {
        return this.note_ati;
    }

    public void setNote_ati(String note_ati) {
        this.note_ati = note_ati;
    }

    public int getIdGara() {
        return this.idGara;
    }

    public void setIdGara(int idGara) {
        this.idGara = idGara;
    }

    public int getId_categoria_gara() {
        return this.id_categoria_gara;
    }

    public void setId_categoria_gara(int id_categoria_gara) {
        this.id_categoria_gara = id_categoria_gara;
    }

    public int getAti_si_no() {
        return this.ati_si_no;
    }

    public void setAti_si_no(int ati_si_no) {
        this.ati_si_no = ati_si_no;
    }

    public int getId_anag_ati() {
        return this.id_anag_ati;
    }

    public void setId_anag_ati(int id_anag_ati) {
        this.id_anag_ati = id_anag_ati;
    }

    public int getEsito_si_no() {
        return this.esito_si_no;
    }

    public void setEsito_si_no(int esito_si_no) {
        this.esito_si_no = esito_si_no;
    }

    public int getAffidata_si_no() {
        return this.affidata_si_no;
    }

    public void setAffidata_si_no(int affidata_si_no) {
        this.affidata_si_no = affidata_si_no;
    }

    public Money getImporto_base_asta() {
        return this.importo_base_asta;
    }

    public void setImporto_base_asta(Money importo_base_asta) {
        this.importo_base_asta = importo_base_asta;
    }

    public Money getOffertaCifra() {
        return this.offertaCifra;
    }

    public void setOffertaCifra(Money offertaCifra) {
        this.offertaCifra = offertaCifra;
    }

    public Money getVersamento() {
        return this.versamento;
    }

    public void setVersamento(Money versamento) {
        this.versamento = versamento;
    }

    public Quantita getOffertaPercentuale() {
        return this.offertaPercentuale;
    }

    public void setOffertaPercentuale(Quantita offertaPercentuale) {
        this.offertaPercentuale = offertaPercentuale;
    }

    public RegistrazioneProtocollo getGara_come_registrazione() {
        return this.gara_come_registrazione;
    }

    public void setGara_come_registrazione(RegistrazioneProtocollo gara_come_registrazione) {
        this.gara_come_registrazione = gara_come_registrazione;
    }

    public int getId_protocollo() {
        return this.id_protocollo;
    }

    public void setId_protocollo(int id_protocollo) {
        this.id_protocollo = id_protocollo;
    }

    public String getCategoria_gara() {
        return this.categoria_gara;
    }

    public void setCategoria_gara(String categoria_gara) {
        this.categoria_gara = categoria_gara;
    }

    public String getData_affidamento() {
        return this.data_affidamento;
    }

    public String getData_affidamento_it() {
        return this.fda.gira_data(this.data_affidamento);
    }

    public void setData_affidamento(String data_affidamento) {
        this.data_affidamento = data_affidamento;
    }

    public String getRagione_sociale_ati() {
        return this.ragione_sociale_ati;
    }

    public void setRagione_sociale_ati(String ragione_sociale_ati) {
        this.ragione_sociale_ati = ragione_sociale_ati;
    }

    public String getTipo_cf_ati() {
        return this.tipo_cf_ati;
    }

    public void setTipo_cf_ati(String tipo_cf_ati) {
        this.tipo_cf_ati = tipo_cf_ati;
    }

    public String getCodice_cf_ati() {
        return this.codice_cf_ati;
    }

    public void setCodice_cf_ati(String codice_cf_ati) {
        this.codice_cf_ati = codice_cf_ati;
    }

    public boolean inserisci(boolean da_solo) {
        try {
            boolean res_prot;
            Performance perf = new Performance("INSERISCI GARA");
            if (da_solo) {
                Configurazioni.getIstanza().connessione.start_transaction();
            }
            if (!(res_prot = this.getGara_come_registrazione().inserisci(false))) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Inserimento Gara non riuscito per protocollo ");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            this.setId_protocollo(this.getGara_come_registrazione().getIdProtocollo());
            String query_ins = "INSERT INTO edil_gare(id_categoria_gara,id_protocollo_registro,importo_base_asta,data_scadenza,offerta_percentuale,offerta_cifra,in_ati,id_anag_ati,note_ati,versamento,esito_presente,affidata,data_affidamento) VALUES (" + this.f.zero_to_null(this.getId_categoria_gara()) + "," + "" + this.getId_protocollo() + "," + "" + this.getImporto_base_asta() + "," + "'" + this.getDataScadenza() + "'," + "" + this.getOffertaPercentuale() + "," + "" + this.getOffertaCifra() + "," + "" + this.getAti_si_no() + "," + "" + this.f.zero_to_null(this.getId_anag_ati()) + "," + "'" + this.getNote_ati().replaceAll("'", "''") + "'," + "" + this.getVersamento() + "," + "" + this.getEsito_si_no() + "," + " " + this.getAffidata_si_no() + "," + " '" + this.getData_affidamento() + "'" + ")";
            boolean r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins);
            if (!r_ins) {
                Configurazioni.getIstanza().connessione.rollback();
                MyTrace.log.severe("Inserimento Gara non riuscito ");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            if (this.getGara_come_registrazione().getId_commessa() != 0) {
                EdilCommessa ec = new EdilCommessa();
                ec.seleziona("WHERE id_commessa_wrapper=" + this.getGara_come_registrazione().getId_commessa() + " ");
                EdilCommesseGareRif rif = new EdilCommesseGareRif();
                rif.setId_gara(this.getIdGara());
                rif.setId_edil_commessa(ec.getIdEdil_commessa());
                rif.inserisci(false);
            }
            this.setIdGara(Configurazioni.getIstanza().connessione.id_inserito("edil_gare"));
            String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','gare','" + this.getIdGara() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
            boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
            if (!r_trace) {
                MyTrace.log.severe("Inserimento Gara non riuscito per trace");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            if (da_solo) {
                Configurazioni.getIstanza().connessione.commit();
            }
            return true;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su FatturaAttiva.iinserisci() ECCEZIONE:[" + e + "]");
            Configurazioni.getIstanza().connessione.rollback();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return false;
        }
    }

    public boolean modifica(boolean da_solo) {
        String q_trace;
        boolean r_trace;
        boolean res_w;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(res_w = this.getGara_come_registrazione().modifica(false))) {
            MyTrace.log.severe("Modifica protocollo non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String query_mod = "UPDATE edil_gare  SET   id_categoria_gara=" + this.f.zero_to_null(this.getId_categoria_gara()) + ", " + " importo_base_asta= " + this.getImporto_base_asta() + "," + " data_scadenza= '" + this.getDataScadenza() + "', " + " offerta_percentuale= " + this.getOffertaPercentuale() + "," + " offerta_cifra= " + this.getOffertaCifra() + "," + " in_ati= " + this.getAti_si_no() + "," + " id_anag_ati= " + this.f.zero_to_null(this.getId_anag_ati()) + "," + " note_ati='" + this.getNote_ati().replaceAll("'", "''") + "', " + " versamento= " + this.getVersamento() + "," + " esito_presente= " + this.getEsito_si_no() + ", " + " data_affidamento= '" + this.getData_affidamento() + "', " + " affidata= " + this.getAffidata_si_no() + " " + " WHERE idedil_gare=" + this.getIdGara() + " ";
        boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod);
        if (!r_mod) {
            MyTrace.log.severe("Modifica edil gara non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (this.getGara_come_registrazione().getId_commessa() != 0) {
            boolean res = true;
            EdilCommessa ec = new EdilCommessa();
            ec.seleziona("WHERE id_commessa_wrapper=" + this.getGara_come_registrazione().getId_commessa() + " ");
            InsiemeEdilCommesseGareRif insieme = new InsiemeEdilCommesseGareRif();
            insieme.caricamento(" WHERE id_gara=" + this.getIdGara() + " ", "");
            EdilCommesseGareRif rif = new EdilCommesseGareRif();
            if (!insieme.vettoreRif.isEmpty()) {
                rif = insieme.vettoreRif.get(0);
                rif.setId_edil_commessa(ec.getIdEdil_commessa());
                res = rif.modifica(false);
            } else {
                rif.setId_gara(this.getIdGara());
                rif.setId_edil_commessa(ec.getIdEdil_commessa());
                res = rif.inserisci(false);
            }
            if (!res) {
                MyTrace.log.severe("Modifica Edil Gara non riuscita per rif");
                Configurazioni.getIstanza().connessione.rollback();
                Configurazioni.eccezione.gestisci("3.3", null);
                return false;
            }
        }
        if (!(r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','edil_gare','" + this.getIdGara() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')"))) {
            MyTrace.log.severe("Modifica Edil Gara non riuscita per trace");
            Configurazioni.getIstanza().connessione.rollback();
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public void seleziona_dettagli() {
    }

    Object getColValue(int col) {
        try {
            String retVal = "";
            switch (col) {
                case 0: {
                    try {
                        retVal = this.getGara_come_registrazione().getNum_prot() + this.getGara_come_registrazione().getCategoria_protocollo().getCodifica() + "/" + this.getGara_come_registrazione().getAnno();
                    }
                    catch (Exception x) {
                        retVal = "";
                    }
                    break;
                }
                case 1: {
                    retVal = this.getGara_come_registrazione().getData_it();
                    break;
                }
                case 2: {
                    retVal = "" + this.getCategoria_gara();
                    break;
                }
                case 3: {
                    retVal = "" + this.f.si_no(this.getAffidata_si_no());
                    break;
                }
                case 4: {
                    if (this.getData_affidamento() != null && !this.getData_affidamento().equals("null")) {
                        retVal = this.getData_affidamento_it();
                        break;
                    }
                    retVal = "/";
                    break;
                }
                case 5: {
                    retVal = this.getGara_come_registrazione().getRagione_sociale();
                    break;
                }
                case 6: {
                    retVal = this.getGara_come_registrazione().getRegesto();
                    break;
                }
                case 7: {
                    retVal = "" + this.f.si_no(this.getEsito_si_no());
                    break;
                }
                default: {
                    retVal = "";
                }
            }
            return retVal;
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su Gare.getColValue() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return "";
        }
    }
}

