/*
 * Decompiled with CFR 0.152.
 */
package controlling.voci_di_analisi;

import controlling.regole.MyRegole;
import controlling.voci_di_analisi.ContiVociTableModel;
import controlling.voci_di_analisi.InsiemeVociDiAnalisi;
import controlling.voci_di_analisi.VoceDiAnalisi;
import controlling.voci_di_analisi.VoceDiAnalisiFixedModel;
import controlling.voci_di_analisi.VociDiAnalisiTableModel;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import gestionale.documenti.MyDocumentiAttivi;
import gestionale.piano_dei_conti.Conto5;
import gestionale.piano_dei_conti.InsiemeConto5;
import gestionale.piano_dei_conti.MyConto5;
import gestionale.primanota.MyRegistrazioni;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import utils.Funzioni;
import utils.GenericTableRenderer;
import utils.MyTrace;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.TextInsertEditor;
import utils.ToolTipHeader;

public class MyVociDiAnalisi
extends JInternalFrame
implements ListSelectionListener,
MouseListener,
InternalFrameListener {
    JToolBar jToolBarMod;
    VociDiAnalisiTableModel vdatm;
    InsiemeVociDiAnalisi insieme_vda;
    JScrollPane scroll;
    JTable jTableVociDiAnalisi;
    VoceDiAnalisiFixedModel vdafm;
    JScrollPane fixedScroll;
    JTable fixedTable;
    private TableRowSorter<VociDiAnalisiTableModel> sorter;
    RowFilter<VociDiAnalisiTableModel, Object> rf = null;
    ArrayList<RowFilter<VociDiAnalisiTableModel, Object>> andFilters = new ArrayList();
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    VoceDiAnalisi vda_selezione;
    Funzioni f = new Funzioni();
    public JInternalFrame chiamante;
    public int row_chiamante;
    public boolean f_c5_open = false;
    public boolean f_te_open = false;
    public boolean f_al_open = false;
    public boolean aiuto_regole = false;
    double prezzo_base = 0.0;
    ContiVociTableModel cvtm;
    private ButtonGroup buttonGroup1;
    private JButton jButtonAddConto;
    private JButton jButtonClean;
    private JButton jButtonElimina;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JComboBox jComboTipo;
    private JLabel jLabel1;
    private JLabel jLabelCF;
    private JLabel jLabelCF1;
    private JLabel jLabelCodice;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelDettaglio;
    private JPanel jPanelElenco;
    private JRadioButton jRadioDiretto;
    private JRadioButton jRadioIndiretto;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane7;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    public JTable jTableContiVoci;
    private JTextField jTextDescrizioneVoce;
    public JTextField jTextRegolaPredefinita;
    private JToolBar jToolBar1;
    private JPanel p;

    public MyVociDiAnalisi() {
        this.vdatm = new VociDiAnalisiTableModel();
        this.cvtm = new ContiVociTableModel();
        this.insieme_vda = new InsiemeVociDiAnalisi();
        this.jTableVociDiAnalisi = new JTable(this.vdatm);
        this.jTableVociDiAnalisi.setSelectionMode(0);
        this.sorter = new TableRowSorter<VociDiAnalisiTableModel>(this.vdatm);
        for (int i = 0; i < this.vdatm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.vdafm = new VoceDiAnalisiFixedModel();
        this.vdafm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.vdafm);
        this.fixedTable.setAutoResizeMode(4);
        this.addInternalFrameListener(this);
        this.initComponents();
        this.crea_toolbar();
        this.aggiungi_tabelle();
        this.filtra();
        this.formatta();
        this.visualizzazione();
        this.controlla_diritti();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(660, 300)));
    }

    private void controlla_diritti() {
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVociDiAnalisi.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVociDiAnalisi.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableVociDiAnalisi){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableVociDiAnalisi.setModel(this.vdatm);
        this.jTableVociDiAnalisi.setAutoCreateRowSorter(true);
        this.jTableVociDiAnalisi.setRowSorter(this.sorter);
        this.jTableVociDiAnalisi.setFillsViewportHeight(true);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
    }

    public void visualizzazione() {
        try {
            this.jButtonAddConto.setEnabled(this.in_modifica);
            this.jTextRegolaPredefinita.setEnabled(this.in_modifica);
            this.jComboTipo.setEnabled(this.in_modifica);
            this.jRadioDiretto.setEnabled(this.in_modifica);
            this.jRadioIndiretto.setEnabled(this.in_modifica);
            this.jTextDescrizioneVoce.setEnabled(this.in_modifica);
            if (this.in_modifica) {
                this.getContentPane().remove(this.jToolBar1);
                this.getContentPane().add((Component)this.jToolBarMod, "North");
                this.jTabbedPane1.setEnabledAt(0, false);
            } else {
                this.getContentPane().remove(this.jToolBarMod);
                this.getContentPane().add((Component)this.jToolBar1, "North");
                this.jTabbedPane1.setEnabledAt(0, true);
            }
            this.getContentPane().validate();
            this.getContentPane().repaint();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyVociDiAnalisi.visualizzazione() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void formatta() {
        try {
            ListSelectionModel listSelectionModel = this.jTableVociDiAnalisi.getSelectionModel();
            listSelectionModel.addListSelectionListener(this);
            this.jTableVociDiAnalisi.getSelectionModel().setSelectionInterval(0, 0);
            this.jTableVociDiAnalisi.setDefaultRenderer(Object.class, new GenericTableRenderer());
            this.fixedTable.setRowHeight(30);
            this.fixedTable.setDefaultEditor(String.class, new TextEditor());
            this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
            this.jTableVociDiAnalisi.addMouseListener(this);
            this.jTableContiVoci.setRowHeight(27);
            this.jTableContiVoci.setDefaultEditor(Object.class, new TextRigaEditor());
            this.jTableContiVoci.setDefaultRenderer(Object.class, new RicercaCellRenderer());
            TableColumn c = this.fixedTable.getColumn("Tipo");
            c.setPreferredWidth(70);
            c.setMaxWidth(70);
            c = this.jTableVociDiAnalisi.getColumn("Tipo");
            c.setPreferredWidth(70);
            c.setMaxWidth(70);
            c = this.fixedTable.getColumn("Diretto");
            c.setPreferredWidth(70);
            c.setMaxWidth(70);
            c = this.jTableVociDiAnalisi.getColumn("Diretto");
            c.setPreferredWidth(70);
            c.setMaxWidth(70);
            this.header_tebella();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyVociDiAnalisi.formatta() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void header_tebella() {
        try {
            String[] headerStr = new String[]{"Descrizione Voce", "Tipo", "Diretto / Non Diretto", "Regola Predefinita"};
            String[] toolTipStr = new String[]{"Descrizione Voce", "Tipo", "Diretto / Non Diretto", "Regola Predefinita"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableVociDiAnalisi.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableVociDiAnalisi.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filtra() {
        try {
            String w = " WHERE ctrl_voci_di_analisi.abilita=1 ";
            if (Configurazioni.righe_ricerca != 0) {
                w = w + " LIMIT 0," + Configurazioni.righe_ricerca;
            }
            this.insieme_vda.caricamento(w, "", false);
            this.vdatm.setDataVoceAnalisi(this.insieme_vda.vettoreVociDiAnalisi);
            if (Configurazioni.righe_ricerca != 0 && this.insieme_vda.vettoreVociDiAnalisi.size() >= Configurazioni.righe_ricerca) {
                this.non_tutte_le_righe = true;
            }
            this.formatta();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyVociDiAnalisi.filtra() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void seleziona(int row) {
        try {
            this.vda_selezione = new VoceDiAnalisi();
            this.vda_selezione = (VoceDiAnalisi)this.insieme_vda.vettoreVociDiAnalisi.elementAt(row);
            this.vda_selezione.seleziona_dettagli();
            this.riempi_campi();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyVociDiAnalisi.seleziona() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void azzera() {
        try {
            this.vda_selezione.setIdvoci_di_analisi(this.f.prossimo_id("ctrl_voci_di_analisi", "idvoci_di_analisi"));
            this.visualizzazione();
            this.jTextDescrizioneVoce.setText("");
            this.jTextRegolaPredefinita.setText("");
            try {
                if (this.vda_selezione.getTipo().equals("costo")) {
                    this.jComboTipo.setSelectedIndex(0);
                } else {
                    this.jComboTipo.setSelectedIndex(1);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.vda_selezione.getDiretto() == 1) {
                this.jRadioDiretto.setSelected(true);
            } else {
                this.jRadioIndiretto.setSelected(true);
            }
            this.cvtm = new ContiVociTableModel();
            this.jTableContiVoci.setModel(this.cvtm);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyVociDiAnalisi.azzera() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void riempi_campi() {
        try {
            this.visualizzazione();
            this.jTextDescrizioneVoce.setText(this.vda_selezione.getDescrizione_voce());
            this.jTextRegolaPredefinita.setText(this.f.nome_regola_da_id(this.vda_selezione.getId_regola_predefinita()));
            try {
                if (this.vda_selezione.getTipo().equals("costo")) {
                    this.jComboTipo.setSelectedIndex(0);
                } else {
                    this.jComboTipo.setSelectedIndex(1);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.vda_selezione.getDiretto() == 1) {
                this.jRadioDiretto.setSelected(true);
            } else {
                this.jRadioIndiretto.setSelected(true);
            }
            this.cvtm = new ContiVociTableModel();
            this.jTableContiVoci.setModel(this.cvtm);
            this.cvtm.setDataContiVoci(this.vda_selezione.getInsiemeConto5().vettoreConto5);
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyVociDiAnalisi.riempi_campi() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void costruisci() {
        try {
            this.vda_selezione.setDescrizione_voce(this.jTextDescrizioneVoce.getText());
            this.vda_selezione.setId_regola_predefinita(this.f.id_regola_da_nome(this.jTextRegolaPredefinita.getText()));
            this.vda_selezione.setTipo(this.jComboTipo.getSelectedItem().toString());
            if (this.jRadioDiretto.isSelected()) {
                this.vda_selezione.setDiretto(1);
            } else {
                this.vda_selezione.setDiretto(0);
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyVociDiAnalisi.costruisci() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private boolean check() {
        if (this.jTextDescrizioneVoce.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il Nome della Voce di Analisi");
            return false;
        }
        return true;
    }

    public void aiuto_riga(int row, int col) {
        try {
            if (col == 0 && !this.f_c5_open) {
                MyConto5 oggetto = new MyConto5();
                oggetto.chiamante = this;
                this.getDesktopPane().add(oggetto);
                oggetto.setLocation(200, 100);
                oggetto.setVisible(true);
                oggetto.moveToFront();
                this.f_c5_open = true;
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE su MyVociDiAnalisi.aiuto_riga() ECCEZIONE:[" + e + "]");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.jPanelDettaglio = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabelCodice = new JLabel();
        this.jTextRegolaPredefinita = new JTextField();
        this.jLabelCF = new JLabel();
        this.jTextDescrizioneVoce = new JTextField();
        this.jLabelCF1 = new JLabel();
        this.jRadioDiretto = new JRadioButton();
        this.jRadioIndiretto = new JRadioButton();
        this.jComboTipo = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane7 = new JScrollPane();
        this.jTableContiVoci = new JTable(this.cvtm);
        this.jButtonAddConto = new JButton();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Analitica \\ Voci di Analisi");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyVociDiAnalisi.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyVociDiAnalisi.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVociDiAnalisi.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVociDiAnalisi.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVociDiAnalisi.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVociDiAnalisi.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVociDiAnalisi.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVociDiAnalisi.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVociDiAnalisi.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVociDiAnalisi.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVociDiAnalisi.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVociDiAnalisi.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVociDiAnalisi.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelDettaglio.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanelDettaglio.add((Component)this.jPanel2, "West");
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabelCodice.setText("Regola Predefinita");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCodice, gridBagConstraints);
        this.jTextRegolaPredefinita.setMinimumSize(new Dimension(200, 30));
        this.jTextRegolaPredefinita.setPreferredSize(new Dimension(200, 30));
        this.jTextRegolaPredefinita.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyVociDiAnalisi.this.jTextRegolaPredefinitaKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextRegolaPredefinita, gridBagConstraints);
        this.jLabelCF.setText("Descrizione Voce");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCF, gridBagConstraints);
        this.jTextDescrizioneVoce.setMinimumSize(new Dimension(200, 30));
        this.jTextDescrizioneVoce.setPreferredSize(new Dimension(350, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextDescrizioneVoce, gridBagConstraints);
        this.jLabelCF1.setText("Tipo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCF1, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioDiretto);
        this.jRadioDiretto.setText("Diretta");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jRadioDiretto, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioIndiretto);
        this.jRadioIndiretto.setText("Indiretta");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jRadioIndiretto, gridBagConstraints);
        this.jComboTipo.setModel(new DefaultComboBoxModel<String>(new String[]{"Costo", "Ricavo"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jComboTipo, gridBagConstraints);
        this.jLabel1.setText("Voce di Costo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane7.setMaximumSize(new Dimension(250, 150));
        this.jScrollPane7.setMinimumSize(new Dimension(250, 150));
        this.jScrollPane7.setPreferredSize(new Dimension(250, 150));
        this.jTableContiVoci.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTableContiVoci.setDragEnabled(true);
        this.jTableContiVoci.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyVociDiAnalisi.this.jTableContiVociKeyPressed(evt);
            }
        });
        this.jScrollPane7.setViewportView(this.jTableContiVoci);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        this.jPanel3.add((Component)this.jScrollPane7, gridBagConstraints);
        this.jButtonAddConto.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-add.png")));
        this.jButtonAddConto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyVociDiAnalisi.this.jButtonAddContoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 15;
        this.jPanel3.add((Component)this.jButtonAddConto, gridBagConstraints);
        this.jPanelDettaglio.add((Component)this.jPanel3, "Center");
        this.jTabbedPane1.addTab("Dettaglio", this.jPanelDettaglio);
        this.jScrollPane1.setViewportView(this.jTabbedPane1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                boolean check2 = this.vda_selezione.inserisci(false);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci();
            boolean check2 = this.vda_selezione.modifica(false);
            if (check2) {
                this.in_modifica = false;
                this.filtra();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento della modifica dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
            }
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        this.in_new = true;
        this.jTableVociDiAnalisi.getSelectionModel().clearSelection();
        this.vda_selezione = new VoceDiAnalisi();
        this.azzera();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        this.in_modifica = true;
        this.visualizzazione();
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
        this.jTabbedPane1.setSelectedIndex(1);
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare questa Regola?");
        if (res == 0) {
            this.vda_selezione.elimina(res);
            this.in_modifica = false;
            this.filtra();
        }
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.vdatm.getRowCount() != 0) {
            this.jTableVociDiAnalisi.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        if (this.jTableVociDiAnalisi.getSelectedRow() > 0 && this.vdatm.getRowCount() != 0) {
            this.jTableVociDiAnalisi.getSelectionModel().setSelectionInterval(this.jTableVociDiAnalisi.getSelectedRow() - 1, this.jTableVociDiAnalisi.getSelectedRow() - 1);
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        if (this.vdatm.getRowCount() != 0) {
            this.jTableVociDiAnalisi.getSelectionModel().setSelectionInterval(this.jTableVociDiAnalisi.getSelectedRow() + 1, this.jTableVociDiAnalisi.getSelectedRow() + 1);
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.vdatm.getRowCount() != 0) {
            this.jTableVociDiAnalisi.getSelectionModel().setSelectionInterval(this.vdatm.getRowCount() - 1, this.vdatm.getRowCount() - 1);
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            this.in_filter = true;
            String[] a_ric = new String[]{"", "", ""};
            this.vdafm.addRow(a_ric);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.fixedTable.setCellSelectionEnabled(true);
            this.fixedTable.changeSelection(0, 0, false, false);
            this.fixedTable.requestFocus();
        } else {
            this.in_filter = false;
            this.vdafm.deleteRow();
            this.vdafm = new VoceDiAnalisiFixedModel();
            this.fixedTable.setModel(this.vdafm);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            this.sorter.setRowFilter(null);
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.formatta();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] a_ric = new String[]{"", "", ""};
            this.vdafm = new VoceDiAnalisiFixedModel();
            this.fixedTable.setModel(this.vdafm);
            this.vdafm.addRow(a_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.vdatm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void jTextRegolaPredefinitaKeyPressed(KeyEvent evt) {
        if (!this.aiuto_regole) {
            MyRegole oggetto = new MyRegole();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setLocation(200, 100);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.aiuto_regole = true;
        }
    }

    private void jTableContiVociKeyPressed(KeyEvent evt) {
        if (this.jTableContiVoci.getCellEditor() != null) {
            this.jTableContiVoci.getCellEditor().stopCellEditing();
        }
    }

    private void jButtonAddContoActionPerformed(ActionEvent evt) {
        if (this.vda_selezione.getInsiemeConto5() == null) {
            this.vda_selezione.setInsiemeConto5(new InsiemeConto5());
        }
        Conto5 ro = new Conto5();
        this.vda_selezione.getInsiemeConto5().vettoreConto5.add(ro);
        this.cvtm.setDataContiVoci(this.vda_selezione.getInsiemeConto5().vettoreConto5);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyVociDiAnalisi().setVisible(true);
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableVociDiAnalisi.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableVociDiAnalisi.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.vdatm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTable jtb = (JTable)e.getSource();
            int viewRow = jtb.getSelectedRow();
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableVociDiAnalisi.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow <= this.vdatm.getRowCount() - 1 && modelRow >= 0) {
                VoceDiAnalisi a = new VoceDiAnalisi();
                a = (VoceDiAnalisi)this.insieme_vda.vettoreVociDiAnalisi.elementAt(modelRow);
                if (this.chiamante != null) {
                    if (this.chiamante.getClass() == MyRegistrazioni.class && ((MyRegistrazioni)this.chiamante).aiuto_riga_analisi) {
                        ((MyRegistrazioni)this.chiamante).jTablePNRighe.getCellEditor().getTableCellEditorComponent(((MyRegistrazioni)this.chiamante).jTablePNRighe, this.f.descrizione_vda_da_id(a.getIdvoci_di_analisi()), false, this.row_chiamante, 5);
                        ((MyRegistrazioni)this.chiamante).jTablePNRighe.getCellEditor().stopCellEditing();
                        ((MyRegistrazioni)this.chiamante).aiuto_riga_analisi = false;
                    }
                    if (this.chiamante.getClass() == MyDocumentiAttivi.class && ((MyDocumentiAttivi)this.chiamante).f_vda_open) {
                        ((MyDocumentiAttivi)this.chiamante).jTablePNRighe.getCellEditor().getTableCellEditorComponent(((MyDocumentiAttivi)this.chiamante).jTablePNRighe, this.f.descrizione_vda_da_id(a.getIdvoci_di_analisi()), false, this.row_chiamante, 5);
                        ((MyDocumentiAttivi)this.chiamante).jTablePNRighe.getCellEditor().stopCellEditing();
                        ((MyDocumentiAttivi)this.chiamante).f_vda_open = false;
                    }
                    if (this.chiamante.getClass() == MyConto5.class && ((MyConto5)this.chiamante).f_vda_open) {
                        ((MyConto5)this.chiamante).jTextVoceDiAnalisi.setText(this.f.descrizione_vda_da_id(a.getIdvoci_di_analisi()));
                        ((MyConto5)this.chiamante).f_vda_open = false;
                    }
                    this.dispose();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (this.chiamante != null) {
            if (this.chiamante.getClass() == MyRegistrazioni.class && ((MyRegistrazioni)this.chiamante).aiuto_riga_analisi) {
                ((MyRegistrazioni)this.chiamante).aiuto_riga_analisi = false;
            }
            if (this.chiamante.getClass() == MyDocumentiAttivi.class && ((MyDocumentiAttivi)this.chiamante).f_vda_open) {
                ((MyDocumentiAttivi)this.chiamante).f_vda_open = false;
            }
            if (this.chiamante.getClass() == MyConto5.class && ((MyConto5)this.chiamante).f_vda_open) {
                ((MyConto5)this.chiamante).f_vda_open = false;
            }
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public class TextRigaEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            MyVociDiAnalisi.this.aiuto_riga(MyVociDiAnalisi.this.jTableContiVoci.getSelectedRow(), col);
            this.getCellEditorValue();
        }

        @Override
        public void azione_focus_lost(String col_row) {
            try {
                String[] a = col_row.split("_");
                int col = Integer.parseInt(a[0]);
                int row = Integer.parseInt(a[1]);
                Object b = null;
                if (col == 0) {
                    MyVociDiAnalisi.this.jTableContiVoci.setValueAt(this.tf.getText(), row, col);
                    MyVociDiAnalisi.this.jTableContiVoci.setValueAt(MyVociDiAnalisi.this.f.descrizione_conto(this.tf.getText()), row, col + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<VociDiAnalisiTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            if (!MyVociDiAnalisi.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyVociDiAnalisi.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyVociDiAnalisi.this.rf = RowFilter.andFilter(MyVociDiAnalisi.this.andFilters);
                MyVociDiAnalisi.this.sorter.setRowFilter(MyVociDiAnalisi.this.rf);
                MyVociDiAnalisi.this.formatta();
            } else {
                String w = " WHERE 1 ";
                if (col == 0) {
                    w = w + " AND descrizione_voce LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 1) {
                    w = w + " AND tipo LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 2) {
                    w = w + " AND diretto LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 3) {
                    int id = 0;
                    try {
                        id = MyVociDiAnalisi.this.f.id_regola_da_nome(this.tf.getText());
                    }
                    catch (Exception d) {
                        // empty catch block
                    }
                    w = w + " AND id_regola_predefinita LIKE '%" + id + "%'";
                }
                String o = " ORDER BY idvoci_di_analisi ASC LIMIT 0," + Configurazioni.righe_ricerca;
                MyVociDiAnalisi.this.insieme_vda.caricamento(w, o, false);
                MyVociDiAnalisi.this.vdatm.setDataVoceAnalisi(MyVociDiAnalisi.this.insieme_vda.vettoreVociDiAnalisi);
                MyVociDiAnalisi.this.formatta();
            }
        }
    }
}

