/*
 * Decompiled with CFR 0.152.
 */
package cisterna.carico_gasolio;

import cisterna.carico_gasolio.CaricoGasolio;
import cisterna.carico_gasolio.InsiemeCaricoGasolio;
import gestionale.configurazioni.Configurazioni;
import gestionale.personalizzazione.stampe.IntestazioneCaricoGasolio;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.Quantita;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaCaricoGasolio {
    public GestoreStampe stampa;
    FunzioniDate fda;
    Funzioni f;
    Vector v_giacenza;
    String dataDA;
    String dataA;
    String targa = "";
    boolean esito = false;
    InsiemeCaricoGasolio insieme_g;
    boolean tutto;

    public StampaCaricoGasolio(String dataDA, String dataA, InsiemeCaricoGasolio insieme_g, boolean tutto, String targa) {
        this.tutto = tutto;
        this.insieme_g = insieme_g;
        this.v_giacenza = insieme_g.vettoreGasolio;
        MyTrace.log.info("RICHIESTA ISTANZA CLASSE StampaCaricoGasolio()");
        this.v_giacenza = this.v_giacenza;
        this.dataA = dataA;
        this.dataDA = dataDA;
        this.targa = targa;
        MyTrace.log.info("CLASSE StampaCaricoGasolio() ISTANZIATA");
    }

    public boolean Elabora() {
        try {
            Configurazioni.getIstanza();
            int y_inizio = Configurazioni.inizio_stampe;
            int y_corrente = y_inizio + 55;
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA CARICO GASOLIO INIZIO XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            long tempo_di_visualizzazione = System.currentTimeMillis();
            this.fda = new FunzioniDate();
            this.f = new Funzioni();
            this.stampa = new GestoreStampe();
            this.stampa.aggiungi_pj();
            Quantita quantita_selezionata = new Quantita(BigDecimal.ZERO);
            this.stampa.setIntPP((OggettoToPrint)new IntestazioneCaricoGasolio());
            this.stampa.setInt((OggettoToPrint)new IntestazioneCaricoGasolio());
            this.stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Giacenza Gasolio"));
            this.stampa_intestazione_carico_gasolio(y_inizio);
            Iterator i_gasolio = this.v_giacenza.iterator();
            Money money_Tot_Costi = new Money(BigDecimal.ZERO);
            while (i_gasolio.hasNext()) {
                CaricoGasolio carico = (CaricoGasolio)i_gasolio.next();
                if (y_corrente > 710) {
                    this.stampa.paginanuova();
                    y_corrente = y_inizio + 55;
                    this.stampa_intestazione_carico_gasolio(y_inizio);
                }
                Date data_mov = this.fda.string_to_date(carico.getData_movimento());
                Date data_da = this.fda.string_to_date(this.fda.gira_data(this.dataDA));
                Date data_a = this.fda.string_to_date(this.fda.gira_data(this.dataA));
                if (!this.tutto) {
                    if ((!data_mov.after(data_da) || !data_mov.before(data_a)) && !data_mov.equals(data_da) && !data_mov.equals(data_a) || !this.targa.equals(carico.getTarga()) && !this.targa.equals("")) continue;
                    this.stampa.setFont(this.stampa.Font_Calibri_8_B);
                    this.stampa.appendTextOvunque("" + carico.getQuantita(), 20, y_corrente + 10);
                    this.stampa.setFont(this.stampa.Font_Calibri_8);
                    this.stampa.appendTextOvunque(this.fda.gira_data(carico.getData_movimento()), 65, y_corrente + 10);
                    this.stampa.appendTextOvunque(carico.getTarga(), 140, y_corrente + 10);
                    this.stampa.setFont(this.stampa.Font_Calibri_8_B);
                    this.stampa.appendTextOvunque(carico.getNum_doc(), 200, y_corrente + 10);
                    this.stampa.appendTextOvunque(carico.getNumero_fattura(), 250, y_corrente + 10);
                    this.stampa.appendTextOvunque(carico.getStringa_fornitore().replaceAll("null-null", ""), 300, y_corrente + 10);
                    this.stampa.appendTextOvunque("" + carico.getCosto_al_litro(), 480, y_corrente + 10);
                    this.stampa.appendStringaOvunqueFormattazioneDestra("" + carico.getCosto_totale(), 515, y_corrente + 10, 40);
                    this.stampa.appendRect(14, y_corrente, 567, 20);
                    quantita_selezionata.plusplus(carico.getQuantita());
                    money_Tot_Costi.plusplus(carico.getCosto_totale());
                    y_corrente += 20;
                    continue;
                }
                this.stampa.setFont(this.stampa.Font_Calibri_8_B);
                this.stampa.appendTextOvunque("" + carico.getQuantita(), 20, y_corrente + 10);
                this.stampa.setFont(this.stampa.Font_Calibri_8);
                this.stampa.appendTextOvunque(this.fda.gira_data(carico.getData_movimento()), 65, y_corrente + 10);
                this.stampa.appendTextOvunque(carico.getTarga(), 140, y_corrente + 10);
                this.stampa.setFont(this.stampa.Font_Calibri_8_B);
                this.stampa.appendTextOvunque(carico.getNum_doc(), 200, y_corrente + 10);
                this.stampa.appendTextOvunque(carico.getNumero_fattura(), 250, y_corrente + 10);
                this.stampa.appendTextOvunque(carico.getStringa_fornitore().replaceAll("null-null", ""), 300, y_corrente + 10);
                this.stampa.appendTextOvunque("" + carico.getCosto_al_litro(), 480, y_corrente + 10);
                this.stampa.appendStringaOvunqueFormattazioneDestra("" + carico.getCosto_totale(), 515, y_corrente + 10, 40);
                this.stampa.appendRect(18, y_corrente, 560, 20);
                quantita_selezionata.plusplus(carico.getQuantita());
                money_Tot_Costi.plusplus(carico.getCosto_totale());
                y_corrente += 20;
            }
            this.stampa.appendRect(18, y_corrente += 15, 560, 50);
            this.stampa.appendTextOvunque("Totale giacenza gasolio = " + this.f.formattaNumero_2(this.insieme_g.giacenza.getDoubleValue()), 20, y_corrente + 13);
            this.stampa.appendTextOvunque("Giacenza relativa ai movimenti selezionati \u00e8 = " + this.f.formattaNumero_2(quantita_selezionata.getDoubleValue()), 20, y_corrente + 28);
            this.stampa.appendTextOvunque("Il costo totale \u00e8 = " + money_Tot_Costi, 20, y_corrente + 43);
            String date_now = this.fda.dataCorrente().replaceAll("-", "");
            String ora_now = this.fda.OraCorrente().replaceAll(":", "");
            if (!this.tutto) {
                this.stampa.getSeg().getMy_pj_corrente().getPj().setJobName(date_now + ora_now + "_Giacenza_Gasolio_dal_" + this.dataDA + "_al_" + this.dataA);
            } else {
                this.stampa.getSeg().getMy_pj_corrente().getPj().setJobName(date_now + ora_now + "_Giacenza_Gasolio");
            }
            MyTrace.log.info(" PERFORMANCE: Tempo di Elaborazione =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            this.stampa.print();
            System.out.println("Fine Stampa");
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA CARICO GASOLIO FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            MyTrace.log.info(" PERFORMANCE: Tempo Totale compresa la stampa =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            this.esito = true;
        }
        catch (Exception ex) {
            MyTrace.log.severe("ECCEZIONE in StampaCaricoGasolio()");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            this.esito = false;
        }
        return this.esito;
    }

    public void stampa_intestazione_carico_gasolio(int altezza) {
        this.stampa.setFont(this.stampa.Font_Calibri_10_B);
        this.stampa.appendRoundRect(18, (altezza += 10) - 10, 560, 35, 10, 10);
        if (!this.tutto) {
            this.stampa.appendTextOvunque("Movimenti Gasolio dal " + this.dataDA + " al " + this.dataA, 20, altezza + 3);
        } else {
            this.stampa.appendTextOvunque("Movimenti Gasolio ", 20, altezza + 3);
        }
        this.stampa.appendTextOvunque("Quantit\u00e0", 20, altezza + 17);
        this.stampa.appendTextOvunque("Data", 65, altezza + 17);
        this.stampa.appendTextOvunque("Targa", 140, altezza + 17);
        this.stampa.appendTextOvunque("N. DAS", 200, altezza + 17);
        this.stampa.appendTextOvunque("N. Fat.", 250, altezza + 17);
        this.stampa.appendTextOvunque("Fornitore", 300, altezza + 17);
        this.stampa.setFont(this.stampa.Font_Calibri_9_B);
        this.stampa.appendTextOvunque("Costo Litro", 470, altezza + 17);
        this.stampa.appendTextOvunque("Costo Totale", 520, altezza + 17);
    }
}

