/*
 * Decompiled with CFR 0.152.
 */
package anagrafiche.banche;

import anagrafiche.banche.IBAN;
import anagrafiche.banche.IBANFixedModel;
import anagrafiche.banche.IBANTableModel;
import anagrafiche.banche.InsiemeIBAN;
import gestionale.MyDesktopWindow;
import gestionale.cap.MyCap;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import utils.Funzioni;
import utils.GenericTableRenderer;
import utils.MyTrace;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.ToolTipHeader;

public class MyBancheInserimento
extends JInternalFrame
implements ListSelectionListener,
MouseListener,
InternalFrameListener {
    JToolBar jToolBarMod;
    IBANTableModel itm;
    InsiemeIBAN insieme_i;
    JScrollPane scroll;
    JTable jTableIBAN;
    IBANFixedModel ifm;
    JScrollPane fixedScroll;
    JTable fixedTable;
    private TableRowSorter<IBANTableModel> sorter;
    RowFilter<IBANTableModel, Object> rf = null;
    ArrayList<RowFilter<IBANTableModel, Object>> andFilters = new ArrayList();
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    public IBAN i_selezione;
    Funzioni f = new Funzioni();
    public JInternalFrame chiamante;
    static Point posizione_finestra = new Point(200, 0);
    static Dimension dimensione_finestra = new Dimension(760, 350);
    public boolean f_cap = false;
    private JButton jButtonClean;
    private JButton jButtonElimina;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelAbi;
    private JLabel jLabelBiccode;
    private JLabel jLabelBickey;
    private JLabel jLabelCab;
    private JLabel jLabelCap;
    private JLabel jLabelDescrizione;
    private JLabel jLabelFiliale;
    private JLabel jLabelIndirizzo;
    private JLabel jLabelLocalita;
    private JLabel jLabelNazione;
    private JLabel jLabelProvincia;
    private JPanel jPanel2;
    private JPanel jPanelDettaglio;
    private JPanel jPanelElenco;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextAbi;
    private JTextField jTextBiccode;
    private JTextField jTextBickey;
    private JTextField jTextCab;
    public JTextField jTextCap;
    private JTextField jTextDescrizione;
    private JTextField jTextFiliale;
    private JTextField jTextIndirizzo;
    private JTextField jTextLocalita;
    public JTextField jTextNazione;
    public JTextField jTextProvincia;
    private JToolBar jToolBar1;
    private JPanel p;

    public MyBancheInserimento() {
        this.itm = new IBANTableModel();
        this.insieme_i = new InsiemeIBAN();
        this.jTableIBAN = new JTable(this.itm);
        this.jTableIBAN.setSelectionMode(0);
        this.sorter = new TableRowSorter<IBANTableModel>(this.itm);
        for (int i = 0; i < this.itm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.ifm = new IBANFixedModel();
        this.ifm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.ifm);
        this.fixedTable.setAutoResizeMode(4);
        this.initComponents();
        this.addInternalFrameListener(this);
        this.crea_toolbar();
        this.aggiungi_tabelle();
        this.filtra();
        ListSelectionModel listSelectionModel = this.jTableIBAN.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.formatta();
        this.visualizzazione();
        this.controlla_diritti();
        this.setLocation(posizione_finestra);
        this.setSize(dimensione_finestra);
    }

    private void controlla_diritti() {
        if (!MyDesktopWindow.profilo.controllaPermesso("CONFIGURAZIONE_TABELLE_MODIFICA")) {
            this.jButtonModifica.setEnabled(true);
            this.jButtonNuovo.setEnabled(true);
            this.jButtonElimina.setEnabled(true);
        }
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBancheInserimento.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBancheInserimento.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableIBAN){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableIBAN.setModel(this.itm);
        this.jTableIBAN.setAutoCreateRowSorter(true);
        this.jTableIBAN.setRowSorter(this.sorter);
        this.jTableIBAN.setFillsViewportHeight(true);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
    }

    public void visualizzazione() {
        this.jTextCap.setEnabled(this.in_modifica);
        this.jTextDescrizione.setEnabled(this.in_modifica);
        this.jTextIndirizzo.setEnabled(this.in_modifica);
        this.jTextLocalita.setEnabled(this.in_modifica);
        this.jTextProvincia.setEnabled(this.in_modifica);
        this.jTextAbi.setEnabled(this.in_modifica);
        this.jTextBiccode.setEnabled(this.in_modifica);
        this.jTextBickey.setEnabled(this.in_modifica);
        this.jTextCab.setEnabled(this.in_modifica);
        this.jTextFiliale.setEnabled(this.in_modifica);
        this.jTextNazione.setEnabled(this.in_modifica);
        if (this.in_modifica) {
            this.getContentPane().remove(this.jToolBar1);
            this.getContentPane().add((Component)this.jToolBarMod, "North");
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.getContentPane().remove(this.jToolBarMod);
            this.getContentPane().add((Component)this.jToolBar1, "North");
            this.jTabbedPane1.setEnabledAt(0, true);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void formatta() {
        this.jTableIBAN.getSelectionModel().setSelectionInterval(0, 0);
        this.jTableIBAN.setDefaultRenderer(Object.class, new GenericTableRenderer());
        this.jTableIBAN.addMouseListener(this);
        TableColumn c = this.fixedTable.getColumn("ABI");
        c.setPreferredWidth(70);
        c.setMaxWidth(70);
        c = this.jTableIBAN.getColumn("ABI");
        c.setPreferredWidth(70);
        c.setMaxWidth(70);
        c = this.fixedTable.getColumn("CAB");
        c.setPreferredWidth(70);
        c.setMaxWidth(70);
        c = this.jTableIBAN.getColumn("CAB");
        c.setPreferredWidth(70);
        c.setMaxWidth(70);
        this.fixedTable.setRowHeight(30);
        this.fixedTable.setDefaultEditor(String.class, new TextEditor());
        this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        TableColumn gruppoColumn = this.fixedTable.getColumnModel().getColumn(2);
        this.header_tebella();
    }

    public void header_tebella() {
        try {
            String[] toolTipStr = new String[]{"Banca", "Filiale", "Indirizzo", "ABI", "CAB"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableIBAN.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableIBAN.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filtra() {
        String query = "SELECT * FROM abi_cab WHERE abilita=1 ORDER BY descrizione ASC ";
        if (Configurazioni.righe_ricerca != 0) {
            query = query + " LIMIT 0," + Configurazioni.righe_ricerca;
        }
        this.insieme_i.caricamento(query);
        this.itm.setDataBanca(this.insieme_i.vettoreIBAN);
        if (Configurazioni.righe_ricerca != 0 && this.insieme_i.vettoreIBAN.size() >= Configurazioni.righe_ricerca) {
            this.non_tutte_le_righe = true;
        }
    }

    public void seleziona(int row) {
        this.i_selezione = new IBAN();
        this.i_selezione = (IBAN)this.insieme_i.vettoreIBAN.elementAt(row);
        this.riempi_campi();
    }

    public void riempi_campi() {
        this.jTextCap.setText(this.i_selezione.getCap());
        this.jTextDescrizione.setText(this.i_selezione.getDescrizione());
        this.jTextIndirizzo.setText(this.i_selezione.getIndirizzo());
        this.jTextLocalita.setText(this.i_selezione.getLocalit\u00e0());
        this.jTextProvincia.setText(this.i_selezione.getCd_provincia());
        this.jTextAbi.setText(this.i_selezione.getAbi());
        this.jTextBiccode.setText(this.i_selezione.getBiccode());
        this.jTextBickey.setText(this.i_selezione.getBickey());
        this.jTextCab.setText(this.i_selezione.getCab());
        this.jTextFiliale.setText(this.i_selezione.getFiliale());
        this.jTextNazione.setText(this.i_selezione.getCd_nazione());
    }

    private void costruisci() {
        this.i_selezione.setAbi(this.jTextAbi.getText());
        this.i_selezione.setBiccode(this.jTextBiccode.getText());
        this.i_selezione.setBickey(this.jTextBickey.getText());
        this.i_selezione.setCab(this.jTextCab.getText());
        this.i_selezione.setCap(this.jTextCap.getText());
        this.i_selezione.setCd_nazione(this.jTextNazione.getText());
        this.i_selezione.setCd_provincia(this.jTextProvincia.getText());
        this.i_selezione.setIndirizzo(this.jTextIndirizzo.getText());
        this.i_selezione.setLocalit\u00e0(this.jTextLocalita.getText());
        this.i_selezione.setDescrizione(this.jTextDescrizione.getText());
        this.i_selezione.setFiliale(this.jTextFiliale.getText());
    }

    private boolean check() {
        if (this.jTextAbi.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire un valore di ABI valido!");
            return false;
        }
        if (this.jTextCab.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire un valore di CAB valido!");
            return false;
        }
        if (!this.jTextAbi.getText().equals("") && !this.jTextCab.getText().equals("") && this.f.check_abi_cab(this.jTextAbi.getText() + this.jTextCab.getText()) != 0) {
            JOptionPane.showMessageDialog(this, "Estiste gi\u00e0 una Banca con questi ABI e CAB!");
            return false;
        }
        return true;
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                boolean check2 = this.i_selezione.inserisci(false);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci();
            boolean check2 = this.i_selezione.modifica(false);
            if (check2) {
                this.in_modifica = false;
                this.filtra();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento della modifica dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
            }
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jScrollPane1 = new JScrollPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.jPanelDettaglio = new JPanel();
        this.jPanel2 = new JPanel();
        this.jTextDescrizione = new JTextField();
        this.jLabelDescrizione = new JLabel();
        this.jTextFiliale = new JTextField();
        this.jLabelFiliale = new JLabel();
        this.jTextIndirizzo = new JTextField();
        this.jLabelIndirizzo = new JLabel();
        this.jTextCap = new JTextField();
        this.jLabelCap = new JLabel();
        this.jTextLocalita = new JTextField();
        this.jLabelLocalita = new JLabel();
        this.jTextProvincia = new JTextField();
        this.jLabelProvincia = new JLabel();
        this.jTextNazione = new JTextField();
        this.jLabelNazione = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextBickey = new JTextField();
        this.jLabelBickey = new JLabel();
        this.jTextBiccode = new JTextField();
        this.jLabelBiccode = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jTextCab = new JTextField();
        this.jTextAbi = new JTextField();
        this.jLabelCab = new JLabel();
        this.jLabelAbi = new JLabel();
        this.jLabel9 = new JLabel();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Configurazioni \\ Abi Cab Banche");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyBancheInserimento.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyBancheInserimento.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBancheInserimento.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBancheInserimento.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBancheInserimento.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBancheInserimento.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBancheInserimento.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBancheInserimento.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBancheInserimento.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBancheInserimento.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBancheInserimento.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBancheInserimento.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBancheInserimento.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelDettaglio.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jTextDescrizione.setMinimumSize(new Dimension(300, 30));
        this.jTextDescrizione.setPreferredSize(new Dimension(460, 30));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jTextDescrizione, gridBagConstraints);
        this.jLabelDescrizione.setText("Descrizione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jLabelDescrizione, gridBagConstraints);
        this.jTextFiliale.setMinimumSize(new Dimension(300, 30));
        this.jTextFiliale.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jTextFiliale, gridBagConstraints);
        this.jLabelFiliale.setText("Filiale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jLabelFiliale, gridBagConstraints);
        this.jTextIndirizzo.setMinimumSize(new Dimension(300, 30));
        this.jTextIndirizzo.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jTextIndirizzo, gridBagConstraints);
        this.jLabelIndirizzo.setText("Indirizzo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jLabelIndirizzo, gridBagConstraints);
        this.jTextCap.setMinimumSize(new Dimension(300, 30));
        this.jTextCap.setPreferredSize(new Dimension(200, 30));
        this.jTextCap.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyBancheInserimento.this.jTextCapKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jTextCap, gridBagConstraints);
        this.jLabelCap.setText("cap");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jLabelCap, gridBagConstraints);
        this.jTextLocalita.setMinimumSize(new Dimension(300, 30));
        this.jTextLocalita.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jTextLocalita, gridBagConstraints);
        this.jLabelLocalita.setText("Localit\u00e0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jLabelLocalita, gridBagConstraints);
        this.jTextProvincia.setMinimumSize(new Dimension(300, 30));
        this.jTextProvincia.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jTextProvincia, gridBagConstraints);
        this.jLabelProvincia.setText("Provincia");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jLabelProvincia, gridBagConstraints);
        this.jTextNazione.setMinimumSize(new Dimension(300, 30));
        this.jTextNazione.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jTextNazione, gridBagConstraints);
        this.jLabelNazione.setText("Nazione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jLabelNazione, gridBagConstraints);
        this.jLabel1.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.jTextBickey.setMinimumSize(new Dimension(300, 30));
        this.jTextBickey.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jTextBickey, gridBagConstraints);
        this.jLabelBickey.setText("Bickey");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jLabelBickey, gridBagConstraints);
        this.jTextBiccode.setMinimumSize(new Dimension(300, 30));
        this.jTextBiccode.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jTextBiccode, gridBagConstraints);
        this.jLabelBiccode.setText("Biccode");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jLabelBiccode, gridBagConstraints);
        this.jLabel7.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        this.jPanel2.add((Component)this.jLabel8, gridBagConstraints);
        this.jTextCab.setMinimumSize(new Dimension(300, 30));
        this.jTextCab.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jTextCab, gridBagConstraints);
        this.jTextAbi.setMinimumSize(new Dimension(300, 30));
        this.jTextAbi.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jTextAbi, gridBagConstraints);
        this.jLabelCab.setText("Cab");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jLabelCab, gridBagConstraints);
        this.jLabelAbi.setText("Abi");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.jPanel2.add((Component)this.jLabelAbi, gridBagConstraints);
        this.jLabel9.setFont(new Font("Tahoma", 0, 10));
        this.jLabel9.setText("(Premi F4 per scegliere tra i cap nel Database)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 15;
        this.jPanel2.add((Component)this.jLabel9, gridBagConstraints);
        this.jPanelDettaglio.add((Component)this.jPanel2, "Center");
        this.jTabbedPane1.addTab("Dettagli", this.jPanelDettaglio);
        this.jScrollPane1.setViewportView(this.jTabbedPane1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        this.in_new = true;
        this.jTableIBAN.getSelectionModel().clearSelection();
        this.i_selezione = new IBAN();
        this.riempi_campi();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        this.in_modifica = true;
        this.visualizzazione();
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
        this.jTabbedPane1.setSelectedIndex(1);
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare questa Banca?");
        if (res == 0) {
            this.i_selezione.elimina();
            this.in_modifica = false;
            this.filtra();
        }
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.itm.getRowCount() != 0) {
            this.jTableIBAN.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        if (this.jTableIBAN.getSelectedRow() > 0 && this.itm.getRowCount() != 0) {
            this.jTableIBAN.getSelectionModel().setSelectionInterval(this.jTableIBAN.getSelectedRow() - 1, this.jTableIBAN.getSelectedRow() - 1);
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        try {
            if (this.itm.getRowCount() != 0) {
                this.jTableIBAN.getSelectionModel().setSelectionInterval(this.jTableIBAN.getSelectedRow() + 1, this.jTableIBAN.getSelectedRow() + 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO PRIMO");
            err.printStackTrace();
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        try {
            if (this.itm.getRowCount() != 0) {
                this.jTableIBAN.getSelectionModel().setSelectionInterval(this.itm.getRowCount() - 1, this.itm.getRowCount() - 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO ULTIMO");
            err.printStackTrace();
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            this.in_filter = true;
            String[] b_ric = new String[]{"", "", "", "", ""};
            this.ifm.addRow(b_ric);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.fixedTable.setCellSelectionEnabled(true);
            this.fixedTable.changeSelection(0, 0, false, false);
            this.fixedTable.requestFocus();
        } else {
            this.in_filter = false;
            this.ifm.deleteRow();
            this.ifm = new IBANFixedModel();
            this.fixedTable.setModel(this.ifm);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            this.sorter.setRowFilter(null);
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] b_ric = new String[]{"", "", "", "", ""};
            this.ifm = new IBANFixedModel();
            this.fixedTable.setModel(this.ifm);
            this.ifm.addRow(b_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.itm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void posizione_finestra(ComponentEvent evt) {
        System.out.println("component moved");
        posizione_finestra = this.getLocation();
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        System.out.println("component resized");
        dimensione_finestra = this.getSize();
    }

    private void jTextCapKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 115 && !this.f_cap) {
            MyCap oggetto = new MyCap();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_cap = true;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableIBAN.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableIBAN.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.itm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTable jtb = (JTable)e.getSource();
            int viewRow = jtb.getSelectedRow();
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableIBAN.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow > this.itm.getRowCount() - 1 || modelRow >= 0) {
                // empty if block
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (this.chiamante != null) {
            this.dispose();
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<IBANTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            if (!MyBancheInserimento.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyBancheInserimento.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyBancheInserimento.this.rf = RowFilter.andFilter(MyBancheInserimento.this.andFilters);
                MyBancheInserimento.this.sorter.setRowFilter(MyBancheInserimento.this.rf);
                MyBancheInserimento.this.formatta();
            } else {
                String query = "SELECT * FROM  abi_cab WHERE abilita=1 ";
                if (col == 0) {
                    query = query + " AND descrizione LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 1) {
                    query = query + " AND filiale LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 2) {
                    query = query + " AND indirizzo LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 3) {
                    query = query + " AND cd_abicab LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 4) {
                    query = query + " AND cd_abicab LIKE '%" + this.tf.getText() + "%'";
                }
                query = query + "ORDER BY anag_banche ASC LIMIT 0," + Configurazioni.righe_ricerca;
                MyBancheInserimento.this.insieme_i.caricamento(query);
                MyBancheInserimento.this.itm.setDataBanca(MyBancheInserimento.this.insieme_i.vettoreIBAN);
                MyBancheInserimento.this.formatta();
            }
        }
    }
}

