/*
 * Decompiled with CFR 0.152.
 */
package anagrafiche.banche;

import anagrafiche.banche.Banca;
import anagrafiche.banche.BancheFixedModel;
import anagrafiche.banche.BancheTableModel;
import anagrafiche.banche.InsiemeBanche;
import cisterna.das.MyDAS;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import gestionale.documenti.MyDocumentiAttivi;
import gestionale.piano_dei_conti.Conto5;
import gestionale.piano_dei_conti.MyConto5;
import gestionale.primanota.MyRegistrazioni;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import magazzino.fOUT.MyFOut;
import magazzino.fpIN.MyfpIN;
import magazzino.ncIN.MyncIN;
import trasporti.fatturazione.MyTraFatturazione;
import trasporti.fatture_passive_autostrade.MyTraFattureAutostrade;
import trasporti.fatture_vettori.MyTraFattureVettori;
import trasporti.manutenzione_ddi.MyDDIManutenzione;
import utils.Funzioni;
import utils.GenericTableRenderer;
import utils.MyTrace;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.ToolTipHeader;

public class MyBanche
extends JInternalFrame
implements ListSelectionListener,
MouseListener,
InternalFrameListener {
    String civetta_permessi;
    public static int size_diritti = 2;
    public static String[] array_diritti = new String[]{"ANAG_Banche_Visualizza", "ANAG_Banche_Modifica"};
    JToolBar jToolBarMod;
    BancheTableModel btm;
    InsiemeBanche insieme_b;
    JScrollPane scroll;
    JTable jTableBanche;
    BancheFixedModel bfm;
    JScrollPane fixedScroll;
    JTable fixedTable;
    private TableRowSorter<BancheTableModel> sorter;
    RowFilter<BancheTableModel, Object> rf = null;
    ArrayList<RowFilter<BancheTableModel, Object>> andFilters = new ArrayList();
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean azzera_maschera_iban = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    public Banca b_selezione;
    Funzioni f = new Funzioni();
    public JInternalFrame chiamante;
    GridBagConstraints gridBagConstraints = new GridBagConstraints();
    static Point posizione_finestra = new Point(200, 0);
    static Dimension dimensione_finestra = new Dimension(760, 350);
    private JButton jButtonClean;
    private JButton jButtonElimina;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JLabel jLabelCap;
    private JLabel jLabelCodice;
    private JLabel jLabelConto;
    private JLabel jLabelIBAN;
    private JLabel jLabelIndirizzo;
    private JLabel jLabelLocalita;
    private JLabel jLabelNote;
    private JLabel jLabelProvincia;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelDettaglio;
    private JPanel jPanelElenco;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextCap;
    private JTextField jTextCodice;
    public JTextField jTextConto;
    private JTextArea jTextDescrizione;
    private JTextField jTextIBAN;
    private JTextField jTextIndirizzo;
    private JTextField jTextLocalita;
    private JTextField jTextProvincia;
    private JToolBar jToolBar1;
    private JPanel p;

    public MyBanche() {
        if (!MyDesktopWindow.profilo.controllaPermesso("ANAG_Banche_Visualizza")) {
            Configurazioni.eccezione.gestisci("7.1", null);
            this.dispose();
        }
        this.btm = new BancheTableModel();
        this.insieme_b = new InsiemeBanche();
        this.jTableBanche = new JTable(this.btm);
        this.jTableBanche.setSelectionMode(0);
        this.sorter = new TableRowSorter<BancheTableModel>(this.btm);
        for (int i = 0; i < this.btm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.bfm = new BancheFixedModel();
        this.bfm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.bfm);
        this.fixedTable.setAutoResizeMode(4);
        this.initComponents();
        this.addInternalFrameListener(this);
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.crea_toolbar();
        this.aggiungi_tabelle();
        this.filtra();
        ListSelectionModel listSelectionModel = this.jTableBanche.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.formatta();
        this.visualizzazione();
        this.controlla_diritti();
        this.setLocation(posizione_finestra);
        this.setSize(dimensione_finestra);
    }

    private void controlla_diritti() {
        if (!MyDesktopWindow.profilo.controllaPermesso("ANAG_Banche_Modifica")) {
            this.jButtonModifica.setEnabled(true);
            this.jButtonNuovo.setEnabled(true);
            this.jButtonElimina.setEnabled(true);
        }
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBanche.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBanche.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableBanche){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableBanche.setModel(this.btm);
        this.jTableBanche.setAutoCreateRowSorter(true);
        this.jTableBanche.setRowSorter(this.sorter);
        this.jTableBanche.setFillsViewportHeight(true);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
    }

    public void visualizzazione() {
        this.jTextCap.setEnabled(this.in_modifica);
        this.jTextConto.setEnabled(this.in_modifica);
        this.jTextDescrizione.setEnabled(this.in_modifica);
        this.jTextIBAN.setEnabled(this.in_modifica);
        this.jTextIndirizzo.setEnabled(this.in_modifica);
        this.jTextLocalita.setEnabled(this.in_modifica);
        this.jTextProvincia.setEnabled(this.in_modifica);
        this.jTextCodice.setEnabled(this.in_modifica);
        if (this.in_modifica) {
            this.getContentPane().remove(this.jToolBar1);
            this.getContentPane().add((Component)this.jToolBarMod, "North");
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.getContentPane().remove(this.jToolBarMod);
            this.getContentPane().add((Component)this.jToolBar1, "North");
            this.jTabbedPane1.setEnabledAt(0, true);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void formatta() {
        this.jTableBanche.getSelectionModel().setSelectionInterval(0, 0);
        this.jTableBanche.setDefaultRenderer(Object.class, new GenericTableRenderer());
        this.jTableBanche.addMouseListener(this);
        TableColumn c = this.fixedTable.getColumn("Codice");
        c.setPreferredWidth(70);
        c.setMaxWidth(70);
        c = this.jTableBanche.getColumn("Codice");
        c.setPreferredWidth(70);
        c.setMaxWidth(70);
        c = this.fixedTable.getColumn("Conto");
        c.setPreferredWidth(110);
        c.setMaxWidth(110);
        c = this.jTableBanche.getColumn("Conto");
        c.setPreferredWidth(110);
        c.setMaxWidth(110);
        c = this.fixedTable.getColumn("IBAN");
        c.setPreferredWidth(220);
        c.setMaxWidth(220);
        c = this.jTableBanche.getColumn("IBAN");
        c.setPreferredWidth(220);
        c.setMaxWidth(220);
        this.fixedTable.setRowHeight(30);
        this.fixedTable.setDefaultEditor(String.class, new TextEditor());
        this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        TableColumn gruppoColumn = this.fixedTable.getColumnModel().getColumn(2);
        this.header_tebella();
    }

    public void header_tebella() {
        try {
            String[] toolTipStr = new String[]{"Codice Banca", "Conto", "Descrizione", "IBAN"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableBanche.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableBanche.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filtra() {
        String query = "SELECT * FROM anag_banche WHERE abilita='1' ORDER BY conto ASC ";
        if (Configurazioni.righe_ricerca != 0) {
            query = query + " LIMIT 0," + Configurazioni.righe_ricerca;
        }
        this.insieme_b.caricamento(query);
        this.btm.setDataBanca(this.insieme_b.vettoreBanca);
        if (Configurazioni.righe_ricerca != 0 && this.insieme_b.vettoreBanca.size() >= Configurazioni.righe_ricerca) {
            this.non_tutte_le_righe = true;
        }
    }

    public void azzera() {
        this.jTextCap.setText("");
        this.jTextConto.setText("");
        this.jTextDescrizione.setText("");
        this.jTextIBAN.setText("");
        this.azzera_maschera_iban = false;
        this.jTextIndirizzo.setText("");
        this.jTextLocalita.setText("");
        this.jTextProvincia.setText("");
        this.jTextCodice.setText("");
    }

    public void seleziona(int row) {
        this.azzera();
        this.b_selezione = new Banca();
        this.b_selezione = (Banca)this.insieme_b.vettoreBanca.elementAt(row);
        this.riempi_campi();
    }

    public void riempi_campi() {
        this.jTextCap.setText(this.b_selezione.getCap());
        this.jTextConto.setText(this.b_selezione.getConto());
        this.jTextDescrizione.setText(this.b_selezione.getDescrizione());
        this.jTextIBAN.setText(this.b_selezione.getIBAN());
        this.jTextIndirizzo.setText(this.b_selezione.getIndirizzo());
        this.jTextLocalita.setText(this.b_selezione.getLocalita());
        this.jTextProvincia.setText(this.b_selezione.getProvincia());
        this.jTextCodice.setText(this.b_selezione.getCodice());
    }

    private void costruisci() {
        Conto5 temp = new Conto5();
        this.b_selezione.setCap(String.valueOf(this.jTextCap.getText()));
        this.b_selezione.setConto(String.valueOf(this.jTextConto.getText()));
        this.b_selezione.setDescrizione(String.valueOf(this.jTextDescrizione.getText()));
        this.b_selezione.setIBAN(String.valueOf(this.jTextIBAN.getText()).replaceAll("-", ""));
        this.b_selezione.setIndirizzo(String.valueOf(this.jTextIndirizzo.getText()));
        this.b_selezione.setLocalita(String.valueOf(this.jTextLocalita.getText()));
        this.b_selezione.setProvincia(String.valueOf(this.jTextProvincia.getText()));
        this.b_selezione.setCodice(String.valueOf(this.jTextCodice.getText()));
        temp.seleziona(this.b_selezione.getCodice());
        this.b_selezione.setId_conto(temp.getId());
    }

    private boolean check() {
        String codice = this.jTextCodice.getText();
        if (this.jTextCap.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire un Cap valido");
            return false;
        }
        if (this.jTextConto.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire un Conto valido");
            return false;
        }
        if (this.jTextCodice.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire un Codice valido");
            return false;
        }
        if (this.jTextCodice.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire un Codice valido");
            return false;
        }
        if (codice.length() > 2 || codice.length() < 2) {
            JOptionPane.showMessageDialog(this, "il codice deve essere di due cifre");
            return false;
        }
        return true;
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                boolean check2 = this.b_selezione.inserisci(false);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci();
            boolean check2 = this.b_selezione.modifica(false);
            if (check2) {
                this.in_modifica = false;
                this.filtra();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento della modifica dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
            }
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.jPanelDettaglio = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jTextConto = new JTextField();
        this.jLabelConto = new JLabel();
        this.jLabelIBAN = new JLabel();
        this.jLabelIndirizzo = new JLabel();
        this.jTextIndirizzo = new JTextField();
        this.jLabelLocalita = new JLabel();
        this.jTextLocalita = new JTextField();
        this.jLabelCap = new JLabel();
        this.jTextCap = new JTextField();
        this.jLabelProvincia = new JLabel();
        this.jTextProvincia = new JTextField();
        this.jLabelCodice = new JLabel();
        this.jTextCodice = new JTextField();
        this.jTextIBAN = new JTextField();
        this.jPanel4 = new JPanel();
        this.jLabelNote = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextDescrizione = new JTextArea();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Anagrafiche \\ Banche");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyBanche.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyBanche.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBanche.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBanche.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBanche.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBanche.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBanche.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBanche.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBanche.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBanche.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBanche.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBanche.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBanche.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelDettaglio.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jTextConto.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyBanche.this.jTextContoKeyPressed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextConto, gridBagConstraints);
        this.jLabelConto.setText("Conto (F4 Scegli)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelConto, gridBagConstraints);
        this.jLabelIBAN.setText("IBAN: Nazione - Codice");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelIBAN, gridBagConstraints);
        this.jLabelIndirizzo.setText("Indirizzo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelIndirizzo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextIndirizzo, gridBagConstraints);
        this.jLabelLocalita.setText("Localit\u00e0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelLocalita, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextLocalita, gridBagConstraints);
        this.jLabelCap.setText("Cap");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCap, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextCap, gridBagConstraints);
        this.jLabelProvincia.setText("Provincia");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelProvincia, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextProvincia, gridBagConstraints);
        this.jLabelCodice.setText("Codice (Deve essere di due cifre es: 01-12-84)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCodice, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextCodice, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextIBAN, gridBagConstraints);
        this.jPanel2.add((Component)this.jPanel3, new GridBagConstraints());
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabelNote.setText("Descrizione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel4.add((Component)this.jLabelNote, gridBagConstraints);
        this.jTextDescrizione.setColumns(60);
        this.jTextDescrizione.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextDescrizione);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanelDettaglio.add((Component)this.jPanel2, "West");
        this.jTabbedPane1.addTab("Dettagli", this.jPanelDettaglio);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        this.in_new = true;
        this.jTableBanche.getSelectionModel().clearSelection();
        this.b_selezione = new Banca();
        this.azzera_maschera_iban = true;
        this.azzera();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        this.in_modifica = true;
        this.visualizzazione();
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
        this.jTabbedPane1.setSelectedIndex(1);
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare questa Banca?");
        if (res == 0) {
            this.b_selezione.elimina(res);
            this.in_modifica = false;
            this.filtra();
        }
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.btm.getRowCount() != 0) {
            this.jTableBanche.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        if (this.jTableBanche.getSelectedRow() > 0 && this.btm.getRowCount() != 0) {
            this.jTableBanche.getSelectionModel().setSelectionInterval(this.jTableBanche.getSelectedRow() - 1, this.jTableBanche.getSelectedRow() - 1);
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        try {
            if (this.btm.getRowCount() != 0) {
                this.jTableBanche.getSelectionModel().setSelectionInterval(this.jTableBanche.getSelectedRow() + 1, this.jTableBanche.getSelectedRow() + 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO PRIMO");
            err.printStackTrace();
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        try {
            if (this.btm.getRowCount() != 0) {
                this.jTableBanche.getSelectionModel().setSelectionInterval(this.btm.getRowCount() - 1, this.btm.getRowCount() - 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO ULTIMO");
            err.printStackTrace();
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            this.in_filter = true;
            String[] b_ric = new String[]{"", "", "", ""};
            this.bfm.addRow(b_ric);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.fixedTable.setCellSelectionEnabled(true);
            this.fixedTable.changeSelection(0, 0, false, false);
            this.fixedTable.requestFocus();
        } else {
            this.in_filter = false;
            this.bfm.deleteRow();
            this.bfm = new BancheFixedModel();
            this.fixedTable.setModel(this.bfm);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            this.sorter.setRowFilter(null);
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] b_ric = new String[]{"", "", "", ""};
            this.bfm = new BancheFixedModel();
            this.fixedTable.setModel(this.bfm);
            this.bfm.addRow(b_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.btm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jTextContoKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 115) {
            MyConto5 oggetto = new MyConto5();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
        }
    }

    private void posizione_finestra(ComponentEvent evt) {
        System.out.println("component moved");
        posizione_finestra = this.getLocation();
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        System.out.println("component resized");
        dimensione_finestra = this.getSize();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableBanche.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableBanche.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.btm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTable jtb = (JTable)e.getSource();
            int viewRow = jtb.getSelectedRow();
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableBanche.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow <= this.btm.getRowCount() - 1 && modelRow >= 0) {
                Banca b = new Banca();
                b = (Banca)this.insieme_b.vettoreBanca.elementAt(modelRow);
                if (this.chiamante != null) {
                    if (this.chiamante.getClass() == MyRegistrazioni.class && ((MyRegistrazioni)this.chiamante).f_ba_open) {
                        ((MyRegistrazioni)this.chiamante).jTextBancaAppoggio.setText(b.getDescrizione());
                        ((MyRegistrazioni)this.chiamante).f_ba_open = false;
                    }
                    if (this.chiamante.getClass() == MyDocumentiAttivi.class && ((MyDocumentiAttivi)this.chiamante).f_ba_open) {
                        ((MyDocumentiAttivi)this.chiamante).jTextBanca.setText(b.getDescrizione());
                        ((MyDocumentiAttivi)this.chiamante).f_ba_open = false;
                    }
                    if (this.chiamante.getClass() == MyFOut.class && ((MyFOut)this.chiamante).f_ba_open) {
                        ((MyFOut)this.chiamante).jTextBancaAppoggio.setText(b.getDescrizione());
                        ((MyFOut)this.chiamante).f_ba_open = false;
                    }
                    if (this.chiamante.getClass() == MyfpIN.class && ((MyfpIN)this.chiamante).f_ba_open) {
                        ((MyfpIN)this.chiamante).jTextBancaAppoggio.setText(b.getDescrizione());
                        ((MyfpIN)this.chiamante).f_ba_open = false;
                    }
                    if (this.chiamante.getClass() == MyncIN.class && ((MyncIN)this.chiamante).f_ba_open) {
                        ((MyncIN)this.chiamante).jTextBancaAppoggio.setText(b.getDescrizione());
                        ((MyncIN)this.chiamante).f_ba_open = false;
                    }
                    if (this.chiamante.getClass() == MyDDIManutenzione.class && ((MyDDIManutenzione)this.chiamante).f_ba_open) {
                        ((MyDDIManutenzione)this.chiamante).f_ba_open = false;
                    }
                    if (this.chiamante.getClass() == MyDAS.class && ((MyDAS)this.chiamante).f_ba_open) {
                        ((MyDAS)this.chiamante).jTextBancaAppoggio.setText(b.getDescrizione());
                        ((MyDAS)this.chiamante).f_ba_open = false;
                    }
                    if (this.chiamante.getClass() == MyTraFatturazione.class && ((MyTraFatturazione)this.chiamante).f_ba_open) {
                        ((MyTraFatturazione)this.chiamante).jTextBancaAppoggio.setText(b.getDescrizione());
                        ((MyTraFatturazione)this.chiamante).f_ba_open = false;
                    }
                    if (this.chiamante.getClass() == MyTraFattureAutostrade.class && ((MyTraFattureAutostrade)this.chiamante).f_ba_open) {
                        ((MyTraFattureAutostrade)this.chiamante).jTextBancaAppoggio.setText(b.getDescrizione());
                        ((MyTraFattureAutostrade)this.chiamante).f_ba_open = false;
                    }
                    this.dispose();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (this.chiamante != null) {
            if (this.chiamante.getClass() == MyRegistrazioni.class && ((MyRegistrazioni)this.chiamante).f_ba_open) {
                ((MyRegistrazioni)this.chiamante).f_ba_open = false;
            }
            if (this.chiamante.getClass() == MyDocumentiAttivi.class && ((MyDocumentiAttivi)this.chiamante).f_ba_open) {
                ((MyDocumentiAttivi)this.chiamante).f_ba_open = false;
            }
            if (this.chiamante.getClass() == MyfpIN.class && ((MyfpIN)this.chiamante).f_ba_open) {
                ((MyfpIN)this.chiamante).f_ba_open = false;
            }
            if (this.chiamante.getClass() == MyncIN.class && ((MyncIN)this.chiamante).f_ba_open) {
                ((MyncIN)this.chiamante).f_ba_open = false;
            }
            if (this.chiamante.getClass() == MyDAS.class && ((MyDAS)this.chiamante).f_ba_open) {
                ((MyDAS)this.chiamante).f_ba_open = false;
            }
            if (this.chiamante.getClass() == MyDDIManutenzione.class && ((MyDDIManutenzione)this.chiamante).f_ba_open) {
                ((MyDDIManutenzione)this.chiamante).f_ba_open = false;
            }
            if (this.chiamante.getClass() == MyFOut.class && ((MyFOut)this.chiamante).f_ba_open) {
                ((MyFOut)this.chiamante).f_ba_open = false;
            }
            if (this.chiamante.getClass() == MyTraFattureVettori.class && ((MyTraFattureVettori)this.chiamante).f_ba_open) {
                ((MyTraFattureVettori)this.chiamante).f_ba_open = false;
            }
            if (this.chiamante.getClass() == MyTraFatturazione.class && ((MyTraFatturazione)this.chiamante).f_ba_open) {
                ((MyTraFatturazione)this.chiamante).f_ba_open = false;
            }
            if (this.chiamante.getClass() == MyTraFattureAutostrade.class && ((MyTraFattureAutostrade)this.chiamante).f_ba_open) {
                ((MyTraFattureAutostrade)this.chiamante).f_ba_open = false;
            }
            this.dispose();
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<BancheTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            if (!MyBanche.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyBanche.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyBanche.this.rf = RowFilter.andFilter(MyBanche.this.andFilters);
                MyBanche.this.sorter.setRowFilter(MyBanche.this.rf);
                MyBanche.this.formatta();
            } else {
                String query = "SELECT * FROM  anag_banche WHERE abilita='1' ";
                if (col == 0) {
                    query = query + " AND codice LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 1) {
                    query = query + " AND conto LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 2) {
                    query = query + " AND descrizione LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 3) {
                    query = query + " AND IBAN LIKE '%" + this.tf.getText() + "%'";
                }
                query = query + "ORDER BY anag_banche.codice ASC LIMIT 0," + Configurazioni.righe_ricerca;
                MyBanche.this.insieme_b.caricamento(query);
                MyBanche.this.btm.setDataBanca(MyBanche.this.insieme_b.vettoreBanca);
                MyBanche.this.formatta();
            }
        }
    }
}

