/*
 * Decompiled with CFR 0.152.
 */
package anagrafiche.banche;

import anagrafiche.banche.IBAN;
import gestionale.configurazioni.Configurazioni;
import java.sql.ResultSet;
import java.util.Vector;
import utils.Funzioni;
import utils.MyTrace;

public class InsiemeIBAN {
    public Vector vettoreIBAN = new Vector();
    int colCount;
    public String[] headers;
    private final Funzioni f = new Funzioni();

    public int caricamento(String query) {
        this.vettoreIBAN = new Vector();
        int contatore = 0;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                ++contatore;
                try {
                    IBAN i = new IBAN();
                    String abicab = res.getString("cd_abicab");
                    i.setAbi(abicab.substring(0, 5));
                    i.setCab(abicab.substring(5, 10));
                    i.setBiccode(res.getString("biccode"));
                    i.setBickey(res.getString("bickey"));
                    i.setCap(res.getString("cap"));
                    i.setCd_nazione(res.getString("cd_nazione"));
                    i.setCd_provincia(res.getString("cd_provincia"));
                    i.setDescrizione(res.getString("descrizione").replaceAll("   ", ""));
                    i.setFiliale(res.getString("filiale").replaceAll("   ", ""));
                    i.setId(Integer.valueOf(res.getString("id")));
                    i.setIndirizzo(res.getString("indirizzo").replaceAll("   ", ""));
                    i.setLocalit\u00e0(res.getString("localita").replaceAll("   ", ""));
                    this.vettoreIBAN.addElement(i);
                }
                catch (Exception e) {
                    MyTrace.log.severe("Eccezione InsiemeIBAN(): problema per la riga " + contatore);
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreIBAN = new Vector();
            MyTrace.log.severe("Seleziona IBAN non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreIBAN.size();
    }
}

