<script language="JavaScript">

this.name ="utente";
var risposta_username;
var CodiceFiscale = Class.create();
CodiceFiscale.prototype = 
{
	_codiceFiscale : null,
	_dataDiNascita : null,
	_nome : null,
	_cognome : null,
	_arrayMesi : [null,'A','B','C','D','E','H','L','M','P','R','S','T'], // 1 based enumeration


	initialize: function(jsonArgs)
	{
		if(jsonArgs.codiceFiscale){this.setCodiceFiscale(jsonArgs.codiceFiscale);}
		if(jsonArgs.dataDiNascita){this.setDataDiNascita(jsonArgs.dataDiNascita);}
		if(jsonArgs.nome)         {this.setNome(jsonArgs.nome);}
		if(jsonArgs.cognome)      {this.setCognome(jsonArgs.cognome);}		
	},
	
	getCodiceFiscale : function()
	{
		return this._codiceFiscale;
	},


	setCodiceFiscale : function(codiceFiscale)
	{
		if (!codiceFiscale) 
		{
			window.alert("Istanziare l'oggetto CodiceFiscale solo se si ha un codice da controllare.");
			return false;
		}
		this._codiceFiscale = this._trim(codiceFiscale).toUpperCase();
	},

	getDataDiNascita : function()
	{
		return this._dataDiNascita;
	},

	// <comment>
	// dataDiNascita  un oggetto espresso in JSON {anno:'0000',mese:'00',giorno:'00'}
	// </comment>	
	setDataDiNascita : function(dataDiNascita)
	{
		if (this.isDataValida(dataDiNascita)>0)
		{
			this._dataDiNascita = dataDiNascita;
		}
	},

	isDataValida : function(jsonArgs)
	{
		var g = parseInt((""+jsonArgs.giorno).replace(/^[0]+/,'')); 
		var m = parseInt((""+jsonArgs.mese).replace(/^[0]+/,'')); 
		var a = parseInt(jsonArgs.anno);
		// <comment>
		// Prima di tutto anno e mese
		// </comment>
		if (isNaN(a) || (a > 2100 )     ) { return -1; }
		if (isNaN(m) || !(m>=1 && m<=12)) { return -2; }

		// <comment>
		// E' bisestile?? 
		// </comment>
		var estBisestile = ((a%4)==0 && (a%100) != 0 || (a%400) == 0)?1:0;
		var ggMesi = Array();
		ggMesi[1]  = 31; ggMesi[2]  = (estBisestile)?29:28; ggMesi[3]  = 31; ggMesi[4]  = 30; 
		ggMesi[5]  = 31; ggMesi[6]  = 30;                   ggMesi[7]  = 31; ggMesi[8]  = 31;                   
		ggMesi[9]  = 30; ggMesi[10] = 31;                   ggMesi[11] = 30; ggMesi[12] = 31;
		if(isNaN(g) || g<1 || g>ggMesi[m]) { return -3; }

		return 1;
	},

	controllaDataDiNascita:function()
	{
		d = this.getDataDiNascita();
		AA = (''+d.anno).substr(2); M = this._arrayMesi[d.mese]; GG = d.giorno;

		fCase = ""+AA+M+(GG+40); // caso femmina
		mCase = ""+AA+M+(GG); // caso maschio

		subStrData = this.getCodiceFiscale().substring(6,11);

		return (subStrData == mCase || subStrData == fCase)?"0":"1";

	},

	getNome : function()
	{
		return this._nome;
	},


	setNome : function(nome)
	{
		this._nome = this._trim(nome).toUpperCase();
	},


	getCognome : function()
	{
		return this._cognome;
	},

	setCognome : function(cognome)
	{
		this._cognome = this._trim(cognome).toUpperCase();
	},

	controllaOnomastica: function()
	{
		codicefiscale = this.getCodiceFiscale();
		podc = codicefiscale.substring(0,6); // parte onomastica di confronto
		
		nome = this.getNome();
		cognome = this.getCognome();


		n = nome.replace(/[\s]+/g,'').split('');
		c = cognome.replace(/[\s]+/g,'').split('');
		
		vocali = 'AEIOU';
		consonanti = 'BCDFGHJKLMNPQRSTVWXYZ';
		
		cc = Array(); // consonanti cognome
		vc = Array(); // vocali cognome

		for(i=0; lettera = c[i++];)
		{
			if ( consonanti.indexOf(lettera) != -1 ) { cc.push(lettera); }
			if ( vocali.indexOf(lettera) != -1 ) { vc.push(lettera); }
		}
		
		
		

		cn = Array(); // consonanti nome
		vn = Array(); // vocali nome
		for(i=0; lettera = n[i++];)
		{
			if ( consonanti.indexOf(lettera) != -1 ) { cn.push(lettera); }
			if ( vocali.indexOf(lettera) != -1 ) { vn.push(lettera); }
		}

		
		pc = (cc[2])?cc[0]+cc[1]+cc[2]:''; // parte cognome
		for (i=0;pc.length < 3 && cc[i];) { pc += cc[i++];}
		for ($i=0;pc.length < 3 && vc[i];) { pc += vc[i++];}
		for (;pc.length < 3;) { pc += 'X'; }
		
		pn = (cn[3])?cn[0]+cn[2]+cn[3]:''; // parte nome
		for (i=0;pn.length < 3 && cn[i];) { pn += cn[i++]; }
		for (i=0;pn.length < 3 && vn[i];) { pn += vn[i++]; }
		for (;pn.length < 3;) { pn += 'X'; }
		
		po = pc+pn; // parte onomastica = parte nome + parte cognome
		
		return (po == podc)?'0':'1';

	},


	_trim : function(s)
	{
		return s.replace(/^[\s]+|[\s]+$/g,"");
	},
	
	controllaErrori : function()
	{
		try
		{
			cf = this.getCodiceFiscale();
	
			// <comment>
			//	Restituisce una stringa di 3 bit aventi il seguente significato:
			//	Bit nro 1: Se 1 => Errore di lunghezza
			//	Bit nro 2: Se 1 => Pattern LLLLLLCCLCCLCCCL non rispettato (L = lettera, C = cifra)
			//	Bit nro 3: Se 1 => Carattere di controllo X(LLLLLLCCLCCLCCCX) non coerente
			// </comment> 

			var validi  = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"; 
			var set1    = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
			var set2    = "ABCDEFGHIJABCDEFGHIJKLMNOPQRSTUVWXYZ";
			var setpari = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
			var setdisp = "BAKPLCQDREVOSFTGUHMINJWZYX";
			var s = 0;

			// <comment>
			// Non controllo il nulla
			// </comment>			
			if( cf == '' )  return '000'; 
			cf = cf.toUpperCase();
			if( cf.length != 16 )
			{
				window.alert("La lunghezza del codice fiscale non e' \n" +
				             "corretta: il codice fiscale dovrebbe essere lungo \n"+
				             "esattamente 16 caratteri.\n");
				return '100';		 
			}			 
			
			for( i = 0; i < 16; i++ )
			{
				if( validi.indexOf( cf.charAt(i) ) == -1 )
				{
					window.alert( "Il codice fiscale contiene un carattere non valido '"
					            + cf.charAt(i)
									+ "'.\nI caratteri validi sono le lettere e le cifre.\n" );
					return '010';		 
				}			 
			}
			
			for( i = 1; i <= 13; i += 2 ){s += setpari.indexOf( set2.charAt( set1.indexOf( cf.charAt(i) )));}
			for( i = 0; i <= 14; i += 2 ){s += setdisp.indexOf( set2.charAt( set1.indexOf( cf.charAt(i) )));}
			if( s%26 != cf.charCodeAt(15)-'A'.charCodeAt(0) )
			{
				window.alert("Il codice fiscale non e' corretto:\n"+
				   	       "il codice di controllo non corrisponde.\n");
				return '001';				 
			}			 
			
			 return '000';
			 
		} catch (e) {}	
	},
	
	controlla: function()
	{
		/*
			Restituisce una stringa di 5 bit aventi il seguente significato:
			Bit nro 1: Se 1 => Errore di lunghezza
			Bit nro 2: Se 1 => Pattern LLLLLLCCLCCLCCCL non rispettato (L = lettera, C = cifra)
			Bit nro 3: Se 1 => Carattere di controllo X(LLLLLLCCLCCLCCCX) non coerente
			Bit nro 4: Se 1 => "Data di nascita di riferimento" e "data di nascita 
						  			 nel codice fiscale" non coerenti
			Bit nro 5: Se 1 => "Nome-Cognome" e "parte onomastica del codice fiscale" non coerenti
		 */
		if (!this.getCodiceFiscale()) { return '00000';}
		controllo = this.controllaErrori();
		controllo += this.controllaDataDiNascita();
		controllo += this.controllaOnomastica();
		return controllo;
	}
	
}
/*

jsonArgs = {
				 codiceFiscale : 'LCHSFN75M24G478D',
				 nome:'stefano'					,
				 cognome:'luchetti',
				 dataDiNascita : {anno:1975,mese:8,giorno:24}
			  }
	

ccf = new CodiceFiscale(jsonArgs);
alert(ccf.controlla());
*/

function controlla_cf()
{
	cod=document.getElementById('codice_fiscale').value.toLowerCase();
	check=true;
	if (cod.length!=16)
		check=false
	else
	{
		lettere=cod.substr(0,6)+cod.substr(8,1)+cod.substr(11,1)+cod.substr(15);
		numeri=cod.substr(6,2)+cod.substr(9,2)+cod.substr(12,3);
		for (i=0;i<10;i++)
			if (lettere.charCodeAt(i)<97 || lettere.charCodeAt(i)>122)
				check=false;
		for (i=0;i<8;i++)
			if (numeri.charCodeAt(i)<48 || numeri.charCodeAt(i)>57)
				check=false;
	}
	return check;
}

/*
var ControlloreDiCf = Class.create();
ControlloreDiCf.prototype = 
{
	cod     = document.getElementById('codice_fiscale').value.toLowerCase();
	name   = document.getElementById('nome').value.toLowerCase();
	surname = document.getElementById('cognome').value.toLowerCase();
	m 		  = document.getElementById('data_nMonth').value;
	d 		  = document.getElementById('data_nDay').value;
	y 		  = document.getElementById('data_nYear').value;
	arrayMesi = Array	( "01" => "A",	"02" => "B", "03" => "C",
										 "04" => "D", "05" => "E", "06" => "H",
										 "07" => "L",	"08" => "M", "09" => "P",
		     							 "10" => "R", "11" => "S", "12" => "T" ); 
	check _cf :function()
	{
		this.validator_cf();
		this.validator_nameBirth_cf();
	}
	
	validator_cf:function()
	{
		check=true;
	if (cod.length!=16)
		check=false
	else
	{
		lettere=cod.substr(0,6)+cod.substr(8,1)+cod.substr(11,1)+cod.substr(15);
		numeri=cod.substr(6,2)+cod.substr(9,2)+cod.substr(12,3);
		for (i=0;i<10;i++)
			if (lettere.charCodeAt(i)<97 || lettere.charCodeAt(i)>122)
		check=false;
		for (i=0;i<8;i++)
			if (numeri.charCodeAt(i)<48 || numeri.charCodeAt(i)>57)
		check=false;
		}
		
		return check;
	}
	
	validator_nameBirth_cf:function()
	{
	 	result = 0;
			
	}

}
*/
function switch_form(selected_value) 
{
	//alert(document.getElementById("specifico_socio").style.display);
	document.getElementById("specifico_socio").style.display = (selected_value  == "3")?"none":"";
}

/*
function sel_tipo()
{
<?php if ($identita==3){ ?>
    
	document.getElementById("altro_utente").className="visible";
	document.getElementById("socio").className="invisible";
<?php }else { ?>
    
 	document.getElementById("altro_utente").className="invisible";
	document.getElementById("socio").className="visible";
 <?php } ?>

}
*/

var estDataValida = function(giorno,mese,anno)
{  
	//var data = new Date();
	var g = parseInt((""+giorno).replace(/^[0]+/,'')); 
	var m = parseInt((""+mese).replace(/^[0]+/,'')); 
	var a = parseInt(anno);
	// Prima di tutto anno e mese
	if (isNaN(a) || (a > 2100 )) return -1;
	if (isNaN(m) || !(m>=1 && m<=12)) return -2;
	//if(a == data.getFullYear() && m > data.getMonth()) return -4;
	//if(a == data.getFullYear() && m >= data.getMonth() && g > data.getDay() ) return -4;
		// E' bisestile?? 
	var estBisestile = ((a%4)==0 && (a%100) != 0 || (a%400) == 0)?1:0;
	var ggMesi = Array();
	ggMesi[1]  = 31; ggMesi[2]  = (estBisestile)?29:28; ggMesi[3]  = 31; ggMesi[4]  = 30; 
	ggMesi[5]  = 31; ggMesi[6]  = 30;                   ggMesi[7]  = 31; ggMesi[8]  = 31;                   
	ggMesi[9]  = 30; ggMesi[10] = 31;                   ggMesi[11] = 30; ggMesi[12] = 31;
	if(isNaN(g) || g<1 || g>ggMesi[m])return -3;
	return 1;
}


/**
 * Funzione che controlla la consecutivit di data2 rispetto a data1:
 * Es.: 20070215 > 20070214  true (15 Febbraio 2007 viene dopo il 14) i.e.
 * suntConsecutive(new Array(14,02,2007),new Array(15,02,2007)) // true
 * suntConsecutive(new Array(15,02,2007),new Array(14,02,2007)) // false
 */
var suntConsecutive = function(arrayData1,arrayData2, orEqualFlag)
{
	orEqual = (orEqualFlag)?orEqualFlag:false;
	
	if (!estDataValida(arrayData1[0],arrayData1[1],arrayData1[2])) 
	{
		window.alert(arrayData1[0]+"-"+arrayData1[1]+"-"+arrayData1[2]+" sembra scorretta!");
		return false; 
	}
	
	if (!estDataValida(arrayData2[0],arrayData2[1],arrayData2[2])) 
	{
		window.alert(arrayData2[0]+"-"+arrayData2[1]+"-"+arrayData2[2]+" sembra scorretta!");
		return false; 
	}
	
	data1 = ""+arrayData1[2]+arrayData1[1]+arrayData1[0];
	data2 = ""+arrayData2[2]+arrayData2[1]+arrayData2[0];

	condizione = (orEqual)?data2 >= data1:data2 > data1;

	return (condizione)?true:false;
}


function check()
{	

	var form = "form_utenti";

	var year  = $('today').value.substring(0,4);
	var month = $('today').value.substring(5,7);
	var day   = $('today').value.substring(8,10);	
	var arrayDataOggi = new Array(day, month, year);

	if (!$('id_identita').value)
	{
		alert("Scegliere l'identit dell'utente!");
		$('id_identita').focus();
		return false;
	}

	
	if($('id_identita').value !=3 && !$('id_regione').value)
	{
		alert("Scegliere la regione di riferimento!!");
		$('id_regione').focus();
		return false
	}
	
	
	if( ($('data_nDay').value != "") || ($('data_nMonth').value!="") || ($('data_nYear').value !="") )
	{
		var arrayDataNascita = new Array($('data_nDay').value,$('data_nMonth').value,$('data_nYear').value);
		dataNascitaValida = estDataValida(arrayDataNascita[0],arrayDataNascita[1],arrayDataNascita[2]);

		if (dataNascitaValida < 0) 
		{ 
			//alert(dataNascitaValida);
			messaggio  = " La data di Nascita ";
			messaggio += "'"+arrayDataNascita[0]+"-"+arrayDataNascita[1]+"-"+arrayDataNascita[2]+"'";
			messaggio += " sembra scorretta o esterna all'intervallo [1900;2100] !";
			window.alert(messaggio); 
			$('data_nDay').select();
			return false;
		}

		if (suntConsecutive(arrayDataOggi,arrayDataNascita,0))
		{	
			messaggio  = " La data di Nascita ("+arrayDataNascita[0]+"-"+arrayDataNascita[1]+"-"+arrayDataNascita[2]+")";
			messaggio += " deve precedere la data di oggi ("+arrayDataOggi[0]+"-"+arrayDataOggi[1]+"-"+arrayDataOggi[2]+")!";
			window.alert(messaggio); 
			$('data_nDay').select();
			return false;
		}
	}

	if( $('id_identita').value !=3 && 
	   (( $('data_iscrizioneDay').value   != "" ) || 
		(  $('data_iscrizioneMonth').value !=""  ) || 
		(  $('data_iscrizioneYear').value  !=""  ) ))
	{
		var arrayDataIscrizione = new Array($('data_iscrizioneDay').value,$('data_iscrizioneMonth').value,$('data_iscrizioneYear').value);
		dataIscrizioneValida = estDataValida(arrayDataIscrizione[0],arrayDataIscrizione[1],arrayDataIscrizione[2]);

		if (dataIscrizioneValida < 0) 
		{
			messaggio  = " La data di iscrizione ";
			messaggio += "'"+arrayDataIscrizione[0]+"-"+arrayDataIscrizione[1]+"-"+arrayDataIscrizione[2]+"'";
			messaggio += " sembra scorretta o esterna all'intervallo [1900;2100] !";
			window.alert(messaggio); 
			$('data_iscrizioneDay').select();
			return false;
		}

		if (suntConsecutive(arrayDataOggi,arrayDataIscrizione,0) )
		{
			messaggio  = " La data di iscrizione ("+arrayDataIscrizione[0]+"-"+arrayDataIscrizione[1]+"-"+arrayDataIscrizione[2]+")";
			messaggio += " deve precedere od essere al pi uguale alla ";
			messaggio += " data di oggi ("+arrayDataOggi[0]+"-"+arrayDataOggi[1]+"-"+arrayDataOggi[2]+")!";
			window.alert(messaggio);
			$('data_iscrizioneDay').select();
			return false;
		}
	}
	if($('codice_fiscale').value)
	{
		 
	if(controlla_cf()==false){
	
	alert("Il codice fiscale risulta scorretto!!")
	return false;
	}
	return true;
	}
	if(!$('id_gruppo').value)
	{
		alert("Inserire la tipologia di accesso al software!!");
		$('id_gruppo').focus();
		return false;
	}
	
	if(!$('nome').value)
	{
		alert("Inserire il nome!");
		$('nome').focus();
		return false;
	}

	if(!$('cognome').value)
	{
		alert("Inserire il cognome!!");
		$('cognome').focus();
		return false;
	}
	
	if(!$('username').value)
	{
		alert("Inserire lo username!!");
		$('username').focus();
		return false;
	}
	else
	{ 
	/*	check_username();
		if($('risposta_username').value == false) 
		return false;*/
	}
	if(!$('password').value)
		{
			alert("Inserire la password!!");
			$('password').focus();
			return false;
		}

	return true;

}
function check_username()
{
		var url = '/AMD/utenti/query/q_utenti_username_sel.php';
		var pars = 'username='+$F('username');
		var richiesta = new Ajax.Request(
				url,
				{
					method: 'post',
					parameters: pars,
					onComplete: visualizza_risposta,
					asynchronous: false
				}
			);
			
}
function visualizza_risposta(originalRequest)
{
	if(originalRequest.responseText==true)
	{
		alert("Username gi in uso");
		$('username').focus(); 
		$('risposta_username').value = false;
	}
	else
	{
		$('risposta_username').value = true;
	}
}

/////////////////////////////    SALVA dal CLIENT

//Funzione per il popup per l'inserimento dell'allegato
function popup_password()
{   
	my_window= window.open ("./cambia_password.php","CAMBIA_PASSWORD","status=no,width=450,height=140,top=200,left=300,Resizable=no,Scrollbars=no"); 
	
}

function popup_centro()
{
		my_window = window.open ("./index.php?sezione=centri&pop_up=1","VISUALIZZA_CENTRI",										        "status=no,width=750,height=550,top=100,left=200,Resizable=yes,Scrollbars=yes");
}

function cripta_password(field){
	field.value = hex_md5(field.value);
}

function home()
{
document.location.href="./index.php";
}

function torna()
{
		document.forms["form_utenti"].modo.value="RICERCA";
		document.forms["form_utenti"].target="utenti";
		document.forms["form_utenti"].action = "./index.php?sezione=VIS&profilo=<?php echo  @$profilo ?>&pop_up=<?php echo  $pop_up ?>&opener=<?php echo  $opener ?>";
		document.forms["form_utenti"].submit();
}

function torna_indietro(numero_della_pagina)
{
	if (isNaN(numero_della_pagina/2))return;

	pagina = (numero_della_pagina)?((numero_della_pagina > parseInt($('pagine').value))?$('pagine').value:numero_della_pagina):1;
	da     = 30 * (pagina-1);
	
   document.forms["form_utenti"].action = "./index.php?sezione=VIS&da="+da+"&pagina="+pagina;
	document.forms["form_utenti"].modo.value="RICERCA";
	document.forms["form_utenti"].target  =  "_self";
   document.forms["form_utenti"].submit();
}

function btn_salva_modifiche_click(id) 
{
   if(check())	
	{
	$('controllers').modo.value = "vis";
	$('controllers').azione.value = "upd"; 

	var added_fields = "";

		var added_fields = "";
			added_fields  += "<input type=\"hidden\" name=\"id\" value=\""+id+"\" />\n";//'nome'		
			added_fields  += "<input type=\"hidden\" name=\"nome\" value=\""+$('nome').value+"\" />\n";//'nome'		
			added_fields  += "<input type=\"hidden\" name=\"cognome\" value=\""+$('cognome').value+"\" />\n";//'cognome'
			if($('maschio').checked) sex=0;
			if($('femmina').checked) sex=1;
			//alert(sex);
			added_fields  += "<input type=\"hidden\" name=\"sesso\" value=\""+sex+"\" />\n";//'sesso'

			if ($('id_identita').value != 3)
			{
				added_fields  += "<input type=\"hidden\" name=\"data_iscrizioneYear\" value=\""+$('data_iscrizioneYear').value+"\" />\n";//'data_iscrizioneYear'
				added_fields  += "<input type=\"hidden\" name=\"data_iscrizioneMonth\" value=\""+$('data_iscrizioneMonth').value+"\" />\n";//'data_iscrizioneMonth'
				added_fields  += "<input type=\"hidden\" name=\"data_iscrizioneDay\" value=\""+$('data_iscrizioneDay').value+"\" />\n";//'data_iscrizioneDay'
				added_fields  += "<input type=\"hidden\" name=\"ruolo_cdn\" value=\""+$('id_ruolo_cdn').value+"\" />\n";//'ruolo_cdn'
				added_fields  += "<input type=\"hidden\" name=\"ruolo_cdr\" value=\""+$('id_ruolo_cdr').value+"\" />\n";//'ruolo_cdr'
				added_fields  += "<input type=\"hidden\" name=\"id_centro\" value=\""+$('id_centro').value+"\" />\n";//'id_centro'
				added_fields  += "<input type=\"hidden\" name=\"nome_centro\" value=\""+$('nome_centro').value+"\" />\n";//'nome_centro'
			}

			added_fields  += "<input type=\"hidden\" name=\"data_nYear_s\" value=\""+$('data_nYear').value+"\" />\n";//'data_nYear_s'
			added_fields  += "<input type=\"hidden\" name=\"data_nMonth_s\" value=\""+$('data_nMonth').value+"\" />\n";//'data_nMonth_s'
			added_fields  += "<input type=\"hidden\" name=\"data_nDay_s\" value=\""+$('data_nDay').value+"\" />\n";//'data_nDay_s'
			added_fields  += "<input type=\"hidden\" name=\"data_nYear\" value=\""+$('data_nYear').value+"\" />\n";//'data_nYear'
			added_fields  += "<input type=\"hidden\" name=\"data_nMonth\" value=\""+$('data_nMonth').value+"\" />\n";//'data_nMonth'
			added_fields  += "<input type=\"hidden\" name=\"data_nDay\" value=\""+$('data_nDay').value+"\" />\n";//'data_nDay'
			added_fields  += "<input type=\"hidden\" name=\"luogo_n_s\" value=\""+$('luogo_n').value+"\" />\n";//'luogo_n_s'
			added_fields  += "<input type=\"hidden\" name=\"luogo_n\" value=\""+$('luogo_n').value+"\" />\n";//'luogo_n'
			added_fields  += "<input type=\"hidden\" name=\"codice_fiscale_s\" value=\""+$('codice_fiscale').value+"\" />\n";//'codice_fiscale_s'
			added_fields  += "<input type=\"hidden\" name=\"codice_fiscale\" value=\""+$('codice_fiscale').value+"\" />\n";//'codice_fiscale'
			added_fields  += "<input type=\"hidden\" name=\"indirizzo_s\" value=\""+$('indirizzo').value+"\" />\n";//'indirizzo_s'
			added_fields  += "<input type=\"hidden\" name=\"indirizzo\" value=\""+$('indirizzo').value+"\" />\n";//'indirizzo'
			added_fields  += "<input type=\"hidden\" name=\"cap_s\" value=\""+$('cap').value+"\" />\n";//'cap_s'
			added_fields  += "<input type=\"hidden\" name=\"cap\" value=\""+$('cap').value+"\" />\n";//'cap'
			added_fields  += "<input type=\"hidden\" name=\"citta_s\" value=\""+$('citta').value+"\" />\n";//'citta_s'
			added_fields  += "<input type=\"hidden\" name=\"citta\" value=\""+$('citta').value+"\" />\n";//'citta'
			added_fields  += "<input type=\"hidden\" name=\"provincia_s\" value=\""+$('provincia').value+"\" />\n";//'provincia_s'
			added_fields  += "<input type=\"hidden\" name=\"provincia\" value=\""+$('provincia').value+"\" />\n";//'provincia'
			added_fields  += "<input type=\"hidden\" name=\"telefono_s\" value=\""+$('telefono').value+"\" />\n";//'telefono_s'
			added_fields  += "<input type=\"hidden\" name=\"telefono\" value=\""+$('telefono').value+"\" />\n";//'telefono'
			added_fields  += "<input type=\"hidden\" name=\"fax\" value=\""+$('fax').value+"\" />\n";//'fax'
			added_fields  += "<input type=\"hidden\" name=\"fax_l\" value=\""+$('fax_l').value+"\" />\n";//'fax_l'
			added_fields  += "<input type=\"hidden\" name=\"cellulare\" value=\""+$('cellulare').value+"\" />\n";//'cellulare'
			added_fields  += "<input type=\"hidden\" name=\"email\" value=\""+$('email').value+"\" />\n";//'email'
			added_fields  += "<input type=\"hidden\" name=\"ufficio\" value=\""+$('ufficio').value+"\" />\n";//'ufficio'
			added_fields  += "<input type=\"hidden\" name=\"indirizzo_l\" value=\""+$('indirizzo_l').value+"\" />\n";//'indirizzo_l'
			added_fields  += "<input type=\"hidden\" name=\"cap_l\" value=\""+$('cap_l').value+"\" />\n";//'cap_l'
			added_fields  += "<input type=\"hidden\" name=\"citta_l\" value=\""+$('citta_l').value+"\" />\n";//'citta_l'
			added_fields  += "<input type=\"hidden\" name=\"provincia_l\" value=\""+$('provincia_l').value+"\" />\n";//'provincia_l'
			added_fields  += "<input type=\"hidden\" name=\"telefono_l\" value=\""+$('telefono_l').value+"\" />\n";//'telefono_l'
			added_fields  += "<input type=\"hidden\" name=\"email_l\" value=\""+$('email_l').value+"\" />\n";//'email_l'
			added_fields  += "<input type=\"hidden\" name=\"note\" value=\""+$('note').value+"\" />\n";//'note'
			added_fields  += "<input type=\"hidden\" name=\"regione_s\" value=\""+$('id_regione').value+"\" />\n";//'regione_s'
			added_fields  += "<input type=\"hidden\" name=\"regione\" value=\""+$('id_regione').value+"\" />\n";//'regione'
			added_fields  += "<input type=\"hidden\" name=\"username\" value=\""+$('username').value+"\" />\n";//'username'
//		added_fields  += "<input type=\"hidden\" name=\"codice_utente\" value=\""+$('codice_utente').value+"\" />\n";//'codice_utente'
 			added_fields  += "<input type=\"hidden\" name=\"password\" value=\""+$('password').value+"\" />\n";//'password'
			added_fields  += "<input type=\"hidden\" name=\"gruppo\" value=\""+$('id_gruppo').value+"\" />\n";//'gruppo'
			added_fields  += "<input type=\"hidden\" name=\"identita\" value=\""+$('id_identita').value+"\" />\n";//'identita'
			added_fields  += "<input type=\"hidden\" name=\"pagina\" value=\""+$('pagina').value+"\" />\n";//'identita'
//		added_fields  += "<input type=\"hidden\" name=\"id\" value=\""+$('id').value+"\" />\n";//'id'
//		added_fields  += "<input type=\"hidden\" name=\"anno\" value=\""+$('anno').value+"\" />\n";//'anno'
//		added_fields  += "<input type=\"hidden\" name=\"pagamento\" value=\""+$('pagamento').value+"\" />\n";//'pagamento'
		   added_fields  += "<input type=\"hidden\" name=\"titolo\" value=\""+$('id_titolo').value+"\" />\n";//'titolo'


		$('controllers').target="_self";
		$('controllers').innerHTML += added_fields;


	$('controllers').action = "/<?php echo  $sito ?>/utenti/index_new.php?sezione=<?php echo  $sezione ?><?php echo  ($pop_up)? "&pop_up=true":""; ?>";
	$('controllers').submit();
	}

}

function btn_inserisci_click()
{
	if(this.check())
	{
		$('controllers').modo.value = "vis";
		$('controllers').azione.value = "ins"; 
		var added_fields = "";


			added_fields  += "<input type=\"hidden\" name=\"nome\" value=\""+$('nome').value+"\" />\n";//'nome'		
			added_fields  += "<input type=\"hidden\" name=\"cognome\" value=\""+$('cognome').value+"\" />\n";//'cognome'
			if($('maschio').checked) sex=0;
			if($('femmina').checked) sex=1;
			//alert(sex);
			added_fields  += "<input type=\"hidden\" name=\"sesso\" value=\""+sex+"\" />\n";//'sesso'
			if ($('id_identita').value != 3)
			{
				added_fields  += "<input type=\"hidden\" name=\"data_iscrizioneYear\" value=\""+$('data_iscrizioneYear').value+"\" />\n";//'data_iscrizioneYear'
				added_fields  += "<input type=\"hidden\" name=\"data_iscrizioneMonth\" value=\""+$('data_iscrizioneMonth').value+"\" />\n";//'data_iscrizioneMonth'
				added_fields  += "<input type=\"hidden\" name=\"data_iscrizioneDay\" value=\""+$('data_iscrizioneDay').value+"\" />\n";//'data_iscrizioneDay'
				added_fields  += "<input type=\"hidden\" name=\"ruolo_cdn\" value=\""+$('id_ruolo_cdn').value+"\" />\n";//'ruolo_cdn'
				added_fields  += "<input type=\"hidden\" name=\"ruolo_cdr\" value=\""+$('id_ruolo_cdr').value+"\" />\n";//'ruolo_cdr'
				added_fields  += "<input type=\"hidden\" name=\"id_centro\" value=\""+$('id_centro').value+"\" />\n";//'id_centro'
				added_fields  += "<input type=\"hidden\" name=\"nome_centro\" value=\""+$('nome_centro').value+"\" />\n";//'nome_centro'
			}

			added_fields  += "<input type=\"hidden\" name=\"data_nYear_s\" value=\""+$('data_nYear').value+"\" />\n";//'data_nYear_s'
			added_fields  += "<input type=\"hidden\" name=\"data_nMonth_s\" value=\""+$('data_nMonth').value+"\" />\n";//'data_nMonth_s'
			added_fields  += "<input type=\"hidden\" name=\"data_nDay_s\" value=\""+$('data_nDay').value+"\" />\n";//'data_nDay_s'
			added_fields  += "<input type=\"hidden\" name=\"data_nYear\" value=\""+$('data_nYear').value+"\" />\n";//'data_nYear'
			added_fields  += "<input type=\"hidden\" name=\"data_nMonth\" value=\""+$('data_nMonth').value+"\" />\n";//'data_nMonth'
			added_fields  += "<input type=\"hidden\" name=\"data_nDay\" value=\""+$('data_nDay').value+"\" />\n";//'data_nDay'
			added_fields  += "<input type=\"hidden\" name=\"luogo_n_s\" value=\""+$('luogo_n').value+"\" />\n";//'luogo_n_s'
			added_fields  += "<input type=\"hidden\" name=\"luogo_n\" value=\""+$('luogo_n').value+"\" />\n";//'luogo_n'
			added_fields  += "<input type=\"hidden\" name=\"codice_fiscale_s\" value=\""+$('codice_fiscale').value+"\" />\n";//'codice_fiscale_s'
			added_fields  += "<input type=\"hidden\" name=\"codice_fiscale\" value=\""+$('codice_fiscale').value+"\" />\n";//'codice_fiscale'
			added_fields  += "<input type=\"hidden\" name=\"indirizzo_s\" value=\""+$('indirizzo').value+"\" />\n";//'indirizzo_s'
			added_fields  += "<input type=\"hidden\" name=\"indirizzo\" value=\""+$('indirizzo').value+"\" />\n";//'indirizzo'
			added_fields  += "<input type=\"hidden\" name=\"cap_s\" value=\""+$('cap').value+"\" />\n";//'cap_s'
			added_fields  += "<input type=\"hidden\" name=\"cap\" value=\""+$('cap').value+"\" />\n";//'cap'
			added_fields  += "<input type=\"hidden\" name=\"citta_s\" value=\""+$('citta').value+"\" />\n";//'citta_s'
			added_fields  += "<input type=\"hidden\" name=\"citta\" value=\""+$('citta').value+"\" />\n";//'citta'
			added_fields  += "<input type=\"hidden\" name=\"provincia_s\" value=\""+$('provincia').value+"\" />\n";//'provincia_s'
			added_fields  += "<input type=\"hidden\" name=\"provincia\" value=\""+$('provincia').value+"\" />\n";//'provincia'
			added_fields  += "<input type=\"hidden\" name=\"telefono_s\" value=\""+$('telefono').value+"\" />\n";//'telefono_s'
			added_fields  += "<input type=\"hidden\" name=\"telefono\" value=\""+$('telefono').value+"\" />\n";//'telefono'
			added_fields  += "<input type=\"hidden\" name=\"fax\" value=\""+$('fax').value+"\" />\n";//'fax'
			added_fields  += "<input type=\"hidden\" name=\"fax_l\" value=\""+$('fax_l').value+"\" />\n";//'fax_l'
			added_fields  += "<input type=\"hidden\" name=\"cellulare\" value=\""+$('cellulare').value+"\" />\n";//'cellulare'
			added_fields  += "<input type=\"hidden\" name=\"email\" value=\""+$('email').value+"\" />\n";//'email'
			added_fields  += "<input type=\"hidden\" name=\"ufficio\" value=\""+$('ufficio').value+"\" />\n";//'ufficio'
			added_fields  += "<input type=\"hidden\" name=\"indirizzo_l\" value=\""+$('indirizzo_l').value+"\" />\n";//'indirizzo_l'
			added_fields  += "<input type=\"hidden\" name=\"cap_l\" value=\""+$('cap_l').value+"\" />\n";//'cap_l'
			added_fields  += "<input type=\"hidden\" name=\"citta_l\" value=\""+$('citta_l').value+"\" />\n";//'citta_l'
			added_fields  += "<input type=\"hidden\" name=\"provincia_l\" value=\""+$('provincia_l').value+"\" />\n";//'provincia_l'
			added_fields  += "<input type=\"hidden\" name=\"telefono_l\" value=\""+$('telefono_l').value+"\" />\n";//'telefono_l'
			added_fields  += "<input type=\"hidden\" name=\"email_l\" value=\""+$('email_l').value+"\" />\n";//'email_l'
			added_fields  += "<input type=\"hidden\" name=\"note\" value=\""+$('note').value+"\" />\n";//'note'
			added_fields  += "<input type=\"hidden\" name=\"regione_s\" value=\""+$('id_regione').value+"\" />\n";//'regione_s'
			added_fields  += "<input type=\"hidden\" name=\"regione\" value=\""+$('id_regione').value+"\" />\n";//'regione'
			added_fields  += "<input type=\"hidden\" name=\"username\" value=\""+$('username').value+"\" />\n";//'username'
//		added_fields  += "<input type=\"hidden\" name=\"codice_utente\" value=\""+$('codice_utente').value+"\" />\n";//'codice_utente'
			added_fields  += "<input type=\"hidden\" name=\"pagina\" value=\""+$('pagina').value+"\" />\n";//'identita'
 			added_fields  += "<input type=\"hidden\" name=\"password\" value=\""+$('password').value+"\" />\n";//'password'
			added_fields  += "<input type=\"hidden\" name=\"gruppo\" value=\""+$('id_gruppo').value+"\" />\n";//'gruppo'
			added_fields  += "<input type=\"hidden\" name=\"identita\" value=\""+$('id_identita').value+"\" />\n";//'identita'
//		added_fields  += "<input type=\"hidden\" name=\"id\" value=\""+$('id').value+"\" />\n";//'id'
//		added_fields  += "<input type=\"hidden\" name=\"anno\" value=\""+$('anno').value+"\" />\n";//'anno'
//		added_fields  += "<input type=\"hidden\" name=\"pagamento\" value=\""+$('pagamento').value+"\" />\n";//'pagamento'
		   added_fields  += "<input type=\"hidden\" name=\"titolo\" value=\""+$('id_titolo').value+"\" />\n";//'titolo'


		$('controllers').target="_self";
		$('controllers').innerHTML += added_fields;


		$('controllers').action = "/<?php echo  $sito ?>/utenti/index_new.php?sezione=<?php echo  $sezione ?><?php echo  ($pop_up)? "&pop_up=true":""; ?>";
		$('controllers').submit();
	} 
}



/* <calendario> */
	
var backtable = '#adbade';
var calendback = '#eaedf5';
var lines = '#134271';
var bright = '#000000';
var festa = '#ff6600';
var source;
var tipo;
var campi = new Array();

var cal = function (val, e, t, hiddenSelectsArray) {
	
	var dt = new Array();

	if (!e) var e = window.event;
	var xPos = (e.pageX)? e.pageX : (e.clientX)? e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft:0;
	var yPos = (e.pageY)? e.pageY : (e.clientY)? e.clientY + document.body.scrollTop + document.documentElement.scrollTop:0;
	
	tipo = t;
	source = val;

	if (t == 0) 
	{
	   var oggi = new Date();
		var testDate = new Date(val[2].value,val[1].value,val[0].value);
		dt[0] = (!isNaN(testDate) && val[0].value)? val[0].value : 1;
		dt[1] = (!isNaN(testDate) && val[1].value)? val[1].value : oggi.getMonth()+1;
		dt[2] = (!isNaN(testDate) && val[2].value)? val[2].value : oggi.getFullYear();
	}
	else
		dt = val.value.split('-');

	showCalendar(new Date(dt[2], dt[1] - 1, dt[0]), xPos-160, yPos+20, hiddenSelectsArray);
}

/* </calendario> */

/* <PasswordManager> */

var PasswordManager = Class.create();

PasswordManager.prototype = 
{

	pwd:null,v1:null,v2:null,div:null,
	
	initialize : function(pwd,v1,v2,div)
	{

		this.pwd = pwd;
		this.v1 = v1;
		this.v2 = v2; 
		this.div = div;

	},
	
	switchDisplay : function()
	{

		if (this.div.style.display == 'none')
		{
			this.div.style.display = '';
			this.v1.select();
		} 
		else
		{
			this.div.style.display = 'none';
			this.v1.value = this.v2.value = "";
		}

	},
	
	conferma : function()
	{

		np1 = this.v1.value;
		if (!np1) {return;}

		np2 = this.v2.value;
		
		if (np1 == np2)
		{ //password coincidenti
			this.pwd.value = hex_md5(np1);
			window.alert("La password  stata modificata!");
			this.switchDisplay();
		}
		else  
		{//password NON coincidenti
			window.alert('Password non coincidenti!');
			this.v1.value = this.v2.value = "";
			this.v1.select();
		}

	}
	
}

/* </PasswordManager> */

</script>