<?php
class BullettinMail
{
	private $pdfObject;
	private $mailer;
	private $args;
	private $dir;
	private $filename;

	public function __construct($args)
	{
		require_once('/var/www/htdocs/test/fpdf153/fpdf.php');
		require_once('/var/www/htdocs/AMD/test/class.phpmailer.php');		

		$this -> setPdfObject(new FPDF());
		$this -> setMailer(new PHPMailer());
		
		$this -> args = $args;
		
		if (!session_id())
		{
			session_start();
		}

		$this -> directory = session_id();			
		$this -> filename = str_replace('@','AT', $args['to']).".pdf";
	}
	
	function __destruct()
	{
		$this -> removeDir(dirname(__FILE__)."/".$this -> directory);
	}

	
	private function getPdfObject()
	{
		return $this -> pdfObject;
	}	

	private function getMailer()
	{
		return $this -> mailer;
	}	

	private function setPdfObject($FPDF)
	{
		$this -> pdfObject = $FPDF;
	}	

	private function setMailer($mailer)
	{
		$this -> mailer = $mailer;
	}	
	
	private function createAttachment()
	{
	
		/*
			Creazione dell'attachment
		 */
		 
		$pdf = $this -> getPdfObject();		
		$pdf->AddPage();
		$pdf->SetFont('Arial','B',16);
		$pdf->Cell(40,10,'A peppe!');
		
		if (!file_exists(dirname(__FILE__)."/".$this -> directory)) mkdir($this -> directory , 0777);

		$pdf->Output( $this -> directory ."/". $this -> filename,'F');
	
	}
	
	private function sendMessage()
	{

		/*
			Spedizione
		 */
		$mail = $this -> getMailer();		

		$mail->IsSMTP(); // set mailer to use SMTP		
		$mail->IsHTML(true); // set email format to HTML
		$mail->WordWrap = 50; // set word wrap to 50 characters
		$mail->Host = "192.168.1.1";  // specify main and backup server
		$mail->SMTPAuth = false; // turn on SMTP authentication
		//$mail->From = "segreteria@aemmedi.it";
		$mail->From = "stefano.luchetti@kronositalia.com";
		$mail->FromName = "AMD - Associazione Medici Diabetologi";

		$to = $this -> args['to'];

		$mail->AddAddress($to);
		// $mail->AddCC($addressCC);
		// $mail->AddBCC($addressBCC);		

		$mail->Subject = "Quota associativa - ".$this -> args['subject'];

		$mail->Body  = ""; 
		$mail->Body .= "<p style=\"font-family:Verdana, Arial, Helvetica, sans-serif\">".$this -> args['subject']."</p>";
		$mail->Body .= "<p style=\"font-family:Verdana, Arial, Helvetica, sans-serif\">".$this -> args['body']."</p>";
		$mail->Body .= "<p style=\"font-family:Verdana, Arial, Helvetica, sans-serif\">L'importo dovuto &egrave; di Euro. ".$this -> args['quota']."</p>";

		$mail->AddAttachment( dirname(__FILE__)."/".$this -> directory."/".$this -> filename , "bollettino.pdf"); // add attachments
	
		if (!$mail->Send())
			echo "KO!";
		else 
			echo "OK!";
	}
	
	public function createAndSend ()
	{
		$this -> createAttachment();
		$this -> sendMessage();
	}

	function removeDir($path) {
		
		if (substr($path, -1, 1) != "/") {
			$path .= "/";
		}
		
		foreach (glob($path . "*") as $file) {
			if (is_file($file) === TRUE) {
				
				unlink($file);
			}
			else if (is_dir($file) === TRUE) {
				
				removeDir($file);
			}
		}
		
		if (is_dir($path) === TRUE) {
			rmdir($path);

		}
	} 

}



$testo = "
<p style=\"font-family:Verdana, Arial, Helvetica, sans-serif\">Ciao</p>
<p style=\"font-family:Verdana, Arial,Helvetica,sans-serif \">Miao</p>
<p style=\"font-family:Verdana, Arial, Helvetica,sans-serif\">Bau</p>";

$address = "stefano.luchetti@gmail.com";
$intestazione = "Stefano Luchetti";
$quota = 250;


$args = array
		  ( 
				"to"      => $address,
				"subject" => $intestazione, // Nome Cognome
				"body"    => $testo, 
				"quota"   => $quota
		  );

$bm  = new BullettinMail($args);
$bm -> createAndSend();



?>