// JavaScript Document

/* <GestoreImportoConRitenuta> */
var GestoreImportoConRitenuta = Class.create();

GestoreImportoConRitenuta.prototype = {

   jsonHandlers: null,
	jsonImportoIniziale:null,
	
	initialize:function(jsonHandlers){
		if(jsonHandlers) this.setJsonHandlers(jsonHandlers);
	},

	setJsonHandlers:function(jsonHandlers)
	{
      this.jsonHandlers = jsonHandlers;
      /**
		 * Istantanea dello stato iniziale dell'importo
		 */
		this.setJsonImportoIniziale();
	},
	getJsonHandlers:function()
	{
		return this.jsonHandlers;
	},

	setJsonImportoIniziale:function()
	{
	   var importo = this.getJsonHandlers(); 
		this.jsonImportoIniziale = {
			lordo            : importo.lordo.value,
			ritenuta         : importo.ritenuta.checked,
			importoRitenuta  : importo.importoRitenuta.value,
			netto            : importo.netto.value,	
			ritenutaPagata   : importo.ritenutaPagata.checked,
			dataPagamentoRitenuta : {giorno:importo.dataPagamentoRitenuta.giorno.value,
									       mese  :importo.dataPagamentoRitenuta.mese.value,
									       anno  :importo.dataPagamentoRitenuta.anno.value}						  	
		}
	},
	getJsonImportoIniziale:function()
	{
		return this.jsonImportoIniziale;
	},
	setDataPagato:function(DataPagato)
	{
	  /* this.dataPagato = "";
		this.dataPagato = this.getImporto().dataPagato.anno.value+"-";
		this.dataPagato = this.getImporto().dataPagato.mese.value+"-";
		this.dataPagato = this.getImporto().dataPagato.giorno.value;*/
	},
	getDataPagato:function()
	{
		return this.DataPagato;
	},
	restoreInitialState:function()
	{
		if(!this.getJsonImportoIniziale()) return;
		
		var handlers = this.getJsonHandlers();
		var importoIniziale = this.getJsonImportoIniziale();
		handlers.lordo.value = importoIniziale.lordo;
		handlers.checkBoxRitenuta.value = importoIniziale.checkBoxRitenuta;
		handlers.ritenuta.value = importoIniziale.ritenuta;
		handlers.netto.value = importoIniziale.netto;
		handlers.netto.value = importoIniziale.netto;

	}
	
}

/* </GestoreImportoConRitenuta> */


handlers = {
	lordo                 : $('importo_lordo_edt'),
	ritenute              :{
		ritenuta1:{
			stato   : $('ritenuta_edt'),
			importo : $('ritenuta_data_pagamento_edt'),
			pagata  : $('ritenuta_pagato_edt'),
			
		}
	},
	importoRitenuta       : $('ritenuta_importo_edt'),
	netto                 : $('importo_netto_edt'),	
	ritenutaPagata        : $('ritenuta_data_pagamento_edt'),
	dataPagamentoRitenuta : {giorno:$('ritenuta_data_pagamento_giorno_edt'),
	                         mese  :$('ritenuta_data_pagamento_mese_edt'),
							       anno  :$('ritenuta_data_pagamento_anno_edt')},
	refreshCommand        : $('refresh_importo')						  	
}

var gestoreImporto = new GestoreImportoConRitenuta(handlers);*/

<!-- </ImportoConRitenuta> -->		  		  
