// More languages are welcome. Please send your list of country names, error messages, page text and explain text
// to TBG5 administrator. Thnx

// Special thx to:
// Italiano: Renato Polo
// Norsk: Siri-Anne dos Santos
// French: Walter Hoffmann & Pierrick Daumain
// Polski: Norbert Wozniak
// Romanian: Kalman Pusztai
// Srpski: Aleksandar Blagojevic

// Scripting: Hendrik Muus

// letters will be replaced with digits
repl = new Array (	"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M",
			"N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z",
		 	"10","11","12","13","14","15","16","17","18","19","20","21","22",
		 	"23","24","25","26","27","28","29","30","31","32","33","34","35");
// use language 2 (english) by default
lngg = 3;

// we have currently 7 languages   1 deutsch, 2 english, 3 italiano, 4 norsk, 5 french, 6 polski, 7 romanian, 8 srpski
lgc = 8;
// country codes, fixed length for those countries, appliance of EU REGULATION 2560/2001 and IBAN example
ilbc = new Array (	"AD","AT","BA","BE","BG","CH","CY","CZ","DE","DK","EE","ES","FI","FO","FR","GB","GI","GL","GR",
			"HR","HU","IE","IL","IS","IT","LI","LT","LU","LV","MC","ME","MK","MT","MU","NL","NO","PL","PT","RO",
			"RS","SE","SI","SK","SM","TN","TR",
			 24,  20,  20,  16,  22,  21,  28,  24,  22,  18,  20,  24,  18,  18,  27,  22,  23,  18,  27,
			 21,  28,  22,  23,  26,  27,  21,  20,  20,  21,  27,  22,  19,  31,  30,  18,  15,  28,  25,  24,
			 22,  24,  19,  24,  27,  24,  26,
			"n", "y", "n", "y", "y", "n", "y", "y", "y", "y", "y", "y", "y", "n", "y", "y", "y", "n", "y",
			"n", "y", "y", "n", "y", "y", "y", "y", "y", "y", "n", "n", "n", "y", "n", "y", "y", "y", "y", "y",
			"n", "y", "y", "y", "n", "n", "n",
			"AD1200012030200359100100","AT611904300234573201","BA391290079401028494","BE68539007547034",
			"BG80BNBG96611020345678","CH9300762011623852957","CY17002001280000001200527600",
			"CZ6508000000192000145399","DE89370400440532013000","DK5000400440116243","EE382200221020145685",
			"ES9121000418450200051332","FI2112345600000785","FO7630004440960235","FR1420041010050500013M02606",
			"GB29NWBK60161331926819","GI75NWBK000000007099453","GL4330003330229543","GR1601101250000000012300695",
			
			"HR1210010051863000160","HU42117730161111101800000000","IE29AIBK93115212345678","IL620108000000099999999",
			"IS140159260076545510730339","IT60X0542811101000000123456","LI21088100002324013AA","LT121000011101001000",
			"LU280019400644750000","LV80BANK0000435195001","MC...","ME25505000012345678951",
			"MK07300000000042425","MT84MALT011000012345MTLCAST001S","MU17BOMM0101101030300200000MUR","NL91ABNA0417164300",
			"NO9386011117947","PL27114020040000300201355387","PT50000201231234567890154","RO49AAAA1B31007593840000",
			
			"RS35260005601001611379","SE3550000000054910000003","SI56191000000123438","SK3112000000198742637541",
			"SM86U0322509800000000270100","TN5914207207100707129648","TR330006100519786457841326");
// we have currently # countries
ctcnt = ilbc.length/4;
// we have currently # alert texts
atcnt = 10;
// we have currently # web texts
wbcnt = 10;

// gets the country name 
function rcty(tnum) { return ctynm[tnum+ctcnt*(lngg-1)]; }
//gets the error text
function ralt(tnum) { return altxt[tnum+atcnt*(lngg-1)]; }
// the magic core routine
function checkibancore(iban) {
	illegal = /\W|_/; // contains chars other than (a-zA-Z0-9) 
	if(illegal.test(iban)) { alert(ralt(0)); return false; } // yes, alert and exit
	else { // no, continue
		illegal = /^\D\D\d\d.+/; // first chars are letter letter digit digit
		if(illegal.test(iban) == false) { alert(ralt(1)); return false; } // no, alert and exit
		else { // yes, continue
			illegal = /^\D\D00.+|^\D\D01.+|^\D\D99.+/; // check digit are 00 or 01 or 99
			if(illegal.test(iban)) { alert(ralt(2)); return false; } // yes, alert and exit
			else { // no, continue
				iban = iban.toUpperCase(); // uppercase, to ease
				cntry = iban.substr(0,2); // fetch country
				lofi = 6; // "default" length of IBAN
				for (i = 0; i < ctcnt; i++) {	if (cntry == ilbc[i]) { lofi = ilbc[ctcnt+i]; ctck=i; }}  // yes, country respected
				if (lofi == 6) { // no, alert
					alert(ralt(3)+cntry+ralt(4)); return false; 
					lofi = iban.length; }  // but continue
				if ((iban.length-lofi) != 0) { // fits length to country
					alert(ralt(5)+rcty(ctck)+ralt(6)+ilbc[ctck+ctcnt]+ralt(7)); return false; } // no, alert and exit
				else { // yes, continue
					iban = iban.substr(4,lofi-4) + iban.substr(0,4); // country and check digits to the end
					for (i = 0; i <= 25; i++) { // replace letters with digits
						while (iban.search(repl[i])!= -1) { iban = iban.replace(repl[i],repl[i+26]); }} // all of them
					coss = Math.ceil(iban.length/7); // calc count of substrings
					rmndr = ""; // remainer starts empty and always preceeds the current substring
					for (i = 1; i <= coss; i++) { // step by step
						rmndr = String(parseFloat(rmndr+iban.substr((i-1)*7,7))%97); } // modulo division 97
					return rmndr; }}}}} // return the remainer
// perform the check
function checkiban(iban) {
	if (checkibancore(iban) == "1") { if(confirm(ralt(8))==true) return true; else return false; } // and prompt result
	else { alert(ralt(9)); return false; }}

// some convenience for web page
function langsel() { document.write(	"<option value=\"1\">deutsch</option><option value=\"2\">english</option>"+
					"<option value=\"5\">french</option><option value=\"3\">italiano</option>"+
					"<option value=\"4\">norsk</option><option value=\"6\">polski</option>"+
					"<option value=\"7\">romanian</option><option value=\"8\">srpski</option>"); } //language selector
function rwt(tnum) { document.write(wptxt[(lngg-1)*wbcnt+tnum]); } //web page text by number
function rwt2(pos) { 
	if (wptxt[(lngg-1)*wbcnt] == pos) {
		document.write(" EU Regulation 2560/2001 "); }} //special web page text
// some convenience to list the countries
function rcc(tnum) { return ilbc[tnum]; } //country code by number
function rcn(tnum) { return rcty(tnum); } //country name by number
function rcr(tnum) { return ilbc[ctcnt*2+tnum]; } //country regulatory info by number
function rcl(tnum) { return wptxt[(lngg-1)*wbcnt+8]+ilbc[ctcnt*1+tnum]; } //hover text for code
function rce(tnum) { return wptxt[(lngg-1)*wbcnt+9]+ilbc[ctcnt*3+tnum]; } //hover text for name
// list countries in x columns with language y ##### old, use new please #####
function listcountries(columni,llngg) {
	listcountriesnew(columni,llngg,"n",""); }
// list countries in x columns with language y show flag y/n from path ##### new #####
// make sure the flag images are available at path and provide a style declaration like "img.tbg5cdf { height:20px; }" !!
function listcountriesnew(columni,llngg,flag,ipath) {
	lngg = llngg; //use language parameter
	if (flag == "n") {
		document.write("<table class=\"tbg5ct\">\r\n<TR class=\"tbg5crt\"><TD class=\"tbg5cdt\" colspan=\""+columni*2+"\">&nbsp;</TD></TR>\r\n"); }
	else {	document.write("<table class=\"tbg5ct\">\r\n<TR class=\"tbg5crt\"><TD class=\"tbg5cdt\" colspan=\""+columni*3+"\">&nbsp;</TD></TR>\r\n"); }
	numberofrows = Math.ceil(ctcnt/columni); //calculate rows
	for (i = 0; i < numberofrows; i++) { //for each row
		document.write("<tr class=\"tbg5crl\">");
		for (j = 0; j < columni; j++) { //for each column
			if ((i*columni+j)<ctcnt) { //fill cells
				document.write(	"<td class=\"tbg5cdc\" title=\""+rcl(i*columni+j)+"\"><span class=\"tbg5era"+rcr(i*columni+j)+"\">"+rcc(i*columni+j)+"</span></td>"); //country code
				if (flag == "y") { //show flag
					document.write(	"<td class=\"tbg5cdf\"><img class=\"tbg5cdf\" src=\""+ipath+rcc(i*columni+j)+".png\" alt=\""+rcn(i*columni+j)+"\" title=\""+rcn(i*columni+j)+"\"></td>"); }
				document.write(	"<td class=\"tbg5cdn\" title=\""+rce(i*columni+j)+"\"><span class=\"tbg5era"+rcr(i*columni+j)+"\">"+rcn(i*columni+j)+"</span></td>"); }} //country name
		document.write("</tr>\r\n"); }
	document.write("</table>\r\n"); }
// some convenience for additional explanations
function doexplain(llngg) {
	document.write(xpltxt[llngg-1]); }

// test
function checkiban2(iban) {
	ibano = iban.substr(0,2)+(99-checkibancore(iban))+iban.substr(4,iban.length-4);
	return ibano; }


// deutsch ++++++++++++++++++++++++++++++++++++++++
// country names
ctynm =			new Array (	"Andorra","sterreich","Bosnien und Herzegowina","Belgien","Bulgarien","Schweiz",
					"Zypern","Tschechien","Deutschland","Dnemark","Estland","Spanien","Finnland",
					"Frer","Frankreich","Grobritannien","Gibraltar","Grnland","Griechenland","Kroatien",
					"Ungarn","Irland","Israel","Island","Italien","Liechtenstein","Litauen","Luxemburg","Lettland",
					"Monaco","Montenegro","Mazedonien","Malta","Mauritius","Niederlande","Norwegen","Polen","Portugal",
					"Rumnien","Serbien","Schweden","Slowenien","Slowakei","San Marino","Tunesien","Trkei");
// error messages
altxt =			new Array (	"Die IBAN enthlt unzulssige Zeichen.",
					"Die Struktur der IBAN ist falsch.",
					"Die Prfziffern der IBAN sind falsch.",
					"Die Lnge der IBAN kann nicht geprft werden, weil "," zur Zeit nicht bercksichtigt ist.",
					"Die Lnge der IBAN ist falsch. Die IBAN fr "," muss "," Zeichen lang sein.",
					"Die IBAN scheint korrekt zu sein.",
					"Die IBAN ist nicht korrekt.");
// additional explanations
xpltxt =		new Array (	"IE Irland kann fr GB Grobritannien Konten benutzt werden im Fall, dass die servisierende "+
					"Bank in Nord Irland situiert ist und das Clearingsystem Irlands benutzt; GG Guernsey und "+
					"JE Jersey benutzen entweder GB Grobritannien oder FR Frankreich abhngig vom Clearingsystem, "+
					"das die servisierende Bank benutzt; GF Franzsisch Guyana, GP Guadeloupe, MQ Martinique und "+
					"RE Runion benutzen FR Frankreich und unterliegen der EU-Regulative 2560/2001; NC Neu Kaledonien, "+
					"PF Franzsisch Polynesien, PM Saint Pierre und Miquelon, TF Sdfranzsische Territorien, "+
					"WF Wallis und Futuna und YT Mayotte benutzen FR Frankreich; ES Spanien inkludiert die "+						
					"Kanarischen Inseln, Ceuta und Melilla; PT Portugal inkludiert die Azoren und Madeira");
// web page
wptxt =			new Array (	1,"Bei folgenden Lnder (geordnet nach Lnderkode) wird zur Zeit die zustzliche Lngenprfung bercksichtigt:",
					"letzte nderung: "," Unterliegt","unterliegt nicht","Testen einer gegebenen IBAN.","Druckform"
					,"Elektronische Form","Lnge: ","Beispiel: ");
// deutsch ++++++++++++++++++++++++++++++++++++++++
// english ++++++++++++++++++++++++++++++++++++++++
// country names
ctynm = ctynm.concat	( new Array (	"Andorra","Austria","Bosnia and Herzegovina","Belgium","Bulgaria","Switzerland",
					"Cyprus","Czech Republic","Germany","Denmark","Estonia","Spain","Finland",
					"Faroe Islands","France","Great Britain","Gibraltar","Greenland","Greece","Croatia",
					"Hungary","Ireland","Israel","Iceland","Italy","Liechtenstein","Lithuania","Luxemburg","Latvia",
					"Monaco","Montenegro","Macedonia","Malta","Mauritius","Netherlands","Norway","Poland","Portugal",
					"Romania","Serbia","Sweden","Slovenia","Slovak Republic","San Marino","Tunisia","Turkey"));
// error messages
altxt = altxt.concat	( new Array (	"The IBAN contains illegal characters.",
					"The structure of IBAN is wrong.",
					"The check digits of IBAN are wrong.",
					"Can not check correct length of IBAN because "," is currently not respected.",
					"The length of IBAN is wrong. The IBAN of "," needs to be "," characters long.",
					"The IBAN seems to be correct.",
					"The IBAN is incorrect."));
// additional explanations
xpltxt = xpltxt.concat	( new Array (	"IE Ireland may be used for GB Great Britain accounts in case the servicing bank is situated "+
					"in North Ireland and uses the clearing system of the Republic of Ireland; GG Guernsey and JE Jersey "+
					"are using either GB Great Britain or FR France depending on the clearing system used by the "+
					"servicing bank; GF French Guiana, GP Guadeloupe, MQ Martinique and RE Runion are using FR France "+
					"and EU REGULATION 2560/2001 applies; NC New Caledonia, PF French Polynesia, PM Saint Pierre and "+
					"Miquelon, TF French Southern Territories, WF Wallis and Futuna and YT Mayotte are using FR France; "+
					"ES Spain includes Canary Islands, Ceuta and Melilla; "+
					"PT Portugal includes Azores and Madeira"));
// web page
wptxt = wptxt.concat	( new Array (	0,"Currently the additional length check of following countries is respected (ordered by country code):",
					"last update: ","applies","applies not ","","Print form",
					"Electronic form","Length: ","Example: "));
// english ++++++++++++++++++++++++++++++++++++++++
// italiano +++++++++++++++++++++++++++++++++++++++
// country names
ctynm = ctynm.concat	( new Array (	"Andorra","Austria","Bosnia e Herzegovina","Belgio","Bulgara","Svizzera",
					"Cipro","Repubblica Ceca","Germania","Danimarca","Estonia","Spagna","Finlandia",
					"Isole Faroe","Francia","Gran Bretagna","Gibilterra","Groenlandia","Grecia","Croazia",
					"Ungheria","Irlanda","Israel","Islanda","Italia","Liechtenstein","Lituania","Lussemburgo","Lettonia",
					"Monaco","Montenegro","Macedonia","Malta","Mauritius","Paesi Bassi","Norvegia","Polonia","Portogallo",
					"Romania","Serbia","Svezia","Slovenia","Slovacchia","San Marino","Tunisia","Turchia"));
// error messages
altxt = altxt.concat	( new Array (	"Attenzione: L'IBAN contiene caratteri non ammessi!",
					"Attenzione: La struttura dell'IBAN  errata !",
					"Attenzione: Il check digit dell'IBAN  errato!",
					"Attenzione: Non  possibile verificare l'IBAN perch "," non  attualmente inventariato!",
					"Attenzione: La lunghezza dell'IBAN  errata. L' IBAN di "," deve avere lunghezza di ","!",
					"L'IBAN risulta essere esatto confermi l'inserimento?. ",
					"Attenzione: L'IBAN non  esatto!"));
// additional explanations
xpltxt = xpltxt.concat	( new Array (	"IE Irlanda pu essere usata per conti di GB Gran Bretagna se la banca amministrante  "+
					"localizzata in Irlanda del Nord e usa il clearing della Repubblica di Irlanda; GG Guernsey e "+
					"JE Jersey usano sia GB Gran Bretagna oppure FR Francia in relazione a quale clearing viene "+
					"usato dalla banca che amministra il conto; GF Guyana Francese, GP Guadalupa, MQ Martinica e RE "+
					"Isole Riunione usano FR Francia e adottano il Regolamento 2560/2001; NC Nuova Caledonia, PF "+
					"Polinesia Francese, PM Saint-Pierre e Miquelon, TF Territori Francesi di Oltremare, WF Wallis e "+
					"Futuna e YT Mayotte usano FR Francia; ES Spagna comprende Isole Canarie, Ceuta e Melilla; PT "+
					"Portogallo comprende Isole Azzorre e Madeira"));
// web page
wptxt = wptxt.concat	( new Array (	1,"Attualmente il controllo aggiuntivo di lunghezza per i seguenti paesi  rispettato (ordinamento per Codice Paese):",
					"ultimo aggiornamento: "," Adottano","non adottano ","","Formato esteso",
					"Formato elettronico","Lunghezza: ","Esempio: "));
// italiano +++++++++++++++++++++++++++++++++++++++
// norsk ++++++++++++++++++++++++++++++++++++++++++
// country names
ctynm = ctynm.concat	( new Array (	"Andorra","sterrike","Bosnia og Herzegovina","Belgia","Bulgaria","Sveits",
					"Kypros","Tsjekkia","Tyskland","Danmark","Estland","Spania","Finland",
					"Fryene","Frankrike","Storbritannia","Gibraltar","Grnland","Hellas","Kroatia",
					"Ungarn","Irland","Israel","Island","Italia","Liechtenstein","Litauen","Luxemburg","Latvia",
					"Monaco","Montenegro","Makedonia","Malta","Mauritius","Nederland","Norge","Polen","Portugal",
					"Romania","Serbia","Sverige","Slovenia","Slovakia","San Marino","Tunis","Tyrkia"));
// error messages
altxt = altxt.concat	( new Array (	"IBAN inneholder ugyldige karakterer.",
					"IBAN-strukturen er feil.",
					"Kontrollsifferene i IBAN er feil.",
					"Kan ikke sjekke korrekt lengde p IBAN fordi "," p.t ikke er dekket.",
					"Lengden p IBAN er feil. IBAN fra "," m vre p "," karakterer.",
					"IBAN ser ut til  vre korrekt.",
					"IBAN er feil."));
// additional explanations
xpltxt = xpltxt.concat	( new Array (	"IE Irland kan benyttes for konti i GB Storbritannia dersom servicebanken er lokalisert i "+
					"Nord-Irland og benytter avregningssentralen i Den Irske Republikk; GG Guernsey og JE Jersey "+
					"bruker enten GB Storbritannia eller FR Frankrike avhengig av avregningssentralen benyttet av "+
					"servicebanken; GF Fransk Guiana, GP Guadeloupe, MQ Martinique og RE Runion benytter FR "+
					"Frankrike og dekkes av EU REGULATIV 2560/2001; NC Ny-Caledonia, PF Fransk Polynesia, PM Saint "+
					"Pierre og Miquelon, TF Franske Srlige Territorier, WF Wallis og  Futunayene og YT Mayotte "+
					"benytter FR Frankrike; ES Spaina inkluderer Kanariyene, Ceuta og Melilla; PT Portugal "+
					"inkluderer Azorene og Madeira"));
// web page
wptxt = wptxt.concat	( new Array (	0,"P.t. stttes i tillegg lengden for flgende land (angitt ved landkode):",
					"sist oppdatert: ","anvendes","anvendes ikke ","Test av en gitt IBAN.","Utskrift format",
					"Elektronisk format","Lengde: ","Eksempel: "));
// norsk ++++++++++++++++++++++++++++++++++++++++++
// french +++++++++++++++++++++++++++++++++++++++++
// country names
ctynm = ctynm.concat	( new Array (	"Andorre","Autriche","Bosnie et Herzgovine","Belgique","Bulgarie","Suisse",
					"Chypre","Rpublique Tchque","Allemagne","Danemark","Estonie","Espagne","Finlande",
					"les Fro","France","Grande Bretagne","Gibraltar","Groenland","Grce","Croatie",
					"Hongrie","Irlande","Israel","Islande","Italie","Liechtenstein","Lithuanie","Luxembourg","Lettonie",
					"Monaco","Montngro","Macdoine","Malte","le Maurice","Pays-Bas","Norvge","Pologne","Portugal",
					"Roumanie","Serbie","Sude","Slovnie","Rpublique Slovaquie","San Marino","Tunisie","Turquie"));
// error messages
altxt = altxt.concat	( new Array (	"L'IBAN contient des caractres non autoriss.",
					"La structure de l'IBAN est incorrecte.",
					"La cl numrique de l'IBAN est erronne.",
					"La longueur fixe de l'IBAN n'a pas pu tre vrifie parceque "," n'est actuellement pas respecte.",
					"La longueur de l'IBAN est incorrecte. Les IBANs "," doivent avoir une longueur de "," caractres.",
					"L'IBAN semble correct.","L'IBAN est incorect."));
// additional explanations
xpltxt = xpltxt.concat	( new Array (	"Le code IE Irlande peut tre utilise pour des comptes GB Grande Bretagne dans le cas o la "+
					"banque qui tient le compte est situe en Irlande du Nord et utilise le systme d'change de la "+
					"Rpublique d'Irlande; GG Guernesey and JE Jersey utilisent soit GB Grande Bretagne soit FR France "+
					"suivant le systme d'change utilis par la banque qui tient le compte; GF Guyane Franaise, "+
					"GP Guadeloupe, MQ Martinique et RE Runion utilisent FR France and le Rglement europen "+
					"2560/2001 s'applique; NC Nouvelle Caldonie, PF Polynsie Franaise, PM Saint Pierre et "+
					"Miquelon, TF Terres Australes Franaises, WF Wallis et Futuna et YT Mayotte utilisent FR France; "+
					"ES Espagne inclut les les Canaries, Ceuta et Melilla; PT Portugal inclut les Aores et Madre"));
// web page
wptxt = wptxt.concat	( new Array (	0,"Actuellement le contrle additionnel de la longueur pour les pays suivants est respect (class par code pays):",
					"dernire mise  jour: ","s'applique","ne s'applique pas ","Test d'un IBAN.","Reprsentation Papier",
					"Reprsentation lectronique","Longueur: ","Exemple: "));
// french +++++++++++++++++++++++++++++++++++++++++
// polski +++++++++++++++++++++++++++++++++++++++++
// country names
ctynm = ctynm.concat	( new Array (	"Andorra","Austria","Bosnia i Herzegowina","Belgia","Bulgaria","Szwajcaria",
					"Cypr","Czechy","Niemcy","Dania","Estonia","Hiszpania","Finlandia",
					"Wyspy Feroe","Francja","Wielka Brytania","Gibraltar","Grenlandia","Grecja","Chorwacja",
					"Wegry","Irlandia","Israel","Islandia","Wlochy","Liechtenstein","Litwa","Luxemburg","Lotwa",
					"Monaco","Czarnogora","Macedonia","Malta","Mauritius","Holandia","Norwegia","Polska","Portugalia",
					"Rumunia","Serbia","Szwecja","Slowenia","Slowacja","San Marino","Tunezja","Turcja"));
// error messages
altxt = altxt.concat	( new Array (	"IBAN zawiera nieprawidlowe znaki.",
					"Struktura IBAN'u jest bledna.",
					"Cyfry kontrolne IBAN'u sa bledne.",
					"Dlugosc IBAN'u nie moze zostac sprawdzona, poniewaz "," czasowo nie jest uwzgledniona.",
					"Dlugosc IBAN'u jest bledna. IBAN dla "," musi miec "," miejsc.",
					"IBAN wyglada na prawidlowy.",
					"IBAN jest nieprawidlowy."));
// additional explanations
xpltxt = xpltxt.concat	( new Array (	"IE Irlandii moze zostac uzyty dla kont Wielkiej Brytanii w przypadku, gdy serwisujacy "+
					"bank znajduje sie w Irlandii Polnocnej i uzywa clearing systemu Irlandii; GG Guernesey "+
					"i JE Jersey uzywaja albo GB Wielkiej Brytanii lub FR Francji uzaleznione jest to od "+
					"clearing systemu  uzywanego przez bank serwisujacy; GF Gujana Francuska, GP Guadelupa, "+
					"MQ Martynika i RE Runion uzywaja FR Francji i podlegaja rozporzadzeniu UE 2560/2001; NC "+
					"Nowa Kaledonia, PF Polinezja Francuska, PM Saint Pierre et Miquelon, TF Francuskie Terytoria "+
					"Poludniowe, WF Wallis i Futuna i YT Mayotte uzywaja FR Francji; ES Hiszpanii zawiera "+
					"Wyspy Kanaryjskie, Ceuta i Melilla; PT Portugalii zawiera Azory i Madere"));
// web page
wptxt = wptxt.concat	( new Array (	0,"W nastepujacych krajach (wg kodu danego panstwa) jest uwzgledniona czasowo kontrola jego dlugosci:",
					"ostatnia zmiana: ","podlega","nie podlega ","Test danego IBANu.","W formie druku",
					"Forma elektroniczna","Dlugosc: ","Przyklad: "));
// polski +++++++++++++++++++++++++++++++++++++++++
// romanian +++++++++++++++++++++++++++++++++++++++
// country names
ctynm = ctynm.concat	( new Array (	"Andora","Austria","Bosnia Hertegovina","Belgia","Bulgaria","Elvetia",
					"Cipru","Republica Cehia","Germania","Danemarka","Estonia","Spania","Finlanda",
					"Insulele Faroe","Franta","Marea Britanie","Gibraltar","Groenlanda","Grecia","Croatia",
					"Ungaria","Irlanda","Israel","Islanda","Italia","Liechtenstein","Lituania","Luxemburg","Letonia",
					"Monaco","Montenegro","Macedonia","Malta","Mauritania","Olanda","Norvegia","Polonia","Portugalia",
					"Romania","Serbia","Suedia","Slovenia","Republica Slovacia","San Marino","Tunisia","Turcia"));
// error messages
altxt = altxt.concat	( new Array (	"Codul IBAN contine caractere ilegale.",
					"Structura codului IBAN este gresita.",
					"Cifrele de control din codul IBAN sunt gresite.",
					"Nu se poate virifica lungimea corecta a codului IBAN deoarece "," nu este inca suportat.",
					"Lungimea codului IBAN este gesita. Codul IBAN din "," trebuie sa aiba lungimea de "," caractere.",
					"Codul IBAN pare sa fie corect.",
					"Codul IBAN este incorect."));
// additional explanations
xpltxt = xpltxt.concat	( new Array (	"IE Irlanda poate fi utilizat pentru conturi din GB Marea Britanie in cazul in care banca este situata "+
					"Irlanda de Nord si utilizeaza sistemul de decontari al Republicii Irlanda; GG Guernsey si JE Jersey "+
					"utilizeaza fie GB Marea Britanie sau FR Franta in functie de sistemul de decontari utilizat de "+
					"banca respectiva; GF Guiana Franceza, GP Guadeloupe, MQ Martinique si RE Runion utilizeaza FR Franta "+
					"si se aplica REGULATMENTUL EU 2560/2001; NC Noua Caledonie, PF Polinezia Franceza, PM Saint Pierre si "+
					"Miquelon, TF Teritoriile Australe Franceze, WF Wallis si Futuna si YT Mayotte utilizeaza FR Franta; "+
					"ES Spania include Insulele Canare, Ceuta si Melilla; "+
					"PT Portugalia include Insulele Azore si Madeira"));
// web page
wptxt = wptxt.concat	( new Array (	0,"In prezent se respecta verificarea aditionala a lungimii codului pentru urmatoarele tari (ordonate dupa codul tarii):",
					"ultima actualizare: ","se aplica","nu se aplica ","Verificarea unui cod IBAN.","Forma tiparita",
					"Forma electronica","Lungimea: ","Exemplu: "));
// romanian +++++++++++++++++++++++++++++++++++++++
// srpski +++++++++++++++++++++++++++++++++++++++++
// country names
ctynm = ctynm.concat	( new Array (	"Andora","Austrija","Bosna i Hercegovina","Belgija","Bugarska","vajcarska",
					"Kipar","Ceka Republika","Nemacka","Danska","Estonija","panija","Finska",
					"Farska ostrva","Francuska","Velika Britanija","Gibraltar","Grenland","Grcka","Hrvatska",
					"Ma&#273;arska","Irska","Izrael","Island","Italija","Lihtentajn","Litvanija","Luksemburg","Letonija",
					"Monako","Crna Gora","Makedonija","Malta","Mauricijus","Holandija","Norveka","Poljska","Portugal",
					"Rumunija","Srbija","vedska","Slovenija","Slovacka Republika","San Marino","Tunis","Turska"));
// error messages
altxt = altxt.concat	( new Array (	"IBAN sadri nedozvoljene karaktere.",
					"Struktura IBAN-a je pogrena.",
					"Kontrolne cifre IBAN-a su pogrene.",
					"Ne moe se proveriti tacna duina IBAN-a jer "," se trenutno ne proverava.",
					"Duina IBAN-a je pogrena. IBAN "," treba da bude "," karaktera dug.",
					"IBAN izgleda kao tacan.",
					"IBAN je netacan."));
// additional explanations
xpltxt = xpltxt.concat	( new Array (	"IE Irska moe biti koricen za racune GB Velika Britanija u slucaju da je usluna banka u Severnoj Irskoj "+
					"i da koristi kliring sistem Republike Irske; GG Gernsi i JE Dersi koriste ili GB Velika Britanija ili "+
					"FR Francuska u zavisnosti od kliring sistema koji koristi usluna banka; GF Francuska Gvajana, "+
					"GP Gvadelupe, MQ Martinik i RE Reunion koriste FR Francuska i EU Propis 2560/2001 se primenjuje; "+
					"NC Nova Kaledonija, PF Francuska Polinezija, PM Sent-Pijer i Mikelon, "+
					"TF Francuske June Teritorije, WF Valis i Futuna i YT Majot koriste  FR Francuska; "+
					"ES panija ukljucuje Kanarska ostrva, Seutu i Melilju; "+
					"PT Portugal ukljucuje Azore i Madeiru"));
// web page
wptxt = wptxt.concat	( new Array (	0,"Trenutno se obavlja dodatna provera duine IBAN koda sledecih zemalja (redosled po kodu zemlje):",
					"poslednja promena: ","se primenjuje","se ne primenjuje ","Provera zadatog IBAN-a.","tampani oblik",
					"Elektronski oblik","Duina: ","Primer: "));
// srpski +++++++++++++++++++++++++++++++++++++++++

//                                    V
// wptxt = wptxt.concat ( new Array ( 0 ,"text 1","text 2","text 3","text 4","text 5","text 6","text 7","text 8","text 9"));
// resuts in
// "("+" EU Regulation 2560/2001 "+"text 3"+"/"+"text 4"+")"
//
// while
//                                    V
// wptxt = wptxt.concat ( new Array ( 1 ,"text 1","text 2","text 3","text 4","text 5","text 6","text 7","text 8","text 9"));
// resuts in
// "("+" "text 3"+"/"+"text 4"+" EU Regulation 2560/2001 "+")"
//
// i.e. it is a language adaptor. Please choose properly. Thx


// script end
