<?php
# FILE: pdf.php
# CREATO DA: Stefano Luchetti	
# IN DATA: 22/05/07
# CONTENUTO: classe che estende le funzionalit della classe fpdf
# con metodi che permettono la rotazione dei contenuti (testo e immagini).
#-----------------------------------------------------
# VERSIONE: 0.1
# MODIFICATO DA:
# IN DATA:
# ->
#-----------------------------------------------------

require_once('fpdf.php');

class PDF extends FPDF
{
	var $angle=0;
	
	function Rotate($angle,$x=-1,$y=-1)
	{
		 if($x==-1)
			  $x=$this->x;
		 if($y==-1)
			  $y=$this->y;
		 if($this->angle!=0)
			  $this->_out('Q');
		 $this->angle=$angle;
		 if($angle!=0)
		 {
			  $angle*=M_PI/180;
			  $c=cos($angle);
			  $s=sin($angle);
			  $cx=$x*$this->k;
			  $cy=($this->h-$y)*$this->k;
			  $this->_out(sprintf('q %.5f %.5f %.5f %.5f %.2f %.2f cm 1 0 0 1 %.2f %.2f cm',$c,$s,-$s,$c,$cx,$cy,-$cx,-$cy));
		 }
	}
	
	function _endpage()
	{
		 if($this->angle!=0)
		 {
			  $this->angle=0;
			  $this->_out('Q');
		 }
		 parent::_endpage();
	}


	function RotatedText($x,$y,$txt,$angle)
	{
		 //Text rotated around its origin
		 $this->Rotate($angle,$x,$y);
		 $this->Text($x,$y,$txt);
		 $this->Rotate(0);
	}
	
	function RotatedImage($file,$x,$y,$w,$h,$angle)
	{
		 //Image rotated around its upper-left corner
		 $this->Rotate($angle,$x,$y);
		 $this->Image($file,$x,$y,$w,$h);
		 $this->Rotate(0);
	}

	//Simple table
	function BasicTable($header,$data)
	{
		 //Header
		 foreach($header as $col)
			  $this->Cell(40,7,$col,1);
		 $this->Ln();
		 //Data
		 foreach($data as $row)
		 {
			  foreach($row as $col)
					$this->Cell(40,6,$col,1);
			  $this->Ln();
		 }
	}

	//Better table
	function ImprovedTable($header,$data)
	{
		 //Column widths
		 $w=array(40,35,40,45);
		 //Header
		 for($i=0;$i<count($header);$i++)
			  $this->Cell($w[$i],7,$header[$i],1,0,'C');
		 $this->Ln();
		 //Data
		 foreach($data as $row)
		 {
			  $this->Cell($w[0],6,$row[0],'LR');
			  $this->Cell($w[1],6,$row[1],'LR');
			  $this->Cell($w[2],6,number_format($row[2]),'LR',0,'R');
			  $this->Cell($w[3],6,number_format($row[3]),'LR',0,'R');
			  $this->Ln();
		 }
		 //Closure line
		 $this->Cell(array_sum($w),0,'','T');
	}
	
	//Colored table
	function FancyTable($header,$data)
	{
		 //Colors, line width and bold font
		 $this->SetFillColor(255,0,0);
		 $this->SetTextColor(255);
		 $this->SetDrawColor(128,0,0);
		 $this->SetLineWidth(.3);
		 $this->SetFont('','B');
		 //Header
		 $w=array(40,35,40,45);
		 for($i=0;$i<count($header);$i++)
			  $this->Cell($w[$i],7,$header[$i],1,0,'C',1);
		 $this->Ln();
		 //Color and font restoration
		 $this->SetFillColor(224,235,255);
		 $this->SetTextColor(0);
		 $this->SetFont('');
		 //Data
		 $fill=0;
		 foreach($data as $row)
		 {
			  $this->Cell($w[0],6,$row[0],'LR',0,'L',$fill);
			  $this->Cell($w[1],6,$row[1],'LR',0,'L',$fill);
			  $this->Cell($w[2],6,number_format($row[2]),'LR',0,'R',$fill);
			  $this->Cell($w[3],6,number_format($row[3]),'LR',0,'R',$fill);
			  $this->Ln();
			  $fill=!$fill;
		 }
		 $this->Cell(array_sum($w),0,'','T');
	}

}
?>