<?php
#------------------------------------------------------------------------#
# FILE: classe_eccezione.inc
# CREATO DA: Stefano Luchetti
# IN DATA: 04/12/2006
# CONTENUTO: Classe che implementa una primitiva gestione delle
# eccezioni.
#------------------------------------------------------------------------#
# VERSIONE: 0.1
# MODIFICATO DA: 
# IN DATA: 
# ->
#------------------------------------------------------------------------#

class K_eccezione
{

	private static $_lanciata = false;
    private static $_numero = 0;
    private static $_istanze = array();
	
	private $_tracer;
    private $_codice;
    private $_file;
	private $_linea;
	

    /**
	 * Costruttore
	 */
	public function __construct  ($codice, $tracer, $file, $linea)
	{
        if (!self :: is_lanciata()) self :: lanciata(); 
		$this -> set_tracer($tracer);
		$this -> set_codice($codice);
		$this -> set_file($file);
		$this -> set_linea($linea);
        $this -> nuova_istanza();
		$this->get_tracer()->trace(1, "ECCEZIONE: File ".$this->get_file()." - Linea:".$this->get_linea());
	}

    /**
	 * Distruttore
	 */
	public function __destruct ()
	{			
	}
	

    /**
	 * $_tracer accessor method
	 */
	private function get_tracer()
	{
	   return $this -> _tracer;
	}


    /**
	 * $_tracer mutator method
     */
	private function set_tracer($tracer)
	{
	   $this -> _tracer = $tracer;
	}

    /**
	 * $_lanciata accessor method
	 */
	public static function is_lanciata()
	{
	   return self :: $_lanciata;
	}

    /**
	 * $_lanciata mutator method
	 */
	public static function lancia()
	{
	   self :: $_lanciata = true;
	}

    /**
	 * $_numero accessor method
	 */
	public static function get_numero()
	{
	   return self :: $_numero;
	}

    /**
	 * $_numero mutator method
	 */
	private static function incrementa_numero()
	{
	   self :: $_numero ++ ;
	}
	
    /**
	 * $_codice accessor method
	 */
	public function get_codice()
	{
	   return $this -> _codice;
	}

    /**
	 * $_codice mutator method
     */
	private function set_codice($codice)
	{
	   $this -> _codice = $codice;
	}

    /**
	 * $_file accessor method
	 */
	private function get_file()
	{
	   return $this -> _file;
	}

    /**
	 * $_file mutator method
     */
	private function set_file($file)
	{
	   $this -> _file = $file;
	}

    /**
	 * $_linea accessor method
	 */
	private function get_linea()
	{
	   return $this -> _linea;
	}


    /**
	 * $_linea mutator method
     */
	private function set_linea($linea)
	{
	   $this -> _linea = $linea;
	}


	public static function istanza($item)
	{
	   return self :: $_istanze[$item];
	}
	
	private function nuova_istanza()
	{
	   self :: incrementa_numero();
	   self :: $_istanze [self :: get_numero()] = $this;

	}
	
}//fine della classe

?>