<?php
#------------------------------------------------------------------------#
# FILE: classe_eccezione.inc
# CREATO DA: Stefano Luchetti
# IN DATA: 04/12/2006
# CONTENUTO: Classe che implementa una primitiva gestione delle
# eccezioni.
#------------------------------------------------------------------------#
# VERSIONE: 0.1
# MODIFICATO DA: 
# IN DATA: 
# ->
#------------------------------------------------------------------------#

class K_eccezione
{

	private static $_lanciata = false;
	private static $_numero = 0;
	private static $_istanze = array();
	private static $_tracer = null;

	private $_codice;
	private $_file;
	private $_linea;
	private $_alert;
   private $_stringa_errori;
    /**
	 * Costruttore
	 */
	public function __construct  ($args)
	{
      if (!self :: is_lanciata()) self :: lancia(); 

		$this -> nuova_istanza();

		/**
		 * If inibitore: il $_tracer  un reference che nell'ambito della classe 
		 * eccezione deve fare da "lupo solitario" (uno "pseudo singleton").
		 */
		//if (!self :: $_tracer) self :: set_tracer ( $args["tracer"] );
		$utente = ( isset($_SESSION['user'])) ? $_SESSION['user'] : "anonimo" ;
		if (!self :: $_tracer) self :: set_tracer (new K_trace(1, __FILE__, $utente));

		$this -> set_codice ( $args["codice"] );
		$this -> set_file   ( $args["file"]   );
		$this -> set_linea  ( $args["linea"]  );
		if (isset($args["stringa_errori"])) {$this -> set_stringa_errori($args["stringa_errori"]);}
		

		switch ($this -> get_codice()){
			case  "0.1":
				$this -> set_alert(array("immagine" => "no_access.png",
												 "messaggio"=> "Errore di autenticazione. Rifare login",
												 "reazione" => "javascript: document.location.href='/AMD/index.php'"));
				break;  

			case  "0.2":
				$this -> set_alert(array("immagine" => "no_access.png",
						    					 "messaggio"=> "Non si dispone dei permessi per eseguire l'operazione.",
												 "reazione" => "javascript: home()"));
				break;

			case "1.1": 
				$this -> set_alert(array("immagine" => "error_cross1.gif",
												 "messaggio"=> "Input anomalo! Lo script  stato interrotto.",
												 "reazione" => "javascript: home()"));
				break;
				
			case "1.2": 
				/*
				 * Ad una query che deve selezionare/modificare "... WHERE id= xyz"
				 * non gli  arrivato un xyz
				 */ 				   
				$this -> set_alert(array("immagine" => "db_broken1.gif",
												 "messaggio"=> "Errore del sistema informativo. Se il problema persiste, contattare <script type=\"text/javascript\">document.write('<a href=ma'+'ilto:kro'+'nos@kron'+'ositali'+'a.com >Kronos</a>');</script>!",
												 "reazione" => "javascript: home()")); 
				break;										 																	 

			case "1.11": 
				/*
				 * UNITA: fornitori_finanziatori SEZIONE:fornitori_finanziatori MODO: ins
				 */ 
				$this -> set_alert(array("immagine" => "alert.gif",
												 "messaggio"=> "Codice fiscale e/o partita I.V.A. gi censiti dal sistema!",
												 "reazione" => "javascript: home()")); 
			break;												 																	
																 
			case "1.12": 
				$this -> set_alert(array("immagine" => "error_cross1.gif",
																 "messaggio"=> "Questo record  gia presente nel database! Lo script  stato interrotto.",
																 "reazione" => "javascript: home()"));
			break;												 																	

			case "1.13": 
				$this -> set_alert(array("immagine" => "error_cross1.gif",
																 "messaggio"=> " 
																 Hai forse tentato di riaggiornare la pagina dal tasto aggiorna del browser????
																 Lo script  stato comunque interrotto e i tuoi dati sono stati salvati.",
																 "reazione" => "javascript: close_refresh()"));
			break;												 																	


			case "100.1": 
				$this -> set_alert(array("immagine" => "assert.jpg",
									  			 "messaggio"=> "Asserzione fallita.",
												 "reazione" => "javascript: home()"));
				break;												 																	
			case "100.2":
				$this -> set_alert(array("immagine" => "alert.gif",
												 "messaggio" => "Questa operazione sul database  stata interrotta ed  stato ripristinato il valore originario dei record, ritenta ancora grazie.",
												 "reazione"  =>"javascript: home()"));
			break;

			case "100.3": 
				$this -> set_alert(array("immagine" => "assert.jpg",
																 "messaggio"=> "Asserzione fallita: Un addebito deve essere associato almeno ad un Progetto OPPURE ad una Sede regionale OPPURE alla Sede Centrale. Inoltre, l'assegnazione di un addebito ad uno dei predetti, esclude l'assegnazione agli altri due.",
																 "reazione" => "javascript: home()"));
			break;												 																	

			case "100.4":
				$this -> set_alert(array("immagine" => "alert.gif",
																	"messaggio" => "Non &egrave; possibile inserire questo socio  in quanto non &egrave; ancora stata inserita la quota per questo anno.",
																	"reazione"  =>"javascript: home()"));
			break;

			case "100.5":
				$this -> set_alert(array("immagine" => "alert.gif",
																	"messaggio" => "Questa operazione sul database  stata interrotta ed  stato ripristinato il valore originario dei record, ritenta ancora grazie.",
																	"reazione"  =>"javascript:  window.close(); "));
			break;
																 																	
			case "100.6":
				$this -> set_alert(array("immagine" => "alert.gif",
																	"messaggio" => "la tua carta di credito  gia stata inserita, non appena sar validata dall'amministrazione ne appariranno i dati al login .",
																	"reazione"  =>"javascript: home()"));
			break;


			case "100.6":
				$this -> set_alert(array("immagine" => "alert.gif",
																	"messaggio" => "la tua carta di credito  gia stata inserita, non appena sar validata dall'amministrazione ne appariranno i dati al login .",
																	"reazione"  =>"javascript: home()"));
			break;


			// Eccezione lanciata dal valore di ritorno del metodo 
			// K_funzioni :: renameAndRegisterUploadedFile($insertedIdInTblDocumentazione)
			// invocato nel file q_documentazione_ins.php.
			
			case "100.7":
				$this -> set_alert(array("immagine" => "alert.gif",
																	"messaggio" => "Errore durante la fase di registrazione del documento. Probabilmente si  eseguito l'inserimento a sessione scaduta!",
																	"reazione"  =>"javascript: home()"));
			break;


			case "300.0":
			$stringa_errori="";
			$stringa_errori = $this -> get_stringa_errori();
			$str = "I dati sono risultati formalmente scorretti. I problemi occorsi sono i seguenti:<b />";
			if(strlen($this -> get_stringa_errori())!=6)  
			{
				//trigger_error("la lunghezza della stringa di errori e di max 5 caratteri", E_USER_ERROR);
			}
			$hiddens  = "<form id=\"hiddens\" name=\"hiddens\" method=\"post\">";
			$hiddens .= "<input type=\"hidden\" name=\"id\" value=\"".$_POST['id']."\" />\n";
			$hiddens .= "<input type=\"hidden\" name=\"id_carta\" value=\"".$_POST['id_carta']."\" />\n";
			$hiddens .= "<input type=\"hidden\" name=\"data_n\" value=\"".$_POST['data_n']."\" />\n";
			$hiddens .= "<input type=\"hidden\" name=\"nome\" value=\"".$_POST['nome']."\"/>\n";
			$hiddens .= "<input type=\"hidden\" name=\"cognome\" value=\"".$_POST['cognome']."\"/>\n";
			$hiddens .= "<input type=\"hidden\" name=\"codice_fiscale\" value=\"".$_POST['codice_fiscale']."\"/>\n";			
			$hiddens .= "<input type=\"hidden\" name=\"nome_intestatario\" value=\"".$_POST['nome_intestatario']."\"/>\n";
			$hiddens .= "<input type=\"hidden\" name=\"cognome_intestatario\" value=\"".$_POST['cognome_intestatario']."\"/>\n";
			$hiddens .= "<input type=\"hidden\" name=\"circuito\" value=\"".$_POST['circuito']."\"/>\n";	
			$hiddens .= "<input type=\"hidden\" name=\"scadenza\" value=\"".$_POST['scadenza']."\" />\n";
			$hiddens .= "<input type=\"hidden\" name=\"cvv\" value=\"".$_POST['cvv']."\"/>\n";			
			$hiddens .= "<input type=\"hidden\" name=\"numero_cc\" value=\"".$_POST['numero_cc']."\"/>\n";
			$hiddens .= "<input type=\"hidden\" name=\"proprieta\" value=\"".$_POST['proprieta']."\"/>\n";
			$hiddens .= "<input type=\"hidden\" name=\"autorizzazione\" value=\"".$_POST['autorizzazione']."\"/>\n";

				
			$car = str_split($stringa_errori);
			$i=0;
			for ($i=0;$i<=5;$i++)
			{	
				if (($i == 0) && ($car[$i] == "1"))
				{  
					$str .= "<br />- La lunghezza del codice fiscale non &egrave; corretta: il codice fiscale dovrebbe essere 
					lungo esattamente 16 caratteri<br />";
					$hiddens .= "<input type = \"hidden\" name = \"codice_fiscale_err\" id=\"codice_fiscale_err\" value = \"1\">";						
				}
				if (($i == 1) && ($car[$i] == "1"))
				{
					$str .= "- La sequenza del codice fiscale non &egrave; valida <br />";
					$hiddens .= "<input type = \"hidden\" name = \"codice_fiscale_err\" value = \"1\">";						
				}
				if (($i == 2) && ($car[$i] == "1"))
				{
					$str .= "- Il codice fiscale non &egrave; corretto: "
		  ."il codice di controllo non corrisponde <br />";
					$hiddens .= "<input type = \"hidden\" name = \"codice_fiscale_err\" value = \"1\">";						
				}
				if (($i == 3) && ($car[$i] == "1"))
				{
					$str .=  "- Il codice fiscale  &egrave; corretto ma la data di nascita non corrisponde <br />";
					$hiddens .= "<input type = \"hidden\" name = \"codice_fiscale_err\" value = \"1\">";						
				}
				if (($i == 4) && ($car[$i] == "1"))
				{
					$str .=  "- Nome/Cognome e parte onomastica del codice fiscale sono incoerenti <br />";
					$hiddens .= "<input type = \"hidden\" name = \"codice_fiscale_err\" value = \"1\">";						
				}
				if (($i == 5) && ($car[$i] == "1"))
				{
					$str .= "- Il numero della carta di credito non  &egrave; valido!<br />";
					$hiddens .= "<input type = \"hidden\" name = \"carta_credito_err\" value = \"1\">";						
				}

			}//fine for
			$hiddens .= "</form>";
			$str .= $str.$hiddens;
							

			$this -> set_alert(array("immagine" => "alert.gif",
															"messaggio" => $str,
															"reazione"  =>"javascript:  torna_indietro(); "));
															
			break;


			case "300.1":
			$stringa_errori="";
			$stringa_errori = $this -> get_stringa_errori();
			$str = "I dati sono risultati formalmente scorretti. I problemi occorsi sono i seguenti:<b />";
			if(strlen($this -> get_stringa_errori())!=6)  
			{
				//trigger_error("la lunghezza della stringa di errori e di max 5 caratteri", E_USER_ERROR);
			}
			$hiddens  = "<form id=\"hiddens\" name=\"hiddens\" method=\"post\">";
			$hiddens .= "<input type=\"hidden\" name=\"id_modifica_cc\" value=\"".$_POST['id_modifica_cc']."\" />\n";
			$hiddens .= "<input type=\"hidden\" name=\"id_carta\" value=\"".$_POST['id_carta']."\" />\n";
			$hiddens .= "<input type=\"hidden\" name=\"id_utente_modifica_cc\" value=\"".$_POST['id_utente_modifica_cc']."\" />\n";
			$hiddens .= "<input type=\"hidden\" name=\"data_n\" value=\"".$_POST['data_n']."\" />\n";
			$hiddens .= "<input type=\"hidden\" name=\"nome\" value=\"".$_POST['nome']."\"/>\n";
			$hiddens .= "<input type=\"hidden\" name=\"cognome\" value=\"".$_POST['cognome']."\"/>\n";
			$hiddens .= "<input type=\"hidden\" name=\"codice_fiscale\" value=\"".$_POST['codice_fiscale']."\"/>\n";			
			$hiddens .= "<input type=\"hidden\" name=\"nome_intestatario\" value=\"".$_POST['nome_intestatario']."\"/>\n";
			$hiddens .= "<input type=\"hidden\" name=\"cognome_intestatario\" value=\"".$_POST['cognome_intestatario']."\"/>\n";
			$hiddens .= "<input type=\"hidden\" name=\"circuito\" value=\"".$_POST['circuito']."\"/>\n";	
			$hiddens .= "<input type=\"hidden\" name=\"scadenza\" value=\"".$_POST['scadenza']."\" />\n";
			$hiddens .= "<input type=\"hidden\" name=\"cvv\" value=\"".$_POST['cvv']."\"/>\n";			
			$hiddens .= "<input type=\"hidden\" name=\"numero_cc\" value=\"".$_POST['numero_cc']."\"/>\n";
			$hiddens .= "<input type=\"hidden\" name=\"proprieta\" value=\"".$_POST['proprieta']."\"/>\n";
			$hiddens .= "<input type=\"hidden\" name=\"abilitato\" value=\"".$_POST['abilitato']."\"/>\n";
			$hiddens .= "<input type=\"hidden\" name=\"autorizzazione\" value=\"".$_POST['autorizzazione']."\"/>\n";
			$hiddens .= "<input type=\"hidden\" name=\"postExceptionBack\" value=\"1\"/>\n";
				
			$car = str_split($stringa_errori);
			$i=0;
			for ($i=0;$i<=5;$i++)
			{	
				if (($i == 0) && ($car[$i] == "1"))
				{  
					$str .= "<br />- La lunghezza del codice fiscale non &egrave; corretta: il codice fiscale dovrebbe essere 
					lungo esattamente 16 caratteri<br />";
					$hiddens .= "<input type = \"hidden\" name = \"codice_fiscale_err\" id=\"codice_fiscale_err\" value = \"1\">";						
				}
				if (($i == 1) && ($car[$i] == "1"))
				{
					$str .= "- La sequenza del codice fiscale non &egrave; valida <br />";
					$hiddens .= "<input type = \"hidden\" name = \"codice_fiscale_err\" value = \"1\">";						
				}
				if (($i == 2) && ($car[$i] == "1"))
				{
					$str .= "- Il codice fiscale non &egrave; corretto: "
		  ."il codice di controllo non corrisponde <br />";
					$hiddens .= "<input type = \"hidden\" name = \"codice_fiscale_err\" value = \"1\">";						
				}
				if (($i == 3) && ($car[$i] == "1"))
				{
					$str .=  "- Il codice fiscale  &egrave; corretto ma la data di nascita non corrisponde <br />";
					$hiddens .= "<input type = \"hidden\" name = \"codice_fiscale_err\" value = \"1\">";						
				}
				if (($i == 4) && ($car[$i] == "1"))
				{
					$str .=  "- Nome/Cognome e parte onomastica del codice fiscale sono incoerenti <br />";
					$hiddens .= "<input type = \"hidden\" name = \"codice_fiscale_err\" value = \"1\">";						
				}
				if (($i == 5) && ($car[$i] == "1"))
				{
					$str .= "- Il numero della carta di credito non  &egrave; valido!<br />";
					$hiddens .= "<input type = \"hidden\" name = \"carta_credito_err\" value = \"1\">";						
				}

			}//fine for
			$hiddens .= "</form>";
			$str .= $str.$hiddens;
							

			$this -> set_alert(array("immagine" => "alert.gif",
															"messaggio" => $str,
															"reazione"  =>"javascript:  torna_indietro(); "));
															
			break;
			
							  
			default:    
				$this -> set_alert(array("immagine" => "alert.gif",
																 "messaggio"=> "Codice di eccezione non gestito!",
																 "reazione" => "javascript: home()"));
				break;												 																																		 
		} // </switch>


		self::get_tracer()->trace(1, "<eccezione metodo=\"__construct\" istanza=\"".$this->get_numero()."\" file=\"".$this->get_file()."\" linea=\"".$this->get_linea()."\" />");

	}

    /**
	 * Distruttore
	 */
	public function __destruct ()
	{
		self::get_tracer()->trace(1, "<eccezione metodo=\"__destruct\" istanza=\"".$this->get_numero()."\" file=\"".$this->get_file()."\" linea=\"".$this->get_linea()."\" />");			
	}


    /**
	 * Caricatore di classi
	 */
	public function __autoload ()
	{
		require_once("class_trace.inc");			
	}


	

    /**
	 * $_tracer accessor method
	 */
	private static function get_tracer()
	{
	   return self :: $_tracer;
	}


    /**
	 * $_tracer mutator method
     */
	private static function set_tracer($tracer)
	{
	   self :: $_tracer = $tracer;
	}

    /**
	 * $_lanciata accessor method
	 */
	public static function is_lanciata()
	{
	   return self :: $_lanciata;
	}

    /**
	 * $_lanciata mutator method
	 */
	private static function lancia()
	{
	   self :: $_lanciata = true;
	}


    /**
	 * Metodo statico creazionale
	 */
	public static function crea($args)
	{	  
	  new self($args);
	}

    /**
	 * $_numero accessor method
	 */
	public static function get_numero()
	{
	   return self :: $_numero;
	}

    /**
	 * $_numero mutator method
	 */
	private static function set_numero($numero)
	{
	   self :: $_numero = $numero;
	}

    /**
	 * Incrementa $_numero
	 */
	private static function incrementa_numero()
	{
	   $corrente = self :: get_numero();
       self :: set_numero(++ $corrente);	
	}
	
    /**
	 * $_codice accessor method
	 */
	public function get_codice()
	{
	   return $this -> _codice;
	}

    /**
	 * $_codice mutator method
     */
	private function set_codice($codice)
	{
	   $this -> _codice = $codice;
	}

    /**
	 * $_file accessor method
	 */
	private function get_file()
	{
	   return $this -> _file;
	}

    /**
	 * $_file mutator method
     */
	private function set_file($file)
	{
	   $this -> _file = $file;
	}

    /**
	 * $_linea accessor method
	 */
	private function get_linea()
	{
	   return $this -> _linea;
	}


    /**
	 * $_linea mutator method
     */
	private function set_linea($linea)
	{
	   $this -> _linea = $linea;
	}

    /**
	 * $_stringa_errori accessor method
	 */
	 
	private function get_stringa_errori()
	{
	   return $this -> _stringa_errori;
	}

    /**
	 * $_stringa_errori mutator method
    */

	private function set_stringa_errori($stringa_errori)
	{
	   $this -> _stringa_errori = $stringa_errori;
	}

    /**
	 * $_alert accessor method
	 */
	public function get_alert()
	{
	   return $this -> _alert;
	}


    /**
	 * $_alert mutator method
     */
	public function set_alert($args)
	{
	
		$immagine = (!is_null($args["immagine"]))?"/AMD/common/immagini/".$args["immagine"]:"/AMD/common/immagini/alert.gif"; 
		$this -> _alert .=
"
     <div class=\"div_eccezione\" >
	   <table class=\"messaggio_eccezione\">
		 <tr>
		  <td colspan=\"2\" class=\"barra_del_titolo\">Eccezione</td>
		 </tr>
		 <tr>
		  <td rowspan=\"2\" class=\"immagine_eccezione\">
		   <img src=\"".$immagine."\" />
		  </td>
		  <td class=\"messaggio_eccezione\">".$args['messaggio']."</td>		  
		 </tr>
		 <tr>
		  <td class=\"reazione_eccezione\"><input type=\"button\" value=\"&nbsp;&nbsp;&nbsp;Ok&nbsp;&nbsp;&nbsp;\" class=\"pulsantearancio\" onclick=\"". $args['reazione']."\" /></td>		  
		 </tr>
		</table>
	  </div>
	  <script type=\"text/javascript\" language=\"javascript\">
	  	var halfPageH = Math.round(document.body.offsetWidth/2);
		var halfPageV = Math.round(document.body.offsetHeight/2);
	   var divs = document.getElementsByTagName(\"div\");
      for(i=0;i<divs.length;i++)
		{
			if (divs[i].className == \"div_eccezione\") 
			{
				//divs[i].style.marginLeft  = (halfPageH-(Math.round(halfPageH/0.9)))+\"px\";;
				//divs[i].style.marginLeft  = \"20px\";;
				divs[i].style.width = (halfPageH)+\"px\";
			}	
		}
	  </script>
	  ";

	}
	
	public static function istanza($item)
	{
	   return self :: $_istanze[$item];
	}
	
	protected function nuova_istanza()
	{
	   self :: incrementa_numero();
	   self :: $_istanze [self :: get_numero()] = $this;
	}

	public static function gestisci($echo=true){
		$exception_reporting = true;		
/*		if ($exception_reporting) self::istanza(1)->to_string();
		if ($echo) echo self::istanza(1) -> get_alert(); 
	*/	
		for ($i=1;$i<=self::get_numero();$i++)
		{ // <for>
			if ($exception_reporting) self::istanza($i)->to_string();
			if ($echo) echo self::istanza($i) -> get_alert(); 
		} // </for>
	}	


	public static function reset(){
	
		self :: $_istanze = array();
		self :: $_lanciata = false;
		self :: set_numero(0);
	
	}

	public function __toString()
	{
		echo $this -> get_alert();
	}
	
	
	public function to_string(){
		echo "<p style=\"position:inherit\">";
		echo "<div style=\"padding:1px;margin:3px;border:1px dashed #ddeeff;color:#ddeeff\"><span style=\"width:100px\">Codice:</span><span style=\"\">".$this->get_codice()."</span></div>";
		echo "<div style=\"padding:1px;margin:3px;border:1px dashed #ddeeff;color:#ddeeff\"><span style=\"width:100px\">File:</span><span style=\"\">".$this->get_file()."</span></div>";
		echo "<div style=\"padding:1px;margin:3px;border:1px dashed #ddeeff;color:#ddeeff\"><span style=\"width:100px\">Linea:</span><span style=\"\">".$this->get_linea()."</span></div>";
		echo "</p>";		
	}
	
}//fine della classe





?>