<?php
#------------------------------------------------------------------------#
# FILE: class.ajaxmanager.php
# CREATO DA: Stefano Luchetti
# IN DATA: 20/07/2007
# CONTENUTO: 
#------------------------------------------------------------------------#
# VERSIONE: 0.1
# MODIFICATO DA: 
# IN DATA: 
# ->
#------------------------------------------------------------------------#

class IAjaxManager
{
	private $databaseEnvironment = array();
	private $code = null;
	private $exception = null; // 0 oppure codice <> 0
	private static $responseFormat = null; // 1: XML; 2: JSON; 3: PLAIN-TEXT-PROTOCOL
	private $models = array();
	private $views  = array(); 
	private $httpFields = array();
	private $diritti = array();
	private $UID = NULL;

	public function __construct($args,$dbEnvironment = null)
	{
		$this -> setHttpFields();

		$this -> setCode($args['requestCode']);
		$this -> setUID($args['userId']);


		self :: setResponseFormat(isset($args['responseFormat'])?  $args['responseFormat'] : 1);

		$this -> setDatabaseEnvironment($dbEnvironment);

	}

	public function __destruct()
	{
	
	}

	public function convertDbResourceToArray($args,$mode)
	{
		try
		{
			$resource = $args['resource'];
			$return   = array(); 
			$counter = 0; // 0-based
			
			switch($mode)
			{
				case 1:
					// Mysql
					while ($documento = mysql_fetch_array($resource))
					{
						$return[$counter++] = $documento;							
					}
				break;
			}
			
			return $return;
			
		} catch (Exception $e)
		{
			$this -> setException($e);
		}
	}

	public function getHttpFields()
	{
		return $this -> httpFields;
	}
	
	public function setHttpFields()
	{
		$this -> httpFields = array_merge($_GET,$_POST)	;
	}

	
	public function getHttpField($fieldName)
	{
		$i = $this -> getHttpFields(); // assegnazione dummy 
		// Anzich lanciare un'eccezione, se il nome passato non esiste
		// faccio scaturire l'errore: in sostanza volutamente non  vado 
		// a fare un check con array_key_exists($key).
		return $i[$fieldName];
	}

	public function setSessionField($fieldName,$fieldValue)
	{
		if (!session_id()) { session_start(); } 
		$_SESSION[$fieldName] = $fieldValue;
	}	

	public function getSessionField($fieldName)
	{
		if (!session_id()) { session_start(); } 
		return $_SESSION[$fieldName];
	}	
	
	public function getDiritti()
	{
		return $this -> diritti;
	}

	public function checkDiritto($key)
	{
		$dummyReference = $this -> getDiritti();
		return ($dummyReference[$key]=='0') ? false : true ;
	}

	public function setDiritti()
	{
		try 
		{
			$userId = $this -> getUID();

			if (!$userId) throw new Exception("<table align='center' style='padding:10px;border:1px solid #0000ff;background:#eeeeff;'><tr><td align='center' rowspan='2'><img src='../common/immagini/warning.png' title='Input anomalo.' /></td><td>Sessione inconsistente. Sar necessaria una nuova procedura di login.</td></tr><tr><td colspan='2' align='center' ><input type='button' value='OK' class='pulsantearancio' onclick='$(\"messageBox\").innerHTML = \"\";home();' /></td></tr></table>");
			// Rintraccio tutti i diritti dalla tabella gruppi ... dell'utente il cui id  <$this -> getUserId()>
			$sql  = " SELECT gruppi.* FROM utenti LEFT JOIN gruppi ON (utenti.id_gruppo = gruppi.id) ";
			$sql .= " WHERE utenti.id = '".$userId."'";
	
			$risultato = $this -> executeQuery($sql,1);
			
			$this -> diritti = mysql_fetch_array($risultato["VALORI"]);
			
		} catch (Exception $e) 
		{
			$this -> setException($e);
		}
		
	}

	public function getUID()
	{
		return $this -> UID;
	}

	public function setUID($userId)
	{
		$this -> UID = $userId;
	}

	public function getDatabaseEnvironment()
	{
		return $this -> databaseEnvironment;
	}

	public function setDatabaseEnvironment($databaseEnvironment)
	{
		$this -> databaseEnvironment = $databaseEnvironment;
	}

	public function getCode()
	{
		return $this -> code;
	}

	public function setCode($code)
	{
		$this -> code = $code;
	}

	public function getException()
	{
		return $this -> exception;
	}

	public function setException($exception)
	{
		$this -> views = array(); // Resetto tutte le viste;
		$this -> exception = $exception;
		$this -> flushResponse();
		exit(0);
	}

	public function setModularException($args)
	{
		$mode = isset($args['mode']) ? $args['mode'] : 1;
		switch ($mode)
		{
			case 1:
			   // L'eccezione  trattata come fosse una vista
				$exception = $args['exception'];
				$this -> setView($args['clientNode'],$exception -> getMessage());
			break;
		}
	}

	public static function getResponseFormat()
	{
		return self :: $responseFormat;
	}

	public static function setResponseFormat($responseFormat)
	{
		self :: $responseFormat = $responseFormat;
	}


	public function buildModelsAndViews()
	{
		// Carico i diritti dell'utente che ha fatto la richiesta ajax
		$this -> setDiritti();
		
		$currentModelBuilderMethod = "requestModel".$this -> getCode();
		$currentViewBuilderMethod  = "requestView".$this -> getCode();

		eval("\$this -> ".$currentModelBuilderMethod."();");
		eval("\$this -> ".$currentViewBuilderMethod."();");		
	}

	public function flushResponse()
	{
		ob_clean(); // Resetta l'output buffer
		
		$exception = $this -> getException();

		switch (self :: $responseFormat)
		{
			// Intestazione sulla base del response format
			case 1: 
				header('Content-Type: text/xml;charset=iso-8859-1');
			break; 
			case 2: 
				header('Content-Type: application/json');
			break; 
			case 3: 
				header('Content-type: text/plain');
			break; 
		}

      $response = "<responses requestCode=\"".$this -> getCode()."\" exceptionFlag=\"".(($exception)?1:0)."\">";
      //echo "<requestCode>".$this -> getCode()."</requestCode>";		
		//echo "<exceptionFlag>".(($exception)?1:0)."</exceptionFlag>";
		
		if ( $exception ) 
		{
			$response .= "<response clientNode='messageBox' >";
			$response .= "<div style='text-align:justify;padding:4px;margin:10px;border:1px solid black;font-family:tahoma;color:red;font-size:12px;'>".$exception -> getMessage()."</div>";
			$response .= "</response >";
		} else
		{
			foreach ($this -> getViews() as $view)
			{
				$response .= $view;
			}
		}

		$response .= "</responses>";	
		
		echo $response;

	}
	
	
	public function getViews()
	{
		return $this -> views;
	}

	
	public function setView($clientNode,$html,$otherAttributesString="")
	{
		$response = "<response id='".(count($this -> getViews())+1)."' clientNode='".$clientNode."' ".$otherAttributesString." >";
		$response .= $html;		
		$response .= "</response>";
		
		array_push($this -> views,$response);
	}
	

	public function getModels()
	{
		return $this -> models;
	}
	


	public function setModel($key,$model)
	{
		$this -> models[$key] = $model;
	}
	

	protected function encode($string)
	{
		// Tolgo i nefasti apici e doppi apici ... Anche le & non sono Roma!!!
		$stringa = str_replace(array("'",'"'),array("",''), $string);
		return htmlspecialchars($stringa);		
	}



	protected function executeQuery($sql,$type=1)
	{
		try 
		{
			$query = trim($sql);
			
			$isSELECT = 0;$isINSERT = 0;$isUPDATE = 0;$isDELETE = 0;	

			switch($type)
			{
				case 1: $isSELECT = 1;break;
				case 2: $isINSERT = 1;break;
				case 3: $isUPDATE = 1;break;
				case 4: $isDELETE = 1;break;												
			}
			
			$dbEnv = $this -> getDatabaseEnvironment();

			if (!isset($dbEnv['dbConnection']) || !isset($dbEnv['dbName']))	
			{
				throw new Exception("Configurare il database environment per l'oggetto corrente!");
			}	

			$dbConnection = $dbEnv['dbConnection'];
			$dbName       = $dbEnv['dbName'];

			$recordset = @mysql_db_query($dbName,$query,$dbConnection);

			if (!$recordset)	
			{
				throw new Exception("<p><b>Errore con il database:</b> ".mysql_error()."</p>");
			}	

			return array(
							 'LAST_INSERT_ID' => ($isINSERT)?mysql_result("SELECT LAST_INSERT_ID()",0,0):null,
							 'NUMERO_RIGHE'   => ($isSELECT)?mysql_num_rows($recordset):mysql_affected_rows($dbConnection),
							 'VALORI'         => $recordset
					 	   );
				
			
		} catch (Exception $e) 
		{
			$this -> setException($e);
		}
		
	}

	function reformatDate($d)
	{
		if ($d){
			$a=explode("-",$d);
			return $a[2]."-".$a[1]."-".$a[0];
		}
		return $d;
	}	
	
}
?>