<?php
class FileUploader
{
	private $callbackElement;
	private $databaseEnvironment = array();
	
	private $mime_types = array("323" => "text/h323", "acx" => "application/internet-property-stream", "ai" => "application/postscript", "aif" => "audio/x-aiff", "aifc" => "audio/x-aiff", "aiff" => "audio/x-aiff", "asf" => "video/x-ms-asf", "asr" => "video/x-ms-asf", "asx" => "video/x-ms-asf", "au" => "audio/basic", "avi" => "video/x-msvideo", "axs" => "application/olescript", "bas" => "text/plain", "bcpio" => "application/x-bcpio", "bin" => "application/octet-stream", "bmp" => "image/bmp", "c" => "text/plain", "cat" => "application/vnd.ms-pkiseccat", "cdf" => "application/x-cdf", "cer" => "application/x-x509-ca-cert", "class" => "application/octet-stream", "clp" => "application/x-msclip", "cmx" => "image/x-cmx", "cod" => "image/cis-cod", "cpio" => "application/x-cpio", "crd" => "application/x-mscardfile", "crl" => "application/pkix-crl", "crt" => "application/x-x509-ca-cert", "csh" => "application/x-csh", "css" => "text/css", "dcr" => "application/x-director", "der" => "application/x-x509-ca-cert", "dir" => "application/x-director", "dll" => "application/x-msdownload", "dms" => "application/octet-stream", "doc" => "application/msword", "dot" => "application/msword", "dvi" => "application/x-dvi", "dxr" => "application/x-director", "eps" => "application/postscript", "etx" => "text/x-setext", "evy" => "application/envoy", "exe" => "application/octet-stream", "fif" => "application/fractals", "flr" => "x-world/x-vrml", "gif" => "image/gif", "gtar" => "application/x-gtar", "gz" => "application/x-gzip", "h" => "text/plain", "hdf" => "application/x-hdf", "hlp" => "application/winhlp", "hqx" => "application/mac-binhex40", "hta" => "application/hta", "htc" => "text/x-component", "htm" => "text/html", "html" => "text/html", "htt" => "text/webviewhtml", "ico" => "image/x-icon", "ief" => "image/ief", "iii" => "application/x-iphone", "ins" => "application/x-internet-signup", "isp" => "application/x-internet-signup", "jfif" => "image/pipeg", "jpe" => "image/jpeg", "jpeg" => "image/jpeg", "jpg" => "image/jpeg", "js" => "application/x-javascript", "latex" => "application/x-latex", "lha" => "application/octet-stream", "lsf" => "video/x-la-asf", "lsx" => "video/x-la-asf", "lzh" => "application/octet-stream", "m13" => "application/x-msmediaview", "m14" => "application/x-msmediaview", "m3u" => "audio/x-mpegurl", "man" => "application/x-troff-man", "mdb" => "application/x-msaccess", "me" => "application/x-troff-me", "mht" => "message/rfc822", "mhtml" => "message/rfc822", "mid" => "audio/mid", "mny" => "application/x-msmoney", "mov" => "video/quicktime", "movie" => "video/x-sgi-movie", "mp2" => "video/mpeg", "mp3" => "audio/mpeg", "mpa" => "video/mpeg", "mpe" => "video/mpeg", "mpeg" => "video/mpeg", "mpg" => "video/mpeg", "mpp" => "application/vnd.ms-project", "mpv2" => "video/mpeg", "ms" => "application/x-troff-ms", "mvb" => "application/x-msmediaview", "nws" => "message/rfc822", "oda" => "application/oda", "p10" => "application/pkcs10", "p12" => "application/x-pkcs12", "p7b" => "application/x-pkcs7-certificates", "p7c" => "application/x-pkcs7-mime", "p7m" => "application/x-pkcs7-mime", "p7r" => "application/x-pkcs7-certreqresp", "p7s" => "application/x-pkcs7-signature", "pbm" => "image/x-portable-bitmap", "pdf" => "application/pdf", "pfx" => "application/x-pkcs12", "pgm" => "image/x-portable-graymap", "pko" => "application/ynd.ms-pkipko", "pma" => "application/x-perfmon", "pmc" => "application/x-perfmon", "pml" => "application/x-perfmon", "pmr" => "application/x-perfmon", "pmw" => "application/x-perfmon", "pnm" => "image/x-portable-anymap", "pot" => "application/vnd.ms-powerpoint", "ppm" => "image/x-portable-pixmap", "pps" => "application/vnd.ms-powerpoint", "ppt" => "application/vnd.ms-powerpoint", "prf" => "application/pics-rules", "ps" => "application/postscript", "pub" => "application/x-mspublisher", "qt" => "video/quicktime", "ra" => "audio/x-pn-realaudio", "ram" => "audio/x-pn-realaudio", "ras" => "image/x-cmu-raster", "rgb" => "image/x-rgb", "rmi" => "audio/mid", "roff" => "application/x-troff", "rtf" => "application/rtf", "rtx" => "text/richtext", "scd" => "application/x-msschedule", "sct" => "text/scriptlet", "setpay" => "application/set-payment-initiation", "setreg" => "application/set-registration-initiation", "sh" => "application/x-sh", "shar" => "application/x-shar", "sit" => "application/x-stuffit", "snd" => "audio/basic", "spc" => "application/x-pkcs7-certificates", "spl" => "application/futuresplash", "src" => "application/x-wais-source", "sst" => "application/vnd.ms-pkicertstore", "stl" => "application/vnd.ms-pkistl", "stm" => "text/html", "svg" => "image/svg+xml", "sv4cpio" => "application/x-sv4cpio", "sv4crc" => "application/x-sv4crc", "t" => "application/x-troff", "tar" => "application/x-tar", "tcl" => "application/x-tcl", "tex" => "application/x-tex", "texi" => "application/x-texinfo", "texinfo" => "application/x-texinfo", "tgz" => "application/x-compressed", "tif" => "image/tiff", "tiff" => "image/tiff", "tr" => "application/x-troff", "trm" => "application/x-msterminal", "tsv" => "text/tab-separated-values", "txt" => "text/plain", "uls" => "text/iuls", "ustar" => "application/x-ustar", "vcf" => "text/x-vcard", "vrml" => "x-world/x-vrml", "wav" => "audio/x-wav", "wcm" => "application/vnd.ms-works", "wdb" => "application/vnd.ms-works", "wks" => "application/vnd.ms-works", "wmf" => "application/x-msmetafile", "wps" => "application/vnd.ms-works", "wri" => "application/x-mswrite", "wrl" => "x-world/x-vrml", "wrz" => "x-world/x-vrml", "xaf" => "x-world/x-vrml", "xbm" => "image/x-xbitmap", "xla" => "application/vnd.ms-excel", "xlc" => "application/vnd.ms-excel", "xlm" => "application/vnd.ms-excel", "xls" => "application/vnd.ms-excel", "xlt" => "application/vnd.ms-excel", "xlw" => "application/vnd.ms-excel", "xof" => "x-world/x-vrml", "xpm" => "image/x-xpixmap", "xwd" => "image/x-xwindowdump", "z" => "application/x-compress", "zip" => "application/zip", "sxw" => "application/vnd.sun.xml.writer", "stw" => "application/vnd.sun.xml.writer.template", "sxg" => "application/vnd.sun.xml.writer.global", "sdw" => "application/vnd.stardivision.writer", "vor" => "application/vnd.stardivision.writer", "sgl" => "application/vnd.stardivision.writer-global", "sxc" => "application/vnd.sun.xml.calc", "stc" => "application/vnd.sun.xml.calc.template", "sdc" => "application/vnd.stardivision.calc", "sxi" => "application/vnd.sun.xml.impress", "sti" => "application/vnd.sun.xml.impress.template", "sdp" => "application/vnd.stardivision.impress", "sdd" => "application/vnd.stardivision.impressv", "sxd" => "application/vnd.sun.xml.draw", "std" => "application/vnd.sun.xml.draw.template", "sda" => "application/vnd.stardivision.draw", "sxm" => "application/vnd.sun.xml.math", "smf" => "application/vnd.stardivision.math", "odt" => "application/vnd.oasis.opendocument.text", "ott" => "application/vnd.oasis.opendocument.text-template", "oth" => "application/vnd.oasis.opendocument.text-web", "odm" => "application/vnd.oasis.opendocument.text-master", "odg" => "application/vnd.oasis.opendocument.graphics", "otg" => "application/vnd.oasis.opendocument.graphics-template", "odp" => "application/vnd.oasis.opendocument.presentation", "otp" => "application/vnd.oasis.opendocument.presentation-template", "ods" => "application/vnd.oasis.opendocument.spreadsheet", "ots" => "application/vnd.oasis.opendocument.spreadsheet-template", "odc" => "application/vnd.oasis.opendocument.chart", "odf" => "application/vnd.oasis.opendocument.formula", "odb" => "application/vnd.oasis.opendocument.database", "odi" => "application/vnd.oasis.opendocument.image");

	
	public function __construct($args)
	{
		try 
		{
			if(!session_id()) session_start();
			
			$this -> callbackElement = $args['callbackElement'];

			if (isset($args['databaseEnvironment'])) { $this -> setDatabaseEnvironment($args['databaseEnvironment']); }
	
			if (@$_POST["loaded"])
			{
				$this -> registerLoadedfiles();
			} else
			{
				$this -> sendUploadForm();
			}
		} catch (Exception $e){}
		
	}

	public function __destruct(){}
	
	private function sendUploadForm()
	{
		try 
		{
			echo "<form enctype='multipart/form-data' method='post' action='' ";
			echo "name='uploadform' id='uploadform'>
			      <input type='hidden' name='MAX_FILE_SIZE' value=''/>
					<input type='hidden' name='callBackElement' ='".$this -> callBackElement."' />
					<input type='hidden' name='loaded' value='1' />
					 <div style='margin:1px;'>
					 <div style='font-family:arial;font-weight:bold;font-size:12px;background:#efefff;text-align:center;margin:3px;padding:3px;width:300px;'>
					<div>
					 <div style='margin:3px;padding:3px;background:#ddddff;color:#ffffff;'>
					  Seleziona il file da caricare sul server:
					 </div>
					 </div>
					 <div>
					  <div style='margin:5px;'><input type='file' name='theFile' size='25' class='pulsantearancio' /></div>
					  <div style='margin:5px;'><input type='submit' value='invia' name='invio' class='pulsantearancio' /></div>
					 </div>
					 </div>
					 </div>
					</form>
					"; 
		} catch (Exception $e) {}
	}

	private function fileExtension($fileName)
	{
		return ereg_replace("^.+\\.([^.]+)$", "\\1", basename($fileName));
	}
	
	private function registerLoadedFiles()
	{
		try
		{
			echo "<div style='margin:1px;'>";
			echo "<div style='font-family:arial;font-weight:bold;font-size:12px;background:#efefff;text-align:center;margin:3px;padding:3px;width:300px;'>";

			error_reporting(2047);
			$percorso = $_SERVER["DOCUMENT_ROOT"]."/AMD/common/allegati/";
			
			if (is_uploaded_file($_FILES['theFile']['tmp_name'])) 
			{
				$secureName = "__".session_id().".".$this -> fileExtension($_FILES['theFile']['name']).".sec";
				
				$_SESSION["last_uploaded_document"] = $secureName;
				
				if (move_uploaded_file($_FILES['theFile']['tmp_name'], $percorso.$secureName)) 
				{
					echo "<div>";
					echo "File: <b>".$_FILES['theFile']['name']."</b><br>";
					//echo "MIME Type: <b>".$_FILES['theFile']['type']."</b><br>";
					echo "Dimensione: <b>".$_FILES['theFile']['size']."</b> byte<br>";
					echo "<hr />";
					echo "File caricato correttamente<br><br>";
					echo "</div>";
					echo "<script type='text/javascript'><!--\r\n";
               echo "opener.document.getElementById(\"".$this -> callbackElement."\").value = '".$_FILES['theFile']['name']."'";
				   echo "\r\n--></script>";
				} else {
					$this -> showErrorMessage($_FILES["theFile"]["error"]);
				}
			} else {
				$this -> showErrorMessage($_FILES["theFile"]["error"]);			
			}
			
			echo "<input type='button' value='Chiudi' onClick=\"javascript: window.close();\" /></div></div>";

		} catch (Exception $e) {}					
	}
	
	private function buildFileName($fileName)
	{
		
	}

	private function showErrorMessage($errorCode)
	{
		echo "<div>";
		echo "<div>Errore durante l'operazione di upload</div>";
		$errStr = "";
		switch ($errorCode)
		{
			case 1: $errStr .= "Il file inviato eccede le dimensioni specificate nel parametro upload_max_filesize di php.ini."; 
			case 2: $errStr .= "Il file inviato eccede le dimensioni specificate nel parametro MAX_FILE_SIZE del form."; 
         case 3: $errStr .= "Upload eseguito parzialmente.";
			case 4: $errStr .= "Nessun file  stato inviato.";
			case 6: $errStr .= "Mancanza della cartella temporanea.";
		}
		echo $errStr;
		echo "</div>";

	}	
	

	// La classe  stata dotata di un metodo "executeQuery" per l'esecuzione delle query.
	// Allo stato attuale non viene per utilizzato
		
	protected function executeQuery($sql,$type=1)
	{
		try 
		{
			$query = trim($sql);
			
			$isSELECT = 0;$isINSERT = 0;$isUPDATE = 0;$isDELETE = 0;	

			switch($type)
			{
				case 1: $isSELECT = 1;break;
				case 2: $isINSERT = 1;break;
				case 3: $isUPDATE = 1;break;
				case 4: $isDELETE = 1;break;												
			}
			
			$dbEnv = $this -> getDatabaseEnvironment();

			if (!isset($dbEnv['dbConnection']) || !isset($dbEnv['dbName']))	
			{
				throw new Exception("Configurare il database environment per l'oggetto corrente!");
			}	

			$dbConnection = $dbEnv['dbConnection'];
			$dbName       = $dbEnv['dbName'];

			$recordset = @mysql_db_query($dbName,$query,$dbConnection);

			if (!$recordset)	
			{
				throw new Exception("<p><b>Errore con il database:</b> ".mysql_error()."</p>");
			}	

			return array(
							 'LAST_INSERT_ID' => ($isINSERT)?mysql_result("SELECT LAST_INSERT_ID()",0,0):null,
							 'NUMERO_RIGHE'   => ($isSELECT)?mysql_num_rows($recordset):mysql_affected_rows($dbConnection),
							 'VALORI'         => $recordset
					 	   );
				
			
		} catch (Exception $e) 
		{
			$this -> setException($e);
		}

	}


	protected function getDatabaseEnvironment()
	{
		return $this -> databaseEnvironment;
	}


	protected function setDatabaseEnvironment($databaseEnvironment)
	{
		$this -> databaseEnvironment = $databaseEnvironment;
	}



}
?>