<?php # FILE: class.datacheck.inc
# CREATO DA: Paola Paoloni
# IN DATA: 09/05/07
# CONTENUTO: classe di funzioni utili per la programmazione.
#--------------------------------------------------------------------------------------------
# VERSIONE: 0.1
# MODIFICATO DA:
# IN DATA:
# ->
#
#-------------------------------- CLASSE DI FUNZIONI UTILI ------------------------------------



class DataChecker {

	private $input;
	private $CF;
	private $CC;
	private $proprieta;
	
	#-------------------------------- COSTRUTTORE --------------------------------------------------
	public function __construct($input)
	{
		$this -> setInput($input);
		$this -> setCF($input['codice_fiscale']);
		$this -> setCC($input['numero_cc']);
		$this -> setProprieta($input['proprieta']);
	} 
	
	
	#-------------------------------- DISTRUTTORE ---------------------------------------------------		
	public function __destruct ()
	{
			
	}

	private function __autoload()
	{
		require_once("class.codicefiscale.php");
		require_once("szValidCC.inc.php");
	}

	//SET DELL'ARRAY INPUT
	
	private function setInput($input)
	{
		$this -> input = $input;
	}
	
	//GET DELL'ARRAY INPUT
	
	public function getInput()
	{
		return $this -> input;
	}

	
	//SET VARIABILE CARTA DI CREDITO
	
	private function setCC($CC)
	{
		$this -> CC = $CC;
	}
	
	//GET VARIABILE CARTA DI CREDITO
	
	public function getCC()
	{
		return $this -> CC;
	}

	
//METODO CHE FA IL SETTING DELLA VARIABILE CF

	private function setCF($CF)
	{
		$this -> CF = $CF;
	}
	
//METODO CHE RESTITUISCE IL VALORE DI CF
	
	private function getCF()
	{
		return $this -> CF;
	}

//METODO CHE FA IL SETTING DELLA VARIABILE PROPRIETA

private function setProprieta($proprieta)
{
	$this -> proprieta = $proprieta;
}

//METODO CHE RESTITUISCE IL VALORE DELLA VARIABILE PROPRIETA

public function getProprieta()
{
	return $this -> proprieta;
}

	
//METODO CHE RICHIAMA I DIVERSI CONTROLLI SUL CODICE FISCALE

	private function controllaCF($CF)
	{
		require_once("class.codicefiscale.php");
		$input = $this -> getInput();
		$cfc = new CodiceFiscaleAvanzato(array(
			 									  "codiceFiscale" => $CF               , 
			 									  "nome"          => $input['nome']    , 
												  "cognome"       => $input['cognome'] , 
												  "dataDiNascita" => $input['data_n']
												  ));
		return $cfc -> controllaErrori();
	}
	

//METODO CHE RICHIAMA LA CLASSE CHE VALIDA LA CARTA DI CREDITO	
	private function controllaCC($CC)
	{
		require_once("szValidCC.inc.php");
		$ccvalidator = new szValidCC($CC);
		return ($ccvalidator->isValid())?"0":"1";
	}
	
	function controlla() 
	{ 
		/* INCASPULO L'ALGORITMO DI CONTROLLO PER TUTTI I CAMPI */
		if($this -> getCF()){$cfCorretto = 	$this -> controllaCF($this -> getCF());}
		else {$cfCorretto = "00000";}
		$ccCorretto =	$this -> controllaCC($this -> getCC());
		return $cfCorretto.$ccCorretto;
	}
	
}//FINE CLASSE CHECK DATA


?>