<?php
#------------------------------------------------------------------------#
# FILE: class.ajaxmanager.php
# CREATO DA: Stefano Luchetti
# IN DATA: 20/07/2007
# CONTENUTO: 
#------------------------------------------------------------------------#
# VERSIONE: 0.1
# MODIFICATO DA: 
# IN DATA: 
# ->
#------------------------------------------------------------------------#

class AjaxManager
{
	private $databaseEnvironment = array();
	private $code = null;
	private $exception = null; // 0 oppure codice <> 0
	private static $responseFormat = null; // 1: XML; 2: JSON; 3: PLAIN-TEXT-PROTOCOL
	private $models = array();
	private $views  = array(); 

	public function __construct($args,$dbEnvironment = null)
	{
		$this -> setCode($args['requestCode']);
		self :: setResponseFormat(isset($args['responseFormat'])?  $args['responseFormat'] : 1);
		$this -> setDatabaseEnvironment($dbEnvironment);
	}

	public function __destruct()
	{
	}

	public function getDatabaseEnvironment()
	{
		return $this -> databaseEnvironment;
	}


	public function setDatabaseEnvironment($databaseEnvironment)
	{
		$this -> databaseEnvironment = $databaseEnvironment;
	}

	public function getCode()
	{
		return $this -> code;
	}


	public function setCode($code)
	{
		$this -> code = $code;
	}


	public function getException()
	{
		return $this -> exception;
	}


	public function setException($exception)
	{
		$this -> exception = $exception;
		$this -> flushResponse();
		exit(0);
	}


	public static function getResponseFormat()
	{
		return self :: $responseFormat;
	}


	public static function setResponseFormat($responseFormat)
	{
		self :: $responseFormat = $responseFormat;
	}


	public function buildModelsAndViews()
	{
		$currentModelBuilderMethod = "requestModel".$this -> getCode();
		$currentViewBuilderMethod = "requestView".$this -> getCode();

		// First thing: exec queries
		//if ( is_null($this -> getException()) ) 
			eval("\$this -> ".$currentModelBuilderMethod."();");
		// ... and then build relative views
		//if ( is_null($this -> getException()) ) 
			eval("\$this -> ".$currentViewBuilderMethod."();");		
	}

	public function flushResponse()
	{
		ob_clean(); // Resetta l'output buffer
		
		$exception = $this -> getException();

		switch (self :: $responseFormat)
		{
			// Intestazione sulla base del response format
			case 1: 
				header('Content-Type: text/xml;charset=iso-8859-1');
			break; 
			case 2: 
				header('Content-Type: application/json');
			break; 
			case 3: 
				header('Content-type: text/plain');
			break; 
		}

      $response = "<responses requestCode=\"".$this -> getCode()."\" exceptionFlag=\"".(($exception)?1:0)."\">";
      //echo "<requestCode>".$this -> getCode()."</requestCode>";		
		//echo "<exceptionFlag>".(($exception)?1:0)."</exceptionFlag>";
		
		if ( $exception ) 
		{
			$response .= "<response clientNode='messageBox' >";
			//echo "<innerHTMLClientLocation>display</innerHTMLClientLocation>";
			$response .= "<div style='text-align:justify;padding:4px;margin:10px;border:1px solid black;font-family:tahoma;color:red;font-size:12px;'>".$exception -> getMessage()."</div>";
			$response .= "</response >";
		} else
		{
			foreach ($this -> getViews() as $view)
			{
				$response .= $view;
			}
			//echo count($this -> views);
		}

		$response .= "</responses>";	
		
		echo $response;

	}
	
	
	public function getViews()
	{
		return $this -> views;
	}

	
	public function setView($clientNode,$html,$otherAttributesString="")
	{
		$response = "<response id='".(count($this -> getViews())+1)."' clientNode='".$clientNode."' ".$otherAttributesString." >";
		//$response .= "<innerHTMLClientLocation>".$innerHTMLClientLocation."</innerHTMLClientLocation>";		
		//$response .= "<responseHTML>";
		$response .= $html;		
		//$response .= "</responseHTML>";		
		$response .= "</response>";
		
		array_push($this -> views,$response);
	}
	

	public function getModels()
	{
		return $this -> models;
	}
	


	public function setModel($key,$model)
	{
		$this -> models[$key] = $model;
	}
	

	protected function encode($string)
	{
		return htmlspecialchars($string);
	}



	protected function executeQuery($sql,$type=1)
	{
		try 
		{
			$query = trim($sql);
			
			$isSELECT = 0;$isINSERT = 0;$isUPDATE = 0;$isDELETE = 0;	

			switch($type)
			{
				case 1: $isSELECT = 1;break;
				case 2: $isINSERT = 1;break;
				case 3: $isUPDATE = 1;break;
				case 4: $isDELETE = 1;break;												
			}
			
			$dbEnv = $this -> getDatabaseEnvironment();

			if (!isset($dbEnv['dbConnection']) || !isset($dbEnv['dbName']))	
			{
				throw new Exception("Configurare il database environment per l'oggetto corrente!");
			}	

			$dbConnection = $dbEnv['dbConnection'];
			$dbName       = $dbEnv['dbName'];

			$recordset = @mysql_db_query($dbName,$query,$dbConnection);

			if (!$recordset)	
			{
				throw new Exception("<p><b>Errore con il database:</b> ".mysql_error()."</p>");
			}	

			return array(
							 'LAST_INSERT_ID' => ($isINSERT)?mysql_result("SELECT LAST_INSERT_ID()",0,0):null,
							 'NUMERO_RIGHE'   => ($isSELECT)?mysql_num_rows($recordset):mysql_affected_rows($dbConnection),
							 'VALORI'         => $recordset
					 	   );
				
			
		} catch (Exception $e) 
		{
			$this -> setException($e);
		}
		
	}
	
	
}
?>